/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_tbxopdlg.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:47:08 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef MSC
#pragma warning (disable:4355)
#endif

//========================================================================

// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif

// auto strip #include <so3/svstor.hxx>
#pragma hdrstop

// auto strip #include "resmgr.hxx"
// auto strip #include "tbxopdlg.hxx"
#include "tbxopdlg.hrc"
// auto strip #include "msgpool.hxx"
// auto strip #include "cfgmgr.hxx"
// auto strip #include "sfxresid.hxx"
// auto strip #include "dispatch.hxx"

#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif

// auto strip #include "tbxconf.hxx"
// auto strip #include "objsh.hxx"
// auto strip #include "objface.hxx"
// auto strip #include "cfg.hxx"
// auto strip #include "tbxmgr.hxx"
// auto strip #include "sfxtypes.hxx"
// auto strip #include "viewfrm.hxx"
// auto strip #include "bindings.hxx"
// auto strip #include "request.hxx"
namespace binfilter {

#define NEW_SFX_TOOLBOX_MAX 4

//========================================================================
// Der "Index" bezeichnet die Lage in der TreeListBox,
// die "Position" ist der Identifier des Bereiches ( SFX_OBJECTBAR_...)

//STRIP001 USHORT PosToIndex_Impl( USHORT n )
//STRIP001 {
//STRIP001 	// Konvertiert Domain-Identifier in TreeListBox-Index
//STRIP001 	if ( n <= SFX_OBJECTBAR_OPTIONS )
//STRIP001 		// Alte Positionen
//STRIP001 		return n;
//STRIP001 	else if ( n>SFX_OBJECTBAR_USERDEF4 )
//STRIP001 		// Neue Positionen
//STRIP001 		return n - SFX_OBJECTBAR_USERDEF4 + SFX_OBJECTBAR_OPTIONS;
//STRIP001 	else
//STRIP001 		// UserDefToolboxen
//STRIP001 		return n + SFX_OBJECTBAR_MAX - SFX_OBJECTBAR_USERDEF4 - 1;
//STRIP001 }
//STRIP001 
//STRIP001 USHORT IndexToPos_Impl( USHORT n )
//STRIP001 {
//STRIP001 	// Konvertiert TreeListBox-Index in Domain-Identifier
//STRIP001 	if ( n <= SFX_OBJECTBAR_OPTIONS )
//STRIP001 		// Alte Positionen
//STRIP001 		return n;
//STRIP001 	else if ( n < SFX_OBJECTBAR_OPTIONS + SFX_OBJECTBAR_MAX - SFX_OBJECTBAR_USERDEF4 )
//STRIP001 		// Neue Positionen
//STRIP001 		return n + SFX_OBJECTBAR_USERDEF4 - SFX_OBJECTBAR_OPTIONS;
//STRIP001 	else
//STRIP001 		// UserDefToolboxen
//STRIP001 		return n - SFX_OBJECTBAR_MAX + SFX_OBJECTBAR_USERDEF4 + 1;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 #define USERDEF_DOMAIN SFX_OBJECTBAR_USERDEF1
//STRIP001 
//STRIP001 struct SfxTBOptions_Impl
//STRIP001 {
//STRIP001 	USHORT          nIndex;
//STRIP001 	USHORT          nId;
//STRIP001 	USHORT          nDomain;
//STRIP001 	String          aName;
//STRIP001 	SfxInterface*   pIFace;
//STRIP001 	BOOL			bVisible;
//STRIP001 	String			aUserName;
//STRIP001 	USHORT          nOldDomain;
//STRIP001 	String          aOldName;
//STRIP001 	SfxInterface*   pOldIFace;
//STRIP001 	BOOL			bWasVisible;
//STRIP001 	ButtonType		eOldType;
//STRIP001 	ButtonType		eType;
//STRIP001 	BOOL			bDeleted;
//STRIP001 	String			aOldUserName;
//STRIP001 
//STRIP001 	SfxTBOptions_Impl(USHORT n, USHORT nID, USHORT nPos, String aString,
//STRIP001 							BOOL bVis, SfxInterface *pIF, ButtonType eTyp ) :
//STRIP001 		nIndex(n),
//STRIP001 		nId(nID),
//STRIP001 		nDomain(nPos),
//STRIP001 		aName(aString),
//STRIP001 		bVisible(bVis),
//STRIP001 		pIFace(pIF),
//STRIP001 		nOldDomain(nPos),
//STRIP001 		aOldName(aString),
//STRIP001 		pOldIFace(pIF),
//STRIP001 		bWasVisible(bVis),
//STRIP001 		eType( eTyp ),
//STRIP001 		eOldType( eTyp ),
//STRIP001 		bDeleted( FALSE )
//STRIP001 	{}
//STRIP001 };
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 
//STRIP001 DECL_PTRARRAY(SfxTBOptArr_Impl, SfxTBOptions_Impl*, 6, 3)//STRIP008 ;
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 
//STRIP001 SfxObjectBarLB_Impl::SfxObjectBarLB_Impl( Window* pParent, WinBits nWinStyle) :
//STRIP001 	SvTreeListBox(pParent, nWinStyle),
//STRIP001 	bModified (FALSE)
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxObjectBarLB_Impl::SfxObjectBarLB_Impl( Window* pParent, const ResId& rId) :
//STRIP001     SvTreeListBox( pParent, rId ),
//STRIP001 	bModified (FALSE)
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 void SfxObjectBarLB_Impl::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001 	USHORT aCode = rKEvt.GetKeyCode().GetCode();
//STRIP001 	if( aCode == KEY_SPACE )
//STRIP001 	{
//STRIP001 		SvLBoxEntry* pEntry = (SvLBoxEntry*) FirstSelected();
//STRIP001 		if( pEntry && (GetCheckButtonState( pEntry ) == SV_BUTTON_UNCHECKED) )
//STRIP001 			SetCheckButtonState(pEntry, SV_BUTTON_CHECKED);
//STRIP001 		else
//STRIP001 			SetCheckButtonState(pEntry, SV_BUTTON_UNCHECKED);
//STRIP001 		GetCheckButtonHdl().Call(this);
//STRIP001 	}
//STRIP001 	else if( aCode == KEY_ADD )
//STRIP001 		return;
//STRIP001 	else
//STRIP001 		SvTreeListBox::KeyInput( rKEvt );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SfxObjectBarLB_Impl::NotifyMoving
//STRIP001 (
//STRIP001 	SvLBoxEntry* pTarget,
//STRIP001 	SvLBoxEntry* pEntry,
//STRIP001 	SvLBoxEntry*& rpNewParent,
//STRIP001 	ULONG& rNewChildPos
//STRIP001 )
//STRIP001 {
//STRIP001 	SfxTBOptions_Impl *pTO = (SfxTBOptions_Impl*) pEntry->GetUserData();
//STRIP001 	if (!pTO->pIFace)
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	SfxTBOptions_Impl *pT = (SfxTBOptions_Impl*) pTarget->GetUserData();
//STRIP001 
//STRIP001 	if (!GetParent(pTarget))
//STRIP001 	{									// Einfuegen nach einem Begrenzer
//STRIP001 		rpNewParent = pTarget;
//STRIP001 		rNewChildPos = 0L;
//STRIP001 										// solange VISIBILITY ueber Position geht
//STRIP001 		USHORT nMask = pTO->nDomain & SFX_VISIBILITY_MASK;
//STRIP001 		pTO->nDomain = pT->nDomain | nMask;
//STRIP001 		bModified = TRUE;
//STRIP001 
//STRIP001 		if (GetChildCount(pTarget) == 0)
//STRIP001 			return 2;                   // Patch, da SvLBox nicht anders aufklappt
//STRIP001 		else
//STRIP001 			return TRUE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 										// Bereich vom neuen Vorgaenger holen
//STRIP001 		USHORT nMask = pTO->nDomain & SFX_VISIBILITY_MASK;
//STRIP001 		pTO->nDomain = IndexToPos_Impl( (USHORT) GetModel()->GetRelPos(GetParent(pTarget)) ) | nMask;
//STRIP001 		bModified = TRUE;
//STRIP001 
//STRIP001 		return
//STRIP001 		SvTreeListBox::NotifyMoving(pTarget, pEntry, rpNewParent, rNewChildPos);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SfxObjectBarLB_Impl::NotifyQueryDrop( SvLBoxEntry* pEntry )
//STRIP001 {
//STRIP001 	if (pEntry == 0)
//STRIP001 		return FALSE;
//STRIP001 										// selektierte Toolbox samt Daten
//STRIP001 	SvLBoxEntry *pSelected = FirstSelected();
//STRIP001 
//STRIP001 	SfxTBOptions_Impl *pTO = (SfxTBOptions_Impl*) pSelected->GetUserData();
//STRIP001 	if (!pTO->pIFace)
//STRIP001 		return FALSE;
//STRIP001 										// neue Domain holen
//STRIP001 	SvLBoxEntry *pParent = GetParent(pEntry);
//STRIP001 	if (pParent == 0)                   // Einschieben nach einem Begrenzer
//STRIP001 		pParent = pEntry;
//STRIP001 										// alle childs nach dem
//STRIP001 										// selektierten Kontext absuchen
//STRIP001 	BOOL bError = FALSE;
//STRIP001 	SvLBoxEntry *pChild = FirstChild(pParent);
//STRIP001 	while (pChild)
//STRIP001 	{
//STRIP001 		SfxTBOptions_Impl *pT = (SfxTBOptions_Impl*) pChild->GetUserData();
//STRIP001 		if (pT->pIFace == pTO->pIFace)
//STRIP001 		{
//STRIP001 			bError = TRUE;              // Domain enthaelt schon eine ToolBox
//STRIP001 			break;                      // mit gleichem Kontext
//STRIP001 		}
//STRIP001 
//STRIP001 		pChild = NextSibling(pChild);
//STRIP001 	}
//STRIP001 
//STRIP001 	return !bError;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SfxObjectBarLB_Impl::EditingEntry( SvLBoxEntry* pEntry, Selection& )
//STRIP001 {
//STRIP001 	SfxTBOptions_Impl *pTO = (SfxTBOptions_Impl*) pEntry->GetUserData();
//STRIP001 	((SfxObjectBarConfigPage*) Window::GetParent())->StartEditing();
//STRIP001 	
//STRIP001 	if ( pTO->nId && pTO->nDomain >= SFX_OBJECTBAR_USERDEF1 && pTO->nDomain <= SFX_OBJECTBAR_USERDEF4 )
//STRIP001 		return TRUE;
//STRIP001 	else
//STRIP001 		return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SfxObjectBarLB_Impl::EditedEntry( SvLBoxEntry* pEntry, const String& rNewText )
//STRIP001 {
//STRIP001 	SfxTBOptions_Impl *pTO = (SfxTBOptions_Impl*) pEntry->GetUserData();
//STRIP001 	if ( pTO->nId && pTO->nDomain >= SFX_OBJECTBAR_USERDEF1 && pTO->nDomain <= SFX_OBJECTBAR_USERDEF4 )
//STRIP001 	{
//STRIP001 		pTO->aUserName = rNewText;
//STRIP001 		((SfxObjectBarConfigPage*) Window::GetParent())->EndEditing();
//STRIP001 		bModified = TRUE;
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SfxObjectBarLB_Impl::DoubleClickHdl()
//STRIP001 {
//STRIP001 	return FALSE;                       // kein Expandieren/Kollabieren
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 // SfxObjectBarConfigPage::Ctor() *********************************************
//STRIP001 
//STRIP001 SfxObjectBarConfigPage::SfxObjectBarConfigPage( Window *pParent, const SfxItemSet& rSet ) :
//STRIP001 
//STRIP001 	SfxTabPage ( pParent, SfxResId( TP_CONFIG_OBJECTBAR), rSet ),
//STRIP001 
//STRIP001 	aObjectBarBox   ( this, ResId( BOX_OBJBARS ) ),
//STRIP001 	aGBAssign       ( this, ResId( GB_ASSIGN ) ),
//STRIP001 	aNewButton      ( this, ResId( BTN_NEW ) ),
//STRIP001 	aDeleteButton   ( this, ResId( BTN_DELETE ) ),
//STRIP001 	aCustButton 	( this, ResId( BTN_CUSTOMIZE ) ),
//STRIP001 //	aDefaultButton	( this, ResId( BTN_DEFAULT ) ),
//STRIP001 	aContentText    ( this, ResId( FT_CONTENT ) ),
//STRIP001 	aContentBox     ( this, ResId( LB_CONTENT ) ),
//STRIP001 	aContextText    ( this, ResId( FT_CONTEXT ) ),
//STRIP001 	aContextBox     ( this, ResId( LB_CONTEXT ) ),
//STRIP001 	aGBOptions      ( this, ResId( GB_OPTIONS ) ),
//STRIP001 	aLoadButton 	( this, ResId( BTN_LOAD	) ),
//STRIP001 	aSaveButton 	( this, ResId( BTN_SAVE	) ),
//STRIP001 	aResetButton	( this, ResId( BTN_RESET ) ),
//STRIP001 	aDomainStr      (       ResId( STR_DOMAIN   ) ),
//STRIP001 	pTbxConfig		( NULL ),
//STRIP001 
//STRIP001 	pArr			( NULL ),
//STRIP001 	bModified		( FALSE ),
//STRIP001     bDefault		( TRUE )
//STRIP001 {
//STRIP001 	aContentBox.InsertEntry(String(SfxResId(STR_SYMBOL)));
//STRIP001 	aContentBox.InsertEntry(String(SfxResId(STR_TEXT)));
//STRIP001 	aContentBox.InsertEntry(String(SfxResId(STR_SYMBOLTEXT)));
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	pButton = new SvLBoxButtonData( &aObjectBarBox );
//STRIP001 	aObjectBarBox.EnableCheckButton(pButton);
//STRIP001 
//STRIP001 //	  DragDropMode aDDMode = SV_DRAGDROP_CTRL_MOVE;
//STRIP001 //	  aObjectBarBox.SetDragDropMode( aDDMode );
//STRIP001 
//STRIP001 	aObjectBarBox.SetSelectHdl( LINK(this,SfxObjectBarConfigPage,SelectHdl));
//STRIP001 	aContentBox.SetSelectHdl( LINK(this,SfxObjectBarConfigPage,SelectContent));
//STRIP001 	aContextBox.SetSelectHdl( LINK(this,SfxObjectBarConfigPage,SelectContext));
//STRIP001 	aNewButton.SetClickHdl( LINK(this,SfxObjectBarConfigPage,NewHdl));
//STRIP001 	aDeleteButton.SetClickHdl( LINK(this,SfxObjectBarConfigPage,DeleteHdl));
//STRIP001 	aObjectBarBox.SetCheckButtonHdl( LINK(this,SfxObjectBarConfigPage,CheckHdl));
//STRIP001 //	aDefaultButton.SetClickHdl( LINK(this,SfxObjectBarConfigPage,DefaultHdl));
//STRIP001 	aResetButton.SetClickHdl( LINK(this,SfxObjectBarConfigPage,Default));
//STRIP001 	aCustButton.SetClickHdl( LINK(this,SfxObjectBarConfigPage,CustHdl));
//STRIP001 	aLoadButton.SetClickHdl( LINK(this,SfxObjectBarConfigPage,Load));
//STRIP001 	aSaveButton.SetClickHdl( LINK(this,SfxObjectBarConfigPage,Save));
//STRIP001 
//STRIP001 	aDeleteButton.Disable();
//STRIP001 	aContextText.Disable();
//STRIP001 	aContextBox.Disable();
//STRIP001 	aContextText.Hide();
//STRIP001 	aContextBox.Hide();
//STRIP001 //	aDefaultButton.Disable();
//STRIP001 
//STRIP001 	pArr = new SfxTBOptArr_Impl;
//STRIP001 	aObjectBarBox.EnableInplaceEditing(TRUE);
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 SfxObjectBarConfigPage::~SfxObjectBarConfigPage()
//STRIP001 {
//STRIP001 	Exit();
//STRIP001 	delete pArr;
//STRIP001 	delete pButton;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxObjectBarConfigPage, CheckHdl, SvTreeListBox *, pSvTreeListBox )
//STRIP001 {
//STRIP001 	SvLBoxEntry *pEntry 	= aObjectBarBox.GetHdlEntry();
//STRIP001 	BOOL bVis = (aObjectBarBox.GetCheckButtonState(pEntry) == SV_BUTTON_CHECKED);
//STRIP001 
//STRIP001 	SfxTBOptions_Impl *pTO  = (SfxTBOptions_Impl*) pEntry->GetUserData();
//STRIP001 	bModified = TRUE;
//STRIP001 	bDefault = FALSE;
//STRIP001 	if ( aObjectBarBox.GetChildCount(pEntry) == 1 )
//STRIP001 	{
//STRIP001 		// Ausschalten kollabierter Bereiche wirkt nur auf den Bereich,
//STRIP001 		// Einschalten wirkt immer auf Bereich und Objektleiste
//STRIP001 		if ( bVis )
//STRIP001 			pTO->bVisible = bVis;		// Objektleiste
//STRIP001 		pEntry = aObjectBarBox.FirstChild(pEntry);
//STRIP001 		pTO = (SfxTBOptions_Impl*) pEntry->GetUserData();
//STRIP001 		pTO->bVisible = bVis;			// Bereich
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pTO->bVisible = bVis;			// Objektleiste
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxObjectBarConfigPage, SelectHdl, SvTreeListBox *, pBox )
//STRIP001 {
//STRIP001 										// selektierten Eintrag holen
//STRIP001 	SvLBoxEntry *pEntry = pBox->FirstSelected();
//STRIP001 
//STRIP001 										// deselektiert
//STRIP001 	if (pEntry == 0)
//STRIP001 	{
//STRIP001 		aContextBox.SetNoSelection();
//STRIP001 //		aDefaultButton.Disable();
//STRIP001 		aDeleteButton.Disable();
//STRIP001 		aContextText.Disable();
//STRIP001 		aContextBox.Disable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{                                   // Name und Kontext uebertragen
//STRIP001 
//STRIP001 		SfxTBOptions_Impl *pTO = (SfxTBOptions_Impl*) pEntry->GetUserData();
//STRIP001 		aContentBox.SelectEntryPos( (USHORT) pTO->eType );
//STRIP001 		if (pTO->pIFace == 0)
//STRIP001 		{								// Trenner selektiert
//STRIP001 			aContextBox.SetNoSelection();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aContextBox.SelectEntry(pTO->pIFace->GetName());
//STRIP001 //			aContextText.Enable( bCondition );
//STRIP001 //			aContextBox.Enable( bCondition );
//STRIP001 		}
//STRIP001 
//STRIP001 //		aDefaultButton.Enable();
//STRIP001 		BOOL bCondition = SfxToolBoxManager::IsUserDefToolBox_Impl(pTO->nId);
//STRIP001 		aDeleteButton.Enable( bCondition );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxObjectBarConfigPage, SelectContext, ListBox *, pBox )
//STRIP001 {
//STRIP001 										// selektierten Kontext ermitteln
//STRIP001 	USHORT nPos = pBox->GetSelectEntryPos();
//STRIP001 
//STRIP001 										// selektierte ToolBox holen
//STRIP001 	SvLBoxEntry *pSelected = aObjectBarBox.FirstSelected();
//STRIP001 	SfxTBOptions_Impl *pTO = (SfxTBOptions_Impl*) pSelected->GetUserData();
//STRIP001 
//STRIP001 										// Wenn Bereich selektiert ...
//STRIP001 	if (pSelected && !pTO->pIFace)
//STRIP001 		pSelected = 0;
//STRIP001 
//STRIP001 	if (!pSelected)                     // keine ToolBox, keine Anzeige
//STRIP001 	{
//STRIP001 		pBox->SetNoSelection();
//STRIP001 		return 0;
//STRIP001 	}
//STRIP001 										// ToolBox ohne Kontext geht nicht
//STRIP001 	if (pBox->GetSelectEntryCount() == 0)
//STRIP001 	{
//STRIP001 		aObjectBarBox.SelectAll(FALSE,TRUE);
//STRIP001 		return 0;
//STRIP001 	}
//STRIP001 										// alle Geschwister nach dem
//STRIP001 										// selektierten Kontext absuchen
//STRIP001 	SvLBoxEntry *pParent = aObjectBarBox.GetParent(pSelected);
//STRIP001 	if (!pParent)
//STRIP001 		pParent = pSelected;
//STRIP001 	SvLBoxEntry *pChild = aObjectBarBox.FirstChild(pParent);
//STRIP001 
//STRIP001 	BOOL bError = FALSE;
//STRIP001 	while (pChild)
//STRIP001 	{
//STRIP001 		if (pChild == pSelected)
//STRIP001 		{
//STRIP001 			pChild = aObjectBarBox.NextSibling(pChild);
//STRIP001 			if (!pChild) break;
//STRIP001 		}
//STRIP001 
//STRIP001 		SfxTBOptions_Impl *pT = (SfxTBOptions_Impl*) pChild->GetUserData();
//STRIP001 		if (pT->pIFace ==(SfxInterface*)  pBox->GetEntryData(nPos))
//STRIP001 		{
//STRIP001 			bError = TRUE;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		pChild = aObjectBarBox.NextSibling(pChild);
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bError)
//STRIP001 	{
//STRIP001 										// alter Kontext bleibt erhalten
//STRIP001 		pBox->SelectEntry(pTO->pIFace->GetName());
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 										// neuen Kontext eintragen
//STRIP001 		pTO->pIFace = (SfxInterface*) pBox->GetEntryData(nPos);
//STRIP001 		bModified = TRUE;
//STRIP001 		bDefault = FALSE;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxObjectBarConfigPage::Apply( SfxToolBoxConfig* pTbxCfg, BOOL bIsDefault )
//STRIP001 {
//STRIP001 	if ( bIsDefault )
//STRIP001 	{
//STRIP001 		pTbxCfg->UseDefault();
//STRIP001 		pTbxCfg->SetDefault( TRUE );
//STRIP001 
//STRIP001 		SvUShorts aListOfIds;
//STRIP001 		USHORT n=0;
//STRIP001 
//STRIP001         // copy all toolbox configurations as they were before starting the configuration dialog
//STRIP001         // don't copy immediately, put the IDs into a list and copy later
//STRIP001         // userdefined toolboxes start a new interface iterating loop, and these loops are
//STRIP001         // not reentrant
//STRIP001 		SfxInterface *pIFace;
//STRIP001 		SfxConfigManager* pCfgMgr = pTbxCfg->GetConfigManager();
//STRIP001 		for ( pIFace = SFX_SLOTPOOL().FirstInterface(); pIFace != 0; pIFace = SFX_SLOTPOOL().NextInterface() )
//STRIP001 		{
//STRIP001 			if ( pIFace->HasName() )
//STRIP001 			{
//STRIP001 				for ( USHORT nNo=0; nNo<pIFace->GetObjectBarCount(); nNo++ )
//STRIP001 				{
//STRIP001 					USHORT nId = pIFace->GetObjectBarResId(nNo).GetId();
//STRIP001 					aListOfIds.Insert(nId, n++);
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001         // copy items collected
//STRIP001 		for ( USHORT i=0; i<n; i++ )
//STRIP001 		{
//STRIP001 			pCfgMgr->ResetConfigItem( aListOfIds[i] );
//STRIP001 			pCfgMgr->ReInitialize( aListOfIds[i] );
//STRIP001 		}
//STRIP001 
//STRIP001         // copy user defined toolboxes also
//STRIP001         for ( USHORT nId = RID_SFX_TOOLBOX_USERSTART; nId <= RID_SFX_TOOLBOX_USEREND; nId++ )
//STRIP001 		{
//STRIP001             pCfgMgr->ResetConfigItem( nId );
//STRIP001 			pCfgMgr->ReInitialize( nId );
//STRIP001 		}
//STRIP001 
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 //	pTbxConfig->SetDefault( FALSE );
//STRIP001 	for ( USHORT n=pArr->Count(); n>0; n-- )
//STRIP001 	{
//STRIP001 		// R"uckw"arts, damit zuerst die gel"oschten UserDefToolBoxen abgemeldet
//STRIP001 		// werden, bevor neue etvl. mit der gleichen Id angemeldet werden!
//STRIP001 		SfxTBOptions_Impl *pTO = (*pArr)[n-1];
//STRIP001 		if ( pTO == 0 )
//STRIP001 			continue;
//STRIP001 
//STRIP001 		USHORT nId = pTO->nId;
//STRIP001 		SfxInterface* pIFace = pTO->pIFace;
//STRIP001 										// Wurde der Kontext gewechselt ?
//STRIP001 		if ( pIFace != pTO->pOldIFace )
//STRIP001 		{
//STRIP001 			if ( pIFace )				// Neuer Kontext
//STRIP001 			{							// Gibt es einen alten Kontext ??
//STRIP001 				pIFace->TransferObjectBar( pTO->nDomain, nId, pTO->pOldIFace, &pTO->aName );
//STRIP001 				pIFace->SetObjectBarVisible( pTO->bVisible, nId );
//STRIP001 			}
//STRIP001 			else if ( pTO->pOldIFace )	// nur abmelden
//STRIP001 			{
//STRIP001 				pTO->pOldIFace->ReleaseObjectBar( nId );
//STRIP001 				if ( !pIFace && SfxToolBoxManager::IsUserDefToolBox_Impl( nId ) )
//STRIP001 				{
//STRIP001 										// selbstdefinierte Toolboxen, die in
//STRIP001 										// keinem Interface mehr registriert
//STRIP001 										// sind, koennen entfernt werden
//STRIP001                     pTbxCfg->GetConfigManager()->ResetConfigItem( nId );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if ( pIFace )
//STRIP001 		{
//STRIP001 			if ( pTO->nDomain != pTO->nOldDomain )
//STRIP001 				pIFace->SetObjectBarPos( pTO->nDomain, nId );
//STRIP001 
//STRIP001 			if ( pTO->aName != pTO->aOldName )
//STRIP001 				pIFace->SetObjectBarName( pTO->aName, nId );
//STRIP001 
//STRIP001 			if ( pTO->bVisible != pTO->bWasVisible )
//STRIP001 				pIFace->SetObjectBarVisible( pTO->bVisible, nId );
//STRIP001 			
//STRIP001 			if ( SfxToolBoxManager::IsUserDefToolBox_Impl( nId ) && pTO->aOldUserName != pTO->aUserName )
//STRIP001 				pTbxCfg->SetToolBoxPositionUserName( pTO->nDomain, pTO->aUserName );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			USHORT nDomain = pTO->nDomain;
//STRIP001 			if ( pTO->eType != pTO->eOldType )
//STRIP001 				pTbxCfg->SetButtonType( nDomain, pTO->eType );
//STRIP001 
//STRIP001 			if ( pTO->bVisible != pTO->bWasVisible )
//STRIP001 				pTbxCfg->SetToolBoxPositionVisible( nDomain, pTO->bVisible );
//STRIP001 
//STRIP001 			if ( pTO->nId && nDomain >= SFX_OBJECTBAR_USERDEF1 && nDomain <= SFX_OBJECTBAR_USERDEF4 )
//STRIP001 			{
//STRIP001 				if ( pTO->bDeleted )
//STRIP001 					SfxToolBoxManager::RemoveConfiguration( pTbxCfg->GetConfigManager(), pTO->nId );
//STRIP001 				else
//STRIP001 					SfxToolBoxManager::CreateConfiguration( pTbxCfg->GetConfigManager(), pTO->nId );
//STRIP001 
//STRIP001 				if ( SfxToolBoxManager::IsUserDefToolBox_Impl( nId ) && pTO->aOldUserName != pTO->aUserName )
//STRIP001 				{
//STRIP001 					pTbxCfg->SetToolBoxPositionUserName( pTO->nDomain, pTO->aUserName );
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 //			if ( pTO->aName != pTO->aOldName )
//STRIP001 //				pTbxCfg->SetToolBoxPositionName( nDomain, &pTO->aName );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxObjectBarConfigPage, CustHdl, PushButton *, pButton )
//STRIP001 {
//STRIP001 	((SfxTabDialog*)GetParent()->GetParent())->OK_Impl();
//STRIP001 	((SfxConfigDialog*)GetParent()->GetParent())->Ok();
//STRIP001 	((SfxTabDialog*)GetParent()->GetParent())->EndDialog(3);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxObjectBarConfigPage::Exit()
//STRIP001 {
//STRIP001 	for (USHORT i=0; i<pArr->Count(); i++)
//STRIP001 	{
//STRIP001 		SfxTBOptions_Impl *pTO = (*pArr)[i];
//STRIP001 		if (pTO)
//STRIP001 			delete pTO;
//STRIP001 	}
//STRIP001 
//STRIP001 	pArr->Remove(0, pArr->Count());
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 typedef SvLBoxEntry* EntryPtr;
//STRIP001 
//STRIP001 void SfxObjectBarConfigPage::Init(USHORT nSelectedId, BOOL bLoadedCfg )
//STRIP001 {
//STRIP001 	SvLBoxEntry *pSelectedEntry=0;
//STRIP001 
//STRIP001 	// Zun"achst Platz f"ur selbstdefinierte Toolboxen schaffen
//STRIP001 	USHORT nIndex;
//STRIP001 	for ( nIndex=0; nIndex<NEW_SFX_TOOLBOX_MAX; nIndex++ )
//STRIP001 		pArr->Append( (SfxTBOptions_Impl*)0 );
//STRIP001 
//STRIP001 	SfxInterface            *pIFace;
//STRIP001 	SfxTBOptions_Impl       *pTO;       // ToolBox-Arbeitsdaten
//STRIP001 	USHORT                  n=0;        // Interface-Zaehler
//STRIP001 	String					aEmpty;
//STRIP001 
//STRIP001 	// Aus allen auffindbaren Interfaces die Toolboxen einsammeln
//STRIP001 	SfxSlotPool& rSlotPool = SFX_SLOTPOOL();
//STRIP001 	for ( pIFace = rSlotPool.FirstInterface(); pIFace != 0;
//STRIP001 		  pIFace = rSlotPool.NextInterface() )
//STRIP001 	{
//STRIP001 		// Nur Interfaces mit Namen sind anzeigbare Kontexte
//STRIP001 		if ( pIFace->HasName() )
//STRIP001 		{
//STRIP001 			aContextBox.InsertEntry(pIFace->GetName());
//STRIP001 			aContextBox.SetEntryData(n++, pIFace);
//STRIP001 
//STRIP001 			for ( USHORT nNo=0; nNo<pIFace->GetObjectBarCount(); nNo++ )
//STRIP001 			{
//STRIP001 				// F"ur jede Objectbar ein Options-struct anlegen und in das
//STRIP001 				// array einf"ugen
//STRIP001 				pTO = new SfxTBOptions_Impl(nIndex,
//STRIP001 											pIFace->GetObjectBarResId(nNo).GetId(),
//STRIP001 											pIFace->GetObjectBarPos(nNo),
//STRIP001 										  *(pIFace->GetObjectBarName(nNo)),
//STRIP001 											pIFace->IsObjectBarVisible(nNo),
//STRIP001 											pIFace,
//STRIP001 											BUTTON_SYMBOL );	// Erst mal defaulten, wird unten vom Bereich geholt
//STRIP001 
//STRIP001 				nIndex++;
//STRIP001 				pArr->Append(pTO);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	SfxConfigManager* pMgr = GetTabDialog()->GetViewFrame()->GetObjectShell()->GetConfigManager();
//STRIP001 	USHORT nMask = SFX_VISIBILITY_CLIENT | SFX_VISIBILITY_STANDARD;
//STRIP001 	if ( !pMgr )
//STRIP001 	{
//STRIP001 		pMgr = SFX_APP()->GetConfigManager_Impl();
//STRIP001 		nMask = SFX_VISIBILITY_SERVER | SFX_VISIBILITY_STANDARD;
//STRIP001 	}
//STRIP001 
//STRIP001 	for ( USHORT nUser=0; nUser<4; nUser++ )
//STRIP001 	{
//STRIP001 		USHORT nType = nUser + RID_SFX_TOOLBOX_START + 10;
//STRIP001 		if ( pMgr->HasConfigItem( nType ) )
//STRIP001 		{
//STRIP001 			pTO = new SfxTBOptions_Impl(nUser,
//STRIP001 										nType,
//STRIP001 										SFX_OBJECTBAR_USERDEF1 + nUser,
//STRIP001 										pTbxConfig->GetToolBoxPositionName( SFX_OBJECTBAR_USERDEF1 + nUser ),
//STRIP001 										pTbxConfig->IsToolBoxPositionVisible( SFX_OBJECTBAR_USERDEF1 + nUser ),
//STRIP001 										NULL,
//STRIP001 										BUTTON_SYMBOL );	// Erst mal defaulten, wird unten vom Bereich geholt
//STRIP001 
//STRIP001 			pTO->aUserName = pTbxConfig->GetToolBoxPositionUserName( SFX_OBJECTBAR_USERDEF1 + nUser );
//STRIP001 			if ( !bLoadedCfg )
//STRIP001 			{
//STRIP001 				// Set old and new user name identical only if haven't loaded a configuration! Otherwise
//STRIP001 				// we won't store a new user name because they are identical!
//STRIP001 				pTO->aOldUserName = pTO->aUserName;
//STRIP001 			}
//STRIP001 			(*pArr)[nUser] = pTO;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	SvLBoxEntry* pEntry;
//STRIP001 	SvLBoxEntry* pParentEntry;
//STRIP001 	EntryPtr *pEntryArr = new EntryPtr[SFX_OBJECTBAR_MAX];
//STRIP001 
//STRIP001 	// Jede Objectbar-Position ist ein entsprechender Bereich in der Listbox
//STRIP001 	for (n=0; n<SFX_OBJECTBAR_MAX; n++ )
//STRIP001 	{
//STRIP001 		USHORT nDomain = IndexToPos_Impl(n);
//STRIP001 		String aStr = pTbxConfig->GetToolBoxPositionName( nDomain );
//STRIP001 		pEntry = aObjectBarBox.InsertEntry( aStr );
//STRIP001 		pEntryArr[n] = pEntry;
//STRIP001 
//STRIP001 		// Eigenschaften des Bereiches
//STRIP001 		pTO = new SfxTBOptions_Impl(n, 0, nDomain, aStr,
//STRIP001 				pTbxConfig->IsToolBoxPositionVisible( nDomain ), 0,
//STRIP001 				pTbxConfig->GetButtonType( nDomain ) );
//STRIP001 		
//STRIP001 		// Sichtbarkeits-Status auf den entsprechenden Checkbutton "ubertragen
//STRIP001 		if ( pTO->bVisible )
//STRIP001 			aObjectBarBox.SetCheckButtonState(pEntry, SV_BUTTON_CHECKED);
//STRIP001 		else
//STRIP001 			aObjectBarBox.SetCheckButtonState(pEntry, SV_BUTTON_UNCHECKED);
//STRIP001 
//STRIP001 		pArr->Append(pTO);
//STRIP001 		pEntry->SetUserData(pTO);
//STRIP001 	}
//STRIP001 
//STRIP001 	// F"ur jede Objectbar den entsprechenden entry aus dem array holen
//STRIP001 	for (n=0; n<pArr->Count();  n++)
//STRIP001 	{
//STRIP001 		pTO = (*pArr)[n];
//STRIP001 		if ( pTO && pTO->nId )
//STRIP001 		{
//STRIP001 			USHORT nIndex = PosToIndex_Impl( pTO->nDomain & SFX_POSITION_MASK );
//STRIP001 			pParentEntry = pEntryArr[ nIndex ];
//STRIP001 			pEntry = aObjectBarBox.InsertEntry( pTO->aName, pParentEntry );
//STRIP001 			pEntry->SetUserData(pTO);
//STRIP001 
//STRIP001 			// Buttontype vom Bereich auf die Objectbar "ubertragen
//STRIP001 			pTO->eType = pTO->eOldType = ((SfxTBOptions_Impl*)pParentEntry->GetUserData())->eType;
//STRIP001 
//STRIP001 			// Sichtbarkeits-Status auf den entsprechenden Checkbutton "ubertragen
//STRIP001 			if (pTO->bVisible)
//STRIP001 				aObjectBarBox.SetCheckButtonState(pEntry, SV_BUTTON_CHECKED);
//STRIP001 			else
//STRIP001 				aObjectBarBox.SetCheckButtonState(pEntry, SV_BUTTON_UNCHECKED);
//STRIP001 
//STRIP001 			// Falls eine Id "ubergeben wurde, soll sie die Objectbar mit
//STRIP001 			// diese Id gleich selektiert werden
//STRIP001 			if ( pTO->nId == nSelectedId )
//STRIP001 				pSelectedEntry = pEntry;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Alle Bereiche untersuchen, ob sie mehr als einen ChildEntry enthalten;
//STRIP001 	// anderenfalls wird der Entry f"ur den Bereich durch den seines childs
//STRIP001 	// ersetzt
//STRIP001 	for (n=0; n<SFX_OBJECTBAR_MAX; n++ )
//STRIP001 	{
//STRIP001 		pParentEntry = pEntryArr[n];
//STRIP001 		if ( aObjectBarBox.GetChildCount(pParentEntry) == 1 )
//STRIP001 		{
//STRIP001 			pEntry = aObjectBarBox.FirstChild( pParentEntry );
//STRIP001 			SfxTBOptions_Impl *pTO = (SfxTBOptions_Impl*) pEntry->GetUserData();
//STRIP001 			SfxTBOptions_Impl *pT = (SfxTBOptions_Impl*) pParentEntry->GetUserData();
//STRIP001 			pParentEntry->SetUserData(pTO);
//STRIP001 			pEntry->SetUserData(pT);
//STRIP001 
//STRIP001 			if ( pT->bVisible )
//STRIP001 				aObjectBarBox.SetCheckButtonState( pParentEntry, aObjectBarBox.GetCheckButtonState(pEntry) );
//STRIP001 
//STRIP001 			if ( bLoadedCfg )
//STRIP001 			{
//STRIP001 				// Force update if we loaded a configuration
//STRIP001 				if ( pT->bVisible )
//STRIP001 					pT->bWasVisible = FALSE;
//STRIP001 				else
//STRIP001 					pT->bWasVisible = TRUE;
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( pTO->aName.Len() )
//STRIP001 			{
//STRIP001 				if ( pTO->nDomain >= SFX_OBJECTBAR_USERDEF1 && pTO->nDomain <= SFX_OBJECTBAR_USERDEF4 && pTO->aUserName.Len() )
//STRIP001 					aObjectBarBox.SetEntryText(pParentEntry,pTO->aUserName);
//STRIP001 				else
//STRIP001 					aObjectBarBox.SetEntryText(pParentEntry,pTO->aName);
//STRIP001 				if (pEntry == pSelectedEntry)
//STRIP001 					pSelectedEntry = pParentEntry;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				// Keine namenlosen Toolboxen ...
//STRIP001 				aObjectBarBox.GetModel()->Remove(pParentEntry);
//STRIP001 		}
//STRIP001 		else if ( aObjectBarBox.GetChildCount(pParentEntry) == 0 )
//STRIP001 			// Keine leeren Bereiche ...
//STRIP001 			aObjectBarBox.GetModel()->Remove(pParentEntry);
//STRIP001 		else
//STRIP001 		{
//STRIP001 			SfxTBOptions_Impl *pT = (SfxTBOptions_Impl*) pParentEntry->GetUserData();
//STRIP001 			if ( bLoadedCfg )
//STRIP001 			{
//STRIP001 				// Force update if we loaded a configuration
//STRIP001 				if ( pT->bVisible )
//STRIP001 					pT->bWasVisible = FALSE;
//STRIP001 				else
//STRIP001 					pT->bWasVisible = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 //		else
//STRIP001 //			// Alle gef"ullten Bereiche werden auch aufgeklappt angezeigt
//STRIP001 //			aObjectBarBox.Expand (pParentEntry);
//STRIP001 	}
//STRIP001 
//STRIP001 	delete []pEntryArr;
//STRIP001 
//STRIP001 	if ( pSelectedEntry )
//STRIP001 		aObjectBarBox.SetCurEntry( pSelectedEntry );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxObjectBarConfigPage::SetObjectBarId(USHORT nId)
//STRIP001 {
//STRIP001 	SvLBoxEntry *pEntry  = aObjectBarBox.First();
//STRIP001 	SvLBoxEntry *pLast	 = pEntry;
//STRIP001 
//STRIP001 	while (pEntry)
//STRIP001 	{
//STRIP001 		pLast  = pEntry;				// letzte ToolBox merken
//STRIP001 		SfxTBOptions_Impl *pTO = (SfxTBOptions_Impl*) pEntry->GetUserData();
//STRIP001 
//STRIP001 		if (pTO->pIFace)				// eine ToolBox
//STRIP001 		{
//STRIP001 			if (pTO->nId == nId)		// gefunden!
//STRIP001 				break;
//STRIP001 										// sonst naechste ToolBox
//STRIP001 			pEntry = aObjectBarBox.NextSibling(pEntry);
//STRIP001 
//STRIP001 			if (!pEntry)				// gibt's nicht, also nach oben
//STRIP001 			{
//STRIP001 				pEntry = aObjectBarBox.GetParent(pLast);
//STRIP001 				pLast = pEntry;
//STRIP001 				if (pEntry) 			// es geht noch weiter
//STRIP001 					pEntry = aObjectBarBox.NextSibling(pEntry);
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else							// ein Bereich, also nach unten
//STRIP001 			pEntry = aObjectBarBox.FirstChild(pEntry);
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pEntry)
//STRIP001 		aObjectBarBox.SetCurEntry(pEntry);
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxObjectBarConfigPage, NewHdl, PushButton *, pPushButton )
//STRIP001 {
//STRIP001 										// freien Platz suchen
//STRIP001 	USHORT nIndex;
//STRIP001 	SfxTBOptions_Impl* pTO;
//STRIP001 	for (nIndex=0; nIndex<NEW_SFX_TOOLBOX_MAX; nIndex++)
//STRIP001 	{
//STRIP001 		pTO = (*pArr)[nIndex];
//STRIP001 		if ( !pTO || pTO->bDeleted )
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( nIndex == NEW_SFX_TOOLBOX_MAX )      // alle Plaetze belegt
//STRIP001 	{
//STRIP001 		InfoBox( this, SfxResId(IBX_TBXOPT_OVERFLOW) ).Execute();
//STRIP001 		return 0;
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT nDomain = SFX_OBJECTBAR_USERDEF1 + nIndex;
//STRIP001 	USHORT nParent;
//STRIP001 	for ( nParent=0; nParent<pArr->Count(); nParent++ )
//STRIP001 		if ((*pArr)[nParent] && (*pArr)[nParent]->nDomain == nDomain ) break;
//STRIP001 
//STRIP001 	if ( pTO )
//STRIP001 		pTO->bDeleted = FALSE;
//STRIP001 	else
//STRIP001 		pTO = new SfxTBOptions_Impl( nIndex,
//STRIP001 									RID_SFX_TOOLBOX_START + 10 + nIndex,
//STRIP001 									nDomain,
//STRIP001 									pTbxConfig->GetToolBoxPositionName( nDomain ),
//STRIP001 									TRUE,
//STRIP001 									NULL,
//STRIP001 									BUTTON_SYMBOL );	// Erst mal defaulten, wird unten vom Bereich geholt
//STRIP001 	(*pArr)[nIndex] = pTO;
//STRIP001 	bModified = TRUE;
//STRIP001 	bDefault = FALSE;
//STRIP001 
//STRIP001 	SvLBoxEntry *pParent = aObjectBarBox.InsertEntry( pTO->aName, 0, FALSE, PosToIndex_Impl( nDomain ), pTO );
//STRIP001 	SvLBoxEntry *pEntry = aObjectBarBox.InsertEntry( pTO->aName, pParent, FALSE, PosToIndex_Impl( nDomain ), (*pArr)[nParent] );
//STRIP001 	aObjectBarBox.SetCheckButtonState( pParent, SV_BUTTON_CHECKED );
//STRIP001 	aObjectBarBox.SetCheckButtonState( pEntry, SV_BUTTON_CHECKED );
//STRIP001 	aObjectBarBox.SetCurEntry( pParent );
//STRIP001 /*
//STRIP001 										// Name und Id mit default vorbelegen
//STRIP001 	USHORT nId = RID_SFX_TOOLBOX_USERSTART + nIndex;
//STRIP001 	String aName = String (SfxResId(STR_TB_USERDEF_NAME));
//STRIP001 	aName += String::CreateFromInt32(nIndex+1);
//STRIP001 
//STRIP001 	USHORT nPos=0;                      // Bereich und Kontext (Interface)
//STRIP001 	USHORT n=0;                         // durch Suche ermitteln
//STRIP001 	BOOL bError;
//STRIP001 										// mit erstem Bereich starten
//STRIP001 	SvLBoxEntry *pParent = aObjectBarBox.First();
//STRIP001 	USHORT nCount=1;
//STRIP001 
//STRIP001 	SvLBoxEntry *pEntry = aObjectBarBox.FirstSelected();
//STRIP001 
//STRIP001 	SfxTBOptions_Impl* pPTO = (SfxTBOptions_Impl*)pParent->GetUserData();
//STRIP001 	nPos = PosToIndex_Impl( pPTO->nDomain & SFX_POSITION_MASK );
//STRIP001 
//STRIP001 	while ( nPos < PosToIndex_Impl(USERDEF_DOMAIN) )
//STRIP001 	{									// zum ersten UserDef-Bereich
//STRIP001 		pParent = aObjectBarBox.NextSibling(pParent);
//STRIP001 		if (pParent)
//STRIP001 		{
//STRIP001 			pPTO = (SfxTBOptions_Impl*)pParent->GetUserData();
//STRIP001 			nPos = PosToIndex_Impl( pPTO->nDomain & SFX_POSITION_MASK );
//STRIP001 			nCount++;
//STRIP001 		}
//STRIP001 		else							// gibt es noch nicht
//STRIP001 			nPos = PosToIndex_Impl(USERDEF_DOMAIN);
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT nLastCount = nCount;
//STRIP001 	SvLBoxEntry *pFirstUserDef = pParent;
//STRIP001 
//STRIP001 	if (pEntry) 						// einfuegen in selektierten Bereich
//STRIP001 	{
//STRIP001 		SfxTBOptions_Impl* pETO = (SfxTBOptions_Impl*)pEntry->GetUserData();
//STRIP001 		USHORT i = PosToIndex_Impl( pETO->nDomain & SFX_POSITION_MASK );
//STRIP001 		if ( i > PosToIndex_Impl(USERDEF_DOMAIN) )
//STRIP001 		{
//STRIP001 			nPos = i;
//STRIP001 			pParent = aObjectBarBox.GetParent(pEntry) ?
//STRIP001 					  aObjectBarBox.GetParent(pEntry) : pEntry;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	do
//STRIP001 	{
//STRIP001 		do
//STRIP001 		{
//STRIP001 			if (!pParent)
//STRIP001 			{
//STRIP001 				String aStr = pTbxConfig->GetToolBoxPositionName(n);
//STRIP001 				if (!aStr.Len())
//STRIP001 					aStr = aName;
//STRIP001 				pParent = aObjectBarBox.InsertEntry( aStr,0,FALSE,nCount );
//STRIP001 				USHORT nDom = IndexToPos_Impl( nPos );
//STRIP001 				SfxTBOptions_Impl *pTO =
//STRIP001 					new SfxTBOptions_Impl(nPos, 0, nDom, aName,
//STRIP001 						pTbxConfig->IsToolBoxPositionVisible(nPos),
//STRIP001 						0, BUTTON_SYMBOL);
//STRIP001 				pTO->bVisible = TRUE;
//STRIP001 
//STRIP001 				aObjectBarBox.SetCheckButtonState(pParent, SV_BUTTON_CHECKED);
//STRIP001 				pArr->Append(pTO);
//STRIP001 				pParent->SetUserData(pTO);
//STRIP001 				if (!pFirstUserDef)
//STRIP001 					pFirstUserDef = pParent;
//STRIP001 			}
//STRIP001 
//STRIP001 			SvLBoxEntry *pChild = aObjectBarBox.FirstChild(pParent);
//STRIP001 
//STRIP001 			bError = FALSE;
//STRIP001 			while (pChild)
//STRIP001 			{
//STRIP001 				SfxTBOptions_Impl *pT = (SfxTBOptions_Impl*) pChild->GetUserData();
//STRIP001 				if (!pT->pIFace)
//STRIP001 					pT = (SfxTBOptions_Impl*) pParent->GetUserData();
//STRIP001 				if (pT->pIFace == (SfxInterface*) aContextBox.GetEntryData(n))
//STRIP001 				{
//STRIP001 					bError = TRUE;
//STRIP001 					break;
//STRIP001 				}
//STRIP001 
//STRIP001 				pChild = aObjectBarBox.NextSibling(pChild);
//STRIP001 			}
//STRIP001 
//STRIP001 			if (bError)                 // in diesem Bereich gibt es schon eine
//STRIP001 			{                           // Toolbox mit gewuenschtem Interface
//STRIP001 				if ( pEntry && nPos != 0 && nPos != PosToIndex_Impl(USERDEF_DOMAIN) )
//STRIP001 				{						// von vorne anfangen
//STRIP001 					nPos = PosToIndex_Impl(USERDEF_DOMAIN);
//STRIP001 					pParent = pFirstUserDef;
//STRIP001 					nCount = nLastCount;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					pEntry = 0;
//STRIP001 					pParent = aObjectBarBox.NextSibling(pParent);
//STRIP001 					nPos++;
//STRIP001 					if (pParent)
//STRIP001 					{
//STRIP001 						SfxTBOptions_Impl *pT = (SfxTBOptions_Impl*)
//STRIP001 							pParent->GetUserData();
//STRIP001 						if ( PosToIndex_Impl( pT->nDomain & SFX_POSITION_MASK ) > nPos )
//STRIP001 							pParent = 0;
//STRIP001 						else
//STRIP001 							nCount++;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		while (bError && nPos < SFX_OBJECTBAR_MAX);
//STRIP001 
//STRIP001 		if (bError && n<aContextBox.GetEntryCount() - 1)
//STRIP001 		{
//STRIP001 			n++;						// naechsten Kontext ausprobieren
//STRIP001 			nPos = PosToIndex_Impl(USERDEF_DOMAIN);
//STRIP001 			pParent = pFirstUserDef;
//STRIP001 			nCount = nLastCount;
//STRIP001 			pEntry = 0; 				// von vorne anfangen
//STRIP001 		}
//STRIP001 	}
//STRIP001 	while (bError && nPos < SFX_OBJECTBAR_MAX);
//STRIP001 
//STRIP001 	if (bError)
//STRIP001 	{
//STRIP001 		InfoBox( this, SfxResId(IBX_TBXOPT_OVERFLOW) ).Execute();
//STRIP001 		return 0;
//STRIP001 	}
//STRIP001 										// neuer Eintrag ohne altes Interface
//STRIP001 	USHORT nTbxPos = IndexToPos_Impl( nPos );
//STRIP001 	SfxTBOptions_Impl* pTO = new SfxTBOptions_Impl(nIndex,nId,nTbxPos,aName,TRUE,0,BUTTON_SYMBOL);
//STRIP001 	(*pArr)[nIndex] = pTO;
//STRIP001 	pTO->pIFace = (SfxInterface*) aContextBox.GetEntryData(n);
//STRIP001 	bModified = TRUE;
//STRIP001 
//STRIP001 	if (aObjectBarBox.GetChildCount(pParent) == 0)
//STRIP001 	{
//STRIP001 										// erstes Child: auf Top Level
//STRIP001 		SfxTBOptions_Impl *pTp = (SfxTBOptions_Impl*) pParent->GetUserData();
//STRIP001 
//STRIP001 		pParent->SetUserData(pTO);
//STRIP001 		aObjectBarBox.SetEntryText(pParent,pTO->aName);
//STRIP001 		aObjectBarBox.SetCurEntry(pParent);
//STRIP001 
//STRIP001 		pEntry = aObjectBarBox.InsertEntry( pTO->aName, pParent );
//STRIP001 		pEntry->SetUserData(pTp);
//STRIP001 		if (pTp->bVisible)
//STRIP001 			aObjectBarBox.SetCheckButtonState(pEntry, SV_BUTTON_CHECKED);
//STRIP001 		else
//STRIP001 			aObjectBarBox.SetCheckButtonState(pEntry, SV_BUTTON_UNCHECKED);
//STRIP001 	}
//STRIP001 	else if (aObjectBarBox.GetChildCount(pParent) == 1)
//STRIP001 	{
//STRIP001 										// zweites Child: erstes Child auf
//STRIP001 										// niedrigeren Level ziehen
//STRIP001 		pEntry = aObjectBarBox.FirstChild(pParent);
//STRIP001 		SfxTBOptions_Impl *pTp = (SfxTBOptions_Impl*) pParent->GetUserData();
//STRIP001 		SfxTBOptions_Impl *pT  = (SfxTBOptions_Impl*) pEntry->GetUserData();
//STRIP001 
//STRIP001 		pParent->SetUserData(pT);
//STRIP001 		aObjectBarBox.SetEntryText(pParent,pT->aName);
//STRIP001 		if (pT->bVisible)
//STRIP001 			aObjectBarBox.SetCheckButtonState(pParent, SV_BUTTON_CHECKED);
//STRIP001 		else
//STRIP001 			aObjectBarBox.SetCheckButtonState(pParent, SV_BUTTON_UNCHECKED);
//STRIP001 
//STRIP001 		pEntry->SetUserData(pTp);
//STRIP001 		aObjectBarBox.SetEntryText(pEntry,pTp->aName);
//STRIP001 		if (pTp->bVisible)
//STRIP001 			aObjectBarBox.SetCheckButtonState(pEntry, SV_BUTTON_CHECKED);
//STRIP001 		else
//STRIP001 			aObjectBarBox.SetCheckButtonState(pEntry, SV_BUTTON_UNCHECKED);
//STRIP001 
//STRIP001 		pEntry = aObjectBarBox.InsertEntry( pTO->aName, pParent );
//STRIP001 		pEntry->SetUserData(pTO);
//STRIP001 		aObjectBarBox.SetCheckButtonState(pEntry, SV_BUTTON_CHECKED);
//STRIP001 		aObjectBarBox.SetCurEntry(pEntry);
//STRIP001 		aObjectBarBox.ShowEntry(pEntry);
//STRIP001 	}
//STRIP001  */
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxObjectBarConfigPage, DeleteHdl, PushButton *, pPushButton )
//STRIP001 {
//STRIP001 	SvLBoxEntry *pEntry = aObjectBarBox.FirstSelected();
//STRIP001 
//STRIP001 	if (pEntry)
//STRIP001 	{
//STRIP001 		SfxTBOptions_Impl *pTO = (SfxTBOptions_Impl*) pEntry->GetUserData();
//STRIP001 		if ( !SfxToolBoxManager::IsUserDefToolBox_Impl(pTO->nId) )
//STRIP001 		{
//STRIP001 			InfoBox( this, SfxResId(IBX_TBXOPT_NOUSERDEF) ).Execute();
//STRIP001 			return 0;
//STRIP001 		}
//STRIP001 
//STRIP001 		pTO->pIFace = 0;
//STRIP001 		if (pTO->pOldIFace == 0)        // geloeschter Eintrag war noch bei
//STRIP001 		{                               // keinem Interface angemeldet
//STRIP001 //			(*pArr)[pTO->nIndex] = 0;
//STRIP001 //			delete pTO;
//STRIP001 			pTO->bDeleted = TRUE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pArr->Append(pTO);          // geloeschter Eintrag war angemeldet;
//STRIP001 			(*pArr)[pTO->nIndex] = 0;   // aufheben zum spaeteren Abmelden
//STRIP001 			pTO->nIndex = pArr->Count() - 1;
//STRIP001 		}
//STRIP001 
//STRIP001 		SvLBoxEntry *pParentEntry = aObjectBarBox.GetParent(pEntry);
//STRIP001 		aObjectBarBox.GetModel()->Remove(pEntry);
//STRIP001 		bModified = TRUE;
//STRIP001 		bDefault = FALSE;
//STRIP001 
//STRIP001 		if (pParentEntry && aObjectBarBox.GetChildCount(pParentEntry) == 1)
//STRIP001 		{
//STRIP001 			pEntry = aObjectBarBox.FirstChild(pParentEntry);
//STRIP001 			SfxTBOptions_Impl *pTO = (SfxTBOptions_Impl*) pEntry->GetUserData();
//STRIP001 			SfxTBOptions_Impl *pT = (SfxTBOptions_Impl*) pParentEntry->GetUserData();
//STRIP001 			pEntry->SetUserData(pT);
//STRIP001 
//STRIP001 			pParentEntry->SetUserData(pTO);
//STRIP001 			aObjectBarBox.SetEntryText(pParentEntry,pTO->aName);
//STRIP001 			if (pTO->bVisible && pT->bVisible)
//STRIP001 				aObjectBarBox.SetCheckButtonState(pParentEntry, SV_BUTTON_CHECKED);
//STRIP001 			else
//STRIP001 				aObjectBarBox.SetCheckButtonState(pParentEntry, SV_BUTTON_UNCHECKED);
//STRIP001 			aObjectBarBox.Collapse(pParentEntry);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxObjectBarConfigPage::StartEditing()
//STRIP001 {
//STRIP001 	aNewButton.Disable();
//STRIP001 	aDeleteButton.Disable();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxObjectBarConfigPage::EndEditing()
//STRIP001 {
//STRIP001 	aNewButton.Enable();
//STRIP001 	aDeleteButton.Enable();
//STRIP001 	bModified = TRUE;
//STRIP001 	bDefault = FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxObjectBarConfigPage, DefaultHdl, PushButton *, pPushButton )
//STRIP001 {
//STRIP001 	SvLBoxEntry *pEntry = aObjectBarBox.FirstSelected();
//STRIP001 	if (!pEntry)
//STRIP001 		return 0;
//STRIP001 
//STRIP001 	SfxTBOptions_Impl *pTO = (SfxTBOptions_Impl*) pEntry->GetUserData();
//STRIP001 	if (!pTO->pIFace)
//STRIP001 		return 0;
//STRIP001 
//STRIP001     pTbxConfig->GetConfigManager()->ResetConfigItem(pTO->nId);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK( SfxObjectBarConfigPage, Load, Button *, pButton )
//STRIP001 {
//STRIP001 	String aCfgName = SfxConfigDialog::FileDialog_Impl( this,
//STRIP001 		WB_OPEN | WB_STDMODAL | WB_3DLOOK, String( SfxResId( STR_LOADTBXCONFIG) ) );
//STRIP001 	if ( aCfgName.Len() )
//STRIP001 	{
//STRIP001 		GetTabDialog()->EnterWait();
//STRIP001 		BOOL bCreated = FALSE;
//STRIP001 		BOOL bLoadedDocument = FALSE;
//STRIP001 		SfxObjectShellRef xDoc;
//STRIP001 
//STRIP001         SfxConfigManager* pCfgMgr = SFX_APP()->GetConfigManager_Impl();
//STRIP001 		if ( pCfgMgr->GetURL() != aCfgName )
//STRIP001 		{
//STRIP001 			// it was not the global configuration manager
//STRIP001 			// first check if URL points to a document already loaded
//STRIP001 			xDoc = SFX_APP()->DocAlreadyLoaded( aCfgName, TRUE, TRUE );
//STRIP001 			if ( !xDoc.Is() )
//STRIP001 				// try to load a document from the URL
//STRIP001 				xDoc = MakeObjectShellForOrganizer_Impl( aCfgName, TRUE );
//STRIP001 			
//STRIP001 			if ( xDoc.Is() )
//STRIP001 			{
//STRIP001 				// get config manager, force creation if there was none before
//STRIP001 				bLoadedDocument = TRUE;
//STRIP001 				pCfgMgr = xDoc->GetConfigManager( TRUE );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// URL doesn't point to a document, must be a single storage
//STRIP001 				bCreated = TRUE;
//STRIP001         		SvStorageRef xStor = new SvStorage( aCfgName, STREAM_STD_READ );
//STRIP001 				if ( xStor->GetError() == ERRCODE_NONE )
//STRIP001 					pCfgMgr = new SfxConfigManager( xStor );
//STRIP001 				else
//STRIP001 					pCfgMgr = NULL;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( pCfgMgr )
//STRIP001 		{
//STRIP001 			SvUShorts aListOfIds;
//STRIP001 			USHORT n=0;
//STRIP001 
//STRIP001             // copy all toolbox configurations as they were before starting the configuration dialog
//STRIP001             // don't copy immediately, put the IDs into a list and copy later
//STRIP001             // userdefined toolboxes start a new interface iterating loop, and these loops are
//STRIP001             // not reentrant
//STRIP001 			SfxInterface *pIFace;
//STRIP001 			for ( pIFace = SFX_SLOTPOOL().FirstInterface(); pIFace != 0; pIFace = SFX_SLOTPOOL().NextInterface() )
//STRIP001 			{
//STRIP001 				if ( pIFace->HasName() )
//STRIP001 				{
//STRIP001 					for ( USHORT nNo=0; nNo<pIFace->GetObjectBarCount(); nNo++ )
//STRIP001 					{
//STRIP001 						USHORT nId = pIFace->GetObjectBarResId(nNo).GetId();
//STRIP001 						aListOfIds.Insert(nId, n++);
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			// copy items collected
//STRIP001 			SfxConfigManager& rMgr = *SFX_APP()->GetConfigManager_Impl();
//STRIP001 
//STRIP001 			SfxImageManager::CopyConfiguration_Impl( *pCfgMgr, rMgr );
//STRIP001 
//STRIP001 			for ( USHORT i=0; i<n; i++ )
//STRIP001 				rMgr.CopyConfigItem( *pCfgMgr, aListOfIds[i] );
//STRIP001 
//STRIP001             // copy userdefined toolboxes also
//STRIP001 			for ( USHORT nId = RID_SFX_TOOLBOX_USERSTART; nId <= RID_SFX_TOOLBOX_USEREND; nId++ )
//STRIP001                 rMgr.CopyConfigItem( *pCfgMgr, nId );
//STRIP001 
//STRIP001 			// Reinitialize image list configuration
//STRIP001 			rMgr.ReInitialize( SFX_ITEMTYPE_IMAGELIST );
//STRIP001 			rMgr.StoreConfiguration();
//STRIP001 			
//STRIP001 			SfxToolBoxConfig *pTbxCfg = new SfxToolBoxConfig( *pTbxConfig, pCfgMgr );
//STRIP001 			SfxToolBoxConfig* pOld = pTbxConfig;
//STRIP001 
//STRIP001 			// Use loaded configuration to fill controls
//STRIP001 			pTbxConfig = pTbxCfg;
//STRIP001 			
//STRIP001 			aObjectBarBox.SetUpdateMode(FALSE);
//STRIP001 			aObjectBarBox.Clear();
//STRIP001 			aContextBox.Clear();
//STRIP001 			Exit();
//STRIP001 			Init( 0, TRUE ); // configuration loaded
//STRIP001 			aObjectBarBox.SetUpdateMode(TRUE);
//STRIP001 			aObjectBarBox.Invalidate();
//STRIP001 			bModified = TRUE;
//STRIP001 			bDefault = FALSE;
//STRIP001 
//STRIP001 			pTbxConfig = pOld;
//STRIP001 
//STRIP001 			delete pTbxCfg;
//STRIP001 			if ( bCreated )
//STRIP001 				delete pCfgMgr;
//STRIP001             
//STRIP001 			// Reinitialize all dependent toolboxes
//STRIP001 			for ( i=0; i<n; i++ )
//STRIP001 				rMgr.ReInitialize( aListOfIds[i] );
//STRIP001 		}
//STRIP001 
//STRIP001 		GetTabDialog()->LeaveWait();
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxObjectBarConfigPage, Save, Button *, pButton )
//STRIP001 {
//STRIP001 	String aCfgName = SfxConfigDialog::FileDialog_Impl( this,
//STRIP001 		WB_SAVEAS | WB_STDMODAL | WB_3DLOOK, String( SfxResId( STR_SAVETBXCONFIG) ) );
//STRIP001 	if ( aCfgName.Len() )
//STRIP001 	{
//STRIP001 		GetTabDialog()->EnterWait();
//STRIP001 		BOOL bCreated = FALSE;
//STRIP001 		BOOL bLoadedDocument = FALSE;
//STRIP001 		SfxObjectShellRef xDoc;
//STRIP001 
//STRIP001         SfxConfigManager* pCfgMgr = SFX_APP()->GetConfigManager_Impl();
//STRIP001 		if ( pCfgMgr->GetURL() != aCfgName )
//STRIP001 		{
//STRIP001 			// it was not the global configuration manager
//STRIP001 			// first check if URL points to a document already loaded
//STRIP001 			xDoc = SFX_APP()->DocAlreadyLoaded( aCfgName, TRUE, TRUE );
//STRIP001 			if ( xDoc.Is() )
//STRIP001 				bLoadedDocument = TRUE;
//STRIP001 			else
//STRIP001 				// try to load a document from the URL
//STRIP001 				xDoc = MakeObjectShellForOrganizer_Impl( aCfgName, TRUE );
//STRIP001 			if ( xDoc.Is() )
//STRIP001 			{
//STRIP001 				// get config manager, force creation if there was none before
//STRIP001 				pCfgMgr = xDoc->GetConfigManager( TRUE );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// URL doesn't point to a document, must be a single storage
//STRIP001 				bCreated = TRUE;
//STRIP001         		SvStorageRef xStor = new SvStorage( aCfgName, STREAM_STD_WRITE, STORAGE_TRANSACTED );
//STRIP001 				if ( xStor->GetError() == ERRCODE_NONE )
//STRIP001 					pCfgMgr = new SfxConfigManager( xStor );
//STRIP001 				else
//STRIP001 					pCfgMgr = NULL;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( pCfgMgr )
//STRIP001 		{
//STRIP001 			SvUShorts aListOfIds;
//STRIP001 			USHORT n=0;
//STRIP001 
//STRIP001             // copy all toolbox configurations as they were before starting the configuration dialog
//STRIP001             // don't copy immediately, put the IDs into a list and copy later
//STRIP001             // userdefined toolboxes start a new interface iterating loop, and these loops are
//STRIP001             // not reentrant
//STRIP001 			SfxInterface *pIFace;
//STRIP001 			for ( pIFace = SFX_SLOTPOOL().FirstInterface(); pIFace != 0; pIFace = SFX_SLOTPOOL().NextInterface() )
//STRIP001 			{
//STRIP001 				if ( pIFace->HasName() )
//STRIP001 				{
//STRIP001 					for ( USHORT nNo=0; nNo<pIFace->GetObjectBarCount(); nNo++ )
//STRIP001 					{
//STRIP001 						USHORT nId = pIFace->GetObjectBarResId(nNo).GetId();
//STRIP001 						aListOfIds.Insert(nId, n++);
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001             // copy items collected
//STRIP001 			SfxConfigManager* pMgr    = SFX_APP()->GetConfigManager_Impl();
//STRIP001 			SfxConfigManager* pDocMgr = GetTabDialog()->GetViewFrame()->GetObjectShell()->GetConfigManager();
//STRIP001 
//STRIP001 			for ( USHORT i=0; i<n; i++ )
//STRIP001 				if ( pDocMgr && pDocMgr->HasConfigItem( aListOfIds[i] ) )
//STRIP001 					pCfgMgr->CopyConfigItem( *pDocMgr, aListOfIds[i] );
//STRIP001 			    else
//STRIP001 					pCfgMgr->CopyConfigItem( *pMgr, aListOfIds[i] );
//STRIP001 
//STRIP001             // copy user defined toolboxes also
//STRIP001             for ( USHORT nId = RID_SFX_TOOLBOX_USERSTART; nId <= RID_SFX_TOOLBOX_USEREND; nId++ )
//STRIP001 				if ( pDocMgr && pDocMgr->HasConfigItem( nId ) )
//STRIP001 					pCfgMgr->CopyConfigItem( *pDocMgr, nId );
//STRIP001 			    else
//STRIP001 					pCfgMgr->CopyConfigItem( *pMgr, nId );
//STRIP001 
//STRIP001             SfxImageManager::CopyConfiguration_Impl( *GetTabDialog()->GetViewFrame()->GetImageManager()->GetConfigManager(), *pCfgMgr );
//STRIP001 
//STRIP001             // apply changes
//STRIP001             SfxToolBoxConfig *pTbxCfg = new SfxToolBoxConfig( *pTbxConfig, pCfgMgr );
//STRIP001 			Apply( pTbxCfg, FALSE );
//STRIP001 //			pTbxCfg->SetDefault(FALSE);
//STRIP001 			pCfgMgr->StoreAlwaysConfigItem( *pTbxCfg );
//STRIP001 
//STRIP001             // save configuration
//STRIP001             if ( bLoadedDocument )
//STRIP001             {
//STRIP001                 SfxRequest aReq( SID_SAVEDOC, SFX_CALLMODE_SYNCHRON, xDoc->GetPool() );
//STRIP001                 xDoc->ExecuteSlot( aReq );
//STRIP001             }
//STRIP001             else
//STRIP001 				pCfgMgr->StoreConfiguration();
//STRIP001 
//STRIP001             // cleanup
//STRIP001 			delete pTbxCfg;
//STRIP001 			if ( bCreated )
//STRIP001 				delete pCfgMgr;
//STRIP001 			else
//STRIP001 			{
//STRIP001 				pCfgMgr->ReInitialize( pTbxConfig->GetType() );
//STRIP001 				for ( USHORT i=0; i<n; i++ )
//STRIP001 					pCfgMgr->ReInitialize( aListOfIds[i] );
//STRIP001 
//STRIP001 				for ( USHORT nId = RID_SFX_TOOLBOX_USERSTART; nId <= RID_SFX_TOOLBOX_USEREND; nId++ )
//STRIP001 					pCfgMgr->ReInitialize( nId );
//STRIP001 				pCfgMgr->ReInitialize( xDoc->GetImageManager_Impl()->GetType() );
//STRIP001 			}
//STRIP001 
//STRIP001             if ( bLoadedDocument )
//STRIP001 			{
//STRIP001 				// config item has global configuration until now, must be changed
//STRIP001 				if ( !xDoc->GetConfigManager()->HasConfigItem( pTbxConfig->GetType() ) )
//STRIP001                 	xDoc->GetToolBoxConfig_Impl()->GetConfigManager()->ReConnect( pTbxConfig->GetType(), pCfgMgr );
//STRIP001 
//STRIP001 				for ( USHORT i=0; i<n; i++ )
//STRIP001 					if ( !xDoc->GetConfigManager()->HasConfigItem( aListOfIds[i] ) )
//STRIP001 						pMgr->ReConnect( aListOfIds[i], pCfgMgr );
//STRIP001 
//STRIP001 				for ( USHORT nId = RID_SFX_TOOLBOX_USERSTART; nId <= RID_SFX_TOOLBOX_USEREND; nId++ )
//STRIP001 					if ( !xDoc->GetConfigManager()->HasConfigItem( nId ) )
//STRIP001 						pMgr->ReConnect( nId, pCfgMgr );
//STRIP001 
//STRIP001 				if ( xDoc->GetImageManager_Impl()->GetConfigManager() != pCfgMgr )
//STRIP001 					pMgr->ReConnect( xDoc->GetImageManager_Impl()->GetType(), pCfgMgr );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		GetTabDialog()->LeaveWait();
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxObjectBarConfigPage, CheckButtonHdl, Button *, pButton )
//STRIP001 {
//STRIP001 	bModified = TRUE;
//STRIP001 	bDefault = FALSE;
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxObjectBarConfigPage, Default, PushButton *, pPushButton )
//STRIP001 {
//STRIP001 	// creating a ConfigItem without ConfigManager forces it to use its default
//STRIP001 	SfxToolBoxConfig *pTbxCfg = new SfxToolBoxConfig( *pTbxConfig, NULL );
//STRIP001 	SfxToolBoxConfig* pOld = pTbxConfig;
//STRIP001 	pTbxConfig = pTbxCfg;
//STRIP001 
//STRIP001 	aObjectBarBox.SetUpdateMode(FALSE);
//STRIP001 	aObjectBarBox.Clear();
//STRIP001 	aContextBox.Clear();
//STRIP001 	Exit();
//STRIP001 	Init(0);
//STRIP001 	aObjectBarBox.SetUpdateMode(TRUE);
//STRIP001 	aObjectBarBox.Invalidate();
//STRIP001 	bModified = TRUE;
//STRIP001 	bDefault = TRUE;
//STRIP001 
//STRIP001 	pTbxConfig = pOld;
//STRIP001 	delete pTbxCfg;
//STRIP001 	return 0;
//STRIP001 
//STRIP001 /*
//STRIP001 	USHORT nId;
//STRIP001 	for (nId = RID_SFX_TOOLBOX_USERSTART; nId<= RID_SFX_TOOLBOX_USEREND; nId++ )
//STRIP001 		SFX_CFGMANAGER()->Remove(nId);
//STRIP001 
//STRIP001 	SfxInterface *pIFace;
//STRIP001 	for (pIFace = SFX_SLOTPOOL().FirstInterface(); pIFace != 0;
//STRIP001 		 pIFace = SFX_SLOTPOOL().NextInterface())
//STRIP001 	{
//STRIP001 		if (pIFace->HasName())
//STRIP001 		{
//STRIP001 			SFX_CFGMANAGER()->ResetConfigItem(pIFace->GetConfigId());
//STRIP001 
//STRIP001 			for (USHORT nNo=0; nNo<pIFace->GetObjectBarCount(); nNo++)
//STRIP001 			{
//STRIP001 				nId = pIFace->GetObjectBarResId(nNo).GetId();
//STRIP001 				SFX_CFGMANAGER()->ResetConfigItem(nId);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	SFX_CFGMANAGER()->ResetConfigItem(SFX_IMAGEMANAGER()->GetType());
//STRIP001 */
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 #if 0
//STRIP001 
//STRIP001 void SfxObjectBarConfigPage::CopyToolBoxes(
//STRIP001 		SfxConfigManager *pSrcMgr,
//STRIP001 		SfxConfigManager *pDstMgr)
//STRIP001 {
//STRIP001 	// Imagelist kopieren
//STRIP001     SfxImageManager *pImgMgr = SFX_APP()->GetImageManager();
//STRIP001     pImgMgr->GetConfigManager_Impl()->CopyItem(pImgMgr->GetType(), pSrcMgr);
//STRIP001 
//STRIP001 	SvUShorts aListOfIds;
//STRIP001 	USHORT n=0;
//STRIP001 
//STRIP001 	// Alle Toolboxen kopieren
//STRIP001 	SfxInterface *pIFace;
//STRIP001 	for (pIFace = SFX_SLOTPOOL().FirstInterface(); pIFace != 0;
//STRIP001 		 pIFace = SFX_SLOTPOOL().NextInterface())
//STRIP001 	{
//STRIP001 		if (pIFace->HasName())
//STRIP001 		{
//STRIP001 			// Zuerst die Interface-Konfiguration kopieren
//STRIP001             if (pSrcMgr->HasConfigItem(pIFace->GetConfigId()))
//STRIP001                 pIFace->GetConfig_Impl()->GetConfigManager()->
//STRIP001                         CopyItem(pIFace->GetConfigId(), pSrcMgr);
//STRIP001 
//STRIP001 			// dann Konfigurationen f"ur alle ObjectBars des Interface kopieren
//STRIP001 			for (USHORT nNo=0; nNo<pIFace->GetObjectBarCount(); nNo++)
//STRIP001 			{
//STRIP001 				// Nicht sofort kopieren, falls userdefined Toolboxen dabei
//STRIP001 				// sind, denn die machen eine neue Interface-Loop auf, und
//STRIP001 				// die ist leider nicht reentrant !!
//STRIP001 				USHORT nId = pIFace->GetObjectBarResId(nNo).GetId();
//STRIP001 				aListOfIds.Insert(nId, n++);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	for ( USHORT i=0; i<n; i++ )
//STRIP001 		pDstMgr->CopyItem(aListOfIds[i], pSrcMgr);
//STRIP001 }
//STRIP001 #endif
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxObjectBarConfigPage, SelectContent, ListBox *, pBox )
//STRIP001 {
//STRIP001 	// selektierte ToolBox und Daten holen
//STRIP001 	SvLBoxEntry *pSelected = aObjectBarBox.GetHdlEntry();
//STRIP001 	SfxTBOptions_Impl *pTO = (SfxTBOptions_Impl*) pSelected->GetUserData();
//STRIP001 
//STRIP001 	// Buttontype setzen
//STRIP001 	pTO->eType = (ButtonType) aContentBox.GetSelectEntryPos();
//STRIP001 
//STRIP001 	// Wenn kein Bereich selektiert, auch den Bereich bearbeiten
//STRIP001 	if ( pSelected && aObjectBarBox.GetParent( pSelected ) )
//STRIP001 	{
//STRIP001 		pSelected = aObjectBarBox.GetParent( pSelected );
//STRIP001 		pTO = (SfxTBOptions_Impl*) pSelected->GetUserData();
//STRIP001 		pTO->eType = (ButtonType) aContentBox.GetSelectEntryPos();
//STRIP001 	}
//STRIP001 	else if ( aObjectBarBox.GetChildCount(pSelected) == 1 )
//STRIP001 	{
//STRIP001 		// Wenn der Bereich kollabiert ist, auch child bearbeiten
//STRIP001 		SvLBoxEntry *pEntry = aObjectBarBox.FirstChild(pSelected);
//STRIP001 		pTO = (SfxTBOptions_Impl*) pEntry->GetUserData();
//STRIP001 		pTO->eType = (ButtonType) aContentBox.GetSelectEntryPos();
//STRIP001 
//STRIP001 	}
//STRIP001 
//STRIP001 	bModified = TRUE;
//STRIP001 	bDefault = FALSE;
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 BOOL SfxObjectBarConfigPage::FillItemSet( SfxItemSet& )
//STRIP001 {
//STRIP001     if ( bModified || aObjectBarBox.bModified )
//STRIP001 	{
//STRIP001 		Apply( pTbxConfig, bDefault );
//STRIP001 		pTbxConfig->StoreConfig();
//STRIP001 		bModified = FALSE;
//STRIP001         aObjectBarBox.bModified = FALSE;
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 void SfxObjectBarConfigPage::Reset( const SfxItemSet& )
//STRIP001 {
//STRIP001     if ( !pTbxConfig )
//STRIP001     {
//STRIP001         pTbxConfig = GetTabDialog()->GetViewFrame()->GetBindings().GetToolBoxConfig();
//STRIP001         Init(0);
//STRIP001         aObjectBarBox.GrabFocus();
//STRIP001     }
//STRIP001 }

}
