/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_mnumgr.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:41:35 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef SOLARIS
// HACK: prevent conflict between STLPORT and Workshop headers on Solaris 8
#include <ctime>
#endif

#include <string> 	// HACK: prevent conflict between STLPORT and Workshop headers
#include <cstdarg>	// std::va_list

// auto strip #ifndef _PSEUDO_HXX //autogen
// auto strip #include <so3/pseudo.hxx>
// auto strip #endif
// auto strip #ifndef _POINTR_HXX //autogen
// auto strip #include <vcl/pointr.hxx>
// auto strip #endif
#pragma hdrstop

// auto strip #include <unotools/streamwrap.hxx>
// auto strip #include <objsh.hxx>
// auto strip #include <framework/menuconfiguration.hxx>
// auto strip #include <framework/addonmenu.hxx>
// auto strip #include <comphelper/processfactory.hxx>
// auto strip #include <unotools/ucbstreamhelper.hxx>
// auto strip #include <tools/urlobj.hxx>
// auto strip #include <svtools/pathoptions.hxx>
// auto strip #include <toolkit/helper/vclunohelper.hxx>

#include "mnumgr.hxx"

#define _SVSTDARR_USHORTS
// auto strip #include <svtools/svstdarr.hxx>
#include <svtools/menuoptions.hxx>

#include "virtmenu.hxx"
// auto strip #include "msg.hxx"
// auto strip #include "dispatch.hxx"
#include "minstack.hxx"
// auto strip #include "app.hxx"
#include "sfxtypes.hxx"
#include "bindings.hxx"
// auto strip #include "mnucfga.hxx"
#include "sfxresid.hxx"
// auto strip #include "macrconf.hxx"
// auto strip #include "msgpool.hxx"
#include "sfx.hrc"
#include "menu.hrc"
// auto strip #include "viewfrm.hxx"
// auto strip #include "viewsh.hxx"
// auto strip #include "objface.hxx"
// auto strip #ifndef _LEGACYBINFILTERMGR_HXX
// auto strip #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
// auto strip #endif
namespace binfilter {

static const USHORT nCompatVersion = 4;
static const USHORT nVersion = 5;

//=========================================================================

DECL_PTRSTACK(SfxMenuCfgItemArrStack, SfxMenuCfgItemArr*, 4, 4 );

//-------------------------------------------------------------------------

/*N*/ void TryToHideDisabledEntries_Impl( Menu* pMenu )
/*N*/ {
/*N*/ 	DBG_ASSERT( pMenu, "invalid menu" );
/*N*/ 	if( SvtMenuOptions().IsEntryHidingEnabled() == sal_False )
/*N*/ 	{
/*?*/ 		pMenu->SetMenuFlags( pMenu->GetMenuFlags() | MENU_FLAG_HIDEDISABLEDENTRIES );
/*N*/ 	}
/*N*/ }

//-------------------------------------------------------------------------

//STRIP001 class SfxMenuIter_Impl

/*	[Beschreibung]

	Mit solchen Instanzen wird beim Auslesen des Men"us f"ur die
	Konfiguration ein Stack gebildet, um die Iterator-Position zu
	bestimmen.

	Die Instanzen l"oschen sich selbst, wenn der Stack abgebaut wird.
*/

//STRIP001 {
//STRIP001 	String				_aCommand;
//STRIP001 	SfxMenuIter_Impl*	_pPrev; 	// der vorherige auf dem Stack
//STRIP001 	Menu*				_pMenu;		// das Men"u "uber das gerade iteriert wird
//STRIP001 	Menu*				_pPopup;	// Popup an dieser Pos falls noch zu durchl.
//STRIP001 	USHORT  			_nPos;		// die Position des Iterators in 'pMenu'
//STRIP001 	USHORT				_nId;		// Id an Position '_nPos'
//STRIP001 	USHORT				_nLevel;	// Schachteltiefe
//STRIP001 
//STRIP001 						SfxMenuIter_Impl( Menu *pMenu,
//STRIP001 										  SfxMenuIter_Impl *pPrev = 0 );
//STRIP001 
//STRIP001 						~SfxMenuIter_Impl()
//STRIP001 						{}
//STRIP001 
//STRIP001 public:
//STRIP001 	static SfxMenuIter_Impl* Create( Menu *pMenu )
//STRIP001 						{ return ( pMenu && pMenu->GetItemCount() )
//STRIP001 									? new SfxMenuIter_Impl( pMenu )
//STRIP001 									: 0; }
//STRIP001 
//STRIP001 	String				GetCommand() const
//STRIP001 						{ return _aCommand; }
//STRIP001 
//STRIP001 	USHORT				GetLevel() const
//STRIP001 						{ return _nLevel; }
//STRIP001 
//STRIP001 	Menu*   			GetMenu() const
//STRIP001 						{ return _pMenu; }
//STRIP001 
//STRIP001 	USHORT				GetItemId() const
//STRIP001 						{ return _nId; }
//STRIP001 
//STRIP001 	MenuItemType		GetItemType() const
//STRIP001 						{ return _pMenu->GetItemType( _nPos ); }
//STRIP001 
//STRIP001 	Menu*				GetPopupMenu() const
//STRIP001 						{ return _pPopup; }
//STRIP001 
//STRIP001 	String   			GetItemText() const
//STRIP001 						{ return _pMenu->GetItemText( _nId ); }
//STRIP001 
//STRIP001 	String  	 		GetItemHelpText() const
//STRIP001 						{ return _pMenu->GetHelpText( _nId ); }
//STRIP001 
//STRIP001 	BOOL				IsSeparator() const
//STRIP001 						{ return MENUITEM_SEPARATOR == GetItemType(); }
//STRIP001 
//STRIP001     BOOL                IsBinding( SfxModule* pMod ) const;
//STRIP001 
//STRIP001 	SfxMenuIter_Impl*	NextItem();
//STRIP001 
//STRIP001 	void 				RemovePopup()
//STRIP001 						{ _pPopup = NULL; }
//STRIP001 };

//=========================================================================

//STRIP001 SfxMenuIter_Impl::SfxMenuIter_Impl
//STRIP001 (
//STRIP001 	Menu*				pMenu,
//STRIP001 	SfxMenuIter_Impl*	pPrev
//STRIP001 )
//STRIP001 :	_pPrev( pPrev ),
//STRIP001 	_pMenu( pMenu ),
//STRIP001 	_nPos( 0 ),
//STRIP001 	_nId( pMenu->GetItemId(0) ),
//STRIP001 	_nLevel( pPrev ? ( pPrev->_nLevel + 1 ) : 0 )
//STRIP001 {
//STRIP001 	_aCommand = pMenu->GetItemCommand( _nId );
//STRIP001     if ( _aCommand.CompareToAscii("slot:", 5) == 0 )
//STRIP001         _aCommand.Erase();
//STRIP001 
//STRIP001 	_pPopup = pMenu->GetPopupMenu( _nId );
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 SfxMenuIter_Impl* SfxMenuIter_Impl::NextItem()
//STRIP001 {
//STRIP001 	// noch nicht durchlaufenes Popup vorhanden
//STRIP001 	if ( _pPopup )
//STRIP001 	{
//STRIP001 		// dann bevor es weitergeht, das Popup durchlaufen
//STRIP001 		Menu *pSub = _pPopup;
//STRIP001 		_pPopup = 0; // als durchlaufen markieren
//STRIP001 		if ( pSub->GetItemCount() )
//STRIP001 			return new SfxMenuIter_Impl( pSub, this );
//STRIP001 	}
//STRIP001 
//STRIP001 	// zur n"achsten Position in diesem Men"u
//STRIP001 	if ( ++_nPos >=_pMenu->GetItemCount() )
//STRIP001 	{
//STRIP001 		// Men"u zuende => eine Stack-Etage hoch
//STRIP001 		SfxMenuIter_Impl *pPrev = _pPrev;
//STRIP001 		delete this;
//STRIP001 		return pPrev ? pPrev->NextItem() : 0;
//STRIP001 	}
//STRIP001 
//STRIP001 	// bleibt in diesem Menu
//STRIP001 	_nId = _pMenu->GetItemId(_nPos);
//STRIP001 	_aCommand = _pMenu->GetItemCommand( _nId );
//STRIP001     if ( _aCommand.CompareToAscii("slot:", 5) == 0 )
//STRIP001         _aCommand.Erase();
//STRIP001 	_pPopup = _pMenu->GetPopupMenu(_nId);
//STRIP001 
//STRIP001 	// nicht alles wird angezeigt
//STRIP001 	if ( _nId >= START_ITEMID_PICKLIST && _nId <= END_ITEMID_PICKLIST )
//STRIP001 		return NextItem();
//STRIP001 
//STRIP001 	if ( _nId >= START_ITEMID_WINDOWLIST && _nId <= END_ITEMID_WINDOWLIST )
//STRIP001 		return NextItem();
//STRIP001 
//STRIP001 	if (( _nId == SID_ADDONS ) || ( _nId == SID_ADDONHELP ))
//STRIP001 	{
//STRIP001 		_pPopup = 0;
//STRIP001 		return NextItem();
//STRIP001 	}
//STRIP001 		
//STRIP001 	// nicht alle Popups werden durchlaufen
//STRIP001 	if ( _nId == SID_OBJECT ||
//STRIP001 		 ( _nId >= SID_OBJECTMENU0 && _nId <= SID_OBJECTMENU_LAST ) )
//STRIP001 		_pPopup = 0;
//STRIP001 	
//STRIP001 	// Jump over the merged addon popup menus. They shouldn't be stored
//STRIP001 	// nor be configurable by the user.
//STRIP001 	if ( framework::AddonPopupMenu::IsCommandURLPrefix( _aCommand ))
//STRIP001 	{
//STRIP001 		_pPopup = 0;
//STRIP001 		return NextItem();
//STRIP001 	}
//STRIP001 
//STRIP001     if ( framework::AddonMenuManager::IsAddonMenuId( _nId ))
//STRIP001         return NextItem();
//STRIP001 
//STRIP001 	// diesen Eintrag nehmen
//STRIP001 	return this;
//STRIP001 }

//STRIP001 BOOL SfxMenuIter_Impl::IsBinding( SfxModule* pMod ) const
//STRIP001 {
//STRIP001     if ( GetPopupMenu() && _nId > SID_SFX_START )
//STRIP001         if ( !SfxMenuControl::IsSpecialControl( _nId, pMod ) )
//STRIP001 			// "Unechtes" Binding: Popup mit SlotId
//STRIP001 			return FALSE;
//STRIP001     return _nId >= SID_SFX_START || ( GetCommand().Len() != 0);
//STRIP001 }

//--------------------------------------------------------------------

/*N*/ SfxMenuManager::SfxMenuManager( const ResId& rResId, SfxBindings &rBindings, SfxConfigManager* pMgr, BOOL bBar )
/*N*/ :   SfxConfigItem( rResId.GetId(), pMgr ),
/*N*/ 	bMenuBar(bBar),
/*N*/ 	pMenu(0),
/*N*/ 	pOldMenu(0),
/*N*/ 	pResMgr(rResId.GetResMgr()),
/*N*/ 	pBindings(&rBindings)
/*N*/ {
/*N*/ 	bOLE = FALSE;
/*N*/ 	bAddClipboardFuncs = FALSE;
/*N*/ 	DBG_MEMTEST();
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxMenuManager::~SfxMenuManager()
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	pBindings->ENTERREGISTRATIONS();
/*N*/ 	delete pMenu;
/*N*/ 	pBindings->LEAVEREGISTRATIONS();
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxMenuManager::Construct( SfxVirtualMenu& rMenu )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	pMenu = &rMenu;
/*N*/ 
/*N*/ 	// set the handlers
/*N*/ 	Menu *pSvMenu = pMenu->GetSVMenu();
/*N*/ 	pSvMenu->SetSelectHdl( LINK(this, SfxMenuManager, Select) );
/*N*/ 	TryToHideDisabledEntries_Impl( pSvMenu );
/*N*/ }

//--------------------------------------------------------------------

//STRIP001 BOOL SfxMenuManager::Store( SvStream& rStream )
//STRIP001 {
//STRIP001 	DBG_MEMTEST();
//STRIP001     SfxDispatcher* pDisp = pBindings->GetDispatcher_Impl();
//STRIP001     SfxModule *pMod = pDisp ? SFX_APP()->GetActiveModule( pDisp->GetFrame() ) :0;
//STRIP001     return StoreMenu( rStream, pMenu->GetSVMenu(), pMod );
//STRIP001 }

//-------------------------------------------------------------------------
//STRIP001 void InsertVerbs_Impl( const SvVerbList* pList, Menu* pMenu )
//STRIP001 {
//STRIP001     if ( pList )
//STRIP001     {
//STRIP001         pMenu->InsertSeparator();
//STRIP001         USHORT nr=0;
//STRIP001         for ( USHORT n = 0; n < pList->Count(); ++n )
//STRIP001         {
//STRIP001             // nicht alle Verbs landen im Men"u
//STRIP001             const SvVerb& rVerb = (*pList)[n];
//STRIP001             if ( !rVerb.IsOnMenu() )
//STRIP001                 continue;
//STRIP001 
//STRIP001             // neue Id vergeben
//STRIP001             USHORT nId = SID_VERB_START + nr++;
//STRIP001             DBG_ASSERT(nId <= SID_VERB_END, "Zuviele Verben!");
//STRIP001             if ( nId > SID_VERB_END )
//STRIP001                 break;
//STRIP001 
//STRIP001             // einf"ugen
//STRIP001             pMenu->InsertItem( nId, rVerb.GetName() );
//STRIP001             pMenu->SetHelpId( nId, (ULONG) nId );
//STRIP001         }
//STRIP001     }
//STRIP001 }

//STRIP001 void SfxMenuManager::InsertVerbs(const SvVerbList *pList)
//STRIP001 
//STRIP001 /* 	Man k"onnte hier auch einen Separator oder eine bestimmte Menu-Id
//STRIP001 	als Kennung zu Einf"ugen benutzen, dann mu\s man aber das Items-Array
//STRIP001 	verschieben etc.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	// hinten anh"angen
//STRIP001     if ( !pList || !pList->Count() )
//STRIP001 		return;
//STRIP001 
//STRIP001 	Menu *pMenu = GetMenu()->GetSVMenu();
//STRIP001     InsertVerbs_Impl( pList, pMenu );
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 BOOL SfxMenuManager::StoreMenu( SvStream& rStream, Menu* pMenu, SfxModule* pMod )
//STRIP001 {
//STRIP001     LanguageType eLangType = Application::GetSettings().GetUILanguage();
//STRIP001 	rStream << nVersion
//STRIP001 			<< (USHORT) eLangType;
//STRIP001 
//STRIP001     SfxMenuIter_Impl *pIterator = SfxMenuIter_Impl::Create( pMenu );
//STRIP001     if ( !pIterator )
//STRIP001 		return TRUE;
//STRIP001 
//STRIP001     rtl_TextEncoding nEnc = osl_getThreadTextEncoding();
//STRIP001 	SfxMacroConfig* pMC = SfxMacroConfig::GetOrCreate();
//STRIP001 	SvUShorts aMacroSlots;
//STRIP001 
//STRIP001     SfxMenuIter_Impl *pFirstIter = pIterator;
//STRIP001 	USHORT nFirstLevel = pFirstIter->GetLevel();
//STRIP001 	USHORT nLevel = nFirstLevel;
//STRIP001 	do
//STRIP001 	{
//STRIP001 		while ( pIterator->GetLevel() < nLevel )
//STRIP001 		{
//STRIP001 			// Ein Popup wurde verlassen
//STRIP001 			// Ende-Markierung setzen
//STRIP001 			rStream << 'E';
//STRIP001 			nLevel--;
//STRIP001 		}
//STRIP001 
//STRIP001 		nLevel = pIterator->GetLevel();
//STRIP001 
//STRIP001 		if ( pIterator->IsSeparator() )
//STRIP001 		{
//STRIP001 			rStream << 'S';
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			USHORT nId = pIterator->GetItemId();
//STRIP001 			String aTitle = pIterator->GetItemText();
//STRIP001             if( pIterator->IsBinding( pMod ) )
//STRIP001 			{
//STRIP001                 String aCmd( pIterator->GetCommand() );
//STRIP001 				BOOL bIsMacroSlot = SfxMacroConfig::IsMacroSlot(nId);
//STRIP001 
//STRIP001                 if ( aCmd.CompareToAscii("macro:", 6) == 0 && !bIsMacroSlot )
//STRIP001 				{
//STRIP001                     SfxMacroInfo aInfo( aCmd );
//STRIP001             		pMC->GetSlotId( &aInfo );
//STRIP001             		nId = aInfo.GetSlotId();
//STRIP001 					aMacroSlots.Insert( nId, aMacroSlots.Count() );
//STRIP001 				}
//STRIP001 
//STRIP001 				if ( bIsMacroSlot )
//STRIP001 				{
//STRIP001 					SfxMacroInfo* pInfo = pMC->GetMacroInfo(nId);
//STRIP001 					if ( pInfo )
//STRIP001 					{
//STRIP001 						rStream << 'I';
//STRIP001 						rStream << nId;
//STRIP001 		                rStream.WriteByteString(aTitle, nEnc );
//STRIP001 						rStream << *(pInfo);
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						// trashed config entry, avoid disaster
//STRIP001 						rStream << 'S';
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					rStream << 'I';
//STRIP001 					rStream << nId;
//STRIP001 	                rStream.WriteByteString(aTitle, nEnc );
//STRIP001 
//STRIP001 					if ( pIterator->GetPopupMenu() )
//STRIP001 						// Unechtes Popup "uberspringen
//STRIP001 						pIterator->RemovePopup();
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else if ( pIterator->GetPopupMenu() )
//STRIP001 			{
//STRIP001 				rStream << 'P';
//STRIP001 				rStream << nId;
//STRIP001                 rStream.WriteByteString(aTitle, nEnc );
//STRIP001 				if ( !pIterator->GetPopupMenu()->GetItemCount() )
//STRIP001 					rStream << 'E';
//STRIP001 			}
//STRIP001 			else
//STRIP001 				DBG_ERROR( "Invalid menu configuration!" );
//STRIP001 		}
//STRIP001 	}
//STRIP001     while ( ( pIterator = pIterator->NextItem() ) != 0 );
//STRIP001 
//STRIP001 	while ( nLevel > nFirstLevel )
//STRIP001 	{
//STRIP001 		// Ein Popup wurde verlassen
//STRIP001 		// Ende-Markierung setzen
//STRIP001 		rStream << 'E';
//STRIP001 		nLevel--;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Ende-Markierung f"ur MenuBar setzen
//STRIP001 	rStream << 'E';
//STRIP001 
//STRIP001 	for ( USHORT n=0; n<aMacroSlots.Count(); n++ )
//STRIP001 		pMC->ReleaseSlotId( aMacroSlots[n] );
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }

//-------------------------------------------------------------------------

/*N*/ void SfxMenuManager::SetForceCtrlCreateMode( BOOL bCreate )
/*N*/ {
/*N*/ 	bOLE = bCreate;
/*N*/ }

//-------------------------------------------------------------------------

//STRIP001 Menu* SfxMenuManager::LoadMenu( SvStream& rStream )
//STRIP001 {
//STRIP001 	// Config-Version und Sprache der Menuetexte
//STRIP001 	USHORT nFileVersion, nLanguage;
//STRIP001 	rStream >> nFileVersion;
//STRIP001 	if(nFileVersion < nCompatVersion)
//STRIP001         return NULL;
//STRIP001 
//STRIP001 	rStream >> nLanguage;
//STRIP001     LanguageType eLangType = Application::GetSettings().GetUILanguage();
//STRIP001 	if ( eLangType != (LanguageType) nLanguage )
//STRIP001         return NULL;
//STRIP001 
//STRIP001 	BOOL bCompat = FALSE;
//STRIP001 	if ( nFileVersion == nCompatVersion )
//STRIP001 		bCompat = TRUE;
//STRIP001 	BOOL bWithHelp = FALSE;
//STRIP001 //    if ( bCompat )
//STRIP001 //        bWithHelp = TRUE;
//STRIP001 
//STRIP001     MenuBar* pSVMenu = new MenuBar;
//STRIP001     ConstructSvMenu( pSVMenu, rStream, bWithHelp, bCompat );
//STRIP001     return pSVMenu;
//STRIP001 }

/*?*/ int SfxMenuManager::Load( SvStream& rStream )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
//STRIP001 	DBG_MEMTEST();
//STRIP001 
//STRIP001     if ( !bMenuBar )
//STRIP001     {
//STRIP001         UseDefault();
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         Menu* pSVMenu = LoadMenu( rStream );
//STRIP001         if ( pSVMenu )
//STRIP001         {
//STRIP001 		    Construct_Impl( pSVMenu, FALSE );
//STRIP001 			SetDefault( FALSE );
//STRIP001 		}
//STRIP001         else
//STRIP001             UseDefault();
//STRIP001     }
//STRIP001 
//STRIP001 	return SfxConfigItem::ERR_OK;
/*?*/ }

//--------------------------------------------------------------------

/*N*/ void SfxMenuManager::UseDefault()
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/ 	SfxApplication *pSfxApp = SFX_APP();
/*N*/ 	SfxVirtualMenu *pOldVirtMenu=0;
/*N*/ 	if (pMenu)
/*N*/ 	{
/*?*/ 		pOldVirtMenu = pMenu;
/*?*/ 		pBindings->ENTERREGISTRATIONS();
/*N*/ 	}
/*N*/ 
/*N*/ 	SfxVirtualMenu *pVMenu = 0;
/*N*/ 	if ( bMenuBar )
/*N*/ 	{
/*N*/         ResId aId( GetType(), pResMgr );
/*N*/         aId.SetRT(RSC_MENU);
/*N*/         if ( Resource::GetResManager()->IsAvailable( aId ) )
/*N*/         {
/*N*/             MenuBar *pSvMenu = new MenuBar( ResId(GetType(), pResMgr) );
/*N*/ 			SfxMenuManager::EraseItemCmds( pSvMenu ); // Remove .uno cmds to be compatible with 6.0/src641
/*N*/             TryToHideDisabledEntries_Impl( pSvMenu );
/*N*/             pVMenu = new SfxVirtualMenu( pSvMenu, FALSE, *pBindings, bOLE, TRUE );
/*N*/         }
/*N*/         else
/*N*/         {
/*?*/             MenuBar *pSvMenu = new MenuBar;
/*?*/             pVMenu = new SfxVirtualMenu( pSvMenu, FALSE, *pBindings, bOLE, TRUE );
/*N*/         }
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		ResId aResId(GetType());
/*N*/ 		aResId.SetRT(RSC_MENU);
/*N*/ 		aResId.SetResMgr(pResMgr);
/*N*/ 		Menu *pSVMenu = new PopupMenu( aResId );
/*N*/ 		SfxMenuManager::EraseItemCmds( pSVMenu ); // Remove .uno cmds to be compatible with 6.0/src641
/*N*/ 
/*N*/ 		if ( bAddClipboardFuncs )
/*N*/ 		{
/*?*/ 			USHORT n, nCount = pSVMenu->GetItemCount();
/*?*/ 			for ( n=0; n<nCount; n++ )
/*?*/ 			{
/*?*/ 				USHORT nId = pSVMenu->GetItemId( n );
/*?*/ 				if ( nId == SID_COPY || nId == SID_CUT || nId == SID_PASTE )
/*?*/ 					break;
/*?*/ 			}
/*?*/ 
/*?*/ 			if ( n == nCount )
/*?*/ 			{
/*?*/ 				PopupMenu aPop( SfxResId( MN_CLIPBOARDFUNCS ) );
/*?*/ 				nCount = aPop.GetItemCount();
/*?*/ 				pSVMenu->InsertSeparator();
/*?*/ 				for ( n=0; n<nCount; n++ )
/*?*/ 				{
/*?*/ 					USHORT nId = aPop.GetItemId( n );
/*?*/ 					pSVMenu->InsertItem( nId, aPop.GetItemText( nId ), aPop.GetItemBits( nId ) );
/*?*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		pVMenu = new SfxVirtualMenu( pSVMenu, FALSE, *pBindings, TRUE, TRUE );
/*N*/ 	}
/*N*/ 
/*N*/ 	Construct(*pVMenu);
/*N*/ 
/*N*/     if ( bMenuBar && pOldVirtMenu )
/*N*/ 	{
/*?*/         SfxMenuBarManager *pBar = (SfxMenuBarManager*) this;
/*?*/         MenuBar* pOldBar = (MenuBar*) pOldVirtMenu->GetSVMenu();
/*?*/         MenuBar* pSvBar = (MenuBar*) GetMenu()->GetSVMenu();
/*?*/         if ( pBar->GetWindow()->GetMenuBar() == pOldBar )
/*?*/             pBar->GetWindow()->SetMenuBar( pSvBar );
/*N*/ 	}
/*N*/ 
/*N*/ 	if (pOldVirtMenu)
/*N*/ 	{
/*?*/ 		delete pOldVirtMenu;
/*?*/ 		pBindings->LEAVEREGISTRATIONS();
/*N*/ 	}
/*N*/ 
/*N*/     SetDefault( TRUE );
/*N*/ }

// ------------------------------------------------------------------------

/*?*/ String SfxMenuManager::GetStreamName() const
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); String aString;return aString;//STRIP001 
//STRIP001     return SfxConfigItem::GetStreamName( GetType() );
/*?*/ }

//--------------------------------------------------------------------

// Baut aus einem ConfigItemArray rekursiv das StarView-Menu auf

//STRIP001 void SfxMenuManager::ConstructSvMenu( Menu* pSuper, SfxMenuCfgItemArr& rCfg)
//STRIP001 {
//STRIP001 	USHORT nCount = rCfg.Count();
//STRIP001 	for ( USHORT n = 0; n < rCfg.Count(); ++n )
//STRIP001 	{
//STRIP001 		SfxMenuCfgItem *pmIt=rCfg[n];
//STRIP001         USHORT nId = rCfg[n]->nId;
//STRIP001 		if ( rCfg[n]->pPopup )
//STRIP001 		{
//STRIP001             pSuper->InsertItem( nId, rCfg[n]->aTitle );
//STRIP001             pSuper->SetHelpId( nId, (ULONG) nId );
//STRIP001 			PopupMenu *pPopupMenu;
//STRIP001 			pPopupMenu = new PopupMenu;
//STRIP001             pSuper->SetPopupMenu( nId, pPopupMenu );
//STRIP001 			ConstructSvMenu( pPopupMenu, *(rCfg[n]->pPopup) );
//STRIP001 		}
//STRIP001         else if ( nId )
//STRIP001 		{
//STRIP001             pSuper->InsertItem( nId, rCfg[n]->aTitle );
//STRIP001             if ( SfxMacroConfig::IsMacroSlot( nId ) )
//STRIP001             {
//STRIP001 				SfxMacroInfo* pInfo = SFX_APP()->GetMacroConfig()->GetMacroInfo(nId);
//STRIP001 				if ( pInfo )
//STRIP001 				{
//STRIP001 	                SFX_APP()->GetMacroConfig()->RegisterSlotId( nId );
//STRIP001 	                pSuper->SetItemCommand( nId, pInfo->GetURL() );
//STRIP001 				}
//STRIP001             }
//STRIP001 			else if ( rCfg[n]->aCommand.Len() )
//STRIP001 			{
//STRIP001 				pSuper->SetItemCommand( nId, rCfg[n]->aCommand );
//STRIP001 				pSuper->SetHelpId( nId, (ULONG) nId ); // Set help id even if we have a command
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001             	pSuper->SetHelpId( nId, (ULONG) nId );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pSuper->InsertSeparator();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//--------------------------------------------------------------------

// Baut aus einem ConfigStream rekursiv das StarView-Menu auf

//STRIP001 void SfxMenuManager::ConstructSvMenu( Menu* pSuper, SvStream& rStream,
//STRIP001 		BOOL bWithHelp, BOOL bCompat )
//STRIP001 {
//STRIP001 	SvUShorts aShorts;
//STRIP001 
//STRIP001 	USHORT nCount = 0xFFFF;
//STRIP001 	if ( bCompat )
//STRIP001 	{
//STRIP001 		// Alte Eintr"age wg. Kompatibilit"at einlesen
//STRIP001 		USHORT nCtrls,nId;
//STRIP001 		rStream >> nCtrls;
//STRIP001 		for (USHORT i=0; i<nCtrls; i++)
//STRIP001 			rStream >> nId;
//STRIP001 		rStream >> nCount;
//STRIP001 	}
//STRIP001 
//STRIP001     rtl_TextEncoding nEnc = osl_getThreadTextEncoding();
//STRIP001 
//STRIP001 	char cTag;
//STRIP001 	for ( USHORT n=0; n<nCount; n++ )
//STRIP001 	{
//STRIP001 		rStream >> cTag;
//STRIP001 		String aTitle;
//STRIP001 		USHORT nId;
//STRIP001 
//STRIP001 		switch ( cTag )
//STRIP001 		{
//STRIP001 			case 'S':
//STRIP001 				pSuper->InsertSeparator();
//STRIP001 				break;
//STRIP001 
//STRIP001 			case 'I':
//STRIP001 			{
//STRIP001 				rStream >> nId;
//STRIP001                 rStream.ReadByteString( aTitle, nEnc );
//STRIP001 
//STRIP001 				String aHelpText;
//STRIP001 				if ( bWithHelp )
//STRIP001                     rStream.ReadByteString( aHelpText, nEnc );
//STRIP001 
//STRIP001 				if ( SfxMacroConfig::IsMacroSlot(nId) )
//STRIP001 				{
//STRIP001 					SfxMacroInfo aInfo;
//STRIP001 					rStream >> aInfo;
//STRIP001 //                    nId = aInfo.GetSlotId();
//STRIP001 				}
//STRIP001 
//STRIP001 				pSuper->InsertItem( nId, aTitle );
//STRIP001 				pSuper->SetHelpId( nId, (ULONG) nId );
//STRIP001 				if ( bWithHelp )
//STRIP001 					pSuper->SetHelpText( nId, aHelpText );
//STRIP001 
//STRIP001                 if ( nId >= SID_OBJECTMENU0 && nId <= SID_OBJECTMENU_LAST )
//STRIP001                 {
//STRIP001                     // our new menu configuration must have an empty popupmenu, iut doesn't allow for
//STRIP001                     // menu entries without popups in the menubar root
//STRIP001                     PopupMenu *pPopupMenu;
//STRIP001                     pPopupMenu = new PopupMenu;
//STRIP001                     pSuper->SetPopupMenu( nId, pPopupMenu );
//STRIP001                 }
//STRIP001 
//STRIP001 				break;
//STRIP001 			}
//STRIP001 
//STRIP001 			case 'P':
//STRIP001 			{
//STRIP001 				rStream >> nId;
//STRIP001                 rStream.ReadByteString( aTitle, nEnc );
//STRIP001 
//STRIP001 				if ( SfxMacroConfig::IsMacroSlot(nId) || nId < SID_SFX_START )
//STRIP001 				{
//STRIP001 					// Bug im Cfg-Dialog: Popups mit Macro-SlotIds
//STRIP001 					USHORT i;
//STRIP001 					for ( i=0; i<aShorts.Count(); i++ )
//STRIP001 					{
//STRIP001 						// Erste Id nehmen, deren Wert gr"o\ser ist als die Position
//STRIP001 						if ( aShorts[i] > i+1 )
//STRIP001 							break;
//STRIP001 					}
//STRIP001 
//STRIP001 					nId = i+1;
//STRIP001 					aShorts.Insert( nId, i );
//STRIP001 				}
//STRIP001 
//STRIP001 				String aHelpText;
//STRIP001 				if ( bWithHelp )
//STRIP001                     rStream.ReadByteString( aHelpText, nEnc );
//STRIP001 
//STRIP001 				pSuper->InsertItem( nId, aTitle );
//STRIP001 				pSuper->SetHelpId( nId, (ULONG) nId );
//STRIP001 				if ( bWithHelp )
//STRIP001 					pSuper->SetHelpText( nId, aHelpText );
//STRIP001 
//STRIP001 				PopupMenu *pPopupMenu;
//STRIP001 				pPopupMenu = new PopupMenu;
//STRIP001 				pSuper->SetPopupMenu( nId, pPopupMenu );
//STRIP001 				ConstructSvMenu( pPopupMenu, rStream, bWithHelp, bCompat );
//STRIP001 				break;
//STRIP001 			}
//STRIP001 
//STRIP001 			case 'E':
//STRIP001 			{
//STRIP001 				n = nCount-1;				// Ende
//STRIP001 				break;
//STRIP001 			}
//STRIP001 
//STRIP001 			default:
//STRIP001 			{
//STRIP001 				// Wenn ein Fehler aufgetreten ist, sollte man besser aufh"oren
//STRIP001 				DBG_ERROR( "invalid item type in menu-config" );
//STRIP001 				n = nCount-1;				// Ende
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//--------------------------------------------------------------------

// append a binding by function-id

//STRIP001 void SfxMenuManager::AppendItem(const String &rText,
//STRIP001 								const String &rHelpText, USHORT nId, const String &rCommand )
//STRIP001 {
//STRIP001 	SfxMenuCfgItem* pItem = new SfxMenuCfgItem;
//STRIP001 	pItem->nId = nId;
//STRIP001 	pItem->aTitle = rText;
//STRIP001 	pItem->aHelpText = rHelpText;
//STRIP001 	pItem->aCommand = rCommand;
//STRIP001 	pItem->pPopup = 0;
//STRIP001 	pCfgStack->Top()->Append( pItem );
//STRIP001 }

//--------------------------------------------------------------------

// append a separator

//STRIP001 void SfxMenuManager::AppendSeparator()
//STRIP001 {
//STRIP001 	SfxMenuCfgItem* pItem = new SfxMenuCfgItem;
//STRIP001 	pItem->nId = 0;
//STRIP001 	pItem->pPopup = 0;
//STRIP001 	pCfgStack->Top()->Append( pItem );
//STRIP001 }

//--------------------------------------------------------------------

// append a popup (sub)-menu

//STRIP001 void SfxMenuManager::EnterPopup(const String& rTitle,
//STRIP001 								const String& rHelpText, USHORT nId )
//STRIP001 {
//STRIP001 	SfxMenuCfgItem* pItem = new SfxMenuCfgItem;
//STRIP001 	pItem->nId = nId;
//STRIP001 	pItem->aTitle = rTitle;
//STRIP001 	pItem->aHelpText = rHelpText;
//STRIP001 	pItem->pPopup = new SfxMenuCfgItemArr;
//STRIP001 	pCfgStack->Top()->Append( pItem );
//STRIP001 	pCfgStack->Push( pItem->pPopup );
//STRIP001 }

//--------------------------------------------------------------------

// end a sub-menu

//STRIP001 void SfxMenuManager::LeavePopup()
//STRIP001 {
//STRIP001 	SfxMenuCfgItemArr* pArr = pCfgStack->Top();
//STRIP001 	SvUShorts aShorts;
//STRIP001 
//STRIP001 	USHORT n;
//STRIP001 	for ( n=0; n<pArr->Count(); n++ )
//STRIP001 	{
//STRIP001 		USHORT nId = (*pArr)[n]->nId;
//STRIP001 		if ( nId < SID_SFX_START )
//STRIP001 		{
//STRIP001 			// Alle vewendeten Popup-Ids < 5000 merken
//STRIP001 			USHORT i;
//STRIP001 			for ( i=0; i<aShorts.Count(); i++ )
//STRIP001 			{
//STRIP001 				if ( aShorts[i] > nId )
//STRIP001 					break;
//STRIP001 			}
//STRIP001 
//STRIP001 			aShorts.Insert( nId, i );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	for ( n=0; n<pArr->Count(); n++ )
//STRIP001 	{
//STRIP001 		SfxMenuCfgItem* pItem = (*pArr)[n];
//STRIP001 		if ( pItem->pPopup && SfxMacroConfig::IsMacroSlot(pItem->nId) )
//STRIP001 		{
//STRIP001 			// Weil in dem Fucking-ConfigDialog Entries und Popups bunt
//STRIP001 			// vermischt sind, kann auch ein Popup eine Macro-Id haben, die
//STRIP001 			// mu\s nat"urlich weg
//STRIP001 			SFX_APP()->GetMacroConfig()->ReleaseSlotId( pItem->nId );
//STRIP001 
//STRIP001 			// Nun noch eine erlaubte Id suchen
//STRIP001 			USHORT nCount = aShorts.Count();
//STRIP001 			USHORT i;
//STRIP001 			for ( i=0; i<nCount; i++ )
//STRIP001 			{
//STRIP001 				if ( aShorts[i] > i+1 )
//STRIP001 				// Erste Id nehmen, deren Wert gr"o\ser ist als die Position
//STRIP001 					break;
//STRIP001 			}
//STRIP001 
//STRIP001 			pItem->nId = i+1;
//STRIP001 			aShorts.Insert( i+1, i );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	pCfgStack->Pop();
//STRIP001 }

//--------------------------------------------------------------------

// executes the function for the selected item
extern int Select_Impl( void*, void* ) ;

/*N*/ IMPL_LINK( SfxMenuManager, Select, Menu *, pMenu )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	DBG_MEMTEST();
//STRIP001 
//STRIP001 	USHORT nId = (USHORT) pMenu->GetCurItemId();
//STRIP001 	String aCommand = pMenu->GetItemCommand( nId );
//STRIP001 	if ( aCommand.Len() )
//STRIP001 	{
//STRIP001 		pBindings->ExecuteCommand_Impl( aCommand );
//STRIP001 	}
//STRIP001 	else if ( pBindings->IsBound(nId) )
//STRIP001 		// normal function
//STRIP001 		pBindings->Execute( nId );
//STRIP001 	else
//STRIP001 		// special menu function
//STRIP001 		pBindings->GetDispatcher_Impl()->Execute( nId );
//STRIP001 
/*N*/ 	return TRUE;
/*N*/ }

//--------------------------------------------------------------------

// resets the item iterator, FALSE if none

//STRIP001 BOOL SfxMenuManager::FirstItem()
//STRIP001 {
//STRIP001 	pIterator = SfxMenuIter_Impl::Create( pMenu->GetSVMenu() );
//STRIP001 	return 0 != pIterator;
//STRIP001 }

//--------------------------------------------------------------------

// skips to the next item, FALSE if no more

//STRIP001 BOOL SfxMenuManager::NextItem()
//STRIP001 {
//STRIP001 	DBG_ASSERT( pIterator, "invalid iterator state" );
//STRIP001 
//STRIP001 	pIterator = pIterator->NextItem();
//STRIP001 	return 0 != pIterator;
//STRIP001 }

//--------------------------------------------------------------------

// TRUE if current item is a binding

//STRIP001 BOOL SfxMenuManager::IsBinding() const
//STRIP001 {
//STRIP001 	DBG_ASSERT( pIterator, "invalid iterator state" );
//STRIP001     SfxDispatcher* pDisp = pBindings->GetDispatcher_Impl();
//STRIP001     SfxModule *pMod = pDisp ? SFX_APP()->GetActiveModule( pDisp->GetFrame() ) :0;
//STRIP001     return pIterator->IsBinding( pMod );
//STRIP001 }

//STRIP001 String SfxMenuManager::GetCommand() const
//STRIP001 {
//STRIP001 	DBG_ASSERT( pIterator, "invalid iterator state" );
//STRIP001 	return pIterator->GetCommand();
//STRIP001 }

//--------------------------------------------------------------------

// TRUE if current item is a separator

//STRIP001 BOOL SfxMenuManager::IsSeparator() const
//STRIP001 {
//STRIP001 	DBG_ASSERT( pIterator, "invalid iterator state" );
//STRIP001 
//STRIP001 	return pIterator->IsSeparator();
//STRIP001 }

//--------------------------------------------------------------------

// TRUE if current item is a popup; may be also a binding

//STRIP001 BOOL SfxMenuManager::IsPopup() const
//STRIP001 {
//STRIP001 	DBG_ASSERT( pIterator, "invalid iterator state" );
//STRIP001 
//STRIP001 	return 0 != pIterator->GetPopupMenu();
//STRIP001 }

//--------------------------------------------------------------------

// returns sub-menu-level

//STRIP001 USHORT SfxMenuManager::GetLevel() const
//STRIP001 {
//STRIP001 	DBG_ASSERT( pIterator, "invalid iterator state" );
//STRIP001 
//STRIP001 	return pIterator->GetLevel();
//STRIP001 }

//--------------------------------------------------------------------

// id of binding if IsBinding()

//STRIP001 USHORT SfxMenuManager::GetItemId() const
//STRIP001 {
//STRIP001 	DBG_ASSERT( pIterator, "invalid iterator state" );
//STRIP001 
//STRIP001 #ifdef DBG_UTIL
//STRIP001 	ByteString aStr( U2S(pIterator->GetItemText()) );
//STRIP001 #endif
//STRIP001 
//STRIP001 	USHORT nId = pIterator->GetItemId();
//STRIP001 
//STRIP001 #ifdef DBG_UTIL
//STRIP001 	const SfxSlot *pSlot = nId ? SFX_SLOTPOOL().GetSlot( nId ) : NULL;
//STRIP001 	if ( pSlot && !pSlot->IsMode( SFX_SLOT_MENUCONFIG ) && nId != SID_MDIWINDOWLIST )
//STRIP001 	{
//STRIP001 		ByteString aStr( "Slot ");
//STRIP001 		aStr += ByteString::CreateFromInt32( nId );
//STRIP001 		aStr += ByteString( " : MenuConfig fehlt!" );
//STRIP001 		DBG_ERROR( aStr.GetBuffer() );
//STRIP001 	}
//STRIP001 #endif
//STRIP001 
//STRIP001 	if ( pIterator->GetPopupMenu() )
//STRIP001 	{
//STRIP001 #if defined( DBG_UTIL ) && !defined( WIN )
//STRIP001 		aStr += ByteString( " : Popups muessen Ids != 0 haben!" );
//STRIP001 		DBG_ASSERT( nId, aStr.GetBuffer() );
//STRIP001 #endif
//STRIP001 		return nId;
//STRIP001 	}
//STRIP001 	else if ( pIterator->GetCommand().Len() )
//STRIP001 	{
//STRIP001 		return nId;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 #if defined( DBG_UTIL ) && !defined( WIN )
//STRIP001 		aStr += ByteString( " : Menue-Entries muessen Ids > SID_SFX_START haben!" );
//STRIP001 		DBG_ASSERT( nId > SID_SFX_START || pIterator->IsSeparator(), aStr.GetBuffer() );
//STRIP001 #endif
//STRIP001 		return nId > SID_SFX_START ? nId : SID_NONE;
//STRIP001 	}
//STRIP001 }

//--------------------------------------------------------------------

// title of popup if IsPopup()

//STRIP001 String SfxMenuManager::GetTitle() const
//STRIP001 {
//STRIP001 	DBG_ASSERT( pIterator, "invalid iterator state" );
//STRIP001 
//STRIP001 	return pIterator->GetItemText();
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 String SfxMenuManager::GetHelpText() const
//STRIP001 {
//STRIP001 	DBG_ASSERT( pIterator, "invalid iterator state" );
//STRIP001 
//STRIP001 	return pIterator->GetItemHelpText();
//STRIP001 }

//--------------------------------------------------------------------

// call this before reconfiguring

//STRIP001 void SfxMenuManager::Clear()
//STRIP001 {
//STRIP001 	pBindings->ENTERREGISTRATIONS();
//STRIP001 	pOldMenu = pMenu;
//STRIP001 
//STRIP001 	// create the root config and a stack for the current sub-configs
//STRIP001 	pCfg = new SfxMenuCfgItemArr;
//STRIP001 	pCfgStack = new SfxMenuCfgItemArrStack;
//STRIP001 	pCfgStack->Push( pCfg );
//STRIP001 }

//--------------------------------------------------------------------

// call this after reconfiguring

//STRIP001 void SfxMenuManager::Reconfigure()
//STRIP001 {
//STRIP001 	SfxVirtualMenu *pVMenu;
//STRIP001 	Menu *pSVMenu;
//STRIP001 	if ( bMenuBar )
//STRIP001 		pSVMenu = new MenuBar;
//STRIP001 	else
//STRIP001 		pSVMenu = new PopupMenu;
//STRIP001 
//STRIP001 	TryToHideDisabledEntries_Impl( pSVMenu );
//STRIP001 	ConstructSvMenu( pSVMenu, *pCfg );
//STRIP001 
//STRIP001 	pVMenu = new SfxVirtualMenu( pSVMenu, FALSE, *pBindings, FALSE );
//STRIP001 	Construct(*pVMenu);
//STRIP001     if ( bMenuBar && pOldMenu )
//STRIP001 	{
//STRIP001         SfxMenuBarManager *pBar = (SfxMenuBarManager*) this;
//STRIP001         MenuBar* pOldBar = (MenuBar*) pOldMenu->GetSVMenu();
//STRIP001         MenuBar* pSvBar = (MenuBar*) GetMenu()->GetSVMenu();
//STRIP001         if ( pBar->GetWindow() && pBar->GetWindow()->GetMenuBar() == pOldBar )
//STRIP001             pBar->GetWindow()->SetMenuBar( pSvBar );
//STRIP001 	}
//STRIP001 
//STRIP001 	delete pOldMenu;
//STRIP001 	pOldMenu = 0;
//STRIP001 	pBindings->LEAVEREGISTRATIONS();
//STRIP001 	SetDefault( FALSE );
//STRIP001 }

//STRIP001 void SfxMenuManager::Construct_Impl( Menu* pSVMenu, BOOL bWithHelp )
//STRIP001 {
//STRIP001 	SfxVirtualMenu *pOldVirtMenu=0;
//STRIP001 	if ( pMenu )
//STRIP001 	{
//STRIP001 		// Es wird umkonfiguriert
//STRIP001 		pOldVirtMenu = pMenu;
//STRIP001 		pBindings->ENTERREGISTRATIONS();
//STRIP001 	}
//STRIP001 
//STRIP001 	TryToHideDisabledEntries_Impl( pSVMenu );
//STRIP001 	SfxVirtualMenu *pVMenu = new SfxVirtualMenu( pSVMenu, bWithHelp, *pBindings, bOLE );
//STRIP001 	Construct(*pVMenu);
//STRIP001 
//STRIP001     if ( bMenuBar && pOldVirtMenu )
//STRIP001 	{
//STRIP001         SfxMenuBarManager *pBar = (SfxMenuBarManager*) this;
//STRIP001         MenuBar* pOldBar = (MenuBar*) pOldVirtMenu->GetSVMenu();
//STRIP001         MenuBar* pSvBar = (MenuBar*) GetMenu()->GetSVMenu();
//STRIP001         if ( pBar->GetWindow()->GetMenuBar() == pOldBar )
//STRIP001             pBar->GetWindow()->SetMenuBar( pSvBar );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pOldVirtMenu )
//STRIP001 	{
//STRIP001 		delete pOldVirtMenu;
//STRIP001 		pBindings->LEAVEREGISTRATIONS();
//STRIP001 	}
//STRIP001 }

//--------------------------------------------------------------------

// reload all KeyCodes

//STRIP001 void SfxMenuManager::InvalidateKeyCodes()
//STRIP001 {
//STRIP001 	if ( pMenu )
//STRIP001 		pMenu->InvalidateKeyCodes();
//STRIP001 }

// ------------------------------------------------------------------------

/*N*/ BOOL SfxMenuManager::IsPopupFunction( USHORT nId )
/*N*/ {
/*N*/ 	return nId == SID_PICKLIST ||
/*N*/ 		   nId == SID_MDIWINDOWLIST ||
/*N*/ 		   nId == SID_HELPMENU ||
/*N*/ 		   nId == SID_ADDONLIST;
/*N*/ }

//====================================================================

// creates a menu-manager and loads it from resource RID_DEFAULTMENU or RID_DEFAULTPLUGINMENU
/*
SfxMenuBarManager::SfxMenuBarManager( SfxBindings& rBindings, BOOL bPlugin ) :

	SfxMenuManager( bPlugin ? RID_DEFAULTPLUGINMENU : RID_DEFAULTMENU, rBindings, TRUE ),

	pWindow( rBindings.GetSystemWindow() )

{
	DBG_MEMTEST();

	// initialize ObjectMenus
	for ( int n = 0; n < 4; ++n )
	{
		aObjMenus[n].nId = 0;
		aObjMenus[n].pPMMgr = NULL;
		aObjMenus[n].pResMgr = NULL;
	}
}
*/
//--------------------------------------------------------------------

// creates a menu-manager and loads it from a resource

/*N*/ SfxMenuBarManager::SfxMenuBarManager( const ResId& rResId, SfxBindings &rBindings, SfxConfigManager* pMgr, BOOL bOLE )
/*N*/     : SfxMenuManager( rResId, rBindings, pMgr, TRUE )
/*N*/     , pWindow( rBindings.GetSystemWindow() )
/*N*/     , bDowning( FALSE )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/ 	// initialize ObjectMenus
/*N*/ 	for ( int n = 0; n < 4; ++n )
/*N*/ 	{
/*N*/ 		aObjMenus[n].nId = 0;
/*N*/ 		aObjMenus[n].pPMMgr = NULL;
/*N*/ 		aObjMenus[n].pResMgr = NULL;
/*N*/ 	}
/*N*/ 
/*N*/ 	// #107258# full menu bar hierarchy is needed, if accessibility is enabled
/*N*/ 	BOOL bAccessibilityEnabled = Application::GetSettings().GetMiscSettings().GetEnableATToolSupport();
/*N*/     SetForceCtrlCreateMode( bOLE || bAccessibilityEnabled );
/*N*/ 
/*N*/ 	Initialize();
/*N*/ }

//STRIP001 SfxMenuBarManager::SfxMenuBarManager( const SfxMenuBarManager& rOther, SfxConfigManager* pMgr )
//STRIP001     : SfxMenuManager( ResId( rOther.GetType(), rOther.GetResMgr() ), (SfxBindings&) rOther.GetBindings(), pMgr, TRUE )
//STRIP001     , pWindow( NULL )
//STRIP001     , bDowning( FALSE )
//STRIP001 {
//STRIP001 	DBG_MEMTEST();
//STRIP001 
//STRIP001 	// initialize ObjectMenus
//STRIP001 	for ( int n = 0; n < 4; ++n )
//STRIP001 	{
//STRIP001         aObjMenus[n].nId =     rOther.aObjMenus[n].nId;
//STRIP001         aObjMenus[n].pPMMgr =  0;
//STRIP001         aObjMenus[n].pResMgr = rOther.aObjMenus[n].pResMgr;
//STRIP001 	}
//STRIP001 
//STRIP001     Initialize();
//STRIP001 }

/*N*/ SfxMenuBarManager::~SfxMenuBarManager()
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/ 	DBG_ASSERT(!aObjMenus[0].pPMMgr || !aObjMenus[1].pPMMgr ||
/*N*/ 			   !aObjMenus[2].pPMMgr || !aObjMenus[3].pPMMgr,
/*N*/ 			   "da sind noch ObjectMenus" );
/*N*/ 
/*N*/     bDowning = TRUE;
/*N*/     ResetObjectMenus();
/*N*/ 	UpdateObjectMenus();
/*N*/ 
/*N*/     MenuBar* pSvBar = (MenuBar*) GetMenu()->GetSVMenu();
/*N*/     if ( pWindow && pWindow->GetMenuBar() == pSvBar )
/*?*/         pWindow->SetMenuBar( 0 );
/*N*/ }


/*
SvStream* SfxMenuBarManager::GetDefaultStream( StreamMode nMode )
{
	String aUserConfig = SvtPathOptions().GetUserConfigPath();
    INetURLObject aObj( aUserConfig );
    aObj.insertName( GetStreamName() );
    return ::utl::UcbStreamHelper::CreateStream( aObj.GetMainURL( INetURLObject::NO_DECODE ), nMode );
}

BOOL SfxMenuBarManager::Load( SvStream& rStream, BOOL bOLEServer )
{
	SetForceCtrlCreateMode( bOLEServer );
	Menu *pSVMenu = LoadMenuBar( rStream );
	if ( pSVMenu )
		Construct_Impl( pSVMenu, FALSE );
	return ( pSVMenu != NULL );
}
*/

//------------------------------------------------------------------------
// To be compatible to 6.0/src641 we have to erase .uno commands we got
// from resource file. Otherwise these commands get saved to our XML configurations
// files and 6.0/src641 is not able to map these to slot ids again!!!
/*N*/ void SfxMenuManager::EraseItemCmds( Menu* pMenu )
/*N*/ {
/*N*/ 	USHORT nCount = pMenu->GetItemCount();
/*N*/ 	for ( USHORT nSVPos = 0; nSVPos < nCount; nSVPos++ )
/*N*/ 	{
/*N*/ 		USHORT nId = pMenu->GetItemId( nSVPos );
/*N*/ 		PopupMenu* pPopupMenu = pMenu->GetPopupMenu( nId );
/*N*/ 		if ( pPopupMenu )
/*N*/ 			EraseItemCmds( pPopupMenu );
/*N*/ 		else if ( nId > 0 )
/*N*/ 		{
/*N*/ 			// Remove .uno commands to be compatible with 6.0/src641
/*N*/ 			String aCommand = pMenu->GetItemCommand( nId );
/*N*/ 			if ( aCommand.CompareToAscii(".uno:", 5 ) == COMPARE_EQUAL )
/*N*/ 				pMenu->SetItemCommand( nId, String() );
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------
// Restore the correct macro ID so that menu items with an associated accelerator
// are correctly identified. This ensures that the accelerator info is displayed in
// the menu.
//STRIP001 void SfxMenuManager::RestoreMacroIDs( Menu* pMenu )
//STRIP001 {
//STRIP001 	USHORT nCount = pMenu->GetItemCount();
//STRIP001 	for ( USHORT nSVPos = 0; nSVPos < nCount; nSVPos++ )
//STRIP001 	{
//STRIP001 		USHORT nId = pMenu->GetItemId( nSVPos );
//STRIP001 		PopupMenu* pPopupMenu = pMenu->GetPopupMenu( nId );
//STRIP001 		if ( pPopupMenu )
//STRIP001 			RestoreMacroIDs( pPopupMenu );
//STRIP001 		else if ( nId < SID_SFX_START )
//STRIP001 		{
//STRIP001 			// Restore a valid ID for macro commands!
//STRIP001 			String aCommand = pMenu->GetItemCommand( nId );
//STRIP001 			if ( aCommand.CompareToAscii("macro:", 6 ) == COMPARE_EQUAL )
//STRIP001 			{
//STRIP001 				String	aTitle		= pMenu->GetItemText( nId );
//STRIP001 				String	aHelpText	= pMenu->GetHelpText( nId );
//STRIP001 				ULONG	nHelpId		= pMenu->GetHelpId( nId );
//STRIP001 				MenuItemBits nBits	= pMenu->GetItemBits( nId );
//STRIP001 
//STRIP001 	            SfxMacroInfo aInfo( aCommand );
//STRIP001 				SFX_APP()->GetMacroConfig()->GetSlotId( &aInfo );
//STRIP001 				nId = aInfo.GetSlotId();
//STRIP001 				
//STRIP001 				pMenu->RemoveItem( nSVPos );
//STRIP001 				pMenu->InsertItem( nId, aTitle, nBits, nSVPos );
//STRIP001 				pMenu->SetHelpText( nId, aHelpText );
//STRIP001 				pMenu->SetHelpId( nId, nHelpId );
//STRIP001 			}			
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 MenuBar* SfxMenuBarManager::LoadMenuBar( SvStream& rStream )
//STRIP001 {
//STRIP001 	::com::sun::star::uno::Reference < ::com::sun::star::io::XInputStream > xInputStream =
//STRIP001 		new ::utl::OInputStreamWrapper( rStream );
//STRIP001 	MenuBar *pSVMenu = NULL;
//STRIP001 	try
//STRIP001 	{
//STRIP001         ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory> aXMultiServiceFactory(::legacy_binfilters::getLegacyProcessServiceFactory());
//STRIP001 		::framework::MenuConfiguration aConfig( aXMultiServiceFactory );
//STRIP001 		pSVMenu = aConfig.CreateMenuBarFromConfiguration( xInputStream );
//STRIP001 		if ( pSVMenu )
//STRIP001 			SfxMenuManager::RestoreMacroIDs( pSVMenu );
//STRIP001 	}
//STRIP001 	catch ( ::com::sun::star::lang::WrappedTargetException&  )
//STRIP001 	{
//STRIP001 	}
//STRIP001 
//STRIP001 	return pSVMenu;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 BOOL SfxMenuBarManager::StoreMenuBar( SvStream& rStream, MenuBar* pMenuBar )
//STRIP001 {
//STRIP001 	BOOL bRet = TRUE;
//STRIP001     ::utl::OOutputStreamWrapper* pHelper = new ::utl::OOutputStreamWrapper( rStream );
//STRIP001     ::com::sun::star::uno::Reference < ::com::sun::star::io::XOutputStream > xOut( pHelper );
//STRIP001 	try
//STRIP001 	{
//STRIP001         ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory> aXMultiServiceFactory(::legacy_binfilters::getLegacyProcessServiceFactory());
//STRIP001     	framework::MenuConfiguration aCfg( aXMultiServiceFactory );
//STRIP001     	aCfg.StoreMenuBar( pMenuBar, xOut );
//STRIP001 	}
//STRIP001 	catch ( ::com::sun::star::lang::WrappedTargetException&  )
//STRIP001 	{
//STRIP001 		bRet = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }

//------------------------------------------------------------------------

/*N*/ void SfxMenuBarManager::ResetObjectMenus()
/*N*/ {
/*N*/ 	for ( int n = 0; n <= 3; ++n )
/*N*/ 		aObjMenus[n].nId = 0;
/*N*/ }

//------------------------------------------------------------------------

/*N*/ void SfxMenuBarManager::SetObjectMenu( USHORT nPos, const ResId& rResId )
/*N*/ {
/*N*/ 	nPos -= SID_OBJECTMENU0;
/*N*/ 	DBG_ASSERT( nPos < 4, "only 4 object Menu positions defined" );
/*N*/ 
/*N*/ 	aObjMenus[nPos].nId = rResId.GetId();
/*N*/ 	aObjMenus[nPos].pResMgr = rResId.GetResMgr();
/*N*/ }


//------------------------------------------------------------------------

//STRIP001 MenuBar* SfxMenuBarManager::GetMenuBar() const
//STRIP001 {
//STRIP001 	return (MenuBar*) GetMenu()->GetSVMenu();
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 PopupMenu* SfxMenuBarManager::GetObjectMenu( USHORT nPos, USHORT &rConfigId )
//STRIP001 {
//STRIP001 	nPos -= SID_OBJECTMENU0;
//STRIP001 	DBG_ASSERT( nPos < 4, "only 4 object Menu positions defined" );
//STRIP001 
//STRIP001 	rConfigId = aObjMenus[nPos].nId;
//STRIP001 	return aObjMenus[nPos].pPMMgr
//STRIP001 			? (PopupMenu*) aObjMenus[nPos].pPMMgr->GetMenu()->GetSVMenu()
//STRIP001 			: 0;
//STRIP001 }

//------------------------------------------------------------------------

/*N*/ void SfxMenuBarManager::UpdateObjectMenus()
/*N*/ {
/*N*/ 	Menu *pMenu = GetMenu()->GetSVMenu();
/*N*/ 	for ( int n = 0; n < 4; ++n )
/*N*/ 	{
/*N*/ 		SfxPopupMenuManager *pOldPopup = aObjMenus[n].pPMMgr;
/*N*/ 
/*N*/         // check if this object menue is in the menubar at all
/*N*/         USHORT nId = n + SID_OBJECTMENU0;
/*N*/         BOOL bInMenu = ( pMenu->GetItemPos( nId ) != MENU_ITEM_NOTFOUND );
/*N*/         PopupMenu* pOldSVPopup = pMenu->GetPopupMenu( nId );
/*N*/ 
/*N*/ 		if ( aObjMenus[n].nId )
/*N*/ 		{
/*N*/             if ( bInMenu )
/*N*/ 			{
/*N*/                 if ( !pOldPopup && pOldSVPopup )
/*N*/                 {
/*N*/                     // remove dummy popup
/*N*/                     pMenu->SetPopupMenu( nId, 0 );
/*N*/                     delete pOldSVPopup;
/*N*/                 }
/*N*/ 
/*N*/                 if ( !pOldPopup || ( pOldPopup && pOldPopup->GetType() != aObjMenus[n].nId ) )
/*N*/ 				{
/*N*/ 					ResId aResId( aObjMenus[n].nId, aObjMenus[n].pResMgr );
/*N*/ 					aObjMenus[n].pPMMgr =
/*N*/ 						new SfxPopupMenuManager( aResId , GetBindings() );
/*N*/ 					aObjMenus[n].pPMMgr->Initialize();
/*N*/ 				}
/*N*/ 				else
/*N*/                     // popups remains the same, prevent deletion
/*N*/ 					pOldPopup = NULL;
/*N*/ 
/*N*/                 pMenu->SetPopupMenu( nId, (PopupMenu*) aObjMenus[n].pPMMgr->GetMenu()->GetSVMenu() );
/*N*/                 pMenu->EnableItem( nId, TRUE );
/*N*/ 			}
/*N*/ 		}
/*N*/ 		else if ( pOldPopup )
/*N*/ 		{
/*N*/             if ( pMenu->GetItemPos( nId ) != MENU_ITEM_NOTFOUND )
/*N*/ 			{
/*N*/ //                pMenu->EnableItem( nId, FALSE );
/*N*/                 pMenu->SetPopupMenu( nId, 0 );
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( pOldPopup )
/*N*/ 		{
/*N*/             // no new popup menu created, so reset pointer before deleting menu
/*N*/ 			if ( pOldPopup == aObjMenus[n].pPMMgr )
/*N*/ 				aObjMenus[n].pPMMgr = NULL;
/*N*/ 			pOldPopup->StoreConfig();
/*N*/ 			delete pOldPopup;
/*N*/ 		}
/*N*/ 
/*N*/         if ( bDowning )
/*N*/         {
/*N*/             // delete possible empty popup menues
/*N*/             PopupMenu *pPop = pMenu->GetPopupMenu( nId );
/*N*/             if ( pPop )
/*N*/             {
/*N*/                 pMenu->SetPopupMenu( nId, 0 );
/*N*/                 delete pPop;
/*N*/             }
/*N*/         }
/*N*/         else if ( bInMenu )
/*N*/         {
/*N*/             // insert an empty popup window
/*N*/             if ( !aObjMenus[n].pPMMgr && !pMenu->GetPopupMenu( nId ) )
/*N*/                 pMenu->SetPopupMenu( nId, new PopupMenu );
/*N*/         }
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------

//STRIP001 void SfxMenuBarManager::ReconfigureObjectMenus()
//STRIP001 {
//STRIP001 	for ( int n = 0; n < 4; ++n )
//STRIP001 	{
//STRIP001 		if ( aObjMenus[n].nId )
//STRIP001 		{
//STRIP001 			Menu *pMenu = GetMenu()->GetSVMenu();
//STRIP001             if ( pMenu->GetItemPos( n + SID_OBJECTMENU0 ) != MENU_ITEM_NOTFOUND )
//STRIP001 			{
//STRIP001 				if ( !aObjMenus[n].pPMMgr )
//STRIP001 				{
//STRIP001 					ResId aResId(aObjMenus[n].nId, aObjMenus[n].pResMgr);
//STRIP001 					aObjMenus[n].pPMMgr =
//STRIP001 						new SfxPopupMenuManager( aResId , GetBindings() );
//STRIP001 					aObjMenus[n].pPMMgr->Initialize();
//STRIP001 				}
//STRIP001 
//STRIP001 				pMenu->SetPopupMenu( n + SID_OBJECTMENU0,
//STRIP001 					(PopupMenu*) aObjMenus[n].pPMMgr->GetMenu()->GetSVMenu() );
//STRIP001 				pMenu->EnableItem( n + SID_OBJECTMENU0, TRUE );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//====================================================================

// don't insert Popups into ConfigManager, they are not configurable at the moment !
/*N*/ SfxPopupMenuManager::SfxPopupMenuManager(const ResId& rResId, SfxBindings &rBindings )
/*N*/     : SfxMenuManager( rResId, rBindings, NULL/*rBindings.GetConfigManager( rResId.GetId() )*/, FALSE )
/*N*/ 	, pSVMenu( NULL )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ }

//-------------------------------------------------------------------------

//STRIP001 void SfxPopupMenuManager::RemoveDisabledEntries()
//STRIP001 {
//STRIP001 	if ( pSVMenu )
//STRIP001 		TryToHideDisabledEntries_Impl( pSVMenu );
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 USHORT SfxPopupMenuManager::Execute( const Point& rPos, Window* pWindow )
//STRIP001 {
//STRIP001 	DBG_MEMTEST();
//STRIP001 	return ( (PopupMenu*) GetMenu()->GetSVMenu() )->Execute( pWindow, rPos );
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 IMPL_LINK_INLINE_START( SfxPopupMenuManager, SelectHdl, void *, pvoid )
//STRIP001 {
//STRIP001 	return 1;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SfxPopupMenuManager, SelectHdl, void *, pvoid )


//--------------------------------------------------------------------

//STRIP001 USHORT SfxPopupMenuManager::Execute( const Point& rPoint, Window* pWindow, va_list pArgs, const SfxPoolItem *pArg1 )
//STRIP001 {
//STRIP001 	DBG_MEMTEST();
//STRIP001 
//STRIP001 	PopupMenu* pMenu = ( (PopupMenu*)GetMenu()->GetSVMenu() );
//STRIP001 	pMenu->SetSelectHdl( LINK( this, SfxPopupMenuManager, SelectHdl ) );
//STRIP001     USHORT nId = pMenu->Execute( pWindow, rPoint );
//STRIP001 	pMenu->SetSelectHdl( Link() );
//STRIP001 
//STRIP001 	if ( nId )
//STRIP001         GetBindings().GetDispatcher()->_Execute( nId, SFX_CALLMODE_RECORD, pArgs, pArg1 );
//STRIP001 
//STRIP001 	return nId;
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 USHORT SfxPopupMenuManager::Execute( const Point& rPoint, Window* pWindow, const SfxPoolItem *pArg1, ... )
//STRIP001 {
//STRIP001 	DBG_MEMTEST();
//STRIP001 
//STRIP001 	va_list pArgs;
//STRIP001 	va_start(pArgs, pArg1);
//STRIP001 
//STRIP001     return (Execute( rPoint, pWindow, pArgs, pArg1 ));
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void SfxPopupMenuManager::StartInsert()
//STRIP001 {
//STRIP001 	ResId aResId(GetType());
//STRIP001 	aResId.SetRT(RSC_MENU);
//STRIP001 	aResId.SetResMgr(pResMgr);
//STRIP001 	pSVMenu = new PopupMenu( aResId );
//STRIP001 	TryToHideDisabledEntries_Impl( pSVMenu );
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void SfxPopupMenuManager::EndInsert()
//STRIP001 {
//STRIP001 	pBindings->ENTERREGISTRATIONS();
//STRIP001 	pMenu = new SfxVirtualMenu( pSVMenu, FALSE, *pBindings, TRUE, TRUE );
//STRIP001 	Construct( *pMenu );
//STRIP001 	pBindings->LEAVEREGISTRATIONS();
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void SfxPopupMenuManager::InsertSeparator( USHORT nPos )
//STRIP001 {
//STRIP001 	pSVMenu->InsertSeparator( nPos );
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void SfxPopupMenuManager::InsertItem( USHORT nId, const String& rName, MenuItemBits nBits, USHORT nPos )
//STRIP001 {
//STRIP001 	pSVMenu->InsertItem( nId, rName, nBits,nPos );
//STRIP001 	pSVMenu->SetHelpId( nId, (ULONG) nId );
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void SfxPopupMenuManager::RemoveItem( USHORT nId )
//STRIP001 {
//STRIP001 	pSVMenu->RemoveItem( nId );
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void SfxPopupMenuManager::CheckItem( USHORT nId, BOOL bCheck )
//STRIP001 {
//STRIP001 	pSVMenu->CheckItem( nId, bCheck );
//STRIP001 }

//STRIP001 void SfxPopupMenuManager::AddClipboardFunctions()
//STRIP001 {
//STRIP001 	if ( bMenuBar )
//STRIP001 	{
//STRIP001 		DBG_ERROR( "Not for menubars!" );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	bAddClipboardFuncs = TRUE;
//STRIP001 }

/*?*/ int SfxMenuManager::Load( SotStorage& rStorage )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
//STRIP001     SotStorageStreamRef xStream = rStorage.OpenSotStream( SfxMenuManager::GetStreamName(), STREAM_STD_READ );
//STRIP001     if ( xStream->GetError() )
//STRIP001         return SfxConfigItem::ERR_READ;
//STRIP001     else
//STRIP001         return Load( *xStream );
/*?*/ }

/*?*/ BOOL SfxMenuManager::Store( SotStorage& rStorage )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
//STRIP001     SotStorageStreamRef xStream = rStorage.OpenSotStream( SfxMenuManager::GetStreamName(), STREAM_STD_READWRITE|STREAM_TRUNC );
//STRIP001     if ( xStream->GetError() )
//STRIP001         return FALSE;
//STRIP001     else
//STRIP001         return Store( *xStream );
/*?*/ }

/*N*/ int SfxMenuBarManager::Load( SotStorage& rStorage )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
//STRIP001     SotStorageStreamRef xStream = rStorage.OpenSotStream( SfxMenuManager::GetStreamName(), STREAM_STD_READ );
//STRIP001     if ( xStream->GetError() )
//STRIP001         return SfxConfigItem::ERR_READ;
//STRIP001     else
//STRIP001     {
//STRIP001         Menu *pSVMenu = LoadMenuBar( *xStream );
//STRIP001         if ( pSVMenu )
//STRIP001         {
//STRIP001 		    Construct_Impl( pSVMenu, FALSE );
//STRIP001 			SetDefault( FALSE );
//STRIP001 			return ERR_OK;
//STRIP001 		}
//STRIP001         else
//STRIP001 			UseDefault();
//STRIP001 		return ERR_READ;
//STRIP001     }
/*N*/ }

/*N*/ BOOL SfxMenuBarManager::Store( SotStorage& rStorage )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE; //STRIP001 
//STRIP001     SotStorageStreamRef xStream = rStorage.OpenSotStream( SfxMenuManager::GetStreamName(), STREAM_STD_READWRITE|STREAM_TRUNC );
//STRIP001     if ( xStream->GetError() )
//STRIP001         return FALSE;
//STRIP001     else
//STRIP001         return StoreMenuBar( *xStream, (MenuBar*) GetMenu()->GetSVMenu() );
/*N*/ }

//STRIP001 SfxMenuManager::SfxMenuManager( Menu* pMenu, SfxBindings &rBindings )
//STRIP001 :   SfxConfigItem( 0, NULL ),
//STRIP001     bMenuBar(FALSE),
//STRIP001 	pMenu(0),
//STRIP001 	pOldMenu(0),
//STRIP001     pResMgr(NULL),
//STRIP001 	pBindings(&rBindings)
//STRIP001 {
//STRIP001 	bOLE = FALSE;
//STRIP001 	bAddClipboardFuncs = FALSE;
//STRIP001     SfxVirtualMenu* pVMenu = new SfxVirtualMenu( pMenu, FALSE, rBindings, TRUE, TRUE );
//STRIP001 	Construct(*pVMenu);
//STRIP001 }

//STRIP001 SfxPopupMenuManager::SfxPopupMenuManager( PopupMenu* pMenu, SfxBindings& rBindings )
//STRIP001     : SfxMenuManager( pMenu, rBindings )
//STRIP001     , pSVMenu( pMenu )
//STRIP001 {
//STRIP001 }

//STRIP001 void SfxPopupMenuManager::ExecutePopup( const ResId& rResId, SfxViewFrame* pFrame, const Point& rPoint, Window* pWindow )
//STRIP001 {
//STRIP001     PopupMenu *pSVMenu = new PopupMenu( rResId );
//STRIP001     USHORT n, nCount = pSVMenu->GetItemCount();
//STRIP001     for ( n=0; n<nCount; n++ )
//STRIP001     {
//STRIP001         USHORT nId = pSVMenu->GetItemId( n );
//STRIP001         if ( nId == SID_COPY || nId == SID_CUT || nId == SID_PASTE )
//STRIP001             break;
//STRIP001     }
//STRIP001 
//STRIP001     if ( n == nCount )
//STRIP001     {
//STRIP001         PopupMenu aPop( SfxResId( MN_CLIPBOARDFUNCS ) );
//STRIP001         nCount = aPop.GetItemCount();
//STRIP001         pSVMenu->InsertSeparator();
//STRIP001         for ( n=0; n<nCount; n++ )
//STRIP001         {
//STRIP001             USHORT nId = aPop.GetItemId( n );
//STRIP001             pSVMenu->InsertItem( nId, aPop.GetItemText( nId ), aPop.GetItemBits( nId ) );
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     InsertVerbs_Impl( pFrame->GetViewShell()->GetVerbs(), pSVMenu );
//STRIP001     Menu* pMenu = NULL;
//STRIP001     ::com::sun::star::ui::ContextMenuExecuteEvent aEvent;
//STRIP001     aEvent.SourceWindow = VCLUnoHelper::GetInterface( pWindow );
//STRIP001     aEvent.ExecutePosition.X = rPoint.X();
//STRIP001     aEvent.ExecutePosition.Y = rPoint.Y();
//STRIP001     if ( pFrame->GetViewShell()->TryContextMenuInterception( *pSVMenu, pMenu, aEvent ) )
//STRIP001     {
//STRIP001         if ( pMenu )
//STRIP001         {
//STRIP001             delete pSVMenu;
//STRIP001             pSVMenu = (PopupMenu*) pMenu;
//STRIP001         }
//STRIP001 		
//STRIP001 		SfxPopupMenuManager aPop( pSVMenu, pFrame->GetBindings() );
//STRIP001 		aPop.RemoveDisabledEntries();
//STRIP001 		aPop.Execute( rPoint, pWindow );
//STRIP001     }
//STRIP001 }

/*?*/ BOOL SfxMenuBarManager::ReInitialize()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return false;//STRIP001 
//STRIP001 	BOOL bRet = SfxConfigItem::ReInitialize();
//STRIP001 	if ( bRet )
//STRIP001 		UpdateObjectMenus();
//STRIP001 	return bRet;
/*?*/ }
}
