/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_bmkmenu.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:40:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "bmkmenu.hxx"

#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
#ifndef _COM_SUN_STAR_FRAME_XDISPATCH_HPP_
#include <com/sun/star/frame/XDispatch.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XDISPATCHPROVIDER_HPP_
#include <com/sun/star/frame/XDispatchProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XFRAME_HPP_
#include <com/sun/star/frame/XFrame.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_URL_HPP_
#include <com/sun/star/util/URL.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _UNOTOOLS_PROCESSFACTORY_HXX
#include <comphelper/processfactory.hxx>
#endif
#ifndef _COM_SUN_STAR_UTIL_XURLTRANSFORMER_HPP_
#include <com/sun/star/util/XURLTransformer.hpp>
#endif
#ifndef _SFXAPP_HXX
#include <app.hxx>
#endif
#include <tools/urlobj.hxx>
#ifndef _CONFIG_HXX
#include <tools/config.hxx>
#endif
#include <svtools/pathoptions.hxx>
#include <svtools/internaloptions.hxx>
#include <unotools/localfilehelper.hxx>

#include "viewfrm.hxx"
#include "accmgr.hxx"
#include "frame.hxx"
#include "sfxresid.hxx"
#include "helper.hxx"
#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif

#include "menu.hrc"
namespace binfilter {

#define INTERNETSHORTCUT_EXT			"url"
#define INTERNETSHORTCUT_ID_TAG			"InternetShortcut"
#define INTERNETSHORTCUT_URL_TAG		"URL"
#define INTERNETSHORTCUT_PASS_TAG		"Password"
#define INTERNETSHORTCUT_TITLE_TAG		"Title"
#define INTERNETSHORTCUT_TARGET_TAG		"Target"
#define INTERNETSHORTCUT_FOLDER_TAG		"Folder"
#define INTERNETSHORTCUT_FRAME_TAG		"Frame"
#define INTERNETSHORTCUT_BROWSER_TAG	"Browser"
#define INTERNETSHORTCUT_OPENAS_TAG		"OpenAs"
#define INTERNETSHORTCUT_TEMPLATE_TAG	"Template"
#define INTERNETSHORTCUT_DEFTEMPL_TAG	"DefaultTemplate"
#define INTERNETSHORTCUT_DEFURL_TAG		"DefaultURL"
#define INTERNETSHORTCUT_SOICON_TAG		"SOIcon"

#define URLFILE_CHARSET               CHARSET_ANSI

//STRIP001 void ReadURLFile
//STRIP001 (
//STRIP001     const String& rFile,
//STRIP001     String&	rTitle,
//STRIP001     String&	rURL,
//STRIP001     String&	rFrame,
//STRIP001     BOOL*	pShowAsFolder,
//STRIP001 	USHORT&	rImageId,
//STRIP001     String* pOpenAs=0,
//STRIP001     String* pDefTempl=0,
//STRIP001     String* pDefURL=0
//STRIP001 );
//STRIP001 
//STRIP001 using namespace ::com::sun::star::uno;
//STRIP001 using namespace ::com::sun::star::util;
//STRIP001 using namespace ::com::sun::star::frame;
//STRIP001 using namespace ::com::sun::star::beans;
//STRIP001 
//STRIP001 DECLARE_LIST( SfxBmkMenuList, SfxBmkMenu* )//STRIP008 ;
//STRIP001 
//STRIP001 class SfxBmkMenu_Impl
//STRIP001 {
//STRIP001 private:
//STRIP001 	static USHORT		_nMID;
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001     String               _aURL;
//STRIP001     String               _aReferer;
//STRIP001     SfxBmkMenuList       _aSubMenuList;
//STRIP001     SfxBmkMenu*          _pRoot;
//STRIP001     BOOL                 _bInitialized;
//STRIP001     BOOL                 _bActivated;
//STRIP001 
//STRIP001     SfxBmkMenu_Impl( const String& rURL, SfxBmkMenu* pRoot );
//STRIP001     SfxBmkMenu_Impl( const String& rURL, const String& rReferer );
//STRIP001     ~SfxBmkMenu_Impl();
//STRIP001 
//STRIP001 	static USHORT		GetMID();
//STRIP001 	static String		GetTitle( const String& rTitle );
//STRIP001 };
//STRIP001 
//STRIP001 USHORT SfxBmkMenu_Impl::_nMID = BMKMENU_ITEMID_START;
//STRIP001 
//STRIP001 SfxBmkMenu_Impl::SfxBmkMenu_Impl( const String& rURL, SfxBmkMenu* pRoot ) :
//STRIP001 	_aURL(rURL),
//STRIP001 	_pRoot(pRoot),
//STRIP001 	_bInitialized(FALSE),
//STRIP001     _bActivated( FALSE )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 SfxBmkMenu_Impl::SfxBmkMenu_Impl( const String& rURL, const String& rReferer ) :
//STRIP001 	_aURL(rURL),
//STRIP001 	_pRoot(0),
//STRIP001 	_aReferer( rReferer ),
//STRIP001 	_bInitialized(FALSE),
//STRIP001     _bActivated( FALSE )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 SfxBmkMenu_Impl::~SfxBmkMenu_Impl()
//STRIP001 {
//STRIP001 	ULONG nCount = _aSubMenuList.Count();
//STRIP001 	for ( ULONG n = 0; n < nCount; ++n )
//STRIP001 		delete _aSubMenuList.GetObject( n );
//STRIP001 }
//STRIP001 
//STRIP001 USHORT SfxBmkMenu_Impl::GetMID()
//STRIP001 {
//STRIP001 	_nMID++;
//STRIP001 	if( !_nMID )
//STRIP001         _nMID = BMKMENU_ITEMID_START;
//STRIP001 	return _nMID;
//STRIP001 }
//STRIP001 
//STRIP001 String SfxBmkMenu_Impl::GetTitle( const String& rStr )
//STRIP001 {
//STRIP001 	// "_..._" vorne rausschneiden
//STRIP001 	String aTitle( rStr );
//STRIP001     if ( aTitle.Len() && aTitle.GetChar(0) == 0x005f)
//STRIP001 	{
//STRIP001 		aTitle.Erase( 0, 1 );
//STRIP001         while ( aTitle.Len() && aTitle.GetChar(0) != 0x005f )
//STRIP001 			aTitle.Erase( 0, 1 );
//STRIP001 		if ( aTitle.Len() )
//STRIP001 			aTitle.Erase( 0, 1 );
//STRIP001 		else
//STRIP001 			aTitle = rStr;
//STRIP001 	}
//STRIP001 
//STRIP001 	return aTitle;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 ImageList* SfxBmkMenu::_pSmallImages = NULL;
//STRIP001 ImageList* SfxBmkMenu::_pBigImages = NULL;
//STRIP001 
//STRIP001 SfxBmkMenu::SfxBmkMenu( const String& rURL, SfxBmkMenu* pRoot )
//STRIP001 {
//STRIP001     _pImp = new SfxBmkMenu_Impl( rURL, pRoot );
//STRIP001 }
//STRIP001 
//STRIP001 Image SfxBmkMenu::GetImage( USHORT nId, BOOL bBig )
//STRIP001 {
//STRIP001 	ImageList* pList = NULL;
//STRIP001 	if ( bBig )
//STRIP001 	{
//STRIP001 		if ( !_pBigImages )
//STRIP001 			_pBigImages = new ImageList( SfxResId( RID_IMGLST_BIG ) );
//STRIP001 		pList = _pBigImages;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( !_pSmallImages )
//STRIP001 			_pSmallImages = new ImageList( SfxResId( RID_IMGLST_SMALL ) );
//STRIP001 		pList = _pSmallImages;
//STRIP001 	}
//STRIP001 	return pList->GetImage( nId );
//STRIP001 }
//STRIP001 
//STRIP001 SfxBmkMenu::SfxBmkMenu( const String& rURL, const String& rReferer )
//STRIP001 {
//STRIP001     _pImp = new SfxBmkMenu_Impl( rURL, rReferer );
//STRIP001 }
//STRIP001 
//STRIP001 SfxBmkMenu::~SfxBmkMenu()
//STRIP001 {
//STRIP001 	delete _pImp;
//STRIP001 }
//STRIP001 
//STRIP001 void SfxBmkMenu::Activate()
//STRIP001 {
//STRIP001 	Initialize();
//STRIP001 	_pImp->_bActivated = TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 void SfxBmkMenu::Deactivate()
//STRIP001 {
//STRIP001 	PopupMenu::Deactivate();
//STRIP001 	_pImp->_bActivated = FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 void SfxBmkMenu::Select()
//STRIP001 {
//STRIP001 	String aURL( GetItemCommand( GetCurItemId() ) );
//STRIP001 	if( !aURL.Len() )
//STRIP001 		return;
//STRIP001 
//STRIP001     Reference < XFramesSupplier > xDesktop = Reference < XFramesSupplier >( ::legacy_binfilters::getLegacyProcessServiceFactory()->createInstance( DEFINE_CONST_UNICODE("com.sun.star.frame.Desktop") ), UNO_QUERY );
//STRIP001     Reference < XFrame > xFrame( xDesktop->getActiveFrame() );
//STRIP001     if ( !xFrame.is() )
//STRIP001         xFrame = Reference < XFrame >( xDesktop, UNO_QUERY );
//STRIP001 
//STRIP001     URL aTargetURL;
//STRIP001     aTargetURL.Complete = aURL;
//STRIP001     Reference < XURLTransformer > xTrans( ::legacy_binfilters::getLegacyProcessServiceFactory()->createInstance( ::rtl::OUString::createFromAscii("com.sun.star.util.URLTransformer" )), UNO_QUERY );
//STRIP001     xTrans->parseStrict( aTargetURL );
//STRIP001 
//STRIP001     Reference < XDispatchProvider > xProv( xFrame, UNO_QUERY );
//STRIP001     Reference < XDispatch > xDisp;
//STRIP001 	if ( xProv.is() )
//STRIP001         if ( aTargetURL.Protocol.compareToAscii("slot:") == COMPARE_EQUAL )
//STRIP001             xDisp = xProv->queryDispatch( aTargetURL, ::rtl::OUString(), 0 );
//STRIP001         else
//STRIP001             xDisp = xProv->queryDispatch( aTargetURL, ::rtl::OUString::createFromAscii("_blank"), 0 );
//STRIP001     if ( xDisp.is() )
//STRIP001 	{
//STRIP001         SfxBmkMenu* pRoot = _pImp->_pRoot;
//STRIP001         if( !pRoot )
//STRIP001             pRoot = this;
//STRIP001 
//STRIP001 		Sequence<PropertyValue> aArgs(1);
//STRIP001 		PropertyValue* pArg = aArgs.getArray();
//STRIP001 		pArg[0].Name = ::rtl::OUString::createFromAscii("Referer");
//STRIP001         pArg[0].Value <<= (::rtl::OUString) pRoot->_pImp->_aReferer;
//STRIP001 		xDisp->dispatch( aTargetURL, aArgs );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SfxBmkMenu::Initialize()
//STRIP001 {
//STRIP001 	if( _pImp->_bInitialized )
//STRIP001 		return;
//STRIP001 
//STRIP001     _pImp->_bInitialized = TRUE;
//STRIP001     SfxAcceleratorManager* pAccMgr = SFX_APP()->GetAcceleratorManager();
//STRIP001     Sequence< ::rtl::OUString > aFiles = SfxContentHelper::GetFolderContents( _pImp->_aURL, sal_False, sal_True );
//STRIP001 	const ::rtl::OUString* pFiles  = aFiles.getConstArray();
//STRIP001 	UINT32 i, nCount = aFiles.getLength();
//STRIP001 	for ( i = 0; i < nCount; ++i )
//STRIP001 	{
//STRIP001 		String aFileURL( pFiles[i] );
//STRIP001 		INetURLObject aObj( aFileURL );
//STRIP001 
//STRIP001         String aTitle;
//STRIP001         String aURL;
//STRIP001         BOOL bShowAsFolder;
//STRIP001         String aFrame;
//STRIP001 		USHORT nImageId = USHRT_MAX;
//STRIP001 
//STRIP001         ReadURLFile( aObj.GetMainURL( INetURLObject::NO_DECODE ), aTitle, aURL, aFrame, &bShowAsFolder, nImageId );
//STRIP001 
//STRIP001 		if ( !aTitle.Len() && !aURL.Len() )
//STRIP001 			continue;
//STRIP001 
//STRIP001 		if ( aTitle.GetChar(0) == '_' && aTitle.GetChar(3) == '_' )
//STRIP001             aTitle = aTitle.Erase( 0, 4 );
//STRIP001 
//STRIP001         if( aURL.EqualsAscii("private:separator") )
//STRIP001 			InsertSeparator();
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aURL = SvtPathOptions().SubstituteVariable( aURL );
//STRIP001             if ( aURL.CompareToAscii("private:factory/desktop") == 0 && SvtInternalOptions().IsRemoveMenuEntryNewWebtop() )
//STRIP001                 continue;
//STRIP001 
//STRIP001             USHORT nId = CreateMenuId();
//STRIP001             if( !bShowAsFolder )
//STRIP001 			{
//STRIP001                 USHORT nTitleLen = aTitle.Len();
//STRIP001                 if( nTitleLen > 4  && aTitle.GetChar(nTitleLen-4) == '.' && aURL.EqualsAscii( "file:",0,5 ) )
//STRIP001                     aTitle.Erase( nTitleLen-4 );
//STRIP001 				Image aImage = GetImage( nImageId, FALSE );
//STRIP001                 InsertItem( nId, aTitle, aImage );
//STRIP001                 SetItemCommand( nId, aURL );
//STRIP001                 if( aURL.EqualsIgnoreCaseAscii("slot:",0,5) )
//STRIP001                 {
//STRIP001                     INetURLObject aURLObj( aURL );
//STRIP001                     KeyCode aKey(pAccMgr->GetKeyCode( aURLObj.GetURLPath().ToInt32() ) );
//STRIP001                     SetAccelKey( nId, aKey );
//STRIP001                 }
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 InsertItem( nId, aTitle );
//STRIP001                 SfxBmkMenu* pSubMenu = new SfxBmkMenu( aURL,
//STRIP001                         _pImp->_pRoot ? _pImp->_pRoot : this );
//STRIP001                 _pImp->_aSubMenuList.Insert( pSubMenu, LIST_APPEND );
//STRIP001                 SetPopupMenu( nId, pSubMenu );
//STRIP001             }
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 USHORT SfxBmkMenu::CreateMenuId()
//STRIP001 {
//STRIP001     return SfxBmkMenu_Impl::GetMID();
//STRIP001 }
//STRIP001 
//STRIP001 String ReadURL_Impl( Config& rURLFile, const String& rFile )
//STRIP001 {
//STRIP001 	// read the URL from config file
//STRIP001     String aURL( String( rURLFile.ReadKey( INTERNETSHORTCUT_URL_TAG ), RTL_TEXTENCODING_UTF8 ) );
//STRIP001 	aURL = SvtPathOptions().SubstituteVariable( aURL );
//STRIP001 
//STRIP001 	// make it absolute
//STRIP001     INetURLObject aBase( rFile );
//STRIP001     DBG_ASSERT( aBase.GetProtocol() != INET_PROT_NOT_VALID, "Invalid URL!" );
//STRIP001 	INetURLObject aOut;
//STRIP001 	aBase.GetNewAbsURL( aURL, &aOut );
//STRIP001 	return aOut.GetMainURL( INetURLObj::NO_DECODE );
//STRIP001 }
//STRIP001 
//STRIP001 void ReadURLFile
//STRIP001 (
//STRIP001 	const String& rFile,	  // Datei, aus der gelesen werden soll
//STRIP001 	String& rTitle,           // Puffer fuer den Titel
//STRIP001 	String& rURL,             // Puffer fuer den URL
//STRIP001     String& rFrame,           // Puffer fuer den Zielrahmen
//STRIP001 	BOOL* pShowAsFolder,      /* Puffer fuer das Flag, ob die URL als Ordner
//STRIP001 								 dargestellt wird:
//STRIP001 								 NULL => wird nicht geliefert */
//STRIP001 	USHORT& rImageId,		  // zugeordnetes Image
//STRIP001 	String* pOpenAs,          /* Puffer fuer die Oeffnunsart
//STRIP001 								 NULL => wird nicht geliefert */
//STRIP001 	String* pDefTempl,         /* Standardvorlagenname */
//STRIP001 	String* pDefURL
//STRIP001 )
//STRIP001 {
//STRIP001 	// Oefnung der Datei
//STRIP001     String aPath;
//STRIP001     if ( ::utl::LocalFileHelper::ConvertURLToPhysicalName( rFile, aPath ) )
//STRIP001     {
//STRIP001         Config aCfg( aPath );
//STRIP001         aCfg.SetGroup( INTERNETSHORTCUT_ID_TAG );
//STRIP001 
//STRIP001         // Einlesung des URLs
//STRIP001         rURL = ReadURL_Impl( aCfg, rFile );
//STRIP001 
//STRIP001         // Einlesung des Ziels, in dem die URL angezeigt werden soll
//STRIP001         if ( pShowAsFolder )
//STRIP001         {
//STRIP001             ByteString aTemp( aCfg.ReadKey( INTERNETSHORTCUT_TARGET_TAG ) );
//STRIP001             *pShowAsFolder = aTemp == INTERNETSHORTCUT_FOLDER_TAG;
//STRIP001         }
//STRIP001 
//STRIP001         // Einlesung und Konvertierung des Zielrahmens
//STRIP001         rFrame = String( aCfg.ReadKey( INTERNETSHORTCUT_FRAME_TAG ), RTL_TEXTENCODING_UTF8 );
//STRIP001 
//STRIP001         String aImgStr = String( aCfg.ReadKey( INTERNETSHORTCUT_SOICON_TAG ), RTL_TEXTENCODING_UTF8 );
//STRIP001         if ( aImgStr.GetToken(0).EqualsAscii( "StarOfficeIcon" ) )
//STRIP001         {
//STRIP001             rImageId = aImgStr.GetToken(1).ToInt32();
//STRIP001         }
//STRIP001 
//STRIP001         // Einlesung des Oeffnungstyps
//STRIP001         if ( pOpenAs )
//STRIP001             *pOpenAs = String( aCfg.ReadKey( INTERNETSHORTCUT_OPENAS_TAG ), RTL_TEXTENCODING_UTF8 );
//STRIP001 
//STRIP001         if ( pDefTempl )
//STRIP001             *pDefTempl = String( aCfg.ReadKey( INTERNETSHORTCUT_DEFTEMPL_TAG ), RTL_TEXTENCODING_UTF8 );
//STRIP001 
//STRIP001         if ( pDefURL )
//STRIP001             *pDefURL = ReadURL_Impl( aCfg, rFile );
//STRIP001 
//STRIP001         // read and convert the title, dependent on the language
//STRIP001     #if SUPD<613//MUSTINI
//STRIP001         String aLangStr = SfxIniManager::Get()->SubstPathVars( String::CreateFromAscii( "$(vlang)" ) );
//STRIP001     #else
//STRIP001         String aLangStr = SvtPathOptions().SubstituteVariable( String::CreateFromAscii( "$(vlang)" ) );
//STRIP001     #endif
//STRIP001         ByteString aLang = U2S( aLangStr );
//STRIP001         ByteString aGroup = INTERNETSHORTCUT_ID_TAG;
//STRIP001         ( ( aGroup += '-' ) += aLang ) += ".W";
//STRIP001         aCfg.SetGroup( aGroup );
//STRIP001         rTitle = String( aCfg.ReadKey( INTERNETSHORTCUT_TITLE_TAG ), RTL_TEXTENCODING_UTF7 );
//STRIP001     }
//STRIP001     else
//STRIP001         DBG_ERROR( "Bookmark is not in the local file system!" );
//STRIP001 }


}
