/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_tabdlg.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:04:12 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#include <limits.h>
#include <stdlib.h>

// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef INCLUDED_SVTOOLS_VIEWOPTIONS_HXX
// auto strip #include <svtools/viewoptions.hxx>
// auto strip #endif
#pragma hdrstop

#define _SVSTDARR_USHORTS
// auto strip #include <svtools/svstdarr.hxx>

// auto strip #include "sfxtypes.hxx"
// auto strip #include "appdata.hxx"
// auto strip #include "minarray.hxx"
// auto strip #include "tabdlg.hxx"
// auto strip #include "viewfrm.hxx"
// auto strip #include "app.hxx"
// auto strip #include "sfxresid.hxx"
// auto strip #include "sfxhelp.hxx"
// auto strip #include "ctrlitem.hxx"
#include "bindings.hxx"

#include "dialog.hrc"
#include "helpid.hrc"
namespace binfilter {

// for OUString and Any
using namespace ::com::sun::star::uno;
using namespace ::rtl;

#define USERITEM_NAME			OUString::createFromAscii( "UserItem" )

/*	-----------------------------------------------------------------
	Verwaltungsdatenstruktur f"ur jede Seite
	----------------------------------------------------------------- */
//STRIP001 struct Data_Impl
//STRIP001 {
//STRIP001 	USHORT nId;					 // Die ID
//STRIP001 	CreateTabPage fnCreatePage;	 // Pointer auf die Factory
//STRIP001 	GetTabPageRanges fnGetRanges;// Pointer auf die Ranges-Funktion
//STRIP001 	SfxTabPage* pTabPage;		 // die TabPage selber
//STRIP001 	BOOL bOnDemand;				 // Flag: ItemSet onDemand
//STRIP001 	BOOL bRefresh; 				 // Flag: Seite mu\s neu initialisiert werden
//STRIP001 
//STRIP001 	// Konstruktor
//STRIP001 	Data_Impl( USHORT Id, CreateTabPage fnPage,
//STRIP001 			   GetTabPageRanges fnRanges, BOOL bDemand ) :
//STRIP001 
//STRIP001 		nId			( Id ),
//STRIP001 		fnCreatePage( fnPage ),
//STRIP001 		fnGetRanges	( fnRanges ),
//STRIP001 		pTabPage	( 0 ),
//STRIP001 		bOnDemand	( bDemand ),
//STRIP001 		bRefresh	( FALSE )
//STRIP001 	{}
//STRIP001 };
//STRIP001 
//STRIP001 TYPEINIT1(SfxTabDialogItem,SfxSetItem);
//STRIP001 
//STRIP001 SfxTabDialogItem::SfxTabDialogItem( const SfxTabDialogItem& rAttr, SfxItemPool* pItemPool )
//STRIP001     : SfxSetItem( rAttr, pItemPool )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 SfxTabDialogItem::SfxTabDialogItem( USHORT nId, const SfxItemSet& rItemSet )
//STRIP001     : SfxSetItem( nId, rItemSet )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 SfxPoolItem* __EXPORT SfxTabDialogItem::Clone(SfxItemPool* pToPool) const
//STRIP001 {
//STRIP001     return new SfxTabDialogItem( *this, pToPool );
//STRIP001 }
//STRIP001 
//STRIP001 SfxPoolItem* __EXPORT SfxTabDialogItem::Create(SvStream& rStream, USHORT nVersion) const
//STRIP001 {
//STRIP001     DBG_ERROR( "Use it only in UI!" );
//STRIP001     return NULL;
//STRIP001 }
//STRIP001 
//STRIP001 class SfxTabDialogController : public SfxControllerItem
//STRIP001 {
//STRIP001     SfxTabDialog*   pDialog;
//STRIP001     const SfxItemSet*     pSet;
//STRIP001 public:
//STRIP001                     SfxTabDialogController( USHORT nId, SfxBindings& rBindings, SfxTabDialog* pDlg )
//STRIP001                         : SfxControllerItem( nId, rBindings )
//STRIP001                         , pDialog( pDlg )
//STRIP001                         , pSet( NULL )
//STRIP001                     {}
//STRIP001 
//STRIP001                     ~SfxTabDialogController();
//STRIP001 
//STRIP001     DECL_LINK(      Execute_Impl, void* );
//STRIP001     virtual void    StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState );
//STRIP001 };
//STRIP001 
//STRIP001 SfxTabDialogController::~SfxTabDialogController()
//STRIP001 {
//STRIP001     delete pSet;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( SfxTabDialogController, Execute_Impl, void*, pVoid )
//STRIP001 {
//STRIP001     if ( pDialog->OK_Impl() && pDialog->Ok() )
//STRIP001     {
//STRIP001         const SfxPoolItem* aItems[2];
//STRIP001         SfxTabDialogItem aItem( GetId(), *pDialog->GetOutputItemSet() );
//STRIP001         aItems[0] = &aItem;
//STRIP001         aItems[1] = NULL;
//STRIP001         GetBindings().Execute( GetId(), aItems );
//STRIP001     }
//STRIP001 
//STRIP001     return 0;
//STRIP001 }
//STRIP001 
//STRIP001 void SfxTabDialogController::StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
//STRIP001 {
//STRIP001     const SfxSetItem* pSetItem = PTR_CAST( SfxSetItem, pState );
//STRIP001     if ( pSetItem )
//STRIP001     {
//STRIP001         pSet = pDialog->pSet = pSetItem->GetItemSet().Clone();
//STRIP001         BOOL bDialogStarted = FALSE;
//STRIP001         for ( USHORT n=0; n<pDialog->aTabCtrl.GetPageCount(); n++ )
//STRIP001         {
//STRIP001             USHORT nId = pDialog->aTabCtrl.GetPageId( n );
//STRIP001             SfxTabPage* pTabPage = (SfxTabPage*) pDialog->aTabCtrl.GetTabPage( nId );
//STRIP001             if ( pTabPage )
//STRIP001             {
//STRIP001                 pTabPage->Reset( pSetItem->GetItemSet() );
//STRIP001                 bDialogStarted = TRUE;
//STRIP001             }
//STRIP001         }
//STRIP001 
//STRIP001         if ( bDialogStarted )
//STRIP001             pDialog->Show();
//STRIP001     }
//STRIP001     else
//STRIP001         pDialog->Hide();
//STRIP001 }
//STRIP001 
//STRIP001 DECL_PTRARRAY(SfxTabDlgData_Impl, Data_Impl *, 4,4)
//STRIP001 
//STRIP001 struct TabDlg_Impl
//STRIP001 {
//STRIP001 	BOOL				bModified		: 1,
//STRIP001 						bModal			: 1,
//STRIP001 						bInOK			: 1,
//STRIP001 						bHideResetBtn	: 1;
//STRIP001 	SfxTabDlgData_Impl*	pData;
//STRIP001 
//STRIP001 	PushButton*			pApplyButton;
//STRIP001     SfxTabDialogController* pController;
//STRIP001 
//STRIP001 	TabDlg_Impl( BYTE nCnt ) :
//STRIP001 
//STRIP001 		bModified		( FALSE ),
//STRIP001 		bModal			( TRUE ),
//STRIP001 		bInOK			( FALSE ),
//STRIP001 		bHideResetBtn	( FALSE ),
//STRIP001 		pData			( new SfxTabDlgData_Impl( nCnt ) ),
//STRIP001         pApplyButton    ( NULL ),
//STRIP001         pController     ( NULL )
//STRIP001 	{}
//STRIP001 };
//STRIP001 
//STRIP001 struct TabPageImpl
//STRIP001 {
//STRIP001 	BOOL	_bStandard;
//STRIP001 
//STRIP001 	TabPageImpl() : _bStandard( FALSE ) {}
//STRIP001 };
//STRIP001 
//STRIP001 /*	-----------------------------------------------------------------
//STRIP001 	Hilfsfunktion: Finden einer Page anhand seiner Id
//STRIP001 	----------------------------------------------------------------- */
//STRIP001 Data_Impl* Find( SfxTabDlgData_Impl& rArr, USHORT nId, USHORT* pPos = 0 );
//STRIP001 
//STRIP001 Data_Impl* Find( SfxTabDlgData_Impl& rArr, USHORT nId, USHORT* pPos )
//STRIP001 {
//STRIP001 	const USHORT nCount = rArr.Count();
//STRIP001 
//STRIP001 	for ( USHORT i = 0; i < nCount; ++i )
//STRIP001 	{
//STRIP001 		Data_Impl* pObj = rArr[i];
//STRIP001 
//STRIP001 		if ( pObj->nId == nId )
//STRIP001 		{
//STRIP001 			if ( pPos )
//STRIP001 				*pPos = i;
//STRIP001 			return pObj;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // class SfxTabPage-------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage::SfxTabPage( Window *pParent,
//STRIP001 						const ResId &rResId, const SfxItemSet &rAttrSet ) :
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Konstruktor
//STRIP001 */
//STRIP001 
//STRIP001 	TabPage( pParent, rResId ),
//STRIP001 
//STRIP001 	pSet				( &rAttrSet ),
//STRIP001 	bHasExchangeSupport	( FALSE ),
//STRIP001 	pTabDlg				( NULL ),
//STRIP001 	pImpl				( new TabPageImpl )
//STRIP001 
//STRIP001 {
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 SfxTabPage:: SfxTabPage( Window *pParent, WinBits nStyle, const SfxItemSet &rAttrSet ) :
//STRIP001 	TabPage(pParent, nStyle),
//STRIP001 	pSet				( &rAttrSet ),
//STRIP001 	bHasExchangeSupport	( FALSE ),
//STRIP001 	pTabDlg				( NULL ),
//STRIP001 	pImpl				( new TabPageImpl )
//STRIP001 {
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage::~SfxTabPage()
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Destruktor
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	delete pImpl;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxTabPage::ActivatePage( const SfxItemSet& )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Defaultimplementierung der virtuellen ActivatePage-Methode
//STRIP001 	Diese wird gerufen, wenn eine Seite des Dialogs den Datenaustausch
//STRIP001 	zwischen Pages unterst"utzt.
//STRIP001 
//STRIP001 	<SfxTabPage::DeactivatePage(SfxItemSet *)>
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 int SfxTabPage::DeactivatePage( SfxItemSet* )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Defaultimplementierung der virtuellen DeactivatePage-Methode
//STRIP001 	Diese wird vor dem Verlassen einer Seite durch den Sfx gerufen;
//STRIP001 	die Anwendung kann "uber den Returnwert steuern,
//STRIP001 	ob die Seite verlassen werden soll.
//STRIP001 	Falls die Seite "uber bHasExchangeSupport
//STRIP001 	anzeigt, da\s sie einen Datenaustausch zwischen Seiten
//STRIP001 	unterst"utzt, wird ein Pointer auf das Austausch-Set als
//STRIP001 	Parameter "ubergeben. Dieser nimmt die Daten f"ur den Austausch
//STRIP001 	entgegen; das Set steht anschlie\send als Parameter in
//STRIP001 	<SfxTabPage::ActivatePage(const SfxItemSet &)> zur Verf"ugung.
//STRIP001 
//STRIP001 	[R"uckgabewert]
//STRIP001 
//STRIP001 	LEAVE_PAGE; Verlassen der Seite erlauben
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	return LEAVE_PAGE;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxTabPage::FillUserData()
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001    virtuelle Methode, wird von der Basisklasse im Destruktor gerufen
//STRIP001    um spezielle Informationen der TabPage in der Ini-Datei zu speichern.
//STRIP001    Beim "Uberladen muss ein String zusammengestellt werden, der mit
//STRIP001    <SetUserData()> dann weggeschrieben wird.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SfxTabPage::IsReadOnly() const
//STRIP001 
//STRIP001 /*  [Description]
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 const SfxPoolItem* SfxTabPage::GetItem( const SfxItemSet& rSet, USHORT nSlot )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	static Methode: hiermit wird der Code der TabPage-Implementierungen
//STRIP001 	vereinfacht.
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	const SfxItemPool* pPool = rSet.GetPool();
//STRIP001 	USHORT nWh = pPool->GetWhich( nSlot );
//STRIP001 	const SfxPoolItem* pItem = 0;
//STRIP001 	SfxItemState eState = rSet.GetItemState( nWh, TRUE, &pItem );
//STRIP001 
//STRIP001 	if ( !pItem && nWh != nSlot )
//STRIP001 		pItem = &pPool->GetDefaultItem( nWh );
//STRIP001 	return pItem;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 const SfxPoolItem* SfxTabPage::GetOldItem( const SfxItemSet& rSet,
//STRIP001 										   USHORT nSlot )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Diese Methode gibt f"ur Vergleiche den alten Wert eines
//STRIP001 	Attributs zur"uck.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	const SfxItemSet& rOldSet = GetItemSet();
//STRIP001 	USHORT nWh = GetWhich( nSlot );
//STRIP001 	const SfxPoolItem* pItem = 0;
//STRIP001 
//STRIP001 	if ( pImpl->_bStandard && rOldSet.GetParent() )
//STRIP001 		pItem = GetItem( *rOldSet.GetParent(), nSlot );
//STRIP001 	else if ( rSet.GetParent() &&
//STRIP001 			  SFX_ITEM_DONTCARE == rSet.GetItemState( nWh ) )
//STRIP001 		pItem = GetItem( *rSet.GetParent(), nSlot );
//STRIP001 	else
//STRIP001 		pItem = GetItem( rOldSet, nSlot );
//STRIP001 	return pItem;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 const SfxPoolItem* SfxTabPage::GetExchangeItem( const SfxItemSet& rSet,
//STRIP001 												USHORT nSlot )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Diese Methode gibt f"ur Vergleiche den alten Wert eines
//STRIP001 	Attributs zur"uck. Dabei wird ber"ucksichtigt, ob der Dialog
//STRIP001 	gerade mit OK beendet wurde.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	if ( pTabDlg && !pTabDlg->IsInOK() && pTabDlg->GetExampleSet() )
//STRIP001 		return GetItem( *pTabDlg->GetExampleSet(), nSlot );
//STRIP001 	else
//STRIP001 		return GetOldItem( rSet, nSlot );
//STRIP001 }
//STRIP001 
//STRIP001 // class SfxTabDialog ----------------------------------------------------
//STRIP001 
//STRIP001 #define INI_LIST(ItemSetPtr) \
//STRIP001 	aTabCtrl	( this, ResId(ID_TABCONTROL ) ),\
//STRIP001 	aOKBtn		( this ),\
//STRIP001 	pUserBtn	( pUserButtonText? new PushButton(this): 0 ),\
//STRIP001 	aCancelBtn	( this ),\
//STRIP001 	aHelpBtn	( this ),\
//STRIP001 	aResetBtn	( this ),\
//STRIP001 	aBaseFmtBtn	( this ),\
//STRIP001     pSet        ( ItemSetPtr ),\
//STRIP001 	pOutSet		( 0 ),\
//STRIP001 	pExampleSet	( 0 ),\
//STRIP001 	pRanges		( 0 ),\
//STRIP001 	bItemsReset	( FALSE ),\
//STRIP001 	bFmt		( bEditFmt ),\
//STRIP001 	nResId		( rResId.GetId() ), \
//STRIP001 	nAppPageId	( USHRT_MAX ), \
//STRIP001 	pImpl		( new TabDlg_Impl( (BYTE)aTabCtrl.GetPageCount() ) )
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabDialog::SfxTabDialog
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Konstruktor
//STRIP001 */
//STRIP001 
//STRIP001 (
//STRIP001 	SfxViewFrame* pViewFrame,		// Frame, zu dem der Dialog geh"ort
//STRIP001 	Window* pParent,				// Parent-Fenster
//STRIP001 	const ResId& rResId, 			// ResourceId
//STRIP001 	const SfxItemSet* pItemSet,		// Itemset mit den Daten;
//STRIP001 									// kann NULL sein, wenn Pages onDemand
//STRIP001 	BOOL bEditFmt,		// Flag: es werden Vorlagen bearbeitet
//STRIP001 						// wenn ja -> zus"atzlicher Button f"ur Standard
//STRIP001 	const String* pUserButtonText 	// Text fuer BenutzerButton;
//STRIP001 									// wenn != 0, wird der UserButton erzeugt
//STRIP001 ) :
//STRIP001 	TabDialog( pParent, rResId ),
//STRIP001     INI_LIST(pItemSet),
//STRIP001 	pFrame( pViewFrame )
//STRIP001 {
//STRIP001 	Init_Impl( bFmt, pUserButtonText );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabDialog::SfxTabDialog
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Konstruktor, tempor"ar ohne Frame
//STRIP001 */
//STRIP001 
//STRIP001 (
//STRIP001 	Window* pParent,				// Parent-Fenster
//STRIP001 	const ResId& rResId, 			// ResourceId
//STRIP001 	const SfxItemSet* pItemSet,		// Itemset mit den Daten; kann NULL sein,
//STRIP001 									// wenn Pages onDemand
//STRIP001 	BOOL bEditFmt,		// Flag: es werden Vorlagen bearbeitet
//STRIP001 						// wenn ja -> zus"atzlicher Button f"ur Standard
//STRIP001 	const String* pUserButtonText 	// Text f"ur BenutzerButton;
//STRIP001 									// wenn != 0, wird der UserButton erzeugt
//STRIP001 ) :
//STRIP001 	TabDialog( pParent, rResId ),
//STRIP001     INI_LIST(pItemSet),
//STRIP001 	pFrame( 0 )
//STRIP001 {
//STRIP001 	Init_Impl( bFmt, pUserButtonText );
//STRIP001 	DBG_WARNING( "bitte den Ctor mit ViewFrame verwenden" );
//STRIP001 }
//STRIP001 
//STRIP001 SfxTabDialog::SfxTabDialog
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Konstruktor, tempor"ar ohne Frame
//STRIP001 */
//STRIP001 
//STRIP001 (
//STRIP001 	Window* pParent,				// Parent-Fenster
//STRIP001 	const ResId& rResId, 			// ResourceId
//STRIP001     USHORT nSetId,
//STRIP001     SfxBindings& rBindings,
//STRIP001 	BOOL bEditFmt,		// Flag: es werden Vorlagen bearbeitet
//STRIP001 						// wenn ja -> zus"atzlicher Button f"ur Standard
//STRIP001 	const String* pUserButtonText 	// Text f"ur BenutzerButton;
//STRIP001 									// wenn != 0, wird der UserButton erzeugt
//STRIP001 ) :
//STRIP001 	TabDialog( pParent, rResId ),
//STRIP001     INI_LIST(NULL),
//STRIP001 	pFrame( 0 )
//STRIP001 {
//STRIP001     rBindings.ENTERREGISTRATIONS();
//STRIP001     pImpl->pController = new SfxTabDialogController( nSetId, rBindings, this );
//STRIP001     rBindings.LEAVEREGISTRATIONS();
//STRIP001 
//STRIP001     EnableApplyButton( TRUE );
//STRIP001     SetApplyHandler( LINK( pImpl->pController, SfxTabDialogController, Execute_Impl ) );
//STRIP001 
//STRIP001     rBindings.Invalidate( nSetId );
//STRIP001     rBindings.Update( nSetId );
//STRIP001     DBG_ASSERT( pSet, "No ItemSet!" );
//STRIP001 
//STRIP001 	Init_Impl( bFmt, pUserButtonText );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabDialog::~SfxTabDialog()
//STRIP001 {
//STRIP001 	// save settings (screen position and current page)
//STRIP001 	SvtViewOptions aDlgOpt( E_TABDIALOG, String::CreateFromInt32( nResId ) );
//STRIP001 	aDlgOpt.SetWindowState( OUString::createFromAscii( GetWindowState( WINDOWSTATE_MASK_POS ).GetBuffer() ) );
//STRIP001 	aDlgOpt.SetPageID( aTabCtrl.GetCurPageId() );
//STRIP001 
//STRIP001 	const USHORT nCount = pImpl->pData->Count();
//STRIP001 	for ( USHORT i = 0; i < nCount; ++i )
//STRIP001 	{
//STRIP001 		Data_Impl* pDataObject = pImpl->pData->GetObject(i);
//STRIP001 
//STRIP001 		if ( pDataObject->pTabPage )
//STRIP001 		{
//STRIP001 			// save settings of all pages (user data)
//STRIP001 			pDataObject->pTabPage->FillUserData();
//STRIP001 			String aPageData( pDataObject->pTabPage->GetUserData() );
//STRIP001 			if ( aPageData.Len() )
//STRIP001 			{
//STRIP001 				// save settings of all pages (user data)
//STRIP001 				SvtViewOptions aPageOpt( E_TABPAGE, String::CreateFromInt32( pDataObject->nId ) );
//STRIP001 				aPageOpt.SetUserItem( USERITEM_NAME, makeAny( OUString( aPageData ) ) );
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( pDataObject->bOnDemand )
//STRIP001 				delete (SfxItemSet*)&pDataObject->pTabPage->GetItemSet();
//STRIP001 			delete pDataObject->pTabPage;
//STRIP001 		}
//STRIP001 		delete pDataObject;
//STRIP001 	}
//STRIP001 
//STRIP001     delete pImpl->pController;
//STRIP001 	delete pImpl->pApplyButton;
//STRIP001 	delete pImpl->pData;
//STRIP001 	delete pImpl;
//STRIP001 	delete pUserBtn;
//STRIP001 	delete pOutSet;
//STRIP001 	delete pExampleSet;
//STRIP001 	delete [] pRanges;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxTabDialog::Init_Impl( BOOL bFmt, const String* pUserButtonText )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	interne Initialisierung des Dialogs
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	aOKBtn.SetClickHdl( LINK( this, SfxTabDialog, OkHdl ) );
//STRIP001 	aResetBtn.SetClickHdl( LINK( this, SfxTabDialog, ResetHdl ) );
//STRIP001 	aResetBtn.SetText( String( SfxResId( STR_RESET ) ) );
//STRIP001 	aTabCtrl.SetActivatePageHdl(
//STRIP001 			LINK( this, SfxTabDialog, ActivatePageHdl ) );
//STRIP001 	aTabCtrl.SetDeactivatePageHdl(
//STRIP001 			LINK( this, SfxTabDialog, DeactivatePageHdl ) );
//STRIP001 	aTabCtrl.Show();
//STRIP001 	aOKBtn.Show();
//STRIP001 	aCancelBtn.Show();
//STRIP001 	aHelpBtn.Show();
//STRIP001 	aResetBtn.Show();
//STRIP001 	aResetBtn.SetHelpId( HID_TABDLG_RESET_BTN );
//STRIP001 
//STRIP001 	if ( pUserBtn )
//STRIP001 	{
//STRIP001 		pUserBtn->SetText( *pUserButtonText );
//STRIP001 		pUserBtn->SetClickHdl( LINK( this, SfxTabDialog, UserHdl ) );
//STRIP001 		pUserBtn->Show();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bFmt )
//STRIP001 	{
//STRIP001         String aStd( SfxResId( STR_STANDARD_SHORTCUT ) );
//STRIP001 		aBaseFmtBtn.SetText( aStd );
//STRIP001 		aBaseFmtBtn.SetClickHdl( LINK( this, SfxTabDialog, BaseFmtHdl ) );
//STRIP001 		aBaseFmtBtn.SetHelpId( HID_TABDLG_STANDARD_BTN );
//STRIP001 
//STRIP001 		// bFmt = tempor"ares Flag im Ctor() "ubergeben,
//STRIP001 		// wenn bFmt == 2, dann auch TRUE,
//STRIP001 		// zus"atzlich Ausblendung vom StandardButton,
//STRIP001 		// nach der Initialisierung wieder auf TRUE setzen
//STRIP001 		if ( bFmt != 2 )
//STRIP001 			aBaseFmtBtn.Show();
//STRIP001 		else
//STRIP001 			bFmt = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pSet )
//STRIP001 	{
//STRIP001 		pExampleSet = new SfxItemSet( *pSet );
//STRIP001 		pOutSet = new SfxItemSet( *pSet->GetPool(), pSet->GetRanges() );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxTabDialog::RemoveResetButton()
//STRIP001 {
//STRIP001 	aResetBtn.Hide();
//STRIP001 	pImpl->bHideResetBtn = TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 short SfxTabDialog::Execute()
//STRIP001 {
//STRIP001 	if ( !aTabCtrl.GetPageCount() )
//STRIP001 		return RET_CANCEL;
//STRIP001 	Start_Impl();
//STRIP001 	return TabDialog::Execute();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxTabDialog::Start( BOOL bShow )
//STRIP001 {
//STRIP001 	aCancelBtn.SetClickHdl( LINK( this, SfxTabDialog, CancelHdl ) );
//STRIP001 	pImpl->bModal = FALSE;
//STRIP001 	Start_Impl();
//STRIP001 
//STRIP001 	if ( bShow )
//STRIP001 		Show();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxTabDialog::SetApplyHandler(const Link& _rHdl)
//STRIP001 {
//STRIP001 	DBG_ASSERT( pImpl->pApplyButton, "SfxTabDialog::GetApplyHandler: no apply button enabled!" );
//STRIP001 	if ( pImpl->pApplyButton )
//STRIP001 		pImpl->pApplyButton->SetClickHdl( _rHdl );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 Link SfxTabDialog::GetApplyHandler() const
//STRIP001 {
//STRIP001 	DBG_ASSERT( pImpl->pApplyButton, "SfxTabDialog::GetApplyHandler: no button enabled!" );
//STRIP001 	if ( !pImpl->pApplyButton )
//STRIP001 		return Link();
//STRIP001 
//STRIP001 	return pImpl->pApplyButton->GetClickHdl();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxTabDialog::EnableApplyButton(BOOL bEnable)
//STRIP001 {
//STRIP001 	if ( IsApplyButtonEnabled() == bEnable )
//STRIP001 		// nothing to do
//STRIP001 		return;
//STRIP001 
//STRIP001 	// create or remove the apply button
//STRIP001 	if ( bEnable )
//STRIP001 	{
//STRIP001 		pImpl->pApplyButton = new PushButton( this );
//STRIP001 		// in the z-order, the apply button should be behind the ok button, thus appearing at the right side of it
//STRIP001 		pImpl->pApplyButton->SetZOrder(&aOKBtn, WINDOW_ZORDER_BEHIND);
//STRIP001 
//STRIP001 		pImpl->pApplyButton->SetText( String( SfxResId( STR_APPLY ) ) );
//STRIP001 		pImpl->pApplyButton->Show();
//STRIP001 
//STRIP001 		pImpl->pApplyButton->SetHelpId( HID_TABDLG_APPLY_BTN );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		delete pImpl->pApplyButton;
//STRIP001 		pImpl->pApplyButton = NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	// adjust the layout
//STRIP001 	if (IsReallyShown())
//STRIP001 		AdjustLayout();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SfxTabDialog::IsApplyButtonEnabled() const
//STRIP001 {
//STRIP001 	return ( NULL != pImpl->pApplyButton );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 const PushButton* SfxTabDialog::GetApplyButton() const
//STRIP001 {
//STRIP001 	return pImpl->pApplyButton;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 PushButton* SfxTabDialog::GetApplyButton()
//STRIP001 {
//STRIP001 	return pImpl->pApplyButton;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxTabDialog::Start_Impl()
//STRIP001 {
//STRIP001 	DBG_ASSERT( pImpl->pData->Count() == aTabCtrl.GetPageCount(), "not all pages registered" );
//STRIP001 	Point aPos;
//STRIP001 	USHORT nActPage = aTabCtrl.GetPageId( 0 );
//STRIP001 
//STRIP001 	// load old settings, when exists
//STRIP001 	SvtViewOptions aDlgOpt( E_TABDIALOG, String::CreateFromInt32( nResId ) );
//STRIP001 	if ( aDlgOpt.Exists() )
//STRIP001 	{
//STRIP001 		SetWindowState( ByteString( aDlgOpt.GetWindowState().getStr(), RTL_TEXTENCODING_ASCII_US ) );
//STRIP001 
//STRIP001 		// initiale TabPage aus Programm/Hilfe/Konfig
//STRIP001 		nActPage = (USHORT)aDlgOpt.GetPageID();
//STRIP001 
//STRIP001 		if ( USHRT_MAX != nAppPageId )
//STRIP001 			nActPage = nAppPageId;
//STRIP001 		else
//STRIP001 		{
//STRIP001 			USHORT nAutoTabPageId = SFX_APP()->Get_Impl()->nAutoTabPageId;
//STRIP001 			if ( nAutoTabPageId )
//STRIP001 				nActPage = nAutoTabPageId;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( TAB_PAGE_NOTFOUND == aTabCtrl.GetPagePos( nActPage ) )
//STRIP001 			nActPage = aTabCtrl.GetPageId( 0 );
//STRIP001 	}
//STRIP001 	else if ( USHRT_MAX != nAppPageId && TAB_PAGE_NOTFOUND != aTabCtrl.GetPagePos( nAppPageId ) )
//STRIP001 		nActPage = nAppPageId;
//STRIP001 
//STRIP001 	aTabCtrl.SetCurPageId( nActPage );
//STRIP001 	ActivatePageHdl( &aTabCtrl );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxTabDialog::AddTabPage
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Hinzuf"ugen einer Seite zu dem Dialog.
//STRIP001 	Mu\s korrespondieren zu einem entsprechende Eintrag im
//STRIP001 	TabControl in der Resource des Dialogs.
//STRIP001 */
//STRIP001 
//STRIP001 (
//STRIP001 	USHORT nId,						// ID der Seite
//STRIP001 	CreateTabPage pCreateFunc,		// Pointer auf die Factory-Methode
//STRIP001 	GetTabPageRanges pRangesFunc, 	// Pointer auf die Methode f"ur das
//STRIP001 									// Erfragen der Ranges onDemand
//STRIP001 	BOOL bItemsOnDemand				// gibt an, ob das Set dieser Seite beim
//STRIP001 									// Erzeugen der Seite erfragt wird
//STRIP001 )
//STRIP001 {
//STRIP001 	pImpl->pData->Append(
//STRIP001 		new Data_Impl( nId, pCreateFunc, pRangesFunc, bItemsOnDemand ) );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxTabDialog::AddTabPage
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Hinzuf"ugen einer Seite zu dem Dialog.
//STRIP001 	Der Ridertext wird "ubergeben, die Seite hat keine Entsprechung im
//STRIP001 	TabControl in der Resource des Dialogs.
//STRIP001 */
//STRIP001 
//STRIP001 (
//STRIP001 	USHORT nId,
//STRIP001 	const String& rRiderText,
//STRIP001 	CreateTabPage pCreateFunc,
//STRIP001 	GetTabPageRanges pRangesFunc,
//STRIP001 	BOOL bItemsOnDemand,
//STRIP001 	USHORT nPos
//STRIP001 )
//STRIP001 {
//STRIP001 	DBG_ASSERT( TAB_PAGE_NOTFOUND == aTabCtrl.GetPagePos( nId ),
//STRIP001 				"Doppelte Page-Ids in der Tabpage" );
//STRIP001 	aTabCtrl.InsertPage( nId, rRiderText, nPos );
//STRIP001 	pImpl->pData->Append(
//STRIP001 		new Data_Impl( nId, pCreateFunc, pRangesFunc, bItemsOnDemand ) );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 #ifdef SV_HAS_RIDERBITMAPS
//STRIP001 
//STRIP001 void SfxTabDialog::AddTabPage
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Hinzuf"ugen einer Seite zu dem Dialog.
//STRIP001 	Die Riderbitmap wird "ubergeben, die Seite hat keine Entsprechung im
//STRIP001 	TabControl in der Resource des Dialogs.
//STRIP001 */
//STRIP001 
//STRIP001 (
//STRIP001 	USHORT nId,
//STRIP001 	const Bitmap &rRiderBitmap,
//STRIP001 	CreateTabPage pCreateFunc,
//STRIP001 	GetTabPageRanges pRangesFunc,
//STRIP001 	BOOL bItemsOnDemand,
//STRIP001 	USHORT nPos
//STRIP001 )
//STRIP001 {
//STRIP001 	DBG_ASSERT(	TAB_PAGE_NOTFOUND == aTabCtrl.GetPagePos( nId ),
//STRIP001 				"Doppelte Page-Ids in der Tabpage" );
//STRIP001 	aTabCtrl.InsertPage( nId, rRiderBitmap, nPos );
//STRIP001 	pImpl->pData->Append(
//STRIP001 		new Data_Impl( nId, pCreateFunc, pRangesFunc, bItemsOnDemand ) );
//STRIP001 }
//STRIP001 #endif
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxTabDialog::RemoveTabPage( USHORT nId )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	L"oschen der TabPage mit der ID nId
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	USHORT nPos = 0;
//STRIP001 	aTabCtrl.RemovePage( nId );
//STRIP001 	Data_Impl* pDataObject = Find( *pImpl->pData, nId, &nPos );
//STRIP001 
//STRIP001 	if ( pDataObject )
//STRIP001 	{
//STRIP001 		if ( pDataObject->pTabPage )
//STRIP001 		{
//STRIP001 			pDataObject->pTabPage->FillUserData();
//STRIP001 			String aPageData( pDataObject->pTabPage->GetUserData() );
//STRIP001 			if ( aPageData.Len() )
//STRIP001 			{
//STRIP001 				// save settings of this page (user data)
//STRIP001 				SvtViewOptions aPageOpt( E_TABPAGE, String::CreateFromInt32( pDataObject->nId ) );
//STRIP001 				aPageOpt.SetUserItem( USERITEM_NAME, makeAny( OUString( aPageData ) ) );
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( pDataObject->bOnDemand )
//STRIP001 				delete (SfxItemSet*)&pDataObject->pTabPage->GetItemSet();
//STRIP001 			delete pDataObject->pTabPage;
//STRIP001 		}
//STRIP001 
//STRIP001 		delete pDataObject;
//STRIP001 		pImpl->pData->Remove( nPos );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		DBG_WARNINGFILE( "TabPage-Id nicht bekannt" );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxTabDialog::PageCreated
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Defaultimplemetierung der virtuellen Methode.
//STRIP001 	Diese wird unmittelbar nach dem Erzeugen einer Seite gerufen.
//STRIP001 	Hier kann der Dialog direkt an der TabPage Methoden rufen.
//STRIP001 */
//STRIP001 
//STRIP001 (
//STRIP001 	USHORT,			// Id der erzeugten Seite
//STRIP001 	SfxTabPage&		// Referenz auf die erzeugte Seite
//STRIP001 )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxItemSet* SfxTabDialog::GetInputSetImpl()
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Abgeleitete Klassen legen ggf. fuer den InputSet neuen Speicher an.
//STRIP001 	Dieser mu\s im Destruktor auch wieder freigegeben werden. Dazu mu\s
//STRIP001 	diese Methode gerufen werden.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	return (SfxItemSet*)pSet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* SfxTabDialog::GetTabPage( USHORT nPageId ) const
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	TabPage mit der "Ubergebenen Id zur"uckgeben.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	USHORT nPos = 0;
//STRIP001 	Data_Impl* pDataObject = Find( *pImpl->pData, nPageId, &nPos );
//STRIP001 
//STRIP001 	if ( pDataObject )
//STRIP001 		return pDataObject->pTabPage;
//STRIP001 	return NULL;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SfxTabDialog::IsInOK() const
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	return pImpl->bInOK;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 short SfxTabDialog::Ok()
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Ok-Handler des Dialogs
//STRIP001 	Das OutputSet wird erstellt und jede Seite wird mit
//STRIP001 	dem bzw. ihrem speziellen OutputSet durch Aufruf der Methode
//STRIP001 	<SfxTabPage::FillItemSet(SfxItemSet &)> dazu aufgefordert,
//STRIP001 	die vom Benuzter eingestellten Daten in das Set zu tun.
//STRIP001 
//STRIP001 	[R"uckgabewert]
//STRIP001 
//STRIP001 	RET_OK:	wenn mindestens eine Seite TRUE als Returnwert von
//STRIP001 			FillItemSet geliefert hat, sonst RET_CANCEL.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	pImpl->bInOK = TRUE;
//STRIP001 
//STRIP001 	if ( !pOutSet )
//STRIP001 	{
//STRIP001 		if ( !pExampleSet && pSet )
//STRIP001 			pOutSet = pSet->Clone( FALSE );	// ohne Items
//STRIP001 		else if ( pExampleSet )
//STRIP001 			pOutSet = new SfxItemSet( *pExampleSet );
//STRIP001 	}
//STRIP001 	BOOL bModified = FALSE;
//STRIP001 
//STRIP001 	const USHORT nCount = pImpl->pData->Count();
//STRIP001 
//STRIP001 	for ( USHORT i = 0; i < nCount; ++i )
//STRIP001 	{
//STRIP001 		Data_Impl* pDataObject = pImpl->pData->GetObject(i);
//STRIP001 		SfxTabPage* pTabPage = pDataObject->pTabPage;
//STRIP001 
//STRIP001 		if ( pTabPage )
//STRIP001 		{
//STRIP001 			if ( pDataObject->bOnDemand )
//STRIP001 			{
//STRIP001 				SfxItemSet& rSet = (SfxItemSet&)pTabPage->GetItemSet();
//STRIP001 				rSet.ClearItem();
//STRIP001 				bModified |= pTabPage->FillItemSet( rSet );
//STRIP001 			}
//STRIP001 			else if ( pSet && !pTabPage->HasExchangeSupport() )
//STRIP001 			{
//STRIP001 				SfxItemSet aTmp( *pSet->GetPool(), pSet->GetRanges() );
//STRIP001 
//STRIP001 				if ( pTabPage->FillItemSet( aTmp ) )
//STRIP001 				{
//STRIP001 					bModified |= TRUE;
//STRIP001 					pExampleSet->Put( aTmp );
//STRIP001 					pOutSet->Put( aTmp );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pImpl->bModified || ( pOutSet && pOutSet->Count() > 0 ) )
//STRIP001 		bModified |= TRUE;
//STRIP001 
//STRIP001 	if ( bFmt == 2 )
//STRIP001 		bModified |= TRUE;
//STRIP001 	return bModified ? RET_OK : RET_CANCEL;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxTabDialog, CancelHdl, Button*, pButton )
//STRIP001 {
//STRIP001 	Close();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxItemSet* SfxTabDialog::CreateInputItemSet( USHORT )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Defaultimplemetierung der virtuellen Methode.
//STRIP001 	Diese wird gerufen, wenn Pages ihre Sets onDenamd anlegen
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	DBG_WARNINGFILE( "CreateInputItemSet nicht implementiert" );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 const SfxItemSet* SfxTabDialog::GetRefreshedSet()
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Defaultimplemetierung der virtuellen Methode.
//STRIP001 	Diese wird gerufen, wenn <SfxTabPage::DeactivatePage(SfxItemSet *)>
//STRIP001 	<SfxTabPage::REFRESH_SET> liefert.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	DBG_ERRORFILE( "GetRefreshedSet nicht implementiert" );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxTabDialog, OkHdl, Button *, EMPTYARG )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Handler des Ok-Buttons
//STRIP001 	Dieser ruft f"ur die aktuelle Seite
//STRIP001 	<SfxTabPage::DeactivatePage(SfxItemSet *)>.
//STRIP001 	Liefert diese <SfxTabPage::LEAVE_PAGE>, wird <SfxTabDialog::Ok()> gerufen
//STRIP001 	und so der Dialog beendet.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	pImpl->bInOK = TRUE;
//STRIP001 
//STRIP001 	if ( OK_Impl() )
//STRIP001 	{
//STRIP001 		if ( pImpl->bModal )
//STRIP001 			EndDialog( Ok() );
//STRIP001 		else
//STRIP001 		{
//STRIP001 			Ok();
//STRIP001 			Close();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SfxTabDialog::PrepareLeaveCurrentPage()
//STRIP001 {
//STRIP001 	SfxTabPage* pPage =
//STRIP001 		(SfxTabPage*)aTabCtrl.GetTabPage( aTabCtrl.GetCurPageId() );
//STRIP001 
//STRIP001 	BOOL bEnd = !pPage;
//STRIP001 	if ( pPage )
//STRIP001 	{
//STRIP001 		int nRet = SfxTabPage::LEAVE_PAGE;
//STRIP001 		if ( pSet )
//STRIP001 		{
//STRIP001 			SfxItemSet aTmp( *pSet->GetPool(), pSet->GetRanges() );
//STRIP001 			BOOL bRet = FALSE;
//STRIP001 
//STRIP001 			if ( pPage->HasExchangeSupport() )
//STRIP001 				nRet = pPage->DeactivatePage( &aTmp );
//STRIP001 			else
//STRIP001 				nRet = pPage->DeactivatePage( NULL );
//STRIP001 
//STRIP001 			if ( ( SfxTabPage::LEAVE_PAGE & nRet ) == SfxTabPage::LEAVE_PAGE
//STRIP001 				 && aTmp.Count() )
//STRIP001 			{
//STRIP001 				pExampleSet->Put( aTmp );
//STRIP001 				pOutSet->Put( aTmp );
//STRIP001 			}
//STRIP001 			else if ( bRet )
//STRIP001 				pImpl->bModified |= TRUE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			nRet = pPage->DeactivatePage( NULL );
//STRIP001 		bEnd = nRet;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bEnd;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxTabDialog, UserHdl, Button *, EMPTYARG )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Handler des User-Buttons
//STRIP001 	Dieser ruft f"ur die aktuelle Seite
//STRIP001 	<SfxTabPage::DeactivatePage(SfxItemSet *)>.
//STRIP001 	Liefert diese <SfxTabPage::LEAVE_PAGE>, wird <SfxTabDialog::Ok()> gerufen.
//STRIP001 	Mit dem Return-Wert von <SfxTabDialog::Ok()> wird dann der Dialog beendet.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	SfxTabPage* pPage =
//STRIP001 		(SfxTabPage *)aTabCtrl.GetTabPage( aTabCtrl.GetCurPageId() );
//STRIP001 
//STRIP001 	FASTBOOL bEnd = !pPage;
//STRIP001 
//STRIP001 	if ( pPage )
//STRIP001 	{
//STRIP001 		int nRet = SfxTabPage::LEAVE_PAGE;
//STRIP001 
//STRIP001 		if ( pSet )
//STRIP001 		{
//STRIP001 			SfxItemSet aTmp( *pSet->GetPool(), pSet->GetRanges() );
//STRIP001 
//STRIP001 			if ( pPage->HasExchangeSupport() )
//STRIP001 				nRet = pPage->DeactivatePage( &aTmp );
//STRIP001 			else
//STRIP001 				nRet = pPage->DeactivatePage( NULL );
//STRIP001 
//STRIP001 			if ( ( SfxTabPage::LEAVE_PAGE & nRet ) == SfxTabPage::LEAVE_PAGE
//STRIP001 				 && aTmp.Count() )
//STRIP001 			{
//STRIP001 				pExampleSet->Put( aTmp );
//STRIP001 				pOutSet->Put( aTmp );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 			nRet = pPage->DeactivatePage( NULL );
//STRIP001 		bEnd = nRet;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bEnd )
//STRIP001 	{
//STRIP001 		short nRet = Ok();
//STRIP001 
//STRIP001 		if ( RET_OK == nRet )
//STRIP001 			nRet = RET_USER;
//STRIP001 		else
//STRIP001 			nRet = RET_USER_CANCEL;
//STRIP001 		EndDialog( nRet );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxTabDialog, ResetHdl, Button *, EMPTYARG )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Handler hinter dem Zur"ucksetzen-Button.
//STRIP001 	Die aktuelle Page wird mit ihren initialen Daten
//STRIP001 	neu initialisiert; alle Einstellungen, die der Benutzer
//STRIP001 	auf dieser Seite get"atigt hat, werden aufgehoben.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	Data_Impl* pDataObject = Find( *pImpl->pData, aTabCtrl.GetCurPageId() );
//STRIP001 	DBG_ASSERT( pDataObject, "Id nicht bekannt" );
//STRIP001 
//STRIP001 	if ( pDataObject->bOnDemand )
//STRIP001 	{
//STRIP001 		// CSet auf AIS hat hier Probleme, daher getrennt
//STRIP001 		const SfxItemSet* pSet = &pDataObject->pTabPage->GetItemSet();
//STRIP001 		pDataObject->pTabPage->Reset( *(SfxItemSet*)pSet );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pDataObject->pTabPage->Reset( *pSet );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxTabDialog, BaseFmtHdl, Button *, EMPTYARG )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Handler hinter dem Standard-Button.
//STRIP001 	Dieser Button steht beim Bearbeiten von StyleSheets zur Verf"ugung.
//STRIP001 	Alle in dem bearbeiteten StyleSheet eingestellten Attribute
//STRIP001 	werden gel"oscht.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	const USHORT nId = aTabCtrl.GetCurPageId();
//STRIP001 	Data_Impl* pDataObject = Find( *pImpl->pData, nId );
//STRIP001 	DBG_ASSERT( pDataObject, "Id nicht bekannt" );
//STRIP001 	bFmt = 2;
//STRIP001 
//STRIP001 	if ( pDataObject->fnGetRanges )
//STRIP001 	{
//STRIP001 		if ( !pExampleSet )
//STRIP001 			pExampleSet = new SfxItemSet( *pSet );
//STRIP001 
//STRIP001 		const SfxItemPool* pPool = pSet->GetPool();
//STRIP001 		const USHORT* pRanges = (pDataObject->fnGetRanges)();
//STRIP001 		SfxItemSet aTmpSet( *pExampleSet );
//STRIP001 
//STRIP001 		while ( *pRanges )
//STRIP001 		{
//STRIP001 			const USHORT* pU = pRanges + 1;
//STRIP001 
//STRIP001 			if ( *pRanges == *pU )
//STRIP001 			{
//STRIP001 				// Range mit zwei gleichen Werten -> nur ein Item setzen
//STRIP001 				USHORT nWh = pPool->GetWhich( *pRanges );
//STRIP001 				pExampleSet->ClearItem( nWh );
//STRIP001 				aTmpSet.ClearItem( nWh );
//STRIP001 				// am OutSet mit InvalidateItem,
//STRIP001 				// damit die "Anderung wirksam wird
//STRIP001 				pOutSet->InvalidateItem( nWh );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// richtiger Range mit mehreren Werten
//STRIP001 				USHORT nTmp = *pRanges, nTmpEnd = *pU;
//STRIP001 				DBG_ASSERT( nTmp <= nTmpEnd, "Range ist falsch sortiert" );
//STRIP001 
//STRIP001 				if ( nTmp > nTmpEnd )
//STRIP001 				{
//STRIP001 					// wenn wirklich falsch sortiert, dann neu setzen
//STRIP001 					USHORT nTmp1 = nTmp;
//STRIP001 					nTmp = nTmpEnd;
//STRIP001 					nTmpEnd = nTmp1;
//STRIP001 				}
//STRIP001 
//STRIP001 				while ( nTmp <= nTmpEnd )
//STRIP001 				{
//STRIP001 					// "uber den Range iterieren, und die Items setzen
//STRIP001 					USHORT nWh = pPool->GetWhich( nTmp );
//STRIP001 					pExampleSet->ClearItem( nWh );
//STRIP001 					aTmpSet.ClearItem( nWh );
//STRIP001 					// am OutSet mit InvalidateItem,
//STRIP001 					// damit die "Anderung wirksam wird
//STRIP001 					pOutSet->InvalidateItem( nWh );
//STRIP001 					nTmp++;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			// zum n"achsten Paar gehen
//STRIP001 			pRanges += 2;
//STRIP001 		}
//STRIP001 		// alle Items neu gesetzt -> dann an der aktuellen Page Reset() rufen
//STRIP001 		DBG_ASSERT( pDataObject->pTabPage, "die Page ist weg" );
//STRIP001 		pDataObject->pTabPage->Reset( aTmpSet );
//STRIP001 		pDataObject->pTabPage->pImpl->_bStandard = TRUE;
//STRIP001 	}
//STRIP001 	return 1;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxTabDialog, ActivatePageHdl, TabControl *, pTabCtrl )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Handler, der vor dem Umschalten auf eine andere Seite
//STRIP001 	durch Starview gerufen wird.
//STRIP001 	Existiert die Seite noch nicht, so wird sie erzeugt und
//STRIP001 	die virtuelle Methode <SfxTabDialog::PageCreated( USHORT, SfxTabPage &)>
//STRIP001 	gerufen. Existiert die Seite bereits, so wird ggf.
//STRIP001 	<SfxTabPage::Reset(const SfxItemSet &)> oder
//STRIP001 	<SfxTabPage::ActivatePage(const SfxItemSet &)> gerufen.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	DBG_ASSERT( pImpl->pData->Count(), "keine Pages angemeldet" );
//STRIP001 	const USHORT nId = pTabCtrl->GetCurPageId();
//STRIP001 	SfxApplication *pSfxApp = SFX_APP();
//STRIP001 
//STRIP001 	// Tab Page schon da?
//STRIP001 	SfxTabPage* pTabPage = (SfxTabPage *)pTabCtrl->GetTabPage( nId );
//STRIP001 	Data_Impl* pDataObject = Find( *pImpl->pData, nId );
//STRIP001 	DBG_ASSERT( pDataObject, "Id nicht bekannt" );
//STRIP001 
//STRIP001 	// ggf. TabPage erzeugen:
//STRIP001 	if ( !pTabPage )
//STRIP001 	{
//STRIP001 		const SfxItemSet* pTmpSet = 0;
//STRIP001 
//STRIP001 		if ( pSet )
//STRIP001 		{
//STRIP001 			if ( bItemsReset && pSet->GetParent() )
//STRIP001 				pTmpSet = pSet->GetParent();
//STRIP001 			else
//STRIP001 				pTmpSet = pSet;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( pTmpSet && !pDataObject->bOnDemand )
//STRIP001 			pTabPage = (pDataObject->fnCreatePage)( pTabCtrl, *pTmpSet );
//STRIP001 		else
//STRIP001 			pTabPage = (pDataObject->fnCreatePage)
//STRIP001 							( pTabCtrl, *CreateInputItemSet( nId ) );
//STRIP001 		DBG_ASSERT( NULL == pDataObject->pTabPage, "create TabPage more than once" );
//STRIP001 		pDataObject->pTabPage = pTabPage;
//STRIP001 		pDataObject->pTabPage->SetTabDialog( this );
//STRIP001 		SvtViewOptions aPageOpt( E_TABPAGE, String::CreateFromInt32( pDataObject->nId ) );
//STRIP001 		String sUserData;
//STRIP001 		Any aUserItem = aPageOpt.GetUserItem( USERITEM_NAME );
//STRIP001 		OUString aTemp;
//STRIP001 		if ( aUserItem >>= aTemp )
//STRIP001 			sUserData = String( aTemp );
//STRIP001 		pTabPage->SetUserData( sUserData );
//STRIP001 		Size aSiz = pTabPage->GetSizePixel();
//STRIP001 		Size aCtrlSiz = pTabCtrl->GetOutputSizePixel();
//STRIP001 		// Gr"o/se am TabControl nur dann setzen, wenn < als TabPage
//STRIP001 		if ( aCtrlSiz.Width() < aSiz.Width() ||
//STRIP001 			 aCtrlSiz.Height() < aSiz.Height() )
//STRIP001 			pTabCtrl->SetOutputSizePixel( aSiz );
//STRIP001 		PageCreated( nId, *pTabPage );
//STRIP001 
//STRIP001 		if ( pDataObject->bOnDemand )
//STRIP001 			pTabPage->Reset( (SfxItemSet &)pTabPage->GetItemSet() );
//STRIP001 		else
//STRIP001 			pTabPage->Reset( *pSet );
//STRIP001 		pTabCtrl->SetTabPage( nId, pTabPage );
//STRIP001 	}
//STRIP001 	else if ( pDataObject->bRefresh )
//STRIP001 		pTabPage->Reset( *pSet );
//STRIP001 	pDataObject->bRefresh = FALSE;
//STRIP001 
//STRIP001 	if ( pExampleSet )
//STRIP001 		pTabPage->ActivatePage( *pExampleSet );
//STRIP001 	BOOL bReadOnly = pTabPage->IsReadOnly();
//STRIP001 	( bReadOnly || pImpl->bHideResetBtn ) ? aResetBtn.Hide() : aResetBtn.Show();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxTabDialog, DeactivatePageHdl, TabControl *, pTabCtrl )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Handler, der vor dem Verlassen einer Seite durch Starview gerufen wird.
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 
//STRIP001 	<SfxTabPage::DeactivatePage(SfxItemSet *)>
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	USHORT nId = pTabCtrl->GetCurPageId();
//STRIP001 	SfxApplication *pSfxApp = SFX_APP();
//STRIP001 	SfxTabPage *pPage = (SfxTabPage*)pTabCtrl->GetTabPage( nId );
//STRIP001 	DBG_ASSERT( pPage, "keine aktive Page" );
//STRIP001 #ifdef DBG_UTIL
//STRIP001 	Data_Impl* pDataObject = Find( *pImpl->pData, pTabCtrl->GetCurPageId() );
//STRIP001 	DBG_ASSERT( pDataObject, "keine Datenstruktur zur aktuellen Seite" );
//STRIP001 	if ( pPage->HasExchangeSupport() && pDataObject->bOnDemand )
//STRIP001 	{
//STRIP001 		DBG_WARNING( "Datenaustausch bei ItemsOnDemand ist nicht gewuenscht!" );
//STRIP001 	}
//STRIP001 #endif
//STRIP001 
//STRIP001 	int nRet = SfxTabPage::LEAVE_PAGE;
//STRIP001 
//STRIP001 	if ( !pExampleSet && pPage->HasExchangeSupport() && pSet )
//STRIP001 		pExampleSet = new SfxItemSet( *pSet->GetPool(), pSet->GetRanges() );
//STRIP001 
//STRIP001 	if ( pSet )
//STRIP001 	{
//STRIP001 		SfxItemSet aTmp( *pSet->GetPool(), pSet->GetRanges() );
//STRIP001 
//STRIP001 		if ( pPage->HasExchangeSupport() )
//STRIP001 			nRet = pPage->DeactivatePage( &aTmp );
//STRIP001 		else
//STRIP001 			nRet = pPage->DeactivatePage( NULL );
//STRIP001 //!		else
//STRIP001 //!			pPage->FillItemSet( aTmp );
//STRIP001 
//STRIP001 		if ( ( SfxTabPage::LEAVE_PAGE & nRet ) == SfxTabPage::LEAVE_PAGE &&
//STRIP001 			 aTmp.Count() )
//STRIP001 		{
//STRIP001 			pExampleSet->Put( aTmp );
//STRIP001 			pOutSet->Put( aTmp );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( pPage->HasExchangeSupport() ) //!!!
//STRIP001 		{
//STRIP001 			if ( !pExampleSet )
//STRIP001 			{
//STRIP001 				SfxItemPool* pPool = pPage->GetItemSet().GetPool();
//STRIP001 				pExampleSet =
//STRIP001 					new SfxItemSet( *pPool, GetInputRanges( *pPool ) );
//STRIP001 			}
//STRIP001 			nRet = pPage->DeactivatePage( pExampleSet );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			nRet = pPage->DeactivatePage( NULL );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( nRet & SfxTabPage::REFRESH_SET )
//STRIP001 	{
//STRIP001 		pSet = GetRefreshedSet();
//STRIP001 		DBG_ASSERT( pSet, "GetRefreshedSet() liefert NULL" );
//STRIP001 		// alle Pages als neu zu initialsieren flaggen
//STRIP001 		const USHORT nCount = pImpl->pData->Count();
//STRIP001 
//STRIP001 		for ( USHORT i = 0; i < nCount; ++i )
//STRIP001 		{
//STRIP001 			Data_Impl* pObj = (*pImpl->pData)[i];
//STRIP001 
//STRIP001 			if ( pObj->pTabPage != pPage ) // eigene Page nicht mehr refreshen
//STRIP001 				pObj->bRefresh = TRUE;
//STRIP001 			else
//STRIP001 				pObj->bRefresh = FALSE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if ( nRet & SfxTabPage::LEAVE_PAGE )
//STRIP001 		return TRUE;
//STRIP001 	else
//STRIP001 		return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 const SfxItemSet* SfxTabDialog::GetOutputItemSet
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Liefert die Pages, die ihre Sets onDemand liefern, das OutputItemSet.
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 
//STRIP001 	<SfxTabDialog::AddTabPage(USHORT, CreateTabPage, GetTabPageRanges, BOOL)>
//STRIP001 	<SfxTabDialog::AddTabPage(USHORT, const String &, CreateTabPage, GetTabPageRanges, BOOL, USHORT)>
//STRIP001 	<SfxTabDialog::AddTabPage(USHORT, const Bitmap &, CreateTabPage, GetTabPageRanges, BOOL, USHORT)>
//STRIP001 */
//STRIP001 
//STRIP001 (
//STRIP001 	USHORT nId	// die Id, unter der die Seite bei AddTabPage()
//STRIP001 				// hinzugef"ugt wurde.
//STRIP001 ) const
//STRIP001 {
//STRIP001 	Data_Impl* pDataObject = Find( *pImpl->pData, nId );
//STRIP001 	DBG_ASSERT( pDataObject, "TabPage nicht gefunden" );
//STRIP001 
//STRIP001 	if ( pDataObject )
//STRIP001 	{
//STRIP001 		if ( !pDataObject->pTabPage )
//STRIP001 			return NULL;
//STRIP001 
//STRIP001 		if ( pDataObject->bOnDemand )
//STRIP001 			return &pDataObject->pTabPage->GetItemSet();
//STRIP001 		// else
//STRIP001 		return pOutSet;
//STRIP001 	}
//STRIP001 	return NULL;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 int SfxTabDialog::FillOutputItemSet()
//STRIP001 {
//STRIP001 	int nRet = SfxTabPage::LEAVE_PAGE;
//STRIP001 	if ( OK_Impl() )
//STRIP001 		Ok();
//STRIP001 	else
//STRIP001 		nRet = SfxTabPage::KEEP_PAGE;
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 #ifdef WNT
//STRIP001 int __cdecl TabDlgCmpUS_Impl( const void* p1, const void* p2 )
//STRIP001 #else
//STRIP001 #if defined(OS2) && defined(ICC)
//STRIP001 int _Optlink TabDlgCmpUS_Impl( const void* p1, const void* p2 )
//STRIP001 #else
//STRIP001 int TabDlgCmpUS_Impl( const void* p1, const void* p2 )
//STRIP001 #endif
//STRIP001 #endif
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Vergleichsfunktion f"ur qsort
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	return *(USHORT*)p1 - *(USHORT*)p2;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxTabDialog::ShowPage( USHORT nId )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Es wird die TabPage mit der "ubergebenen Id aktiviert.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	aTabCtrl.SetCurPageId( nId );
//STRIP001 	ActivatePageHdl( &aTabCtrl );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 const USHORT* SfxTabDialog::GetInputRanges( const SfxItemPool& rPool )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Bildet das Set "uber die Ranges aller Seiten des Dialogs.
//STRIP001 	Die Pages m"ussen die statische Methode f"ur das Erfragen ihrer
//STRIP001 	Ranges bei AddTabPage angegeben haben, liefern also ihre Sets onDemand.
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 
//STRIP001 	<SfxTabDialog::AddTabPage(USHORT, CreateTabPage, GetTabPageRanges, BOOL)>
//STRIP001 	<SfxTabDialog::AddTabPage(USHORT, const String &, CreateTabPage, GetTabPageRanges, BOOL, USHORT)>
//STRIP001 	<SfxTabDialog::AddTabPage(USHORT, const Bitmap &, CreateTabPage, GetTabPageRanges, BOOL, USHORT)>
//STRIP001 
//STRIP001 	[R"uckgabewert]
//STRIP001 
//STRIP001 	Pointer auf nullterminiertes Array von USHORTs
//STRIP001 	Dieses Array geh"ort dem Dialog und wird beim
//STRIP001 	Zerst"oren des Dialogs gel"oscht.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	if ( pSet )
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "Set bereits vorhanden!" );
//STRIP001 		return pSet->GetRanges();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pRanges )
//STRIP001 		return pRanges;
//STRIP001 	SvUShorts aUS( 16, 16 );
//STRIP001 	USHORT nCount = pImpl->pData->Count();
//STRIP001 
//STRIP001 	USHORT i;
//STRIP001 	for ( i = 0; i < nCount; ++i )
//STRIP001 	{
//STRIP001 		Data_Impl* pDataObject = pImpl->pData->GetObject(i);
//STRIP001 
//STRIP001 		if ( pDataObject->fnGetRanges )
//STRIP001 		{
//STRIP001 			const USHORT* pTmpRanges = (pDataObject->fnGetRanges)();
//STRIP001 			const USHORT* pIter = pTmpRanges;
//STRIP001 
//STRIP001 			USHORT nLen;
//STRIP001 			for( nLen = 0; *pIter; ++nLen, ++pIter )
//STRIP001 				;
//STRIP001 			aUS.Insert( pTmpRanges, nLen, aUS.Count() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//! Doppelte Ids entfernen?
//STRIP001 #ifndef TF_POOLABLE
//STRIP001 	if ( rPool.HasMap() )
//STRIP001 #endif
//STRIP001 	{
//STRIP001 		nCount = aUS.Count();
//STRIP001 
//STRIP001 		for ( i = 0; i < nCount; ++i )
//STRIP001 			aUS[i] = rPool.GetWhich( aUS[i] );
//STRIP001 	}
//STRIP001 
//STRIP001 	// sortieren
//STRIP001 	if ( aUS.Count() > 1 )
//STRIP001 		qsort( (void*)aUS.GetData(),
//STRIP001 			   aUS.Count(), sizeof(USHORT), TabDlgCmpUS_Impl );
//STRIP001 
//STRIP001 	// Ranges erzeugen
//STRIP001 	//!! Auskommentiert, da fehlerhaft
//STRIP001 	/*
//STRIP001 	pRanges = new USHORT[aUS.Count() * 2 + 1];
//STRIP001 	int j = 0;
//STRIP001 	i = 0;
//STRIP001 
//STRIP001 	while ( i < aUS.Count() )
//STRIP001 	{
//STRIP001 		pRanges[j++] = aUS[i];
//STRIP001 		// aufeinanderfolgende Zahlen
//STRIP001 		for( ; i < aUS.Count()-1; ++i )
//STRIP001 			if ( aUS[i] + 1 != aUS[i+1] )
//STRIP001 				break;
//STRIP001 		pRanges[j++] = aUS[i++];
//STRIP001 	}
//STRIP001 	pRanges[j] = 0;		// terminierende NULL
//STRIP001 	*/
//STRIP001 
//STRIP001 	pRanges = new USHORT[aUS.Count() + 1];
//STRIP001 	memcpy(pRanges, aUS.GetData(), sizeof(USHORT) * aUS.Count());
//STRIP001 	pRanges[aUS.Count()] = 0;
//STRIP001 	return pRanges;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxTabDialog::SetInputSet( const SfxItemSet* pInSet )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Mit dieser Methode kann nachtr"aglich der Input-Set initial oder
//STRIP001 	neu gesetzt werden.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	FASTBOOL bSet = ( pSet != NULL );
//STRIP001 
//STRIP001 	pSet = pInSet;
//STRIP001 
//STRIP001 	if ( !bSet && !pExampleSet && !pOutSet )
//STRIP001 	{
//STRIP001 		pExampleSet = new SfxItemSet( *pSet );
//STRIP001 		pOutSet = new SfxItemSet( *pSet->GetPool(), pSet->GetRanges() );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 #if SUPD>=636
//STRIP001 long SfxTabDialog::Notify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001     if ( rNEvt.GetType() == EVENT_GETFOCUS )
//STRIP001 	{
//STRIP001         SfxViewFrame* pViewFrame = GetViewFrame() ? GetViewFrame() : SfxViewFrame::Current();
//STRIP001         if ( pViewFrame )
//STRIP001         {
//STRIP001             Window* pWindow = rNEvt.GetWindow();
//STRIP001             ULONG nHelpId  = 0;
//STRIP001             while ( !nHelpId && pWindow )
//STRIP001             {
//STRIP001                 nHelpId = pWindow->GetHelpId();
//STRIP001                 pWindow = pWindow->GetParent();
//STRIP001             }
//STRIP001 
//STRIP001             if ( nHelpId )
//STRIP001                 SfxHelp::OpenHelpAgent( pViewFrame->GetFrame(), nHelpId );
//STRIP001         }
//STRIP001 	}
//STRIP001 
//STRIP001     return TabDialog::Notify( rNEvt );
//STRIP001 }
//STRIP001 #endif
//STRIP001 
}
