/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_drviewsa.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:38:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#define ITEMID_SIZE 0

// auto strip #ifndef _CPPUHELPER_IMPLBASE1_HXX_
// auto strip #include <cppuhelper/implbase1.hxx>
// auto strip #endif
// auto strip #ifndef _COMPHELPER_PROCESSFACTORY_HXX_
// auto strip #include <comphelper/processfactory.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_SIZEITEM
// auto strip #include <bf_svx/sizeitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVDLAYER_HXX
// auto strip #include <bf_svx/svdlayer.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_ZOOMITEM
// auto strip #include <bf_svx/zoomitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVDPAGV_HXX //autogen
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #endif
// auto strip #ifndef _SFXPTITEM_HXX //autogen
// auto strip #include <svtools/ptitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXSTRITEM_HXX //autogen
// auto strip #include <svtools/stritem.hxx>
// auto strip #endif
// auto strip #ifndef _XPOLY_HXX //autogen
// auto strip #include <bf_svx/xpoly.hxx>
// auto strip #endif
#ifndef _SFXREQUEST_HXX //autogen
#include <bf_sfx2/request.hxx>
#endif
// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOPATH_HXX //autogen
// auto strip #include <bf_svx/svdopath.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDOCFILE_HXX //autogen
// auto strip #include <bf_sfx2/docfile.hxx>
// auto strip #endif

// auto strip #ifndef _SFXENUMITEM_HXX
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif

#pragma hdrstop

#ifndef _SVX_FMSHELL_HXX			// XXX nur temp (dg)
#include <bf_svx/fmshell.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
#ifndef _CLIPLISTENER_HXX
#include <svtools/cliplistener.hxx>
#endif
#ifndef _SVX_FLOAT3D_HXX
#include <bf_svx/float3d.hxx>
#endif

#include "app.hrc"
#include "helpids.h"
#include "strings.hrc"
#include "res_bmp.hrc"
#include "sdpage.hxx"
#include "frmview.hxx"
#include "drawdoc.hxx"
#include "sdresid.hxx"
#include "docshell.hxx"
#include "sdwindow.hxx"
#include "fupoor.hxx"
#include "drviewsh.hxx"
#include "drbezob.hxx"
#include "drglueob.hxx"
#include "drtxtob.hxx"
#include "drgrfob.hxx"
#include "drstdob.hxx"
#include "grstdob.hxx"
#include "drawview.hxx"
#include "SdUnoDrawView.hxx"

#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif
namespace binfilter {

using namespace ::rtl;
using namespace ::com::sun::star;

BOOL SdDrawViewShell::bPipette = FALSE;

// Use magenta as transparency color instead of the standard gray that is
// imported from vcl/image.hxx
#undef IMAGE_STDBTN_COLOR
#undef IMAGE_STDBTN_COLOR_HC
#define IMAGE_STDBTN_COLOR Color(0xff,0x00,0xff)
#define IMAGE_STDBTN_COLOR_HC Color(0xff,0x00,0xff)

// ------------------------
// - ScannerEventListener -
// ------------------------

class ScannerEventListener : public ::cppu::WeakImplHelper1< ::com::sun::star::lang::XEventListener >
{
private:

	SdDrawViewShell*		mpParent;

public:

							ScannerEventListener( SdDrawViewShell* pParent ) : mpParent( pParent )  {};
							~ScannerEventListener();

	// XEventListener
	virtual void SAL_CALL 	disposing( const ::com::sun::star::lang::EventObject& rEventObject ) throw (::com::sun::star::uno::RuntimeException);

	void					ParentDestroyed() { mpParent = NULL; }
};

// -----------------------------------------------------------------------------

/*N*/ ScannerEventListener::~ScannerEventListener()
/*N*/ {
/*N*/ }

// -----------------------------------------------------------------------------

void SAL_CALL ScannerEventListener::disposing( const ::com::sun::star::lang::EventObject& rEventObject ) throw (::com::sun::star::uno::RuntimeException)
{
	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if( mpParent )
//STRIP001 		mpParent->ScannerEvent( rEventObject );
}

/*************************************************************************
|*
|* Standard-Konstruktor
|*
\************************************************************************/

/*N*/ SdDrawViewShell::SdDrawViewShell(SfxViewFrame* pFrame, SfxViewShell *pOldShell) :
/*N*/ 	SdViewShell(pFrame, &pFrame->GetWindow()),
/*N*/ 	aTabControl(this, &pFrame->GetWindow()),
/*N*/ 	aLayerTab(this, &pFrame->GetWindow()),
/*N*/ 	aPageBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS),
/*N*/ 	aMasterPageBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
/*N*/ 	aLayerBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
/*N*/ 	pActualPage(NULL),
/*N*/ 	bLayerMode(FALSE),
/*N*/ 	pXPolygon (0),
/*N*/ 	nPolygonIndex (0),
/*N*/ 	bLineError (FALSE),
/*N*/ 	bLastWasLineTo (FALSE),
/*N*/ 	bLastWasMoveTo (FALSE),
/*N*/ 	bLastWasBezierTo (FALSE),
/*N*/ 	bMousePosFreezed (FALSE),
/*N*/ 	nLastSlot(0),
/*N*/ 	bReadOnly(pDocSh->IsReadOnly()),
/*N*/ 	bInEffectAssignment(FALSE),
/*N*/ 	pSlotArray( NULL ),
/*N*/ 	pClipEvtLstnr(NULL),
/*N*/ 	bPastePossible(FALSE),
/*N*/ 	pController(NULL)
/*N*/ {
/*N*/ 	if (pOldShell)
/*N*/ 	{
/*?*/ 		pFrameView = ( (SdViewShell*) pOldShell)->GetFrameView();
/*?*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		pFrameView = new FrameView(pDoc);
/*N*/ 	}
/*N*/ 
/*N*/ 	pFrameView->Connect();
/*N*/ 
/*N*/ 	Construct(pDocSh);
/*N*/ 	DestroyPolygons ();
/*N*/ 	pXPolygon = new XPolygon;
/*N*/ }

/*************************************************************************
|*
|* Copy-Konstruktor
|*
\************************************************************************/

/*N*/ SdDrawViewShell::SdDrawViewShell(SfxViewFrame* pFrame,
/*N*/ 								 const SdDrawViewShell& rShell) :
/*N*/ 	SdViewShell(pFrame, rShell),
/*N*/ 	aTabControl(this, &pFrame->GetWindow()),
/*N*/ 	aLayerTab(this, &pFrame->GetWindow()),
/*N*/ 	aPageBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
/*N*/ 	aMasterPageBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
/*N*/ 	aLayerBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
/*N*/ 	pActualPage(NULL),
/*N*/ 	bLayerMode(FALSE),
/*N*/ 	pXPolygon (0),
/*N*/ 	nPolygonIndex (0),
/*N*/ 	bLineError (FALSE),
/*N*/ 	bLastWasLineTo (FALSE),
/*N*/ 	bLastWasMoveTo (FALSE),
/*N*/ 	bLastWasBezierTo (FALSE),
/*N*/ 	bMousePosFreezed (FALSE),
/*N*/ 	nLastSlot(0),
/*N*/ 	bReadOnly(pDocSh->IsReadOnly()),
/*N*/ 	bInEffectAssignment(FALSE),
/*N*/ 	pSlotArray( NULL ),
/*N*/ 	pClipEvtLstnr(NULL),
/*N*/ 	bPastePossible(FALSE),
/*N*/ 	pController(NULL)
/*N*/ {
/*N*/ 	pFrameView = new FrameView(pDoc);
/*N*/ 	pFrameView->Connect();
/*N*/ 
/*N*/ 	Construct(pDocSh);
/*N*/ 	DestroyPolygons ();
/*N*/ 	pXPolygon = new XPolygon;
/*N*/ }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ SdDrawViewShell::~SdDrawViewShell()
/*N*/ {
/*N*/ 	if( mxScannerListener.is() )
/*N*/ 		static_cast< ScannerEventListener* >( mxScannerListener.get() )->ParentDestroyed();
/*N*/ 
/*N*/     // #96642# Remove references to items within Svx3DWin
/*N*/     // (maybe do a listening sometime in Svx3DWin)
/*N*/     USHORT nId = Svx3DChildWindow::GetChildWindowId();
/*N*/     SfxChildWindow* pWindow = GetViewFrame() ? GetViewFrame()->GetChildWindow(nId) : NULL;
/*N*/     if(pWindow)
/*N*/     {
/*?*/         DBG_BF_ASSERT(0, "STRIP"); //STRIP001 Svx3DWin* p3DWin = static_cast< Svx3DWin* > (pWindow->GetWindow());
//STRIP001 /*?*/         if(p3DWin)
//STRIP001 /*?*/             p3DWin->DocumentReload();
/*N*/     }
/*N*/     
/*N*/ 	EndListening(*GetViewFrame());
/*N*/ 
/*N*/ 	if (pFuSlideShow)
/*N*/ 	{
		// SlideShow ggf. beenden
/*N*/ 		GetViewFrame()->GetDispatcher()->Execute(SID_PRESENTATION_END,
/*N*/ 					SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD );
/*N*/ 	}

/*N*/ 	if (pFuActual)
/*N*/ 	{
/*N*/ 		if (pFuOld == pFuActual)
/*N*/ 			pFuOld = NULL;
/*N*/ 
/*N*/ 		pFuActual->Deactivate();
/*N*/ 		delete pFuActual;
/*N*/ 		pFuActual = NULL;
/*N*/ 	}
/*N*/ 
/*N*/ 	if (pFuOld)
/*?*/ 	{
/*?*/ 		delete pFuOld;
/*?*/ 		pFuOld = NULL;
/*?*/ 	}
/*N*/ 
/*N*/ 	SdPage* pPage;
/*N*/ 	USHORT nSelectedPage = 0;
/*N*/ 	USHORT aPageCnt = pDoc->GetSdPageCount(ePageKind);
/*N*/ 
/*N*/ 	for (USHORT i = 0; i < aPageCnt; i++)
/*N*/ 	{
/*N*/ 		pPage = pDoc->GetSdPage(i, ePageKind);
/*N*/ 
/*N*/ 		if (pPage == pActualPage)
/*N*/ 		{
/*N*/ 			pDoc->SetSelected(pPage, TRUE);
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/ 			pDoc->SetSelected(pPage, FALSE);
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	RemoveSubShell();
/*N*/ 
/*N*/ 	// Umschaltung der ObjectBarShells unterdruecken, sonst versucht die
/*N*/ 	// sterbende Funktion eventuell die ObjectBars zu wechseln. Die
/*N*/ 	// entsprechende Shell ist aber schon vom SFX vom Dispatcher-Stack
/*N*/ 	// genommen worden.
/*N*/ 	bObjectBarSwitchEnabled = FALSE;
/*N*/ 
/*N*/ 	if ( pClipEvtLstnr )
/*N*/ 	{
/*N*/ 		pClipEvtLstnr->AddRemoveListener( GetActiveWindow(), FALSE );
/*N*/ 		pClipEvtLstnr->ClearCallbackLink();		// #103849# prevent callback if another thread is waiting
/*N*/ 		pClipEvtLstnr->release();
/*N*/ 	}
/*N*/ 
/*N*/ 	delete pDrView;
/*N*/ 	SetWindow(NULL);
/*N*/ 
/*N*/ 	pFrameView->Disconnect();
/*N*/ 	delete pXPolygon;
/*N*/ 	delete [] pSlotArray;
/*N*/ }

/*************************************************************************
|*
|* gemeinsamer Initialisierungsanteil der beiden Konstruktoren
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::Construct(SdDrawDocShell* pDocSh)
/*N*/ {
/*N*/ 	// Array fuer Slot-/ImageMapping:
/*N*/ 	// Gerader Eintrag: Haupt-/ToolboxSlot
/*N*/ 	// Ungerader Eintrag: gemappter Slot
/*N*/ 	// Achtung: Anpassen von GetIdBySubId() !!!
/*N*/ 	// Reihenfolge (insbesondere Zoom) darf nicht geaendert werden !!!
/*N*/ 	pSlotArray = new USHORT[ SLOTARRAY_COUNT ];
/*N*/ 	pSlotArray[ 0 ]  = SID_OBJECT_CHOOSE_MODE;
/*N*/ 	pSlotArray[ 1 ]  = SID_OBJECT_ROTATE;
/*N*/ 	pSlotArray[ 2 ]  = SID_OBJECT_ALIGN;
/*N*/ 	pSlotArray[ 3 ]  = SID_OBJECT_ALIGN_LEFT;
/*N*/ 	pSlotArray[ 4 ]  = SID_ZOOM_TOOLBOX;
/*N*/ 	pSlotArray[ 5 ]  = SID_ZOOM_TOOLBOX;
/*N*/ 	pSlotArray[ 6 ]  = SID_DRAWTBX_TEXT;
/*N*/ 	pSlotArray[ 7 ]  = SID_ATTR_CHAR;
/*N*/ 	pSlotArray[ 8 ]  = SID_DRAWTBX_RECTANGLES;
/*N*/ 	pSlotArray[ 9 ]  = SID_DRAW_RECT;
/*N*/ 	pSlotArray[ 10 ] = SID_DRAWTBX_ELLIPSES;
/*N*/ 	pSlotArray[ 11 ] = SID_DRAW_ELLIPSE;
/*N*/ 	pSlotArray[ 12 ] = SID_DRAWTBX_LINES;
/*N*/ 	pSlotArray[ 13 ] = SID_DRAW_FREELINE_NOFILL;
/*N*/ 	pSlotArray[ 14 ] = SID_DRAWTBX_3D_OBJECTS;
/*N*/ 	pSlotArray[ 15 ] = SID_3D_CUBE;
/*N*/ 	pSlotArray[ 16 ] = SID_DRAWTBX_INSERT;
/*N*/ 	pSlotArray[ 17 ] = SID_INSERT_DIAGRAM;
/*N*/ 	pSlotArray[ 18 ] = SID_POSITION;
/*N*/ 	pSlotArray[ 19 ] = SID_FRAME_TO_TOP;
/*N*/ 	pSlotArray[ 20 ] = SID_DRAWTBX_CONNECTORS;
/*N*/ 	pSlotArray[ 21 ] = SID_TOOL_CONNECTOR;
/*N*/ 	pSlotArray[ 22 ] = SID_DRAWTBX_ARROWS;
/*N*/ 	pSlotArray[ 23 ] = SID_LINE_ARROW_END;
/*N*/ 
/*N*/ 	StartListening(*GetViewFrame());
/*N*/ 	StartListening(*pDocSh);
/*N*/ 
/*N*/ 	SetPool( &pDoc->GetPool() );
/*N*/ 
/*N*/ 	pDoc->CreateFirstPages();
/*N*/ 
/*N*/ 	pDrView = new SdDrawView(pDocSh, pWindow, this);
/*N*/ 	pView = pDrView;			 // Pointer der Basisklasse SdViewShell
/*N*/ 	pDrView->SetSwapAsynchron(TRUE); // Asynchrones Laden von Graphiken
/*N*/ 
/*N*/ 	ePageKind = pFrameView->GetPageKind();
/*N*/ 	eEditMode = EM_PAGE;
/*N*/ 	DocumentType eDocType = pDoc->GetDocumentType(); // RTTI fasst hier noch nicht
/*N*/ 
/*N*/ 	// Shells fuer Object Bars erzeugen
/*N*/ 	SfxShell* pObjBarShell;
/*N*/ 	if( eDocType == DOCUMENT_TYPE_DRAW )
/*N*/ 		pObjBarShell = new SdGraphicStdObjectBar(this, pDrView);
/*N*/ 	else
/*N*/ 		pObjBarShell = new SdDrawStdObjectBar(this, pDrView);
/*N*/ 	// Die ID (Key) bleibt fuer beide ObjectBars gleich, um auch
/*N*/ 	// den Aenderungs- und Pflegeaufwand gering zu halten
/*N*/ 	aShellTable.Insert( RID_DRAW_OBJ_TOOLBOX, pObjBarShell );
/*N*/ 
/*N*/ 	pObjBarShell = new SdDrawBezierObjectBar(this, pDrView);
/*N*/ 	aShellTable.Insert(RID_BEZIER_TOOLBOX, pObjBarShell);
/*N*/ 
/*N*/ 	pObjBarShell = new SdDrawGluePointsObjectBar(this, pDrView);
/*N*/ 	aShellTable.Insert(RID_GLUEPOINTS_TOOLBOX, pObjBarShell);
/*N*/ 
/*N*/ 	pObjBarShell = new SdDrawTextObjectBar( this, pDoc->GetPool(),
/*N*/ 											pDrView );
/*N*/ 	aShellTable.Insert( RID_DRAW_TEXT_TOOLBOX, pObjBarShell );
/*N*/ 
/*N*/ 	aShellTable.Insert( RID_FORMLAYER_TOOLBOX, new FmFormShell( this, pDrView ) );
/*N*/ 
/*N*/ 	aShellTable.Insert( RID_DRAW_GRAF_TOOLBOX, new SdDrawGrafObjectBar( this, pDrView ) );
/*N*/ 
/*N*/ 	// ObjectBar einschalten
/*N*/ 	SwitchObjectBar(RID_DRAW_OBJ_TOOLBOX);
/*N*/ 
/*N*/ 	Size aPageSize = pDoc->GetSdPage(0, ePageKind)->GetSize();
/*N*/ 	Point aPageOrg = Point(aPageSize.Width(), aPageSize.Height() / 2);
/*N*/ 	Size aViewSize = Size(aPageSize.Width() * 3, aPageSize.Height() * 2);
/*N*/ 	InitWindows(aPageOrg, aViewSize, Point(-1, -1));
/*N*/ 
/*N*/ 	Point aVisAreaPos;
/*N*/ 
/*N*/ 	if ( pDocSh->GetCreateMode() == SFX_CREATE_MODE_EMBEDDED )
/*N*/ 	{
/*?*/ 		aVisAreaPos = pDocSh->GetVisArea(ASPECT_CONTENT).TopLeft();
/*?*/ 	}
/*N*/ 
/*N*/ 	pDrView->SetWorkArea(Rectangle(Point() - aVisAreaPos - aPageOrg, aViewSize));
/*N*/ 
/*N*/ 	// Objekte koennen max. so gross wie die ViewSize werden
/*N*/ 	pDoc->SetMaxObjSize(aViewSize);
/*N*/ 
/*N*/ 	// Split-Handler fuer TabControls
/*N*/ 	aTabControl.SetSplitHdl( LINK( this, SdDrawViewShell, TabSplitHdl ) );
/*N*/ 	aLayerTab.SetSplitHdl( LINK( this, SdDrawViewShell, TabSplitHdl ) );
/*N*/ 
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 //STRIP001 /*N*/ 	aPageBtn.SetImage( Image( Bitmap( SdResId( BMP_TAB_PAGEMODE ) ), IMAGE_STDBTN_COLOR ) );
//STRIP001 /*N*/ 	aPageBtn.SetModeImage( Image( Bitmap( SdResId( BMP_TAB_PAGEMODE_H ) ), IMAGE_STDBTN_COLOR_HC ), BMP_COLOR_HIGHCONTRAST );
/*N*/ 	aPageBtn.SetClickHdl(LINK(this, SdDrawViewShell, TabModeBtnHdl));
/*N*/ 	aPageBtn.SetQuickHelpText( String( SdResId( STR_PAGEMODE ) ) );
/*N*/ 	aPageBtn.SetHelpId( HID_SD_BTN_PAGE );
/*N*/ 	aPageBtn.SetAccessibleName (String(SdResId(STR_PAGEMODE)));
/*N*/ 	aPageBtn.Show();
/*N*/ 
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 //STRIP001 /*N*/ 	aMasterPageBtn.SetImage( Image( Bitmap( SdResId( BMP_TAB_MASTERPAGE ) ), IMAGE_STDBTN_COLOR ) );
//STRIP001 /*N*/ 	aMasterPageBtn.SetModeImage( Image( Bitmap( SdResId( BMP_TAB_MASTERPAGE_H ) ), IMAGE_STDBTN_COLOR_HC ), BMP_COLOR_HIGHCONTRAST );
/*N*/ 	aMasterPageBtn.SetClickHdl(LINK(this, SdDrawViewShell, TabModeBtnHdl));
/*N*/ 	aMasterPageBtn.SetQuickHelpText( String( SdResId( STR_MASTERPAGEMODE ) ) );
/*N*/ 	aMasterPageBtn.SetHelpId( HID_SD_BTN_MASTERPAGE );
/*N*/ 	aMasterPageBtn.SetAccessibleName (String(SdResId(STR_MASTERPAGEMODE)));
/*N*/ 	aMasterPageBtn.Show();
/*N*/ 
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 //STRIP001 /*N*/ 	aLayerBtn.SetImage( Image( Bitmap( SdResId( BMP_TAB_LAYERMODE ) ), IMAGE_STDBTN_COLOR ) );
//STRIP001 /*N*/ 	aLayerBtn.SetModeImage( Image( Bitmap( SdResId( BMP_TAB_LAYERMODE_H ) ), IMAGE_STDBTN_COLOR_HC ), BMP_COLOR_HIGHCONTRAST );
/*N*/ 	aLayerBtn.SetClickHdl(LINK(this, SdDrawViewShell, TabModeBtnHdl));
/*N*/ 	aLayerBtn.SetQuickHelpText( String( SdResId( STR_LAYERMODE ) ) );
/*N*/ 	aLayerBtn.SetHelpId( HID_SD_BTN_LAYER );
/*N*/ 	aLayerBtn.SetAccessibleName (String(SdResId(STR_LAYERMODE)));
/*N*/ 	aLayerBtn.Show();
/*N*/ 
/*N*/ 	// Damit der richtige EditMode von der FrameView komplett eingestellt
/*N*/ 	// werden kann, wird hier ein aktuell anderer gewaehlt (kleiner Trick)
/*N*/ 	if (pFrameView->GetViewShEditMode(ePageKind) == EM_PAGE)
/*N*/ 	{
/*N*/ 		eEditMode = EM_MASTERPAGE;
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		eEditMode = EM_PAGE;
/*N*/ 	}
/*N*/ 
/*N*/ 	// Einstellungen der FrameView uebernehmen
/*N*/ 	ReadFrameViewData(pFrameView);
/*N*/ 
/*N*/ 	if( eDocType == DOCUMENT_TYPE_DRAW )
/*N*/ 	{
/*N*/ 		SetHelpId( SD_IF_SDGRAPHICVIEWSHELL );
/*N*/ 		pWindow->SetHelpId( SD_IF_SDGRAPHICVIEWSHELL );
/*N*/ 		pWindow->SetUniqueId( SD_IF_SDGRAPHICVIEWSHELL );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		if (ePageKind == PK_NOTES)
/*N*/ 		{
/*?*/ 			aNotesBtn.Check(TRUE);
/*?*/ 			aLayerBtn.Disable();
/*?*/ 			SetHelpId( SID_NOTESMODE );
/*?*/ 			pWindow->SetHelpId( SID_NOTESMODE );
/*?*/ 			pWindow->SetUniqueId( SID_NOTESMODE );
/*?*/ 
/*?*/ 			// AutoLayouts muessen erzeugt sein
/*?*/ 			pDoc->StopWorkStartupDelay();
/*N*/ 		}
/*N*/ 		else if (ePageKind == PK_HANDOUT)
/*N*/ 		{
/*?*/ 			aHandoutBtn.Check(TRUE);
/*?*/ 			aPageBtn.Disable();
/*?*/ 			aLayerBtn.Disable();
/*?*/ 			SetHelpId( SID_HANDOUTMODE );
/*?*/ 			pWindow->SetHelpId( SID_HANDOUTMODE );
/*?*/ 			pWindow->SetUniqueId( SID_HANDOUTMODE );
/*?*/ 
/*?*/ 			// AutoLayouts muessen erzeugt sein
/*?*/ 			pDoc->StopWorkStartupDelay();
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/ 			aDrawBtn.Check(TRUE);
/*N*/ 			SetHelpId( SD_IF_SDDRAWVIEWSHELL );
/*N*/ 			pWindow->SetHelpId( SD_IF_SDDRAWVIEWSHELL );
/*N*/ 			pWindow->SetUniqueId( SD_IF_SDDRAWVIEWSHELL );
/*N*/ 		}
/*N*/ 	}

	// Selektionsfunktion starten
/*N*/ 	SfxRequest aReq(SID_OBJECT_SELECT, 0, pDoc->GetItemPool());
/*N*/ 	FuPermanent(aReq);
/*N*/ 	pDrView->SetFrameDragSingles(TRUE);
/*N*/ 
/*N*/ 	if (pDocSh->GetCreateMode() == SFX_CREATE_MODE_EMBEDDED)
/*N*/ 	{
/*N*/ 		bZoomOnPage = FALSE;
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		bZoomOnPage = TRUE;
/*N*/ 	}
/*N*/ 
/*N*/ 	bIsRulerDrag = FALSE;
/*N*/ 
/*N*/ 	String aName( RTL_CONSTASCII_USTRINGPARAM( "DrawView" ));
/*N*/ 	SetName (aName);
/*N*/ 
/*N*/ 	if (pFrameView->GetPresentationViewShellId() != SID_VIEWSHELL0)
/*?*/ 	{
		// Die Praesentation ist aus einer anderen ViewShell angewaehlt worden,
		// daraufhin wird zum Zeichentisch (SID_VIEWSHELL0) verzweigt und
		// die Praesentation wird gestartet.
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SfxAllItemSet aSet(pDoc->GetItemPool());
//STRIP001 /*?*/ 		SfxRequest aReq(pFrameView->GetSlotId(), 0, aSet);
//STRIP001 /*?*/ 		FuSupport(aReq);
/*?*/ 	}

/*N*/ 	nLockCount = 0UL;
/*N*/ 
/*N*/ 	::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory > xMgr( ::legacy_binfilters::getLegacyProcessServiceFactory() );
/*N*/ 
/*N*/ 	if( xMgr.is() )
/*N*/ 	{
/*N*/ 		mxScannerManager = ::com::sun::star::uno::Reference< ::com::sun::star::scanner::XScannerManager >(
/*N*/ 						   xMgr->createInstance( ::rtl::OUString::createFromAscii( "com.sun.star.scanner.ScannerManager" ) ),
/*N*/ 						   ::com::sun::star::uno::UNO_QUERY );
/*N*/ 
/*N*/ 		if( mxScannerManager.is() )
/*N*/ 		{
/*N*/ 			mxScannerListener = ::com::sun::star::uno::Reference< ::com::sun::star::lang::XEventListener >(
/*N*/ 								static_cast< ::cppu::OWeakObject* >( new ScannerEventListener( this ) ),
/*N*/ 								::com::sun::star::uno::UNO_QUERY );
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	pController = new SdUnoDrawView(pView, this);
/*N*/ 
/*N*/ 	uno::Reference< awt::XWindow > aTmpRef;
/*N*/ 	GetViewFrame()->GetFrame()->GetFrameInterface()->setComponent( aTmpRef, pController );
/*N*/ 
/*N*/ }

/*************************************************************************
|*
|* pruefe ob linienzuege gezeichnet werden muessen
|*
\************************************************************************/

/*
	linienzuege werden ueber makros als folge von
		MoveTo (x, y)
		LineTo (x, y)	[oder BezierTo (x, y)]
		LineTo (x, y)
			:
	dargestellt. einen endbefehl fuer die linienzuege
	gibt es nicht, also muessen alle befehle in den
	requests nach LineTo (BezierTo) abgetestet und die
	punktparameter gesammelt werden.
	der erste nicht-LineTo fuehrt dann dazu, dass aus
	den gesammelten punkten der linienzug erzeugt wird
*/

/*N*/ void SdDrawViewShell::CheckLineTo (SfxRequest& rReq)
/*N*/ {
/*N*/ 	if (rReq.IsAPI ())
/*?*/ 		if ((rReq.GetSlot () == SID_LINETO) || (rReq.GetSlot () == SID_BEZIERTO))
/*?*/ 		{
/*?*/ 			if ((bLastWasLineTo && (rReq.GetSlot () == SID_LINETO)) ||
/*?*/ 				(bLastWasBezierTo && (rReq.GetSlot () == SID_BEZIERTO)) ||
/*?*/ 				bLastWasMoveTo)
/*?*/ 			{
/*?*/ 				const SfxItemSet* pArgs = rReq.GetArgs ();
/*?*/ 
/*?*/ 				if (pArgs)
/*?*/ 					if (pArgs->Count () == 2)
/*?*/ 					{
/*?*/ 						SFX_REQUEST_ARG (rReq, pMouseStartX, SfxUInt32Item, ID_VAL_MOUSEEND_X, FALSE);
/*?*/ 						SFX_REQUEST_ARG (rReq, pMouseStartY, SfxUInt32Item, ID_VAL_MOUSEEND_Y, FALSE);
/*?*/ 
/*?*/ 						Point aTempPoint (pMouseStartX->GetValue (), pMouseStartY->GetValue ());
/*?*/ 						if (nPolygonIndex < 30) pXPolygon->Insert (nPolygonIndex ++, aTempPoint, XPOLY_NORMAL);
/*?*/ 
/*?*/ 						bLastWasLineTo	 = (rReq.GetSlot () == SID_LINETO);
/*?*/ 						bLastWasBezierTo = (rReq.GetSlot () == SID_BEZIERTO);
/*?*/ 						bLastWasMoveTo	 = FALSE;
/*?*/ 					}
/*?*/ 					else DestroyPolygons ();
/*?*/ 				else DestroyPolygons ();
/*?*/ 			}
/*?*/ 			else DestroyPolygons ();
/*?*/ 		}
/*?*/ 		else
/*?*/ 		{
/*?*/ 			if (bLastWasLineTo || bLastWasBezierTo)
/*?*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SdrPageView *pPV = pDrView->GetPageViewPvNum (0);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				pDrView->InsertObject (new SdrPathObj (bLastWasLineTo
//STRIP001 /*?*/ 														   ? OBJ_PLIN
//STRIP001 /*?*/ 														   : OBJ_PATHLINE, *pXPolygon), *pPV, SDRINSERT_SETDEFLAYER);
//STRIP001 /*?*/ 				if (bLastWasBezierTo) pDrView->ConvertMarkedToPathObj(FALSE);
//STRIP001 /*?*/ 				DestroyPolygons ();
/*?*/ 			}
/*?*/ 
/*?*/ 			if (rReq.GetSlot () == SID_MOVETO)
/*?*/ 			{
/*?*/ 				const SfxItemSet* pArgs = rReq.GetArgs ();
/*?*/ 
/*?*/ 				if (pArgs)
/*?*/ 					if (pArgs->Count () == 2)
/*?*/ 					{
/*?*/ 						SFX_REQUEST_ARG (rReq, pMouseStartX, SfxUInt32Item, ID_VAL_MOUSESTART_X, FALSE);
/*?*/ 						SFX_REQUEST_ARG (rReq, pMouseStartY, SfxUInt32Item, ID_VAL_MOUSESTART_Y, FALSE);
/*?*/ 
/*?*/ 						nPolygonIndex = 0;
/*?*/ 						Point aTempPoint (pMouseStartX->GetValue (), pMouseStartY->GetValue ());
/*?*/ 						pXPolygon->Insert (nPolygonIndex ++, aTempPoint, XPOLY_NORMAL);
/*?*/ 
/*?*/ 						bLastWasMoveTo = TRUE;
/*?*/ 					}
/*?*/ 					else DestroyPolygons ();
/*?*/ 				else DestroyPolygons ();
/*?*/ 			}
/*?*/ 			else bLastWasMoveTo = FALSE;
/*?*/ 		}
/*N*/ 
/*N*/ 	rReq.Ignore ();
/*N*/ }

/*************************************************************************
|*
|* loesche alle polygone, wenn noetig
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::DestroyPolygons ()
/*N*/ {
/*N*/ 	if (nPolygonIndex)
/*?*/ 	{
/*?*/ 		if (pXPolygon) delete pXPolygon;
		pXPolygon	   = new XPolygon;
		nPolygonIndex  = 0;
		bLineError	   =
		bLastWasLineTo =
		bLastWasBezierTo =
		bLastWasMoveTo = FALSE;
/*?*/ 	}
/*N*/ }

/*************************************************************************
|*
|* veraendere die seitemparameter, wenn SID_PAGESIZE oder SID_PAGEMARGIN
|*
\************************************************************************/

//STRIP001 void SdDrawViewShell::SetupPage (Size &rSize,
//STRIP001 								 long nLeft,
//STRIP001 								 long nRight,
//STRIP001 								 long nUpper,
//STRIP001 								 long nLower,
//STRIP001 								 BOOL bSize,
//STRIP001 								 BOOL bMargin,
//STRIP001 								 BOOL bScaleAll)
//STRIP001 {
//STRIP001 	USHORT nPageCnt = pDoc->GetMasterSdPageCount(ePageKind);
//STRIP001 	USHORT i;
//STRIP001 
//STRIP001 	for (i = 0; i < nPageCnt; i++)
//STRIP001 	{
//STRIP001 		/**********************************************************************
//STRIP001 		* Erst alle MasterPages bearbeiten
//STRIP001 		**********************************************************************/
//STRIP001 		SdPage *pPage = pDoc->GetMasterSdPage(i, ePageKind);
//STRIP001 
//STRIP001 		if( pPage )
//STRIP001 		{
//STRIP001 			const SfxPoolItem *pPoolItem = NULL;
//STRIP001 
//STRIP001 			if( bSize )
//STRIP001 			{
//STRIP001 				Rectangle aBorderRect(nLeft, nUpper, nRight, nLower);
//STRIP001 				pPage->ScaleObjects(rSize, aBorderRect, bScaleAll);
//STRIP001 				pPage->SetSize(rSize);
//STRIP001 
//STRIP001 			}
//STRIP001 			if( bMargin )
//STRIP001 			{
//STRIP001 				pPage->SetLftBorder(nLeft);
//STRIP001 				pPage->SetRgtBorder(nRight);
//STRIP001 				pPage->SetUppBorder(nUpper);
//STRIP001 				pPage->SetLwrBorder(nLower);
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( ePageKind == PK_STANDARD )
//STRIP001 			{
//STRIP001 				pDoc->GetMasterSdPage(i, PK_NOTES)->CreateTitleAndLayout();
//STRIP001 			}
//STRIP001 
//STRIP001 			pPage->CreateTitleAndLayout();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	nPageCnt = pDoc->GetSdPageCount(ePageKind);
//STRIP001 
//STRIP001 	for (i = 0; i < nPageCnt; i++)
//STRIP001 	{
//STRIP001 		/**********************************************************************
//STRIP001 		* Danach alle Pages bearbeiten
//STRIP001 		**********************************************************************/
//STRIP001 		SdPage *pPage = pDoc->GetSdPage(i, ePageKind);
//STRIP001 
//STRIP001 		if( pPage )
//STRIP001 		{
//STRIP001 			if( bSize )
//STRIP001 			{
//STRIP001 				Rectangle aBorderRect(nLeft, nUpper, nRight, nLower);
//STRIP001 				pPage->ScaleObjects(rSize, aBorderRect, bScaleAll);
//STRIP001 				pPage->SetSize(rSize);
//STRIP001 			}
//STRIP001 			if( bMargin )
//STRIP001 			{
//STRIP001 				pPage->SetLftBorder(nLeft);
//STRIP001 				pPage->SetRgtBorder(nRight);
//STRIP001 				pPage->SetUppBorder(nUpper);
//STRIP001 				pPage->SetLwrBorder(nLower);
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( ePageKind == PK_STANDARD )
//STRIP001 			{
//STRIP001 				SdPage* pNotesPage = pDoc->GetSdPage(i, PK_NOTES);
//STRIP001 				pNotesPage->SetAutoLayout( pNotesPage->GetAutoLayout() );
//STRIP001 			}
//STRIP001 
//STRIP001 			pPage->SetAutoLayout( pPage->GetAutoLayout() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( ePageKind == PK_STANDARD )
//STRIP001 	{
//STRIP001 		SdPage* pHandoutPage = pDoc->GetSdPage(0, PK_HANDOUT);
//STRIP001 		pHandoutPage->CreateTitleAndLayout(TRUE);
//STRIP001 	}
//STRIP001 
//STRIP001 	long nWidth = pActualPage->GetSize().Width();
//STRIP001 	long nHeight = pActualPage->GetSize().Height();
//STRIP001 
//STRIP001 	Point aPageOrg = Point(nWidth, nHeight / 2);
//STRIP001 	Size aViewSize = Size(nWidth * 3, nHeight * 2);
//STRIP001 
//STRIP001 	InitWindows(aPageOrg, aViewSize, Point(-1, -1), TRUE);
//STRIP001 //	  GetView()->SetWorkArea(Rectangle(Point(0,0) - aPageOrg, aViewSize));
//STRIP001 
//STRIP001 	Point aVisAreaPos;
//STRIP001 
//STRIP001 	if ( pDocSh->GetCreateMode() == SFX_CREATE_MODE_EMBEDDED )
//STRIP001 	{
//STRIP001 		aVisAreaPos = pDocSh->GetVisArea(ASPECT_CONTENT).TopLeft();
//STRIP001 	}
//STRIP001 
//STRIP001 	GetView()->SetWorkArea(Rectangle(Point() - aVisAreaPos - aPageOrg, aViewSize));
//STRIP001 
//STRIP001 	UpdateScrollBars();
//STRIP001 
//STRIP001 	Point aNewOrigin(pActualPage->GetLftBorder(), pActualPage->GetUppBorder());
//STRIP001 	GetView()->GetPageViewPvNum(0)->SetPageOrigin(aNewOrigin);
//STRIP001 
//STRIP001 	GetViewFrame()->GetBindings().Invalidate(SID_RULER_NULL_OFFSET);
//STRIP001 
//STRIP001 	// auf (neue) Seitengroesse zoomen
//STRIP001 	GetViewFrame()->GetDispatcher()->Execute(SID_SIZE_PAGE,
//STRIP001 						SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 }

/*************************************************************************
|*
|* Statuswerte der Statusbar zurueckgeben
|*
\************************************************************************/

//STRIP001 void SdDrawViewShell::GetStatusBarState(SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	// Zoom-Item
//STRIP001 	// Hier sollte der entsprechende Wert (Optimal ?, Seitenbreite oder
//STRIP001 	// Seite) mit Hilfe des ZoomItems weitergegeben werden !!!
//STRIP001 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_ATTR_ZOOM ) )
//STRIP001 	{
//STRIP001 		if (pDocSh->IsUIActive() || pFuSlideShow)
//STRIP001 		{
//STRIP001 			rSet.DisableItem( SID_ATTR_ZOOM );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			SvxZoomItem* pZoomItem;
//STRIP001 			UINT16 nZoom = (UINT16) pWindow->GetZoom();
//STRIP001 
//STRIP001 			if( bZoomOnPage )
//STRIP001 				pZoomItem = new SvxZoomItem( SVX_ZOOM_WHOLEPAGE, nZoom );
//STRIP001 			else
//STRIP001 				pZoomItem = new SvxZoomItem( SVX_ZOOM_PERCENT, nZoom );
//STRIP001 
//STRIP001 			// Bereich einschraenken
//STRIP001 			USHORT nZoomValues = SVX_ZOOM_ENABLE_ALL;
//STRIP001 			SdrPageView* pPageView = pDrView->GetPageViewPvNum( 0 );
//STRIP001 
//STRIP001 			if( ( pPageView && pPageView->GetObjList()->GetObjCount() == 0 ) )
//STRIP001 				// || ( pDrView->GetMarkList().GetMarkCount() == 0 ) )
//STRIP001 			{
//STRIP001 				nZoomValues &= ~SVX_ZOOM_ENABLE_OPTIMAL;
//STRIP001 			}
//STRIP001 
//STRIP001 			pZoomItem->SetValueSet( nZoomValues );
//STRIP001 			rSet.Put( *pZoomItem );
//STRIP001 			delete pZoomItem;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	Point aPos = pWindow->PixelToLogic(aMousePos);
//STRIP001 	pDrView->GetPageViewPvNum(0)->LogicToPagePos(aPos);
//STRIP001 	Fraction aUIScale(pDoc->GetUIScale());
//STRIP001 	aPos.X() = Fraction(aPos.X()) / aUIScale;
//STRIP001 	aPos.Y() = Fraction(aPos.Y()) / aUIScale;
//STRIP001 
//STRIP001 	// Position- und Groesse-Items
//STRIP001 	if ( pDrView->IsAction() )
//STRIP001 	{
//STRIP001 		Rectangle aRect;
//STRIP001 		pDrView->TakeActionRect( aRect );
//STRIP001 
//STRIP001 		if ( aRect.IsEmpty() )
//STRIP001 			rSet.Put( SfxPointItem(SID_ATTR_POSITION, aPos) );
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pDrView->GetPageViewPvNum(0)->LogicToPagePos(aRect);
//STRIP001 			aPos = aRect.TopLeft();
//STRIP001 			aPos.X() = Fraction(aPos.X()) / aUIScale;
//STRIP001 			aPos.Y() = Fraction(aPos.Y()) / aUIScale;
//STRIP001 			rSet.Put( SfxPointItem( SID_ATTR_POSITION, aPos) );
//STRIP001 			Size aSize( aRect.Right() - aRect.Left(), aRect.Bottom() - aRect.Top() );
//STRIP001 			aSize.Height() = Fraction(aSize.Height()) / aUIScale;
//STRIP001 			aSize.Width()  = Fraction(aSize.Width())  / aUIScale;
//STRIP001 			rSet.Put( SvxSizeItem( SID_ATTR_SIZE, aSize) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( pDrView->HasMarkedObj() )
//STRIP001 		{
//STRIP001 			Rectangle aRect = pDrView->GetAllMarkedRect();
//STRIP001 			pDrView->GetPageViewPvNum(0)->LogicToPagePos(aRect);
//STRIP001 
//STRIP001             // Show the position of the selected shape(s)
//STRIP001             Point aShapePosition (aRect.TopLeft());
//STRIP001             aShapePosition.X() = Fraction(aShapePosition.X()) / aUIScale;
//STRIP001             aShapePosition.Y() = Fraction(aShapePosition.Y()) / aUIScale;
//STRIP001             rSet.Put (SfxPointItem(SID_ATTR_POSITION, aShapePosition));
//STRIP001     
//STRIP001 			Size aSize( aRect.Right() - aRect.Left(), aRect.Bottom() - aRect.Top() );
//STRIP001 			aSize.Height() = Fraction(aSize.Height()) / aUIScale;
//STRIP001 			aSize.Width()  = Fraction(aSize.Width())  / aUIScale;
//STRIP001 			rSet.Put( SvxSizeItem( SID_ATTR_SIZE, aSize) );
//STRIP001 		}
//STRIP001 		else
//STRIP001         {
//STRIP001             rSet.Put( SfxPointItem(SID_ATTR_POSITION, aPos) );
//STRIP001 			rSet.Put( SvxSizeItem( SID_ATTR_SIZE, Size( 0, 0 ) ) );
//STRIP001         }
//STRIP001 	}
//STRIP001 
//STRIP001 	// Display of current page and layer.
//STRIP001 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_STATUS_PAGE ) )
//STRIP001 	{
//STRIP001         // Allways show the slide/page number.
//STRIP001 		String aString (SdResId( STR_SD_PAGE ));
//STRIP001         aString += sal_Unicode(' ');
//STRIP001         aString += UniString::CreateFromInt32( aTabControl.GetCurPageId() );
//STRIP001         aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " / " ));
//STRIP001         aString += UniString::CreateFromInt32( pDoc->GetSdPageCount( ePageKind ) );
//STRIP001 		
//STRIP001         // If in layer mode additionally show the layer that contains all
//STRIP001         // selected shapes of the page.  If the shapes are distributed on
//STRIP001         // more than one layer, no layer name is shown.
//STRIP001 		if( bLayerMode )
//STRIP001 		{
//STRIP001 			SdrLayerAdmin& rLayerAdmin = pDoc->GetLayerAdmin();
//STRIP001 			SdrLayerID nLayer, nOldLayer;
//STRIP001 			SdrLayer*  pLayer = NULL;
//STRIP001 			SdrObject* pObj = NULL;
//STRIP001 			const SdrMarkList& rMarkList = pDrView->GetMarkList();
//STRIP001 			ULONG nMarkCount = rMarkList.GetMarkCount();
//STRIP001 			FASTBOOL bOneLayer = TRUE;
//STRIP001 
//STRIP001             // Use the first ten selected shapes as a (hopefully
//STRIP001             // representative) sample of all shapes of the current page.
//STRIP001             // Detect whether they belong to the same layer.
//STRIP001 			for( ULONG j = 0; j < nMarkCount && bOneLayer && j < 10; j++ )
//STRIP001 			{
//STRIP001 				pObj = rMarkList.GetMark( j )->GetObj();
//STRIP001 				if( pObj )
//STRIP001 				{
//STRIP001 					nLayer = pObj->GetLayer();
//STRIP001 
//STRIP001 					if( j != 0 && nLayer != nOldLayer )
//STRIP001 						bOneLayer = FALSE;
//STRIP001 
//STRIP001 					nOldLayer = nLayer;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001             // Append the layer name to the current page number.
//STRIP001 			if( bOneLayer && nMarkCount )
//STRIP001 			{
//STRIP001 				pLayer = rLayerAdmin.GetLayerPerID( nLayer );
//STRIP001 				if( pLayer )
//STRIP001                 {
//STRIP001                     aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " (" ));
//STRIP001 					aString += pLayer->GetName();
//STRIP001                     aString += sal_Unicode(')');
//STRIP001                 }
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		rSet.Put (SfxStringItem (SID_STATUS_PAGE, aString));
//STRIP001 	}
//STRIP001 	// Layout
//STRIP001 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_STATUS_LAYOUT ) )
//STRIP001 	{
//STRIP001 		String aString = pActualPage->GetLayoutName();
//STRIP001 		aString.Erase( aString.SearchAscii( SD_LT_SEPARATOR ) );
//STRIP001 		rSet.Put( SfxStringItem( SID_STATUS_LAYOUT, aString ) );
//STRIP001 	}
//STRIP001 }


}
