/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_tabview.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:35:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

//------------------------------------------------------------------

#if 0
#define _MACRODLG_HXX
#define _BIGINT_HXX
#define _SVCONTNR_HXX
#define BASIC_NODIALOGS
#define _SFXMNUITEM_HXX
#define _SVDXOUT_HXX
#define _SVDATTR_HXX
#define _SFXMNUITEM_HXX
#define _DLGCFG_HXX
#define _SFXMNUMGR_HXX
#define _SFXBASIC_HXX
#define _MODALDLG_HXX
#define _SFX_TEMPLDLG_HXX
#define _SFXSTBMGR_HXX
#define _SFXTBXMGR_HXX
#define _BASE_DLGS_HXX
#define _SFXIMGMGR_HXX
#define _SFXMNUMGR_HXX
#define _SFXSTBITEM_HXX
#define _SFXTBXCTRL_HXX
#define _PASSWD_HXX
//#define _SFXFILEDLG_HXX
//#define _SFXREQUEST_HXX
#define _SFXOBJFACE_HXX

#define _SDR_NOTRANSFORM
#define _SVDXOUT_HXX
#endif
///////////////////////////////////////////////////////////////////////////
// NODRAW.HXX
// Erweiterte Konstanten, um CLOKs mit SVDRAW.HXX zu vermeiden
// Die u.a. Aenderungen nehmen vorgeschlagene Konstante vorweg
///////////////////////////////////////////////////////////////////////////

#if 0
#define _SDR_NOTRANSFORM		// Transformationen, selten verwendet
#define _SDR_NOTOUCH			// Hit-Tests, selten verwendet

#define	_SDR_NOEXTDEV			// ExtOutputDevice
#define	_SDR_NOUNDO				// Undo-Objekte
#define _SDR_NOSURROGATEOBJ     // SdrObjSurrogate
#define _SDR_NOPAGEOBJ          // SdrPageObj
#define _SDR_NOVIRTOBJ          // SdrVirtObj
#define _SDR_NOGROUPOBJ         // SdrGroupObj
#define _SDR_NOTEXTOBJ          // SdrTextObj
#define _SDR_NOPATHOBJ          // SdrPathObj
#define _SDR_NOEDGEOBJ          // SdrEdgeObj
#define _SDR_NORECTOBJ          // SdrRectObj
#define _SDR_NOCAPTIONOBJ       // SdrCaptionObj
#define _SDR_NOCIRCLEOBJ        // SdrCircleObj
#define _SDR_NOGRAFOBJ          // SdrGrafObj
#define _SDR_NOOLE2OBJ          // SdrOle2Obj
#endif

// Dieses define entfernt die VCControls aus SI.HXX

#define _SI_HXX					// VCControls

////////////////////// Umsetzen der Standard-Defines //////////////////////

#ifdef _SDR_NOEXTDEV
	#define	_SDVXOUT_HXX
	#undef _SDR_NOEXTDEV
#endif

//#define _SVDDRAG_HXX		// SdrDragStat
#define _SVDPAGE_HXX        // SdrPage

#ifdef _SDR_NOSURROGATEOBJ
	#undef _SDR_NOSURROGATEOBJ
	#define _SVDSURO_HXX
#endif

#ifdef _SDR_NOPAGEOBJ
	#undef _SDR_NOPAGEOBJ
	#define _SVDOPAGE_HXX
#endif

#ifdef _SDR_NOVIRTOBJ
	#undef _SDR_NOVIRTOBJ
	#define _SVDOVIRT_HXX
#endif

#ifdef _SDR_NOGROUPOBJ
	#undef _SDR_NOGROUPOBJ
	#define _SVDOGRP_HXX
#endif

#ifdef _SDR_NOTEXTOBJ
	#undef _SDR_NOTEXTOBJ
	#define _SVDOTEXT_HXX
#endif

#ifdef _SDR_NOPATHOBJ
	#undef _SDR_NOPATHOBJ
	#define _SVDOPATH_HXX
#endif

#ifdef _SDR_NOEDGEOBJ
	#undef _SDR_NOEDGEOBJ
	#define _SVDOEDGE_HXX
#endif

#ifdef _SDR_NORECTOBJ
	#undef _SDR_NORECTOBJ
	#define _SVDORECT_HXX
#else
	#undef _SDVOTEXT_OBJ
#endif

#ifdef _SDR_NOCAPTIONOBJ
	#undef _SDR_NOCAPTIONOBJ
	#define _SVDCAPT_HXX
#endif

#ifdef _SDR_NOCIRCLEOBJ
	#undef _SDR_NOCIRCLEOBJ
	#define _SVDOCIRC_HXX
#endif

#ifdef _SDR_NOGRAFOBJ
	#undef _SDR_NOGRAFOBJ
	#define _SVDOGRAF_HXX
#else
	#undef _SVDOTEXT_HXX
	#undef _SVDORECT_HXX
#endif

#ifdef _SDR_NOOLE2OBJ
	#undef _SDR_NOOLE2OBJ
	#define _SVDOOLE2_HXX
#else
	#undef _SVDOTEXT_HXX
	#undef _SVDORECT_HXX
#endif

//#ifdef _SDR_NOVIEWS
//	#define _SVDDRAG_HXX
//#endif

////////////////////// Ende der SVDRAW-Modifikationen /////////////////////

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

// auto strip #include "scitems.hxx"
// auto strip #include <bf_sfx2/ipfrm.hxx>
#include <bf_sfx2/bindings.hxx>
// auto strip #include <vcl/help.hxx>
#include <rtl/logfile.hxx>

// auto strip #include "tabview.hxx"
#include "tabvwsh.hxx"
// auto strip #include "document.hxx"
#include "gridwin.hxx"
#include "olinewin.hxx"
#include "olinetab.hxx"
#include "tabsplit.hxx"
#include "colrowba.hxx"
#include "tabcont.hxx"
// auto strip #include "scmod.hxx"
#include "bf_sc.hrc"
// auto strip #include "viewutil.hxx"
#include "globstr.hrc"
#include "drawview.hxx"
#include "docsh.hxx"
#include "viewuno.hxx"
// auto strip #include "AccessibilityHints.hxx"

#include <string>
#include <algorithm>

#define SPLIT_MARGIN	30
#define SC_ICONSIZE		36

#define SC_SCROLLBAR_MIN	30
#define SC_TABBAR_MIN		6

//	fuer Rad-Maus
#define SC_DELTA_ZOOM	10
namespace binfilter {

// STATIC DATA -----------------------------------------------------------


//==================================================================

//	Corner-Button

/*N*/ ScCornerButton::ScCornerButton( Window* pParent, ScViewData* pData, BOOL bAdditional ) :
/*N*/ 	Window( pParent, WinBits( 0 ) ),
/*N*/ 	pViewData( pData ),
/*N*/ 	bAdd( bAdditional )
/*N*/ {
/*N*/ 	const StyleSettings& rStyleSettings = GetSettings().GetStyleSettings();
/*N*/ 	SetBackground( rStyleSettings.GetFaceColor() );
/*N*/ }

/*N*/ __EXPORT ScCornerButton::~ScCornerButton()
/*N*/ {
/*N*/ }

//STRIP001 void __EXPORT ScCornerButton::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	Size aSize = GetOutputSizePixel();
//STRIP001 	long nPosX = aSize.Width()-1;
//STRIP001 	long nPosY = aSize.Height()-1;
//STRIP001 
//STRIP001 	const StyleSettings& rStyleSettings = GetSettings().GetStyleSettings();
//STRIP001 
//STRIP001 	Window::Paint(rRect);
//STRIP001 
//STRIP001 	//	both buttons have the same look now - only dark right/bottom lines
//STRIP001 	SetLineColor( rStyleSettings.GetDarkShadowColor() );
//STRIP001 	DrawLine( Point(0,nPosY), Point(nPosX,nPosY) );
//STRIP001 	DrawLine( Point(nPosX,0), Point(nPosX,nPosY) );
//STRIP001 }

/*N*/ void ScCornerButton::StateChanged( StateChangedType nType )
/*N*/ {
/*N*/ 	Window::StateChanged( nType );
/*N*/ 
/*N*/ 	const StyleSettings& rStyleSettings = GetSettings().GetStyleSettings();
/*N*/ 	SetBackground( rStyleSettings.GetFaceColor() );
/*N*/ 	Invalidate();
/*N*/ }

// -----------------------------------------------------------------------

//STRIP001 void ScCornerButton::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	Window::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	const StyleSettings& rStyleSettings = GetSettings().GetStyleSettings();
//STRIP001 	SetBackground( rStyleSettings.GetFaceColor() );
//STRIP001 	Invalidate();
//STRIP001 }


/*N*/ void __EXPORT ScCornerButton::Resize()
/*N*/ {
/*N*/ 	Invalidate();
/*N*/ }

//STRIP001 void __EXPORT ScCornerButton::MouseButtonDown( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001 	BOOL bDisable = pScMod->IsFormulaMode() || pScMod->IsModalMode();
//STRIP001 	if (!bDisable)
//STRIP001 	{
//STRIP001 		ScTabViewShell* pViewSh = pViewData->GetViewShell();
//STRIP001 		pViewSh->SetActive();									// Appear und SetViewFrame
//STRIP001 		pViewSh->ActiveGrabFocus();
//STRIP001 
//STRIP001 		BOOL bControl = rMEvt.IsMod1();
//STRIP001 		pViewSh->SelectAll( bControl );
//STRIP001 	}
//STRIP001 }

//==================================================================

/*N*/ BOOL lcl_HasColOutline( const ScViewData& rViewData )
/*N*/ {
/*N*/ 	const ScOutlineTable* pTable = rViewData.GetDocument()->GetOutlineTable(rViewData.GetTabNo());
/*N*/ 	if (pTable)
/*N*/ 	{
/*N*/ 		const ScOutlineArray* pArray = pTable->GetColArray();
/*N*/ 		if ( pArray->GetDepth() > 0 )
/*N*/ 			return TRUE;
/*N*/ 	}
/*N*/ 	return FALSE;
/*N*/ }

/*N*/ BOOL lcl_HasRowOutline( const ScViewData& rViewData )
/*N*/ {
/*N*/ 	const ScOutlineTable* pTable = rViewData.GetDocument()->GetOutlineTable(rViewData.GetTabNo());
/*N*/ 	if (pTable)
/*N*/ 	{
/*N*/ 		const ScOutlineArray* pArray = pTable->GetRowArray();
/*N*/ 		if ( pArray->GetDepth() > 0 )
/*N*/ 			return TRUE;
/*N*/ 	}
/*N*/ 	return FALSE;
/*N*/ }

//==================================================================

//	Init und Konstruktoren
//	ScTabView::Init() in tabview5.cxx wegen out of keys


#define TABVIEW_INIT	\
			aFunctionSet( &aViewData ),										\
			aHdrFunc( &aViewData ),											\
		    aHScrollLeft( pFrameWin, WinBits( WB_HSCROLL | WB_DRAG ) ),		\
		    aHScrollRight( pFrameWin, WinBits( WB_HSCROLL | WB_DRAG ) ),	\
		    aVScrollTop( pFrameWin, WinBits( WB_VSCROLL | WB_DRAG ) ),		\
		    aVScrollBottom( pFrameWin, WinBits( WB_VSCROLL | WB_DRAG ) ),	\
			aCornerButton( pFrameWin, &aViewData, FALSE ),					\
			aTopButton( pFrameWin, &aViewData, TRUE ),						\
			aScrollBarBox( pFrameWin, WB_SIZEABLE ),						\
			pInputHintWindow( NULL ),										\
			pPageBreakData( NULL ),											\
			pHighlightRanges( NULL ),										\
		    bDragging( FALSE ),												\
			bIsBlockMode( FALSE ),											\
			bBlockNeg( FALSE ),												\
			bBlockCols( FALSE ),											\
			bBlockRows( FALSE ),											\
			nTipVisible( 0 ),												\
			pDrawView( NULL ),												\
			bDrawSelMode( FALSE ),											\
			bMinimized( FALSE ),											\
			pTimerWindow( NULL ),											\
			pSelEngine( NULL ),												\
			pHdrSelEng( NULL ),												\
			bInUpdateHeader( FALSE ),										\
			bInActivatePart( FALSE ),										\
			bInZoomUpdate( FALSE ),											\
			bMoveIsShift( FALSE ),											\
			bNewStartIfMarking( FALSE )


/*N*/ ScTabView::ScTabView( Window* pParent, ScDocShell& rDocSh, ScTabViewShell* pViewShell ) :
/*N*/ 			pFrameWin( pParent ),
/*N*/ 			aViewData( &rDocSh, pViewShell ),
/*N*/ 			eZoomType( SVX_ZOOM_PERCENT ),
/*N*/ 			TABVIEW_INIT
/*N*/ {
/*N*/ 	RTL_LOGFILE_CONTEXT_AUTHOR ( aLog, "sc", "nn93723", "ScTabView::ScTabView" );
/*N*/ 
/*N*/ 	Init();
/*N*/ }

/*N*/ ScTabView::ScTabView( Window* pParent, const ScTabView& rScTabView, ScTabViewShell* pViewShell ) :
/*N*/ 			pFrameWin( pParent ),
/*N*/ 			aViewData( rScTabView.aViewData ),
/*N*/ 			eZoomType( rScTabView.eZoomType ),
/*N*/ 			TABVIEW_INIT
/*N*/ {
/*N*/ 	RTL_LOGFILE_CONTEXT_AUTHOR ( aLog, "sc", "nn93723", "ScTabView::ScTabView" );
/*N*/ 
/*N*/ 	aViewData.SetViewShell( pViewShell );
/*N*/ 	Init();
/*N*/ 
/*N*/ 	UpdateShow();
/*N*/ 	if ( aViewData.GetActivePart() != SC_SPLIT_BOTTOMLEFT )
/*N*/ 		pGridWin[SC_SPLIT_BOTTOMLEFT]->Show();
/*N*/ 
/*N*/ 	InvalidateSplit();
/*N*/ }

/*N*/ void ScTabView::InitScrollBar( ScrollBar& rScrollBar, long nMaxVal )
/*N*/ {
/*N*/ 	rScrollBar.SetRange( Range( 0, nMaxVal ) );
/*N*/ 	rScrollBar.SetLineSize( 1 );
/*N*/ 	rScrollBar.SetPageSize( 1 );				// wird getrennt abgefragt
/*N*/ 	rScrollBar.SetVisibleSize( 10 );			// wird bei Resize neu gesetzt
/*N*/ 
/*N*/ 	rScrollBar.SetScrollHdl( LINK(this, ScTabView, ScrollHdl) );
/*N*/ 	rScrollBar.SetEndScrollHdl( LINK(this, ScTabView, EndScrollHdl) );
/*N*/ }

//	Scroll-Timer

//STRIP001 void ScTabView::SetTimer( ScGridWindow* pWin, const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	pTimerWindow = pWin;
//STRIP001 	aTimerMEvt   = rMEvt;
//STRIP001 	aScrollTimer.Start();
//STRIP001 }

//STRIP001 void ScTabView::ResetTimer()
//STRIP001 {
//STRIP001 	aScrollTimer.Stop();
//STRIP001 	pTimerWindow = NULL;
//STRIP001 }

IMPL_LINK( ScTabView, TimerHdl, Timer*, pTimer )
{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	DBG_ASSERT( pTimer == &aScrollTimer, "Unbekannter Timer" );
//STRIP001 
//STRIP001 //	aScrollTimer.Stop();
//STRIP001 	if (pTimerWindow)
//STRIP001 		pTimerWindow->MouseMove( aTimerMEvt );
//STRIP001 
	return 0;
}

// --- Resize ---------------------------------------------------------------------

/*N*/ void ScTabView::DoResize( const Point& rOffset, const Size& rSize, BOOL bInner )
/*N*/ {
/*N*/ 	HideListBox();
/*N*/ 
/*N*/ 	BOOL bHasHint = ( pInputHintWindow != NULL );
/*N*/ 	if (bHasHint)
/*N*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 		RemoveHintWindow();
/*N*/ 
/*N*/ 	BOOL bVScroll	 = aViewData.IsVScrollMode();
/*N*/ 	BOOL bHScroll	 = aViewData.IsHScrollMode();
/*N*/ 	BOOL bTabControl = aViewData.IsTabMode();
/*N*/ 	BOOL bHeaders	 = aViewData.IsHeaderMode();
/*N*/ 	BOOL bOutlMode	 = aViewData.IsOutlineMode();
/*N*/ 	BOOL bHOutline	 = bOutlMode && lcl_HasColOutline(aViewData);
/*N*/ 	BOOL bVOutline	 = bOutlMode && lcl_HasRowOutline(aViewData);
/*N*/ 
/*N*/ 	//	Scrollbar-Einstellungen koennen vom Sfx ueberschrieben werden:
/*N*/ 	SfxScrollingMode eMode = aViewData.GetViewShell()->GetScrollingMode();
/*N*/ 	if ( eMode == SCROLLING_NO )
/*N*/ 		bHScroll = bVScroll = FALSE;
/*N*/ 	else if ( eMode == SCROLLING_YES || eMode == SCROLLING_AUTO )	//! Auto ???
/*N*/ 		bHScroll = bVScroll = TRUE;
/*N*/ 
/*N*/ 	if ( aViewData.GetDocShell()->IsPreview() )
/*N*/ 		bHScroll = bVScroll = bTabControl = bHeaders = bOutlMode = bHOutline = bVOutline = FALSE;
/*N*/ 
/*N*/ 	long nBarX = 0;
/*N*/ 	long nBarY = 0;
/*N*/ 	long nOutlineX;
/*N*/ 	long nOutlineY;
/*N*/ 	long nOutPosX;
/*N*/ 	long nOutPosY;
/*N*/ 
/*N*/ 	long nPosX = rOffset.X();
/*N*/ 	long nPosY = rOffset.Y();
/*N*/ 	long nSizeX = rSize.Width();
/*N*/ 	long nSizeY = rSize.Height();
/*N*/ 	long nSize1;
/*N*/ 
/*N*/ 	bMinimized = ( nSizeX<=SC_ICONSIZE || nSizeY<=SC_ICONSIZE );
/*N*/ 	if ( bMinimized )
/*N*/ 		return;
/*N*/ 		  
/*N*/ 	long nSplitSizeX = SPLIT_HANDLE_SIZE;
/*N*/ 	if ( aViewData.GetHSplitMode() == SC_SPLIT_FIX )
/*N*/ 		nSplitSizeX = 1;
/*N*/ 	long nSplitSizeY = SPLIT_HANDLE_SIZE;
/*N*/ 	if ( aViewData.GetVSplitMode() == SC_SPLIT_FIX )
/*?*/ 		nSplitSizeY = 1;
/*?*/ 
/*N*/ 	const long nOverlap = 0;	// ScrollBar::GetWindowOverlapPixel();
/*N*/ 
/*N*/ 	aBorderPos = rOffset;
/*N*/ 	aFrameSize = rSize;
/*N*/ 
/*N*/ 	if ( aViewData.GetHSplitMode() != SC_SPLIT_NONE )
/*?*/ 		if ( aViewData.GetHSplitPos() > nSizeX - SPLIT_MARGIN )
/*?*/ 		{
/*?*/ 			aViewData.SetHSplitMode( SC_SPLIT_NONE );
/*?*/ 			if ( WhichH( aViewData.GetActivePart() ) == SC_SPLIT_RIGHT )
/*?*/  			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 			ActivatePart( SC_SPLIT_BOTTOMLEFT );
/*?*/ 			InvalidateSplit();
/*?*/ //			UpdateShow();
/*?*/ 		}
/*N*/ 	if ( aViewData.GetVSplitMode() != SC_SPLIT_NONE )
/*?*/ 		if ( aViewData.GetVSplitPos() > nSizeY - SPLIT_MARGIN )
/*?*/ 		{
/*?*/ 			aViewData.SetVSplitMode( SC_SPLIT_NONE );
/*?*/ 			if ( WhichV( aViewData.GetActivePart() ) == SC_SPLIT_TOP )
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 	ActivatePart( SC_SPLIT_BOTTOMLEFT );
/*?*/ 			InvalidateSplit();
/*?*/ //			UpdateShow();
/*N*/ 		}
/*N*/ 
/*N*/ 	UpdateShow();
/*N*/ 
/*N*/ 	if (bHScroll || bVScroll)		// Scrollbars horizontal oder vertikal
/*N*/ 	{
/*N*/ 		long nScrollBarSize = pFrameWin->GetSettings().GetStyleSettings().GetScrollBarSize();
/*N*/ 		if (bVScroll)
/*N*/ 		{
/*N*/ //			nBarX = aVScrollBottom.GetSizePixel().Width();
/*N*/ 			nBarX = nScrollBarSize;
/*N*/ 			nSizeX -= nBarX - nOverlap;
/*N*/ 		}
/*N*/ 		if (bHScroll)
/*N*/ 		{
/*N*/ //			nBarY = aHScrollLeft.GetSizePixel().Height();
/*N*/ 			nBarY = nScrollBarSize;
/*N*/ 			nSizeY -= nBarY - nOverlap;
/*N*/ 		}
/*N*/ 
/*N*/ 		//	Fenster rechts unten
/*N*/ 		aScrollBarBox.SetPosSizePixel( Point( nPosX+nSizeX, nPosY+nSizeY ), Size( nBarX, nBarY ) );
/*N*/ 
/*N*/ 		if (bHScroll)								// Scrollbars horizontal
/*N*/ 		{
/*N*/ 			long nSizeLt;			// linker Scrollbar
/*N*/ 			long nSizeRt;			// rechter Scrollbar
/*N*/ 			long nSizeSp;			// Splitter
/*N*/ 
/*N*/ 			switch (aViewData.GetHSplitMode())
/*N*/ 			{
/*N*/ 				case SC_SPLIT_NONE:
/*N*/ 					nSizeSp = nSplitSizeX;
/*N*/ 					nSizeLt = nSizeX - nSizeSp + nOverlap;			// Ecke ueberdecken
/*N*/ 					break;
/*N*/ 				case SC_SPLIT_NORMAL:
/*N*/ 					nSizeSp = nSplitSizeX;
/*N*/ 					nSizeLt = aViewData.GetHSplitPos();
/*N*/ 					break;
/*N*/ 				case SC_SPLIT_FIX:
/*N*/ 					nSizeSp = 0;
/*N*/ 					nSizeLt = 0;
/*N*/ 					break;
/*N*/ 			}
/*N*/ 			nSizeRt = nSizeX - nSizeLt - nSizeSp;
/*N*/ 
/*N*/ 			long nTabSize = 0;
/*N*/ 			if (bTabControl)
/*N*/ 			{
/*N*/ 				nTabSize = pTabControl->GetSizePixel().Width()-nOverlap;
/*N*/ 
/*N*/ 				if ( aViewData.GetHSplitMode() != SC_SPLIT_FIX )	// bei linkem Scrollbar
/*N*/ 				{
/*N*/ 					if (nTabSize > nSizeLt-SC_SCROLLBAR_MIN) nTabSize = nSizeLt-SC_SCROLLBAR_MIN;
/*N*/ 					if (nTabSize < SC_TABBAR_MIN) nTabSize = SC_TABBAR_MIN;
/*N*/ 					nSizeLt -= nTabSize;
/*N*/ 				}
/*N*/ 				else												// bei rechtem Scrollbar
/*N*/ 				{
/*N*/ 					if (nTabSize > nSizeRt-SC_SCROLLBAR_MIN) nTabSize = nSizeRt-SC_SCROLLBAR_MIN;
/*N*/ 					if (nTabSize < SC_TABBAR_MIN) nTabSize = SC_TABBAR_MIN;
/*N*/ 					nSizeRt -= nTabSize;
/*N*/ 				}
/*N*/ 			}
/*N*/ 
/*N*/ 			pTabControl->SetPosSizePixel( Point(nPosX-nOverlap, nPosY+nSizeY),
/*N*/ 												Size(nTabSize+nOverlap, nBarY) );
/*N*/ 
/*N*/ 			aHScrollLeft.SetPosSizePixel( Point(nPosX+nTabSize-nOverlap, nPosY+nSizeY),
/*N*/ 												Size(nSizeLt+2*nOverlap, nBarY) );
/*N*/ 			pHSplitter->SetPosPixel( Point( nPosX+nTabSize+nSizeLt, nPosY+nSizeY ) );
/*N*/ 			aHScrollRight.SetPosSizePixel( Point(nPosX+nTabSize+nSizeLt+nSizeSp-nOverlap,
/*N*/ 													nPosY+nSizeY),
/*N*/ 											Size(nSizeRt+2*nOverlap, nBarY) );
/*N*/ 
/*N*/ 			pHSplitter->SetSizePixel( Size( nSizeSp, nBarY ) );
/*N*/ 			//	SetDragRectPixel ist unten
/*N*/ 		}
/*N*/ 
/*N*/ 		if (bVScroll)								// Scrollbars vertikal
/*N*/ 		{
/*N*/ 			long nSizeUp;			// oberer Scrollbar
/*N*/ 			long nSizeSp;			// Splitter
/*N*/ 			long nSizeDn;			// unterer Scrollbar
/*N*/ 
/*N*/ 			switch (aViewData.GetVSplitMode())
/*N*/ 			{
/*N*/ 				case SC_SPLIT_NONE:
/*N*/ 					nSizeUp = 0;
/*N*/ 					nSizeSp = nSplitSizeY;
/*N*/ 					break;
/*N*/ 				case SC_SPLIT_NORMAL:
/*N*/ 					nSizeUp = aViewData.GetVSplitPos();
/*N*/ 					nSizeSp = nSplitSizeY;
/*N*/ 					break;
/*N*/ 				case SC_SPLIT_FIX:
/*N*/ 					nSizeUp = 0;
/*N*/ 					nSizeSp = 0;
/*N*/ 					break;
/*N*/ 			}
/*N*/ 			nSizeDn = nSizeY - nSizeUp - nSizeSp;
/*N*/ 
/*N*/ 			aVScrollTop.SetPosSizePixel( Point(nPosX+nSizeX, nPosY-nOverlap),
/*N*/ 											Size(nBarX,nSizeUp+2*nOverlap) );
/*N*/ 			pVSplitter->SetPosPixel( Point( nPosX+nSizeX, nPosY+nSizeUp ) );
/*N*/ 			aVScrollBottom.SetPosSizePixel( Point(nPosX+nSizeX,
/*N*/ 												nPosY+nSizeUp+nSizeSp-nOverlap),
/*N*/ 											Size(nBarX, nSizeDn+2*nOverlap) );
/*N*/ 
/*N*/ 			pVSplitter->SetSizePixel( Size( nBarX, nSizeSp ) );
/*N*/ 			//	SetDragRectPixel ist unten
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	//	SetDragRectPixel auch ohne Scrollbars etc., wenn schon gesplittet ist
/*N*/ 	if ( bHScroll || aViewData.GetHSplitMode() != SC_SPLIT_NONE )
/*N*/ 		pHSplitter->SetDragRectPixel(
/*N*/ 			Rectangle( nPosX, nPosY, nPosX+nSizeX, nPosY+nSizeY ), pFrameWin );
/*N*/ 	if ( bVScroll || aViewData.GetVSplitMode() != SC_SPLIT_NONE )
/*N*/ 		pVSplitter->SetDragRectPixel(
/*N*/ 			Rectangle( nPosX, nPosY, nPosX+nSizeX, nPosY+nSizeY ), pFrameWin );
/*N*/ 
/*N*/ 	if (bTabControl && ! bHScroll )
/*N*/ 	{
/*?*/ 		nBarY = aHScrollLeft.GetSizePixel().Height();
/*?*/ 		nBarX = aVScrollBottom.GetSizePixel().Width();
/*?*/ 
/*?*/ 		nSize1 = nSizeX + nOverlap;
/*?*/ 
/*?*/ 		long nTabSize = nSize1;
/*?*/ 		if (nTabSize < 0) nTabSize = 0;
/*?*/ 
/*?*/ 		pTabControl->SetPosSizePixel( Point(nPosX-nOverlap, nPosY+nSizeY-nBarY),
/*?*/ 										Size(nTabSize+nOverlap, nBarY) );
/*?*/ 		nSizeY -= nBarY - nOverlap;
/*?*/ 		aScrollBarBox.SetPosSizePixel( Point( nPosX+nSizeX, nPosY+nSizeY ), Size( nBarX, nBarY ) );
/*?*/ 
/*?*/ 		if( bVScroll )
/*?*/ 		{
/*?*/ 			Size aVScrSize = aVScrollBottom.GetSizePixel();
/*?*/ 			aVScrSize.Height() -= nBarY;
/*?*/ 			aVScrollBottom.SetSizePixel( aVScrSize );
/*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	nOutPosX = nPosX;
/*N*/ 	nOutPosY = nPosY;
/*N*/ 
/*N*/ 	// Outline-Controls
/*N*/ 	if (bVOutline && pRowOutline[SC_SPLIT_BOTTOM])
/*N*/ 	{
/*N*/ 		nOutlineX = pRowOutline[SC_SPLIT_BOTTOM]->GetDepthSize();
/*N*/ 		nSizeX -= nOutlineX;
/*N*/ 		nPosX += nOutlineX;
/*N*/ 	}
/*N*/ 	if (bHOutline && pColOutline[SC_SPLIT_LEFT])
/*N*/ 	{
/*?*/ 		nOutlineY = pColOutline[SC_SPLIT_LEFT]->GetDepthSize();
/*?*/ 		nSizeY -= nOutlineY;
/*?*/ 		nPosY += nOutlineY;
/*N*/ 	}
/*N*/ 
/*N*/ 	if (bHeaders)								// Spalten/Zeilen-Header
/*N*/ 	{
/*N*/ 		nBarX = pRowBar[SC_SPLIT_BOTTOM]->GetSizePixel().Width();
/*N*/ 		nBarY = pColBar[SC_SPLIT_LEFT]->GetSizePixel().Height();
/*N*/ 		nSizeX -= nBarX;
/*N*/ 		nSizeY -= nBarY;
/*N*/ 		nPosX += nBarX;
/*N*/ 		nPosY += nBarY;
/*N*/ 	}
/*N*/ 	else
/*N*/ 		nBarX = nBarY = 0;
/*N*/ 
/*N*/ 		//
/*N*/ 		//		Splitter auswerten
/*N*/ 		//
/*N*/ 
/*N*/ 	long nLeftSize   = nSizeX;
/*N*/ 	long nRightSize  = 0;
/*N*/ 	long nTopSize	 = 0;
/*N*/ 	long nBottomSize = nSizeY;
/*N*/ 	long nSplitPosX  = nPosX;
/*N*/ 	long nSplitPosY  = nPosY;
/*N*/ 
/*N*/ 	if ( aViewData.GetHSplitMode() != SC_SPLIT_NONE )
/*N*/ 	{
/*?*/ 		long nSplitHeight = rSize.Height();
/*?*/ 		if ( aViewData.GetHSplitMode() == SC_SPLIT_FIX )
/*?*/ 		{
/*?*/ 			//	Fixier-Splitter nicht mit Scrollbar/TabBar ueberlappen lassen
/*?*/ 			if ( bHScroll )
/*?*/ 				nSplitHeight -= aHScrollLeft.GetSizePixel().Height();
/*?*/ 			else if ( bTabControl && pTabControl )
/*?*/ 				nSplitHeight -= pTabControl->GetSizePixel().Height();
/*?*/ 		}
/*?*/ 		nSplitPosX = aViewData.GetHSplitPos();
/*?*/ 		pHSplitter->SetPosSizePixel(
/*?*/ 			Point( nSplitPosX, nOutPosY ), Size( nSplitSizeX, nSplitHeight ) );
/*?*/ 		nLeftSize = nSplitPosX - nPosX;
/*?*/ 		nSplitPosX += nSplitSizeX;
/*?*/ 		nRightSize = nSizeX - nLeftSize - nSplitSizeX;
/*N*/ 	}
/*N*/ 	if ( aViewData.GetVSplitMode() != SC_SPLIT_NONE )
/*N*/ 	{
/*?*/		long nSplitWidth = rSize.Width();
/*?*/		if ( aViewData.GetVSplitMode() == SC_SPLIT_FIX && bVScroll )
/*?*/			nSplitWidth -= aVScrollBottom.GetSizePixel().Width();
/*?*/		nSplitPosY = aViewData.GetVSplitPos();
/*?*/		pVSplitter->SetPosSizePixel(
/*?*/			Point( nOutPosX, nSplitPosY ), Size( nSplitWidth, nSplitSizeY ) );
/*?*/		nTopSize = nSplitPosY - nPosY;
/*?*/		nSplitPosY += nSplitSizeY;
/*?*/		nBottomSize = nSizeY - nTopSize - nSplitSizeY;
/*N*/	}
/*N*/ 
/*N*/ 	//	ShowHide fuer pColOutline / pRowOutline passiert in UpdateShow
/*N*/ 
/*N*/ 	if (bHOutline)								// Outline-Controls
/*N*/ 	{
/*?*/ 		if (pColOutline[SC_SPLIT_LEFT])
/*?*/ 		{
/*?*/ 			pColOutline[SC_SPLIT_LEFT]->SetHeaderSize( (USHORT) nBarX );
/*?*/ 			pColOutline[SC_SPLIT_LEFT]->SetPosSizePixel(
/*?*/ 					Point(nPosX-nBarX,nOutPosY), Size(nLeftSize+nBarX,nOutlineY) );
/*?*/ 		}
/*?*/ 		if (pColOutline[SC_SPLIT_RIGHT])
/*?*/ 			pColOutline[SC_SPLIT_RIGHT]->SetPosSizePixel(
/*?*/ 					Point(nSplitPosX,nOutPosY), Size(nRightSize,nOutlineY) );
/*N*/ 	}
/*N*/ 	if (bVOutline)
/*N*/ 	{
/*N*/ 		if (nTopSize)
/*N*/ 		{
/*?*/ 			if (pRowOutline[SC_SPLIT_TOP] && pRowOutline[SC_SPLIT_BOTTOM])
/*?*/ 			{
/*?*/ 				pRowOutline[SC_SPLIT_TOP]->SetHeaderSize( (USHORT) nBarY );
/*?*/ 				pRowOutline[SC_SPLIT_TOP]->SetPosSizePixel(
/*?*/ 						Point(nOutPosX,nPosY-nBarY), Size(nOutlineX,nTopSize+nBarY) );
/*?*/ 				pRowOutline[SC_SPLIT_BOTTOM]->SetHeaderSize( 0 );
/*?*/ 				pRowOutline[SC_SPLIT_BOTTOM]->SetPosSizePixel(
/*?*/ 						Point(nOutPosX,nSplitPosY), Size(nOutlineX,nBottomSize) );
/*?*/ 			}
/*N*/ 		}
/*N*/ 		else if (pRowOutline[SC_SPLIT_BOTTOM])
/*N*/ 		{
/*N*/ 			pRowOutline[SC_SPLIT_BOTTOM]->SetHeaderSize( (USHORT) nBarY );
/*N*/ 			pRowOutline[SC_SPLIT_BOTTOM]->SetPosSizePixel(
/*N*/ 					Point(nOutPosX,nSplitPosY-nBarY), Size(nOutlineX,nBottomSize+nBarY) );
/*N*/ 		}
/*N*/ 	}
/*N*/ 	if (bHOutline && bVOutline)
/*N*/ 	{
/*?*/ 		aTopButton.SetPosSizePixel( Point(nOutPosX,nOutPosY), Size(nOutlineX,nOutlineY) );
/*?*/ 		aTopButton.Show();
/*N*/ 	}
/*N*/ 	else
/*N*/ 		aTopButton.Hide();
/*N*/ 
/*N*/ 	if (bHeaders)								// Spalten/Zeilen-Header
/*N*/ 	{
/*N*/ 		pColBar[SC_SPLIT_LEFT]->SetPosSizePixel(
/*N*/ 			Point(nPosX,nPosY-nBarY), Size(nLeftSize,nBarY) );
/*N*/ 		if (pColBar[SC_SPLIT_RIGHT])
/*N*/ 			pColBar[SC_SPLIT_RIGHT]->SetPosSizePixel(
/*?*/ 				Point(nSplitPosX,nPosY-nBarY), Size(nRightSize,nBarY) );
/*N*/ 
/*N*/ 		if (pRowBar[SC_SPLIT_TOP])
/*N*/ 			pRowBar[SC_SPLIT_TOP]->SetPosSizePixel(
/*?*/ 				Point(nPosX-nBarX,nPosY), Size(nBarX,nTopSize) );
/*N*/ 		pRowBar[SC_SPLIT_BOTTOM]->SetPosSizePixel(
/*N*/ 			Point(nPosX-nBarX,nSplitPosY), Size(nBarX,nBottomSize) );
/*N*/ 
/*N*/ 		aCornerButton.SetPosSizePixel( Point(nPosX-nBarX,nPosY-nBarY), Size(nBarX,nBarY) );
/*N*/ 		aCornerButton.Show();
/*N*/ 		pColBar[SC_SPLIT_LEFT]->Show();
/*N*/ 		pRowBar[SC_SPLIT_BOTTOM]->Show();
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		aCornerButton.Hide();
/*N*/ 		pColBar[SC_SPLIT_LEFT]->Hide();			// immer da
/*N*/ 		pRowBar[SC_SPLIT_BOTTOM]->Hide();
/*N*/ 	}
/*N*/ 
/*N*/ 
/*N*/ 											// Grid-Windows
/*N*/ 
/*N*/ 	if (bInner)
/*N*/  	{
/*?*/ 		pGridWin[SC_SPLIT_BOTTOMLEFT]->SetPosPixel( Point(nPosX,nSplitPosY) );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		pGridWin[SC_SPLIT_BOTTOMLEFT]->SetPosSizePixel(
/*N*/ 			Point(nPosX,nSplitPosY), Size(nLeftSize,nBottomSize) );
/*N*/ 		if ( aViewData.GetHSplitMode() != SC_SPLIT_NONE )
/*N*/ 			pGridWin[SC_SPLIT_BOTTOMRIGHT]->SetPosSizePixel(
/*N*/ 				Point(nSplitPosX,nSplitPosY), Size(nRightSize,nBottomSize) );
/*N*/ 		if ( aViewData.GetVSplitMode() != SC_SPLIT_NONE )
/*N*/ 			pGridWin[SC_SPLIT_TOPLEFT]->SetPosSizePixel(
/*N*/ 				Point(nPosX,nPosY), Size(nLeftSize,nTopSize) );
/*N*/ 		if ( aViewData.GetHSplitMode() != SC_SPLIT_NONE && aViewData.GetVSplitMode() != SC_SPLIT_NONE )
/*N*/ 			pGridWin[SC_SPLIT_TOPRIGHT]->SetPosSizePixel(
/*N*/ 				Point(nSplitPosX,nPosY), Size(nRightSize,nTopSize) );
/*N*/ 	}
/*N*/ 
/*N*/ 				//
/*N*/ 				//	Scrollbars updaten
/*N*/ 				//
/*N*/ 
/*N*/ 	if (!bInUpdateHeader)
/*N*/ 	{
/*N*/ 		UpdateScrollBars();		// Scrollbars nicht beim Scrollen neu setzen
/*N*/ 		UpdateHeaderWidth();
/*N*/ 
/*N*/ 		InterpretVisible();		// #69343# have everything calculated before painting
/*N*/ 	}
/*N*/ 
/*N*/ 	if (bHasHint)
/*N*/ 		TestHintWindow();		// neu positionieren
/*N*/ 
/*N*/ 	UpdateVarZoom();	//	update variable zoom types (after resizing GridWindows)
/*M*/ 
//STRIP001 /*M*/ 	if (aViewData.GetViewShell()->HasAccessibilityObjects())
//STRIP001 /*M*/ 		aViewData.GetViewShell()->BroadcastAccessibility(SfxSimpleHint(SC_HINT_ACC_WINDOWRESIZED));
/*N*/ }

/*N*/ void ScTabView::UpdateVarZoom()
/*N*/ {
/*N*/ 	//	update variable zoom types
/*N*/ 
/*N*/ 	if ( eZoomType != SVX_ZOOM_PERCENT && !bInZoomUpdate )
/*N*/ 	{
/*?*/		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 bInZoomUpdate = TRUE;
//STRIP001 /*?*/		const Fraction& rOldX = GetViewData()->GetZoomX();
//STRIP001 /*?*/		const Fraction& rOldY = GetViewData()->GetZoomY();
//STRIP001 /*?*/		long nOldPercent = ( rOldY.GetNumerator() * 100 ) / rOldY.GetDenominator();
//STRIP001 /*?*/		USHORT nNewZoom = CalcZoom( eZoomType, (USHORT)nOldPercent );
//STRIP001 /*?*/		Fraction aNew( nNewZoom, 100 );
//STRIP001 /*?*/
//STRIP001 /*?*/		if ( aNew != rOldX || aNew != rOldY )
//STRIP001 /*?*/		{
//STRIP001 /*?*/			SetZoom( aNew, aNew );
//STRIP001 /*?*/			PaintGrid();
//STRIP001 /*?*/			PaintTop();
//STRIP001 /*?*/			PaintLeft();
//STRIP001 /*?*/			aViewData.GetViewShell()->GetViewFrame()->GetBindings().
//STRIP001 /*?*/				Invalidate( SID_ATTR_ZOOM );
//STRIP001 /*?*/		}
//STRIP001 /*?*/		bInZoomUpdate = FALSE;
/*N*/	}
/*N*/ }

/*N*/ void ScTabView::UpdateFixPos()
/*N*/ {
/*N*/ 	BOOL bResize = FALSE;
/*N*/ 	if ( aViewData.GetHSplitMode() == SC_SPLIT_FIX )
			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 		if (aViewData.UpdateFixX())
//STRIP001 /*?*/ 			bResize = TRUE;
/*N*/ 	if ( aViewData.GetVSplitMode() == SC_SPLIT_FIX )
			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 		if (aViewData.UpdateFixY())
//STRIP001 /*?*/ 			bResize = TRUE;
/*N*/ 	if (bResize)
/*?*/ 		RepeatResize(FALSE);
/*N*/ }

/*N*/ void ScTabView::RepeatResize( BOOL bUpdateFix )
/*N*/ {
/*N*/ 	if ( bUpdateFix )
/*N*/ 	{
/*N*/ 		if ( aViewData.GetHSplitMode() == SC_SPLIT_FIX )
				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 			aViewData.UpdateFixX();
/*N*/ 		if ( aViewData.GetVSplitMode() == SC_SPLIT_FIX )
				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 			aViewData.UpdateFixY();
/*N*/ 	}
/*N*/ 
/*N*/ 	DoResize( aBorderPos, aFrameSize );
/*N*/ 
/*N*/ 	//!	Border muss neu gesetzt werden ???
/*N*/ }

/*N*/ void ScTabView::GetBorderSize( SvBorder& rBorder, const Size& rSize )
/*N*/ {
/*N*/ 	BOOL bScrollBars = aViewData.IsVScrollMode();
/*N*/ 	BOOL bTabControl = aViewData.IsTabMode();
/*N*/ 	BOOL bHeaders	 = aViewData.IsHeaderMode();
/*N*/ 	BOOL bOutlMode	 = aViewData.IsOutlineMode();
/*N*/ 	BOOL bHOutline	 = bOutlMode && lcl_HasColOutline(aViewData);
/*N*/ 	BOOL bVOutline	 = bOutlMode && lcl_HasRowOutline(aViewData);
/*N*/ 
/*N*/ 	rBorder = SvBorder();
/*N*/ 
/*N*/ 	if (bScrollBars)							// Scrollbars horizontal oder vertikal
/*N*/ 	{
/*N*/ 		rBorder.Right()  += aVScrollBottom.GetSizePixel().Width();
/*N*/ 		rBorder.Bottom() += aHScrollLeft.GetSizePixel().Height();
/*N*/ 	}
/*N*/ 
/*N*/ 	// Outline-Controls
/*N*/ 	if (bVOutline && pRowOutline[SC_SPLIT_BOTTOM])
/*N*/ 		rBorder.Left() += pRowOutline[SC_SPLIT_BOTTOM]->GetDepthSize();
/*N*/ 	if (bHOutline && pColOutline[SC_SPLIT_LEFT])
/*N*/ 		rBorder.Top()  += pColOutline[SC_SPLIT_LEFT]->GetDepthSize();
/*N*/ 
/*N*/ 	if (bHeaders)								// Spalten/Zeilen-Header
/*N*/ 	{
/*N*/ 		rBorder.Left() += pRowBar[SC_SPLIT_BOTTOM]->GetSizePixel().Width();
/*N*/ 		rBorder.Top()  += pColBar[SC_SPLIT_LEFT]->GetSizePixel().Height();
/*N*/ 	}
/*N*/ }

IMPL_LINK( ScTabView, TabBarResize, void*, EMPTY_ARG )
{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	BOOL bHScrollMode = aViewData.IsHScrollMode();
//STRIP001 
//STRIP001 	//	Scrollbar-Einstellungen koennen vom Sfx ueberschrieben werden:
//STRIP001 	SfxScrollingMode eMode = aViewData.GetViewShell()->GetScrollingMode();
//STRIP001 	if ( eMode == SCROLLING_NO )
//STRIP001 		bHScrollMode = FALSE;
//STRIP001 	else if ( eMode == SCROLLING_YES || eMode == SCROLLING_AUTO )	//! Auto ???
//STRIP001 		bHScrollMode = TRUE;
//STRIP001 
//STRIP001 	if( bHScrollMode )
//STRIP001 	{
//STRIP001 		const long nOverlap = 0;	// ScrollBar::GetWindowOverlapPixel();
//STRIP001 		long nSize = pTabControl->GetSplitSize();
//STRIP001 
//STRIP001 		if (aViewData.GetHSplitMode() != SC_SPLIT_FIX)
//STRIP001 		{
//STRIP001 			long nMax = pHSplitter->GetPosPixel().X() - 1;
//STRIP001 			if (nSize>nMax) nSize = nMax;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( nSize != pTabControl->GetSizePixel().Width() )
//STRIP001 		{
//STRIP001 			pTabControl->SetSizePixel( Size( nSize+nOverlap,
//STRIP001 										pTabControl->GetSizePixel().Height() ) );
//STRIP001 			RepeatResize();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
	return 0;
}

//STRIP001 void ScTabView::SetTabBarWidth( long nNewWidth )
//STRIP001 {
//STRIP001 	Size aSize = pTabControl->GetSizePixel();
//STRIP001 
//STRIP001 	if ( aSize.Width() != nNewWidth )
//STRIP001 	{
//STRIP001 		aSize.Width() = nNewWidth;
//STRIP001 		pTabControl->SetSizePixel( aSize );
//STRIP001 	}
//STRIP001 }

/*N*/ long ScTabView::GetTabBarWidth()
/*N*/ {
/*N*/ 	return pTabControl->GetSizePixel().Width();
/*N*/ }

/*N*/ Window* ScTabView::GetActiveWin()
/*N*/ {
/*N*/ 	ScSplitPos ePos = aViewData.GetActivePart();
/*N*/ 	DBG_ASSERT(pGridWin[ePos],"kein aktives Fenster");
/*N*/ 	return pGridWin[ePos];
/*N*/ }

/*N*/ Window* ScTabView::GetWindowByPos( ScSplitPos ePos )
/*N*/ {
/*N*/ 	return pGridWin[ePos];
/*N*/ }

//STRIP001 void ScTabView::SetActivePointer( const Pointer& rPointer )
//STRIP001 {
//STRIP001 	for (USHORT i=0; i<4; i++)
//STRIP001 		if (pGridWin[i])
//STRIP001 			pGridWin[i]->SetPointer( rPointer );

/*	ScSplitPos ePos = aViewData.GetActivePart();
	if (pGridWin[ePos])
		pGridWin[ePos]->SetPointer( rPointer );
*/
//STRIP001 }

//STRIP001 void ScTabView::SetActivePointer( const ResId& rId )
//STRIP001 {
//STRIP001 	DBG_ERRORFILE( "keine Pointer mit ResId!" );
//STRIP001 }

//STRIP001 void ScTabView::ActiveGrabFocus()
//STRIP001 {
//STRIP001 	ScSplitPos ePos = aViewData.GetActivePart();
//STRIP001 	if (pGridWin[ePos])
//STRIP001 		pGridWin[ePos]->GrabFocus();
//STRIP001 }

//STRIP001 void ScTabView::ActiveCaptureMouse()
//STRIP001 {
//STRIP001 	ScSplitPos ePos = aViewData.GetActivePart();
//STRIP001 	if (pGridWin[ePos])
//STRIP001 		pGridWin[ePos]->CaptureMouse();
//STRIP001 }

//STRIP001 void ScTabView::ActiveReleaseMouse()
//STRIP001 {
//STRIP001 	ScSplitPos ePos = aViewData.GetActivePart();
//STRIP001 	if (pGridWin[ePos])
//STRIP001 		pGridWin[ePos]->ReleaseMouse();
//STRIP001 }

//STRIP001 Point ScTabView::ActivePixelToLogic( const Point& rDevicePoint )
//STRIP001 {
//STRIP001 	ScSplitPos ePos = aViewData.GetActivePart();
//STRIP001 	if (pGridWin[ePos])
//STRIP001 		return pGridWin[ePos]->PixelToLogic(rDevicePoint);
//STRIP001 	else
//STRIP001 		return Point();
//STRIP001 }

//STRIP001 ScSplitPos ScTabView::FindWindow( Window* pWindow ) const
//STRIP001 {
//STRIP001 	ScSplitPos eVal = SC_SPLIT_BOTTOMLEFT;		// Default
//STRIP001 	for (USHORT i=0; i<4; i++)
//STRIP001 		if ( pGridWin[i] == pWindow )
//STRIP001 			eVal = (ScSplitPos) i;
//STRIP001 
//STRIP001 	return eVal;
//STRIP001 }

//STRIP001 Point ScTabView::GetGridOffset() const
//STRIP001 {
//STRIP001 	Point aPos;
//STRIP001 
//STRIP001 		// Groessen hier wie in DoResize
//STRIP001 
//STRIP001 	BOOL bHeaders	 = aViewData.IsHeaderMode();
//STRIP001 	BOOL bOutlMode	 = aViewData.IsOutlineMode();
//STRIP001 	BOOL bHOutline	 = bOutlMode && lcl_HasColOutline(aViewData);
//STRIP001 	BOOL bVOutline	 = bOutlMode && lcl_HasRowOutline(aViewData);
//STRIP001 
//STRIP001 	// Outline-Controls
//STRIP001 	if (bVOutline && pRowOutline[SC_SPLIT_BOTTOM])
//STRIP001 		aPos.X() += pRowOutline[SC_SPLIT_BOTTOM]->GetDepthSize();
//STRIP001 	if (bHOutline && pColOutline[SC_SPLIT_LEFT])
//STRIP001 		aPos.Y() += pColOutline[SC_SPLIT_LEFT]->GetDepthSize();
//STRIP001 
//STRIP001 	if (bHeaders)								// Spalten/Zeilen-Header
//STRIP001 	{
//STRIP001 		if (pRowBar[SC_SPLIT_BOTTOM])
//STRIP001 			aPos.X() += pRowBar[SC_SPLIT_BOTTOM]->GetSizePixel().Width();
//STRIP001 		if (pColBar[SC_SPLIT_LEFT])
//STRIP001 			aPos.Y() += pColBar[SC_SPLIT_LEFT]->GetSizePixel().Height();
//STRIP001 	}
//STRIP001 
//STRIP001 	return aPos;
//STRIP001 }

// ---  Scroll-Bars  --------------------------------------------------------

//STRIP001 BOOL ScTabView::ScrollCommand( const CommandEvent& rCEvt, ScSplitPos ePos )
//STRIP001 {
//STRIP001 	HideNoteMarker();
//STRIP001 
//STRIP001 	BOOL bDone = FALSE;
//STRIP001 	const CommandWheelData* pData = rCEvt.GetWheelData();
//STRIP001 	if ( pData && pData->GetMode() == COMMAND_WHEEL_ZOOM )
//STRIP001 	{
//STRIP001 		if ( !aViewData.GetViewShell()->GetViewFrame()->ISA(SfxInPlaceFrame) )
//STRIP001 		{
//STRIP001 			//	for ole inplace editing, the scale is defined by the visarea and client size
//STRIP001 			//	and can't be changed directly
//STRIP001 
//STRIP001 			const Fraction& rOldY = aViewData.GetZoomY();
//STRIP001 			long nOld = (USHORT)(( rOldY.GetNumerator() * 100 ) / rOldY.GetDenominator());
//STRIP001 			long nNew = nOld;
//STRIP001 			if ( pData->GetDelta() < 0 )
//STRIP001 				nNew = Max( (long) MINZOOM, (long)( nOld - SC_DELTA_ZOOM ) );
//STRIP001 			else
//STRIP001 				nNew = Min( (long) MAXZOOM, (long)( nOld + SC_DELTA_ZOOM ) );
//STRIP001 
//STRIP001 			if ( nNew != nOld )
//STRIP001 			{
//STRIP001 				//!	Zoom an AppOptions merken ???
//STRIP001 
//STRIP001 				SetZoomType( SVX_ZOOM_PERCENT );
//STRIP001 				Fraction aFract( nNew, 100 );
//STRIP001 				SetZoom( aFract, aFract );
//STRIP001 				PaintGrid();
//STRIP001 				PaintTop();
//STRIP001 				PaintLeft();
//STRIP001 				aViewData.GetBindings().Invalidate( SID_ATTR_ZOOM );
//STRIP001 			}
//STRIP001 
//STRIP001 			bDone = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		ScHSplitPos eHPos = WhichH(ePos);
//STRIP001 		ScVSplitPos eVPos = WhichV(ePos);
//STRIP001 		ScrollBar* pHScroll = ( eHPos == SC_SPLIT_LEFT ) ? &aHScrollLeft : &aHScrollRight;
//STRIP001 		ScrollBar* pVScroll = ( eVPos == SC_SPLIT_TOP )  ? &aVScrollTop  : &aVScrollBottom;
//STRIP001 		if ( pGridWin[ePos] )
//STRIP001 			bDone = pGridWin[ePos]->HandleScrollCommand( rCEvt, pHScroll, pVScroll );
//STRIP001 	}
//STRIP001 	return bDone;
//STRIP001 }

IMPL_LINK( ScTabView, EndScrollHdl, ScrollBar*, pScroll )
{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	BOOL bOnlineScroll = TRUE;		//! Optionen
//STRIP001 
//STRIP001 	if ( bDragging )
//STRIP001 	{
//STRIP001 		if ( bOnlineScroll )				// nur Ranges aktualisieren
//STRIP001 			UpdateScrollBars();
//STRIP001 		else
//STRIP001 		{
//STRIP001 			long nScrollMin = 0;		// RangeMin simulieren
//STRIP001 			if ( aViewData.GetHSplitMode()==SC_SPLIT_FIX && pScroll == &aHScrollRight )
//STRIP001 				nScrollMin = aViewData.GetFixPosX();
//STRIP001 			if ( aViewData.GetVSplitMode()==SC_SPLIT_FIX && pScroll == &aVScrollBottom )
//STRIP001 				nScrollMin = aViewData.GetFixPosY();
//STRIP001 
//STRIP001 			if ( pScroll == &aHScrollLeft || pScroll == &aHScrollRight )
//STRIP001 			{
//STRIP001 				ScHSplitPos eWhich = (pScroll == &aHScrollLeft) ? SC_SPLIT_LEFT : SC_SPLIT_RIGHT;
//STRIP001 				long nDelta = pScroll->GetThumbPos() + nScrollMin - aViewData.GetPosX(eWhich);
//STRIP001 				if (nDelta)	ScrollX( nDelta, eWhich );
//STRIP001 			}
//STRIP001 			else							// VScroll...
//STRIP001 			{
//STRIP001 				ScVSplitPos eWhich = (pScroll == &aVScrollTop) ? SC_SPLIT_TOP : SC_SPLIT_BOTTOM;
//STRIP001 				long nDelta = pScroll->GetThumbPos() + nScrollMin - aViewData.GetPosY(eWhich);
//STRIP001 				if (nDelta) ScrollY( nDelta, eWhich );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		bDragging = FALSE;
//STRIP001 	}
	return 0;
}

IMPL_LINK( ScTabView, ScrollHdl, ScrollBar*, pScroll )
{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	BOOL bOnlineScroll = TRUE;		//! Optionen
//STRIP001 
//STRIP001 	BOOL bHoriz = ( pScroll == &aHScrollLeft || pScroll == &aHScrollRight );
//STRIP001 	long nViewPos;
//STRIP001 	if ( bHoriz )
//STRIP001 		nViewPos = aViewData.GetPosX( (pScroll == &aHScrollLeft) ?
//STRIP001 										SC_SPLIT_LEFT : SC_SPLIT_RIGHT );
//STRIP001 	else
//STRIP001 		nViewPos = aViewData.GetPosY( (pScroll == &aVScrollTop) ?
//STRIP001 										SC_SPLIT_TOP : SC_SPLIT_BOTTOM );
//STRIP001 
//STRIP001 	ScrollType eType = pScroll->GetType();
//STRIP001 	if ( eType == SCROLL_DRAG )
//STRIP001 	{
//STRIP001 		if (!bDragging)
//STRIP001 		{
//STRIP001 			bDragging = TRUE;
//STRIP001 			nPrevDragPos = nViewPos;
//STRIP001 		}
//STRIP001 
//STRIP001 		//	Scroll-Position anzeigen
//STRIP001 		//	(nur QuickHelp, in der Statuszeile gibt es keinen Eintrag dafuer)
//STRIP001 
//STRIP001 		if (Help::IsQuickHelpEnabled())
//STRIP001 		{
//STRIP001 			Point aMousePos = pScroll->OutputToScreenPixel(pScroll->GetPointerPosPixel());
//STRIP001 			long nScrollMin = 0;		// RangeMin simulieren
//STRIP001 			if ( aViewData.GetHSplitMode()==SC_SPLIT_FIX && pScroll == &aHScrollRight )
//STRIP001 				nScrollMin = aViewData.GetFixPosX();
//STRIP001 			if ( aViewData.GetVSplitMode()==SC_SPLIT_FIX && pScroll == &aVScrollBottom )
//STRIP001 				nScrollMin = aViewData.GetFixPosY();
//STRIP001 
//STRIP001 			String aHelpStr;
//STRIP001 			long nScrollPos = pScroll->GetThumbPos() + nScrollMin;
//STRIP001 			Point aPos = pScroll->GetParent()->OutputToScreenPixel(pScroll->GetPosPixel());
//STRIP001 			Size aSize = pScroll->GetSizePixel();
//STRIP001 			Rectangle aRect;
//STRIP001 			USHORT nAlign;
//STRIP001 			if (bHoriz)
//STRIP001 			{
//STRIP001 				aHelpStr = ScGlobal::GetRscString(STR_COLUMN);
//STRIP001 				aHelpStr += ' ';
//STRIP001 				aHelpStr += ColToAlpha((USHORT) nScrollPos);
//STRIP001 
//STRIP001 				aRect.Left() = aMousePos.X();
//STRIP001 				aRect.Top()	 = aPos.Y() - 4;
//STRIP001 				nAlign		 = QUICKHELP_BOTTOM|QUICKHELP_CENTER;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				aHelpStr = ScGlobal::GetRscString(STR_ROW);
//STRIP001 				aHelpStr += ' ';
//STRIP001 				aHelpStr += String::CreateFromInt32(nScrollPos + 1);
//STRIP001 
//STRIP001 				aRect.Left() = aPos.X() - 8;
//STRIP001 				aRect.Top()	 = aMousePos.Y();
//STRIP001 				nAlign		 = QUICKHELP_RIGHT|QUICKHELP_VCENTER;
//STRIP001 			}
//STRIP001 			aRect.Right() 	= aRect.Left();
//STRIP001 			aRect.Bottom()	= aRect.Top();
//STRIP001 
//STRIP001 			Help::ShowQuickHelp(pScroll->GetParent(), aRect, aHelpStr, nAlign);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bOnlineScroll || eType != SCROLL_DRAG )
//STRIP001 	{
//STRIP001 		long nDelta = pScroll->GetDelta();
//STRIP001 		switch ( eType )
//STRIP001 		{
//STRIP001 			case SCROLL_LINEUP:
//STRIP001 				nDelta = -1;
//STRIP001 				break;
//STRIP001 			case SCROLL_LINEDOWN:
//STRIP001 				nDelta = 1;
//STRIP001 				break;
//STRIP001 			case SCROLL_PAGEUP:
//STRIP001 				if ( pScroll == &aHScrollLeft ) nDelta = -(long) aViewData.PrevCellsX( SC_SPLIT_LEFT );
//STRIP001 				if ( pScroll == &aHScrollRight ) nDelta = -(long) aViewData.PrevCellsX( SC_SPLIT_RIGHT );
//STRIP001 				if ( pScroll == &aVScrollTop ) nDelta = -(long) aViewData.PrevCellsY( SC_SPLIT_TOP );
//STRIP001 				if ( pScroll == &aVScrollBottom ) nDelta = -(long) aViewData.PrevCellsY( SC_SPLIT_BOTTOM );
//STRIP001 				if (nDelta==0) nDelta=-1;
//STRIP001 				break;
//STRIP001 			case SCROLL_PAGEDOWN:
//STRIP001 				if ( pScroll == &aHScrollLeft ) nDelta = aViewData.VisibleCellsX( SC_SPLIT_LEFT );
//STRIP001 				if ( pScroll == &aHScrollRight ) nDelta = aViewData.VisibleCellsX( SC_SPLIT_RIGHT );
//STRIP001 				if ( pScroll == &aVScrollTop ) nDelta = aViewData.VisibleCellsY( SC_SPLIT_TOP );
//STRIP001 				if ( pScroll == &aVScrollBottom ) nDelta = aViewData.VisibleCellsY( SC_SPLIT_BOTTOM );
//STRIP001 				if (nDelta==0) nDelta=1;
//STRIP001 				break;
//STRIP001 			case SCROLL_DRAG:
//STRIP001 				{
//STRIP001 					//	nur in die richtige Richtung scrollen, nicht um ausgeblendete
//STRIP001 					//	Bereiche herumzittern
//STRIP001 
//STRIP001 					long nScrollMin = 0;		// RangeMin simulieren
//STRIP001 					if ( aViewData.GetHSplitMode()==SC_SPLIT_FIX && pScroll == &aHScrollRight )
//STRIP001 						nScrollMin = aViewData.GetFixPosX();
//STRIP001 					if ( aViewData.GetVSplitMode()==SC_SPLIT_FIX && pScroll == &aVScrollBottom )
//STRIP001 						nScrollMin = aViewData.GetFixPosY();
//STRIP001 
//STRIP001 					long nScrollPos = pScroll->GetThumbPos() + nScrollMin;
//STRIP001 					nDelta = nScrollPos - nViewPos;
//STRIP001 					if ( nScrollPos > nPrevDragPos )
//STRIP001 					{
//STRIP001 						if (nDelta<0) nDelta=0;
//STRIP001 					}
//STRIP001 					else if ( nScrollPos < nPrevDragPos )
//STRIP001 					{
//STRIP001 						if (nDelta>0) nDelta=0;
//STRIP001 					}
//STRIP001 					else
//STRIP001 						nDelta = 0;
//STRIP001 					nPrevDragPos = nScrollPos;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 		}
//STRIP001 
//STRIP001 		if (nDelta)
//STRIP001 		{
//STRIP001 			BOOL bUpdate = ( eType != SCROLL_DRAG );	// bei Drag die Ranges nicht aendern
//STRIP001 			if ( bHoriz )
//STRIP001 				ScrollX( nDelta, (pScroll == &aHScrollLeft) ? SC_SPLIT_LEFT : SC_SPLIT_RIGHT, bUpdate );
//STRIP001 			else
//STRIP001 				ScrollY( nDelta, (pScroll == &aVScrollTop) ? SC_SPLIT_TOP : SC_SPLIT_BOTTOM, bUpdate );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
	return 0;
}

/*N*/ void ScTabView::ScrollX( long nDeltaX, ScHSplitPos eWhich, BOOL bUpdBars )
/*N*/ {
/*N*/ 	BOOL bHasHint = ( pInputHintWindow != NULL );
/*N*/ 	if (bHasHint)
			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*N*/ 		RemoveHintWindow();
/*N*/ 
/*N*/ 	USHORT nOldX = aViewData.GetPosX(eWhich);
/*N*/ 	short nNewX = ((short) nOldX) + (short) nDeltaX;
/*N*/ 	if ( nNewX < 0 )
/*N*/ 	{
/*N*/ 		nDeltaX -= nNewX;
/*N*/ 		nNewX = 0;
/*N*/ 	}
/*N*/ 	if ( nNewX > MAXCOL )
/*N*/ 	{
/*N*/ 		nDeltaX -= nNewX - MAXCOL;
/*N*/ 		nNewX = MAXCOL;
/*N*/ 	}
/*N*/ 
/*N*/ 	short nDir = ( nDeltaX > 0 ) ? 1 : -1;
/*N*/ 	ScDocument* pDoc = aViewData.GetDocument();
/*N*/ 	USHORT nTab = aViewData.GetTabNo();
/*N*/ 	while ( ( pDoc->GetColFlags( nNewX, nTab ) & CR_HIDDEN ) &&
/*N*/ 			nNewX+nDir >= 0 && nNewX+nDir <= MAXCOL )
/*N*/ 		nNewX += nDir;
/*N*/ 
/*N*/ 	//	Fixierung
/*N*/ 
/*N*/ 	if (aViewData.GetHSplitMode() == SC_SPLIT_FIX)
/*N*/ 	{
/*N*/ 		if (eWhich == SC_SPLIT_LEFT)
/*N*/ 			nNewX = (short) nOldX;								// links immer stehenlassen
/*N*/ 		else
/*N*/ 		{
/*N*/ 			short nFixX = (short)aViewData.GetFixPosX();
/*N*/ 			if (nNewX < nFixX)
/*N*/ 				nNewX = nFixX;
/*N*/ 		}
/*N*/ 	}
/*N*/ 	if (nNewX == (short) nOldX)
/*N*/ 		return;
/*N*/ 
		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*N*/ 	HideAllCursors();
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 	if ( nNewX >= 0 && nNewX <= MAXCOL && nDeltaX )
//STRIP001 /*N*/ 	{
//STRIP001 /*N*/ 		USHORT nTrackX = std::max( nOldX, (USHORT) nNewX );
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 			//	Auf dem Mac wird in Window::Scroll vor dem Scrollen Update gerufen,
//STRIP001 /*N*/ 			//	so dass mit den neuen Variablen an die alte Position ausgegeben wuerde.
//STRIP001 /*N*/ 			//	Deshalb ein Update vorneweg (vor SetPosX), auf welches Fenster ist beim Mac egal.
//STRIP001 /*N*/ #ifdef MAC
//STRIP001 /*N*/ 		pGridWin[SC_SPLIT_BOTTOMLEFT]->Update();
//STRIP001 /*N*/ #endif
//STRIP001 /*N*/ 			//	Mit VCL wirkt Update() im Moment immer auf alle Fenster, beim Update
//STRIP001 /*N*/ 			//	nach dem Scrollen des GridWindow's wuerde darum der Col-/RowBar evtl.
//STRIP001 /*N*/ 			//	mit schon geaenderter Pos. gepainted werden -
//STRIP001 /*N*/ 			//	darum vorher einmal Update am Col-/RowBar
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 		if (pColBar[eWhich])
//STRIP001 /*N*/ 			pColBar[eWhich]->Update();
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 		long nOldPos = aViewData.GetScrPos( nTrackX, 0, eWhich ).X();
//STRIP001 /*N*/ 		aViewData.SetPosX( eWhich, (USHORT) nNewX );
//STRIP001 /*N*/ 		long nDiff = aViewData.GetScrPos( nTrackX, 0, eWhich ).X() - nOldPos;
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 		if ( eWhich==SC_SPLIT_LEFT )
//STRIP001 /*N*/ 		{
//STRIP001 /*N*/ 			pGridWin[SC_SPLIT_BOTTOMLEFT]->ScrollPixel( nDiff, 0 );
//STRIP001 /*N*/ 			if ( aViewData.GetVSplitMode() != SC_SPLIT_NONE )
//STRIP001 /*N*/ 				pGridWin[SC_SPLIT_TOPLEFT]->ScrollPixel( nDiff, 0 );
//STRIP001 /*N*/ 		}
//STRIP001 /*N*/ 		else
//STRIP001 /*N*/ 		{
//STRIP001 /*N*/ 			pGridWin[SC_SPLIT_BOTTOMRIGHT]->ScrollPixel( nDiff, 0 );
//STRIP001 /*N*/ 			if ( aViewData.GetVSplitMode() != SC_SPLIT_NONE )
//STRIP001 /*N*/ 				pGridWin[SC_SPLIT_TOPRIGHT]->ScrollPixel( nDiff, 0 );
//STRIP001 /*N*/ 		}
//STRIP001 /*N*/ 		if (pColBar[eWhich]) 	 { pColBar[eWhich]->Scroll( nDiff,0 ); pColBar[eWhich]->Update(); }
//STRIP001 /*N*/ 		if (pColOutline[eWhich]) pColOutline[eWhich]->ScrollPixel( nDiff );
//STRIP001 /*N*/ 		if (bUpdBars)
//STRIP001 /*N*/ 			UpdateScrollBars();
//STRIP001 /*N*/ 	}
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 	if (nDeltaX==1 || nDeltaX==-1)
//STRIP001 /*N*/ 		pGridWin[aViewData.GetActivePart()]->Update();
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 	ShowAllCursors();
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 	SetNewVisArea();			// MapMode muss schon gesetzt sein
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 	if (bHasHint)
//STRIP001 /*N*/ 		TestHintWindow();		// neu positionieren
/*N*/ }

/*N*/ void ScTabView::ScrollY( long nDeltaY, ScVSplitPos eWhich, BOOL bUpdBars )
/*N*/ {
/*N*/ 	BOOL bHasHint = ( pInputHintWindow != NULL );
/*N*/ 	if (bHasHint)
			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*N*/ 		RemoveHintWindow();
/*N*/ 
/*N*/ 	USHORT nOldY = aViewData.GetPosY(eWhich);
/*N*/ 	short nNewY = ((short) nOldY) + (short) nDeltaY;
/*N*/ 	if ( nNewY < 0 )
/*N*/ 	{
/*N*/ 		nDeltaY -= nNewY;
/*N*/ 		nNewY = 0;
/*N*/ 	}
/*N*/ 	if ( nNewY > MAXROW )
/*N*/ 	{
/*N*/ 		nDeltaY -= nNewY - MAXROW;
/*N*/ 		nNewY = MAXROW;
/*N*/ 	}
/*N*/ 
/*N*/ 	short nDir = ( nDeltaY > 0 ) ? 1 : -1;
/*N*/ 	ScDocument* pDoc = aViewData.GetDocument();
/*N*/ 	USHORT nTab = aViewData.GetTabNo();
/*N*/ 	while ( ( pDoc->GetRowFlags( nNewY, nTab ) & CR_HIDDEN ) &&
/*N*/ 			nNewY+nDir >= 0 && nNewY+nDir <= MAXROW )
/*N*/ 		nNewY += nDir;
/*N*/ 
/*N*/ 	//	Fixierung
/*N*/ 
/*N*/ 	if (aViewData.GetVSplitMode() == SC_SPLIT_FIX)
/*N*/ 	{
/*N*/ 		if (eWhich == SC_SPLIT_TOP)
/*N*/ 			nNewY = (short) nOldY;								// oben immer stehenlassen
/*N*/ 		else
/*N*/ 		{
/*N*/ 			short nFixY = (short)aViewData.GetFixPosY();
/*N*/ 			if (nNewY < nFixY)
/*N*/ 				nNewY = nFixY;
/*N*/ 		}
/*N*/ 	}
/*N*/ 	if (nNewY == (short) nOldY)
/*N*/ 		return;
/*N*/ 
		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*N*/ 	HideAllCursors();
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 	if ( nNewY >= 0 && nNewY <= MAXROW && nDeltaY )
//STRIP001 /*N*/ 	{
//STRIP001 /*N*/ 		USHORT nTrackY = std::max( nOldY, (USHORT) nNewY );
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 		//	Zeilenkoepfe anpassen vor dem eigentlichen Scrolling, damit nicht
//STRIP001 /*N*/ 		//	doppelt gepainted werden muss
//STRIP001 /*N*/ 		//	PosY darf dann auch noch nicht umgesetzt sein, neuen Wert uebergeben
//STRIP001 /*N*/ 		USHORT nUNew = (USHORT) nNewY;
//STRIP001 /*N*/ 		UpdateHeaderWidth( &eWhich, &nUNew );				// Zeilenkoepfe anpassen
//STRIP001 /*N*/ 
//STRIP001 /*N*/ #ifdef MAC
//STRIP001 /*N*/ 		pGridWin[SC_SPLIT_BOTTOMLEFT]->Update();
//STRIP001 /*N*/ #endif
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 		if (pRowBar[eWhich])
//STRIP001 /*N*/ 			pRowBar[eWhich]->Update();
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 		long nOldPos = aViewData.GetScrPos( 0, nTrackY, eWhich ).Y();
//STRIP001 /*N*/ 		aViewData.SetPosY( eWhich, (USHORT) nNewY );
//STRIP001 /*N*/ 		long nDiff = aViewData.GetScrPos( 0, nTrackY, eWhich ).Y() - nOldPos;
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 		if ( eWhich==SC_SPLIT_TOP )
//STRIP001 /*N*/ 		{
//STRIP001 /*N*/ 			pGridWin[SC_SPLIT_TOPLEFT]->ScrollPixel( 0, nDiff );
//STRIP001 /*N*/ 			if ( aViewData.GetHSplitMode() != SC_SPLIT_NONE )
//STRIP001 /*N*/ 				pGridWin[SC_SPLIT_TOPRIGHT]->ScrollPixel( 0, nDiff );
//STRIP001 /*N*/ 		}
//STRIP001 /*N*/ 		else
//STRIP001 /*N*/ 		{
//STRIP001 /*N*/ 			pGridWin[SC_SPLIT_BOTTOMLEFT]->ScrollPixel( 0, nDiff );
//STRIP001 /*N*/ 			if ( aViewData.GetHSplitMode() != SC_SPLIT_NONE )
//STRIP001 /*N*/ 				pGridWin[SC_SPLIT_BOTTOMRIGHT]->ScrollPixel( 0, nDiff );
//STRIP001 /*N*/ 		}
//STRIP001 /*N*/ 		if (pRowBar[eWhich])	 { pRowBar[eWhich]->Scroll( 0,nDiff ); pRowBar[eWhich]->Update(); }
//STRIP001 /*N*/ 		if (pRowOutline[eWhich]) pRowOutline[eWhich]->ScrollPixel( nDiff );
//STRIP001 /*N*/ 		if (bUpdBars)
//STRIP001 /*N*/ 			UpdateScrollBars();
//STRIP001 /*N*/ 	}
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 	if (nDeltaY==1 || nDeltaY==-1)
//STRIP001 /*N*/ 		pGridWin[aViewData.GetActivePart()]->Update();
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 	ShowAllCursors();
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 	SetNewVisArea();			// MapMode muss schon gesetzt sein
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 	if (bHasHint)
//STRIP001 /*N*/ 		TestHintWindow();		// neu positionieren
/*N*/ }

//STRIP001 void ScTabView::ScrollLines( long nDeltaX, long nDeltaY )
//STRIP001 {
//STRIP001 	ScSplitPos eWhich = aViewData.GetActivePart();
//STRIP001 	if (nDeltaX)
//STRIP001 		ScrollX(nDeltaX,WhichH(eWhich));
//STRIP001 	if (nDeltaY)
//STRIP001 		ScrollY(nDeltaY,WhichV(eWhich));
//STRIP001 }

//STRIP001 USHORT lcl_LastVisible( ScViewData& rViewData )
//STRIP001 {
//STRIP001 	//	wenn am Dokumentende viele Zeilen ausgeblendet sind (welcher Trottel macht sowas?),
//STRIP001 	//	soll dadurch nicht auf breite Zeilenkoepfe geschaltet werden
//STRIP001 	//!	als Member ans Dokument ???
//STRIP001 
//STRIP001 	ScDocument* pDoc = rViewData.GetDocument();
//STRIP001 	USHORT nTab = rViewData.GetTabNo();
//STRIP001 
//STRIP001 	USHORT nVis = MAXROW;
//STRIP001 	while ( nVis > 0 && pDoc->FastGetRowHeight( nVis, nTab ) == 0 )
//STRIP001 		--nVis;
//STRIP001 	return nVis;
//STRIP001 }

/*N*/ void ScTabView::UpdateHeaderWidth( const ScVSplitPos* pWhich, const USHORT* pPosY )
/*N*/ {
/*N*/ 	if ( !pRowBar[SC_SPLIT_BOTTOM] || MAXROW < 10000 )
/*N*/ 		return;
/*N*/ 
/*N*/ 	USHORT nEndPos = MAXROW;
/*N*/ 	if ( !aViewData.GetViewShell()->GetViewFrame()->ISA(SfxInPlaceFrame) )
/*N*/ 	{
/*N*/ 		//	fuer OLE Inplace immer MAXROW
/*N*/ 
/*N*/ 		if ( pWhich && *pWhich == SC_SPLIT_BOTTOM && pPosY )
/*N*/ 			nEndPos = *pPosY;
/*N*/ 		else
/*N*/ 			nEndPos = aViewData.GetPosY( SC_SPLIT_BOTTOM );
/*N*/ 		nEndPos += aViewData.CellsAtY( nEndPos, 1, SC_SPLIT_BOTTOM, SC_SIZE_NONE );	// VisibleCellsY
/*N*/ 		if (nEndPos > MAXROW)
				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 			nEndPos = lcl_LastVisible( aViewData );
/*N*/ 
/*N*/ 		if ( aViewData.GetVSplitMode() != SC_SPLIT_NONE )
/*N*/ 		{
/*?*/ 			USHORT nTopEnd;
/*?*/ 			if ( pWhich && *pWhich == SC_SPLIT_TOP && pPosY )
/*?*/ 				nTopEnd = *pPosY;
/*?*/ 			else
/*?*/ 				nTopEnd = aViewData.GetPosY( SC_SPLIT_TOP );
/*?*/ 			nTopEnd += aViewData.CellsAtY( nTopEnd, 1, SC_SPLIT_TOP, SC_SIZE_NONE );// VisibleCellsY
/*?*/ 			if (nTopEnd > MAXROW)
					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 				nTopEnd = lcl_LastVisible( aViewData );
/*?*/ 
/*?*/ 			if ( nTopEnd > nEndPos )
/*?*/ 				nEndPos = nTopEnd;
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	long nSmall = pRowBar[SC_SPLIT_BOTTOM]->GetSmallWidth();
/*N*/ 	long nBig   = pRowBar[SC_SPLIT_BOTTOM]->GetBigWidth();
/*N*/ 	long nDiff  = nBig - nSmall;
/*N*/ 
/*N*/ 	if (nEndPos>10000)
/*N*/ 		nEndPos = 10000;
/*N*/ 	else if (nEndPos<1)		// avoid extra step at 0 (when only one row is visible)
/*N*/ 		nEndPos = 1;
/*N*/ 	long nWidth = nBig - ( 10000 - nEndPos ) * nDiff / 10000;
/*N*/ 
/*N*/ 	if ( nWidth != pRowBar[SC_SPLIT_BOTTOM]->GetWidth() && !bInUpdateHeader )
/*N*/ 	{
/*N*/ 		bInUpdateHeader = TRUE;
/*N*/ 
/*N*/ 		pRowBar[SC_SPLIT_BOTTOM]->SetWidth( nWidth );
/*N*/ 		if (pRowBar[SC_SPLIT_TOP])
/*?*/ 			pRowBar[SC_SPLIT_TOP]->SetWidth( nWidth );
/*N*/ 
/*N*/ 		RepeatResize();
/*N*/ 
/*N*/ 		// auf VCL gibt's Update ohne Ende (jedes Update gilt fuer alle Fenster)
/*N*/ 		//aCornerButton.Update();		// der bekommt sonst nie ein Update
/*N*/ 
/*N*/ 		bInUpdateHeader = FALSE;
/*N*/ 	}
/*N*/ }

/*N*/ inline void ShowHide( Window* pWin, BOOL bShow )
/*N*/ {
/*N*/ 	DBG_ASSERT(pWin || !bShow, "Fenster ist nicht da");
/*N*/ 	if (pWin)
/*N*/ 		pWin->Show(bShow);
/*N*/ }

/*N*/ void ScTabView::UpdateShow()
/*N*/ {
/*N*/ 	BOOL bHScrollMode = aViewData.IsHScrollMode();
/*N*/ 	BOOL bVScrollMode = aViewData.IsVScrollMode();
/*N*/ 	BOOL bTabMode	  = aViewData.IsTabMode();
/*N*/ 	BOOL bOutlMode	  = aViewData.IsOutlineMode();
/*N*/ 	BOOL bHOutline	  = bOutlMode && lcl_HasColOutline(aViewData);
/*N*/ 	BOOL bVOutline	  = bOutlMode && lcl_HasRowOutline(aViewData);
/*N*/ 	BOOL bHeader	  = aViewData.IsHeaderMode();
/*N*/ 
/*N*/ 	BOOL bShowH = ( aViewData.GetHSplitMode() != SC_SPLIT_NONE );
/*N*/ 	BOOL bShowV = ( aViewData.GetVSplitMode() != SC_SPLIT_NONE );
/*N*/ 
/*N*/ 	//	Scrollbar-Einstellungen koennen vom Sfx ueberschrieben werden:
/*N*/ 	SfxScrollingMode eMode = aViewData.GetViewShell()->GetScrollingMode();
/*N*/ 	if ( eMode == SCROLLING_NO )
/*?*/ 		bHScrollMode = bVScrollMode = FALSE;
/*N*/ 	else if ( eMode == SCROLLING_YES || eMode == SCROLLING_AUTO )	//! Auto ???
/*?*/ 		bHScrollMode = bVScrollMode = TRUE;
/*N*/ 
/*N*/ 	if ( aViewData.GetDocShell()->IsPreview() )
/*?*/ 		bHScrollMode = bVScrollMode = bTabMode = bHeader = bOutlMode = bHOutline = bVOutline = FALSE;
/*N*/ 
/*N*/ 		//
/*N*/ 		//	Windows anlegen
/*N*/ 		//
/*N*/ 
/*N*/ 	if (bShowH && !pGridWin[SC_SPLIT_BOTTOMRIGHT])
/*N*/ 	{
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	pGridWin[SC_SPLIT_BOTTOMRIGHT] = new ScGridWindow( pFrameWin, &aViewData, SC_SPLIT_BOTTOMRIGHT );
//STRIP001 /*?*/ 		DoAddWin( pGridWin[SC_SPLIT_BOTTOMRIGHT] );
/*N*/ 	}
/*N*/ 	if (bShowV && !pGridWin[SC_SPLIT_TOPLEFT])
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pGridWin[SC_SPLIT_TOPLEFT] = new ScGridWindow( pFrameWin, &aViewData, SC_SPLIT_TOPLEFT );
//STRIP001 /*?*/ 		DoAddWin( pGridWin[SC_SPLIT_TOPLEFT] );
/*N*/ 	}
/*N*/ 	if (bShowH && bShowV && !pGridWin[SC_SPLIT_TOPRIGHT])
/*N*/ 	{
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	pGridWin[SC_SPLIT_TOPRIGHT] = new ScGridWindow( pFrameWin, &aViewData, SC_SPLIT_TOPRIGHT );
//STRIP001 /*?*/ 		DoAddWin( pGridWin[SC_SPLIT_TOPRIGHT] );
/*N*/ 	}
/*N*/ 
/*N*/ 	if (bHOutline && !pColOutline[SC_SPLIT_LEFT])
/*?*/ 	{	DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pColOutline[SC_SPLIT_LEFT] = new ScOutlineWindow( pFrameWin, SC_OUTLINE_HOR, &aViewData, SC_SPLIT_BOTTOMLEFT );
/*N*/ 	if (bShowH && bHOutline && !pColOutline[SC_SPLIT_RIGHT])
/*?*/ 	{	DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pColOutline[SC_SPLIT_RIGHT] = new ScOutlineWindow( pFrameWin, SC_OUTLINE_HOR, &aViewData, SC_SPLIT_BOTTOMRIGHT );
/*N*/ 
/*N*/ 	if (bVOutline && !pRowOutline[SC_SPLIT_BOTTOM])
/*?*/ 	{	DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pRowOutline[SC_SPLIT_BOTTOM] = new ScOutlineWindow( pFrameWin, SC_OUTLINE_VER, &aViewData, SC_SPLIT_BOTTOMLEFT );
/*N*/ 	if (bShowV && bVOutline && !pRowOutline[SC_SPLIT_TOP])
/*?*/ 	{	DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pRowOutline[SC_SPLIT_TOP] = new ScOutlineWindow( pFrameWin, SC_OUTLINE_VER, &aViewData, SC_SPLIT_TOPLEFT );
/*N*/ 
/*N*/ 	if (bShowH && bHeader && !pColBar[SC_SPLIT_RIGHT])
/*N*/ 		pColBar[SC_SPLIT_RIGHT] = new ScColBar( pFrameWin, &aViewData, SC_SPLIT_RIGHT,
/*N*/ 												&aHdrFunc, pHdrSelEng );
/*N*/ 	if (bShowV && bHeader && !pRowBar[SC_SPLIT_TOP])
/*N*/ 		pRowBar[SC_SPLIT_TOP] = new ScRowBar( pFrameWin, &aViewData, SC_SPLIT_TOP,
/*N*/ 												&aHdrFunc, pHdrSelEng );
/*N*/ 
/*N*/ 		//
/*N*/ 		//	Windows anzeigen
/*N*/ 		//
/*N*/ 
/*N*/ 	ShowHide( &aHScrollLeft, bHScrollMode );
/*N*/ 	ShowHide( &aHScrollRight, bShowH && bHScrollMode );
/*N*/ 	ShowHide( &aVScrollBottom, bVScrollMode );
/*N*/ 	ShowHide( &aVScrollTop, bShowV && bVScrollMode );
/*N*/ 	ShowHide( &aScrollBarBox, bVScrollMode || bHScrollMode );
/*N*/ 
/*N*/ 	ShowHide( pHSplitter, bHScrollMode || bShowH );			// immer angelegt
/*N*/ 	ShowHide( pVSplitter, bVScrollMode || bShowV );
/*N*/ 	ShowHide( pTabControl, bTabMode );
/*N*/ 
/*N*/ 													// ab hier dynamisch angelegte
/*N*/ 
/*N*/ 	ShowHide( pGridWin[SC_SPLIT_BOTTOMRIGHT], bShowH );
/*N*/ 	ShowHide( pGridWin[SC_SPLIT_TOPLEFT], bShowV );
/*N*/ 	ShowHide( pGridWin[SC_SPLIT_TOPRIGHT], bShowH && bShowV );
/*N*/ 
/*N*/ 	ShowHide( pColOutline[SC_SPLIT_LEFT], bHOutline );
/*N*/ 	ShowHide( pColOutline[SC_SPLIT_RIGHT], bShowH && bHOutline );
/*N*/ 
/*N*/ 	ShowHide( pRowOutline[SC_SPLIT_BOTTOM], bVOutline );
/*N*/ 	ShowHide( pRowOutline[SC_SPLIT_TOP], bShowV && bVOutline );
/*N*/ 
/*N*/ 	ShowHide( pColBar[SC_SPLIT_RIGHT], bShowH && bHeader );
/*N*/ 	ShowHide( pRowBar[SC_SPLIT_TOP], bShowV && bHeader );
/*N*/ 
/*N*/ 
/*N*/ 	//!	neue Gridwindows eintragen
/*N*/ }

// ---  Splitter  --------------------------------------------------------

IMPL_LINK( ScTabView, SplitHdl, Splitter*, pSplitter )
{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if ( pSplitter == pHSplitter )
//STRIP001 		DoHSplit( pHSplitter->GetSplitPosPixel() );
//STRIP001 	else
//STRIP001 		DoVSplit( pVSplitter->GetSplitPosPixel() );
//STRIP001 
//STRIP001 	if ( aViewData.GetHSplitMode() == SC_SPLIT_FIX || aViewData.GetVSplitMode() == SC_SPLIT_FIX )
//STRIP001 		FreezeSplitters( TRUE );
//STRIP001 
//STRIP001 	DoResize( aBorderPos, aFrameSize );
//STRIP001 
	return 0;
}

//STRIP001 void ScTabView::DoHSplit(long nSplitPos)
//STRIP001 {
//STRIP001 	long nMinPos;
//STRIP001 	long nMaxPos;
//STRIP001 	USHORT nOldDelta;
//STRIP001 	USHORT nNewDelta;
//STRIP001 
//STRIP001 	nMinPos = SPLIT_MARGIN;
//STRIP001 	if ( pRowBar[SC_SPLIT_BOTTOM] && pRowBar[SC_SPLIT_BOTTOM]->GetSizePixel().Width() >= nMinPos )
//STRIP001 		nMinPos = pRowBar[SC_SPLIT_BOTTOM]->GetSizePixel().Width() + 1;
//STRIP001 	nMaxPos = aFrameSize.Width() - SPLIT_MARGIN;
//STRIP001 
//STRIP001 	ScSplitMode aOldMode = aViewData.GetHSplitMode();
//STRIP001 	ScSplitMode aNewMode = SC_SPLIT_NORMAL;
//STRIP001 
//STRIP001 	aViewData.SetHSplitPos( nSplitPos );
//STRIP001 	if ( nSplitPos < nMinPos || nSplitPos > nMaxPos )
//STRIP001 		aNewMode = SC_SPLIT_NONE;
//STRIP001 
//STRIP001 	aViewData.SetHSplitMode( aNewMode );
//STRIP001 
//STRIP001 	if ( aNewMode != aOldMode )
//STRIP001 	{
//STRIP001 		UpdateShow();		// vor ActivatePart !!
//STRIP001 
//STRIP001 		if ( aNewMode == SC_SPLIT_NONE )
//STRIP001 		{
//STRIP001 			if (aViewData.GetActivePart() == SC_SPLIT_TOPRIGHT)
//STRIP001 				ActivatePart( SC_SPLIT_TOPLEFT );
//STRIP001 			if (aViewData.GetActivePart() == SC_SPLIT_BOTTOMRIGHT)
//STRIP001 				ActivatePart( SC_SPLIT_BOTTOMLEFT );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			nOldDelta = aViewData.GetPosX( SC_SPLIT_LEFT );
//STRIP001 //			aViewData.SetPosX( SC_SPLIT_LEFT, nOldDelta );
//STRIP001 			long nLeftWidth = nSplitPos - pRowBar[SC_SPLIT_BOTTOM]->GetSizePixel().Width();
//STRIP001 			if ( nLeftWidth < 0 ) nLeftWidth = 0;
//STRIP001 			nNewDelta = nOldDelta + aViewData.CellsAtX( nOldDelta, 1, SC_SPLIT_LEFT,
//STRIP001 							(USHORT) nLeftWidth );
//STRIP001 			if ( nNewDelta > MAXCOL )
//STRIP001 				nNewDelta = MAXCOL;
//STRIP001 			aViewData.SetPosX( SC_SPLIT_RIGHT, nNewDelta );
//STRIP001 			if ( nNewDelta > aViewData.GetCurX() )
//STRIP001 				ActivatePart( (WhichV(aViewData.GetActivePart()) == SC_SPLIT_BOTTOM) ?
//STRIP001 					SC_SPLIT_BOTTOMLEFT : SC_SPLIT_TOPLEFT );
//STRIP001 			else
//STRIP001 				ActivatePart( (WhichV(aViewData.GetActivePart()) == SC_SPLIT_BOTTOM) ?
//STRIP001 					SC_SPLIT_BOTTOMRIGHT : SC_SPLIT_TOPRIGHT );
//STRIP001 		}
//STRIP001 
//STRIP001 		//	#61410# Form-Layer muss den sichtbaren Ausschnitt aller Fenster kennen
//STRIP001 		//	dafuer muss hier schon der MapMode stimmen
//STRIP001 		for (USHORT i=0; i<4; i++)
//STRIP001 			if (pGridWin[i])
//STRIP001 				pGridWin[i]->SetMapMode( pGridWin[i]->GetDrawMapMode() );
//STRIP001 		SetNewVisArea();
//STRIP001 
//STRIP001 		PaintGrid();
//STRIP001 		PaintTop();
//STRIP001 
//STRIP001 		InvalidateSplit();
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScTabView::DoVSplit(long nSplitPos)
//STRIP001 {
//STRIP001 	long nMinPos;
//STRIP001 	long nMaxPos;
//STRIP001 	USHORT nOldDelta;
//STRIP001 	USHORT nNewDelta;
//STRIP001 
//STRIP001 	nMinPos = SPLIT_MARGIN;
//STRIP001 	if ( pColBar[SC_SPLIT_LEFT] && pColBar[SC_SPLIT_LEFT]->GetSizePixel().Height() >= nMinPos )
//STRIP001 		nMinPos = pColBar[SC_SPLIT_LEFT]->GetSizePixel().Height() + 1;
//STRIP001 	nMaxPos = aFrameSize.Height() - SPLIT_MARGIN;
//STRIP001 
//STRIP001 	ScSplitMode aOldMode = aViewData.GetVSplitMode();
//STRIP001 	ScSplitMode aNewMode = SC_SPLIT_NORMAL;
//STRIP001 
//STRIP001 	aViewData.SetVSplitPos( nSplitPos );
//STRIP001 	if ( nSplitPos < nMinPos || nSplitPos > nMaxPos )
//STRIP001 		aNewMode = SC_SPLIT_NONE;
//STRIP001 
//STRIP001 	aViewData.SetVSplitMode( aNewMode );
//STRIP001 
//STRIP001 	if ( aNewMode != aOldMode )
//STRIP001 	{
//STRIP001 		UpdateShow();		// vor ActivatePart !!
//STRIP001 
//STRIP001 		if ( aNewMode == SC_SPLIT_NONE )
//STRIP001 		{
//STRIP001 			nOldDelta = aViewData.GetPosY( SC_SPLIT_TOP );
//STRIP001 			aViewData.SetPosY( SC_SPLIT_BOTTOM, nOldDelta );
//STRIP001 
//STRIP001 			if (aViewData.GetActivePart() == SC_SPLIT_TOPLEFT)
//STRIP001 				ActivatePart( SC_SPLIT_BOTTOMLEFT );
//STRIP001 			if (aViewData.GetActivePart() == SC_SPLIT_TOPRIGHT)
//STRIP001 				ActivatePart( SC_SPLIT_BOTTOMRIGHT );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if ( aOldMode == SC_SPLIT_NONE )
//STRIP001 				nOldDelta = aViewData.GetPosY( SC_SPLIT_BOTTOM );
//STRIP001 			else
//STRIP001 				nOldDelta = aViewData.GetPosY( SC_SPLIT_TOP );
//STRIP001 
//STRIP001 			aViewData.SetPosY( SC_SPLIT_TOP, nOldDelta );
//STRIP001 			long nTopHeight = nSplitPos - pColBar[SC_SPLIT_LEFT]->GetSizePixel().Height();
//STRIP001 			if ( nTopHeight < 0 ) nTopHeight = 0;
//STRIP001 			nNewDelta = nOldDelta + aViewData.CellsAtY( nOldDelta, 1, SC_SPLIT_TOP,
//STRIP001 							(USHORT) nTopHeight );
//STRIP001 			if ( nNewDelta > MAXROW )
//STRIP001 				nNewDelta = MAXROW;
//STRIP001 			aViewData.SetPosY( SC_SPLIT_BOTTOM, nNewDelta );
//STRIP001 			if ( nNewDelta > aViewData.GetCurY() )
//STRIP001 				ActivatePart( (WhichH(aViewData.GetActivePart()) == SC_SPLIT_LEFT) ?
//STRIP001 					SC_SPLIT_TOPLEFT : SC_SPLIT_TOPRIGHT );
//STRIP001 			else
//STRIP001 				ActivatePart( (WhichH(aViewData.GetActivePart()) == SC_SPLIT_LEFT) ?
//STRIP001 					SC_SPLIT_BOTTOMLEFT : SC_SPLIT_BOTTOMRIGHT );
//STRIP001 		}
//STRIP001 
//STRIP001 		//	#61410# Form-Layer muss den sichtbaren Ausschnitt aller Fenster kennen
//STRIP001 		//	dafuer muss hier schon der MapMode stimmen
//STRIP001 		for (USHORT i=0; i<4; i++)
//STRIP001 			if (pGridWin[i])
//STRIP001 				pGridWin[i]->SetMapMode( pGridWin[i]->GetDrawMapMode() );
//STRIP001 		SetNewVisArea();
//STRIP001 
//STRIP001 		PaintGrid();
//STRIP001 		PaintLeft();
//STRIP001 
//STRIP001 		InvalidateSplit();
//STRIP001 	}
//STRIP001 }

//STRIP001 Point ScTabView::GetInsertPos()
//STRIP001 {
//STRIP001 	ScDocument* pDoc = aViewData.GetDocument();
//STRIP001 	USHORT nCol = aViewData.GetCurX();
//STRIP001 	USHORT nRow = aViewData.GetCurY();
//STRIP001 	USHORT nTab = aViewData.GetTabNo();
//STRIP001 	USHORT i;
//STRIP001 	long nPosX = 0;
//STRIP001 	for (i=0; i<nCol; i++)
//STRIP001 		nPosX += pDoc->GetColWidth(i,nTab);
//STRIP001 	nPosX = (long)(nPosX * HMM_PER_TWIPS);
//STRIP001 	long nPosY = 0;
//STRIP001 	for (i=0; i<nRow; i++)
//STRIP001 		nPosY += pDoc->GetRowHeight(i,nTab);
//STRIP001 	nPosY = (long)(nPosY * HMM_PER_TWIPS);
//STRIP001 	return Point(nPosX,nPosY);
//STRIP001 }

//STRIP001 void ScTabView::LockModifiers( USHORT nModifiers )
//STRIP001 {
//STRIP001 	pSelEngine->LockModifiers( nModifiers );
//STRIP001 	pHdrSelEng->LockModifiers( nModifiers );
//STRIP001 }

/*N*/ USHORT ScTabView::GetLockedModifiers() const
/*N*/ {
/*N*/ 	return pSelEngine->GetLockedModifiers();
/*N*/ }

//STRIP001 Point ScTabView::GetMousePosPixel()
//STRIP001 {
//STRIP001 	Point aPos;
//STRIP001 	ScGridWindow* pWin = (ScGridWindow*)GetActiveWin();
//STRIP001 
//STRIP001 	if ( pWin )
//STRIP001 		aPos = pWin->GetMousePosPixel();
//STRIP001 
//STRIP001 	return aPos;
//STRIP001 }

//STRIP001 BOOL lcl_MouseIsOverWin( const Point& rScreenPosPixel, Window* pWin )
//STRIP001 {
//STRIP001 	if (pWin)
//STRIP001 	{
//STRIP001 		//	SPLIT_HANDLE_SIZE draufaddieren, damit das Einrasten genau
//STRIP001 		//	auf dem Splitter nicht aussetzt
//STRIP001 
//STRIP001 		Point aRel = pWin->ScreenToOutputPixel( rScreenPosPixel );
//STRIP001 		Size aWinSize = pWin->GetOutputSizePixel();
//STRIP001 		if ( aRel.X() >= 0 && aRel.X() < aWinSize.Width() + SPLIT_HANDLE_SIZE &&
//STRIP001 				aRel.Y() >= 0 && aRel.Y() < aWinSize.Height() + SPLIT_HANDLE_SIZE )
//STRIP001 			return TRUE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }

//STRIP001 void ScTabView::SnapSplitPos( Point& rScreenPosPixel )
//STRIP001 {
//STRIP001 	BOOL bOverWin = FALSE;
//STRIP001 	USHORT i;
//STRIP001 	for (i=0; i<4; i++)
//STRIP001 		if (lcl_MouseIsOverWin(rScreenPosPixel,pGridWin[i]))
//STRIP001 			bOverWin = TRUE;
//STRIP001 
//STRIP001 	if (!bOverWin)
//STRIP001 		return;
//STRIP001 
//STRIP001 	//	#74761# don't snap to cells if the scale will be modified afterwards
//STRIP001 	if ( eZoomType != SVX_ZOOM_PERCENT )
//STRIP001 		return;
//STRIP001 
//STRIP001 	ScSplitPos ePos = SC_SPLIT_BOTTOMLEFT;
//STRIP001 	if ( aViewData.GetVSplitMode() != SC_SPLIT_NONE )
//STRIP001 		ePos = SC_SPLIT_TOPLEFT;
//STRIP001 
//STRIP001 	Window* pWin = pGridWin[ePos];
//STRIP001 	if (!pWin)
//STRIP001 	{
//STRIP001 		DBG_ERROR("Window NULL");
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	Point aMouse = pWin->ScreenToOutputPixel( rScreenPosPixel );
//STRIP001 	short nPosX;
//STRIP001 	short nPosY;
//STRIP001 	//	#52949# bNextIfLarge=FALSE: nicht auf naechste Zelle, wenn ausserhalb des Fensters
//STRIP001 	aViewData.GetPosFromPixel( aMouse.X(), aMouse.Y(), ePos, nPosX, nPosY, TRUE, FALSE, FALSE );
//STRIP001 	BOOL bLeft;
//STRIP001 	BOOL bTop;
//STRIP001 	aViewData.GetMouseQuadrant( aMouse, ePos, nPosX, nPosY, bLeft, bTop );
//STRIP001 	if (!bLeft)
//STRIP001 		++nPosX;
//STRIP001 	if (!bTop)
//STRIP001 		++nPosY;
//STRIP001 	aMouse = aViewData.GetScrPos( (USHORT)nPosX, (USHORT)nPosY, ePos, TRUE );
//STRIP001 	rScreenPosPixel = pWin->OutputToScreenPixel( aMouse );
//STRIP001 }

/*N*/ void ScTabView::FreezeSplitters( BOOL bFreeze )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*N*/ 	ScSplitMode eOldH = aViewData.GetHSplitMode();
//STRIP001 /*N*/ 	ScSplitMode eOldV = aViewData.GetVSplitMode();
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 	ScSplitPos ePos = SC_SPLIT_BOTTOMLEFT;
//STRIP001 /*N*/ 	if ( eOldV != SC_SPLIT_NONE )
//STRIP001 /*N*/ 		ePos = SC_SPLIT_TOPLEFT;
//STRIP001 /*N*/ 	Window* pWin = pGridWin[ePos];
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 	if ( bFreeze )
//STRIP001 /*N*/ 	{
//STRIP001 /*N*/ 		Point aWinStart = pWin->GetPosPixel();
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 		Point aSplit;
//STRIP001 /*N*/ 		short nPosX;
//STRIP001 /*N*/ 		short nPosY;
//STRIP001 /*N*/ 		if (eOldH != SC_SPLIT_NONE || eOldV != SC_SPLIT_NONE)
//STRIP001 /*N*/ 		{ 
//STRIP001 /*N*/ 			if (eOldH != SC_SPLIT_NONE)
//STRIP001 /*N*/ 				aSplit.X() = aViewData.GetHSplitPos() - aWinStart.X();
//STRIP001 /*N*/ 			if (eOldV != SC_SPLIT_NONE)
//STRIP001 /*N*/ 				aSplit.Y() = aViewData.GetVSplitPos() - aWinStart.Y();
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 			aViewData.GetPosFromPixel( aSplit.X(), aSplit.Y(), ePos, nPosX, nPosY );
//STRIP001 /*N*/ 			BOOL bLeft;
//STRIP001 /*N*/ 			BOOL bTop;
//STRIP001 /*N*/ 			aViewData.GetMouseQuadrant( aSplit, ePos, nPosX, nPosY, bLeft, bTop );
//STRIP001 /*N*/ 			if (!bLeft)
//STRIP001 /*N*/ 				++nPosX;
//STRIP001 /*N*/ 			if (!bTop)
//STRIP001 /*N*/ 				++nPosY;
//STRIP001 /*N*/ 		}
//STRIP001 /*N*/ 		else
//STRIP001 /*N*/ 		{
//STRIP001 /*N*/ 			nPosX = (short) aViewData.GetCurX();
//STRIP001 /*N*/ 			nPosY = (short) aViewData.GetCurY();
//STRIP001 /*N*/ 		}
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 		USHORT nLeftPos = aViewData.GetPosX(SC_SPLIT_LEFT);
//STRIP001 /*N*/ 		USHORT nTopPos = aViewData.GetPosY(SC_SPLIT_BOTTOM);
//STRIP001 /*N*/ 		USHORT nRightPos = nPosX;
//STRIP001 /*N*/ 		USHORT nBottomPos = nPosY;
//STRIP001 /*N*/ 		if (eOldH != SC_SPLIT_NONE)
//STRIP001 /*N*/ 			if (aViewData.GetPosX(SC_SPLIT_RIGHT) > nRightPos)
//STRIP001 /*N*/ 				nRightPos = aViewData.GetPosX(SC_SPLIT_RIGHT);
//STRIP001 /*N*/ 		if (eOldV != SC_SPLIT_NONE)
//STRIP001 /*N*/ 		{
//STRIP001 /*N*/ 			nTopPos = aViewData.GetPosY(SC_SPLIT_TOP);
//STRIP001 /*N*/ 			if (aViewData.GetPosY(SC_SPLIT_BOTTOM) > nBottomPos)
//STRIP001 /*N*/ 				nBottomPos = aViewData.GetPosY(SC_SPLIT_BOTTOM);
//STRIP001 /*N*/ 		}
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 		aSplit = aViewData.GetScrPos( (USHORT)nPosX, (USHORT)nPosY, ePos, TRUE );
//STRIP001 /*N*/ 		if (aSplit.X() > 0)
//STRIP001 /*N*/ 		{
//STRIP001 /*N*/ 			aViewData.SetHSplitMode( SC_SPLIT_FIX );
//STRIP001 /*N*/ 			aViewData.SetHSplitPos( aSplit.X() + aWinStart.X() );
//STRIP001 /*N*/ 			aViewData.SetFixPosX( nPosX );
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 			aViewData.SetPosX(SC_SPLIT_LEFT, nLeftPos);
//STRIP001 /*N*/ 			aViewData.SetPosX(SC_SPLIT_RIGHT, nRightPos);
//STRIP001 /*N*/ 		}
//STRIP001 /*N*/ 		else
//STRIP001 /*N*/ 			aViewData.SetHSplitMode( SC_SPLIT_NONE );
//STRIP001 /*N*/ 		if (aSplit.Y() > 0)
//STRIP001 /*N*/ 		{
//STRIP001 /*N*/ 			aViewData.SetVSplitMode( SC_SPLIT_FIX );
//STRIP001 /*N*/ 			aViewData.SetVSplitPos( aSplit.Y() + aWinStart.Y() );
//STRIP001 /*N*/ 			aViewData.SetFixPosY( nPosY );
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 			aViewData.SetPosY(SC_SPLIT_TOP, nTopPos);
//STRIP001 /*N*/ 			aViewData.SetPosY(SC_SPLIT_BOTTOM, nBottomPos);
//STRIP001 /*N*/ 		}
//STRIP001 /*N*/ 		else
//STRIP001 /*N*/ 			aViewData.SetVSplitMode( SC_SPLIT_NONE );
//STRIP001 /*N*/ 	}
//STRIP001 /*N*/ 	else						// Fixierung aufheben
//STRIP001 /*N*/ 	{
//STRIP001 /*N*/ 		if ( eOldH == SC_SPLIT_FIX )
//STRIP001 /*N*/ 			aViewData.SetHSplitMode( SC_SPLIT_NORMAL );
//STRIP001 /*N*/ 		if ( eOldV == SC_SPLIT_FIX )
//STRIP001 /*N*/ 			aViewData.SetVSplitMode( SC_SPLIT_NORMAL );
//STRIP001 /*N*/ 	}
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 	//	#61410# Form-Layer muss den sichtbaren Ausschnitt aller Fenster kennen
//STRIP001 /*N*/ 	//	dafuer muss hier schon der MapMode stimmen
//STRIP001 /*N*/ 	for (USHORT i=0; i<4; i++)
//STRIP001 /*N*/ 		if (pGridWin[i])
//STRIP001 /*N*/ 			pGridWin[i]->SetMapMode( pGridWin[i]->GetDrawMapMode() );
//STRIP001 /*N*/ 	SetNewVisArea();
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 	RepeatResize(FALSE);
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 	UpdateShow();
//STRIP001 /*N*/ 	PaintLeft();
//STRIP001 /*N*/ 	PaintTop();
//STRIP001 /*N*/ 	PaintGrid();
//STRIP001 /*N*/ 
//STRIP001 /*?*/ 	//	SC_FOLLOW_NONE: only update active part
//STRIP001 /*?*/ 	AlignToCursor( aViewData.GetCurX(), aViewData.GetCurY(), SC_FOLLOW_NONE );
//STRIP001 /*?*/ 	UpdateAutoFillMark();
//STRIP001 /*?*/ 
//STRIP001 /*N*/ 	InvalidateSplit();
/*N*/ }

/*N*/ void ScTabView::RemoveSplit()
/*N*/ {
/*N*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 DoHSplit( 0 );
//STRIP001 	DoVSplit( 0 );
//STRIP001 	RepeatResize();
/*N*/ }

//STRIP001 void ScTabView::SplitAtCursor()
//STRIP001 {
//STRIP001 	ScSplitPos ePos = SC_SPLIT_BOTTOMLEFT;
//STRIP001 	if ( aViewData.GetVSplitMode() != SC_SPLIT_NONE )
//STRIP001 		ePos = SC_SPLIT_TOPLEFT;
//STRIP001 	Window* pWin = pGridWin[ePos];
//STRIP001 	Point aWinStart = pWin->GetPosPixel();
//STRIP001 
//STRIP001 	USHORT nPosX = aViewData.GetCurX();
//STRIP001 	USHORT nPosY = aViewData.GetCurY();
//STRIP001 	Point aSplit = aViewData.GetScrPos( nPosX, nPosY, ePos, TRUE );
//STRIP001 	if ( nPosX > 0 )
//STRIP001 		DoHSplit( aSplit.X() + aWinStart.X() );
//STRIP001 	else
//STRIP001 		DoHSplit( 0 );
//STRIP001 	if ( nPosY > 0 )
//STRIP001 		DoVSplit( aSplit.Y() + aWinStart.Y() );
//STRIP001 	else
//STRIP001 		DoVSplit( 0 );
//STRIP001 	RepeatResize();
//STRIP001 }

/*N*/ void ScTabView::SplitAtPixel( const Point& rPixel, BOOL bHor, BOOL bVer )		// fuer API
/*N*/ {
/*N*/ 	//	Pixel ist auf die ganze View bezogen, nicht auf das erste GridWin
/*N*/ 
/*N*/ 	if (bHor)
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*N*/ 		if ( rPixel.X() > 0 )
//STRIP001 /*N*/ 			DoHSplit( rPixel.X() );
//STRIP001 /*N*/ 		else
//STRIP001 /*N*/ 			DoHSplit( 0 );
/*N*/ 	}
/*N*/ 	if (bVer)
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*N*/ 		if ( rPixel.Y() > 0 )
//STRIP001 /*N*/ 			DoVSplit( rPixel.Y() );
//STRIP001 /*N*/ 		else
//STRIP001 /*N*/ 			DoVSplit( 0 );
/*N*/ 	}
/*N*/ 	RepeatResize();
/*N*/ }

/*N*/ void ScTabView::InvalidateSplit()
/*N*/ {
/*N*/ 	SfxBindings& rBindings = aViewData.GetBindings();
/*N*/ 	rBindings.Invalidate( SID_WINDOW_SPLIT );
/*N*/ 	rBindings.Invalidate( SID_WINDOW_FIX );
/*N*/ 
/*N*/ 	pHSplitter->SetFixed( aViewData.GetHSplitMode() == SC_SPLIT_FIX );
/*N*/ 	pVSplitter->SetFixed( aViewData.GetVSplitMode() == SC_SPLIT_FIX );
/*N*/ }

/*N*/ void ScTabView::SetNewVisArea()
/*N*/ {
/*N*/ 	//	#63854# fuer die Controls muss bei VisAreaChanged der Draw-MapMode eingestellt sein
/*N*/ 	//	(auch wenn ansonsten der Edit-MapMode gesetzt ist)
/*N*/ 	MapMode aOldMode[4];
/*N*/ 	MapMode aDrawMode[4];
/*N*/ 	USHORT i;
/*N*/ 	for (i=0; i<4; i++)
/*N*/ 		if (pGridWin[i])
/*N*/ 		{
/*N*/ 			aOldMode[i] = pGridWin[i]->GetMapMode();
/*N*/ 			aDrawMode[i] = pGridWin[i]->GetDrawMapMode();
/*N*/ 			if (aDrawMode[i] != aOldMode[i])
/*?*/ 				pGridWin[i]->SetMapMode(aDrawMode[i]);
/*N*/ 		}
/*N*/ 
/*N*/ 	Window* pActive = pGridWin[aViewData.GetActivePart()];
/*N*/ 	if (pActive)
/*N*/ 		aViewData.GetViewShell()->VisAreaChanged(
/*N*/ 			pActive->PixelToLogic(Rectangle(Point(),pActive->GetOutputSizePixel())) );
/*N*/ 	if (pDrawView)
/*N*/ 		pDrawView->VisAreaChanged();	// kein Window uebergeben -> alle Fenster
/*N*/ 
/*N*/ 	for (i=0; i<4; i++)
/*N*/ 		if (pGridWin[i] && aDrawMode[i] != aOldMode[i])
/*?*/ 			pGridWin[i]->SetMapMode(aOldMode[i]);
/*N*/ 
/*N*/ 	SfxViewFrame* pViewFrame = aViewData.GetViewShell()->GetViewFrame();
/*N*/ 	if (pViewFrame)
/*N*/ 	{
/*N*/ 		SfxFrame* pFrame = pViewFrame->GetFrame();
/*N*/ 		if (pFrame)
/*N*/ 		{
/*N*/ 			::com::sun::star::uno::Reference< ::com::sun::star::frame::XController> xController = pFrame->GetController();
/*N*/ 			if (xController.is())
/*N*/ 			{
/*?*/ 				ScTabViewObj* pImp = ScTabViewObj::getImplementation( xController );
/*?*/ 				if (pImp)
/*?*/ 					pImp->VisAreaChanged();
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 	if (aViewData.GetViewShell()->HasAccessibilityObjects())
			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 		aViewData.GetViewShell()->BroadcastAccessibility(SfxSimpleHint(SC_HINT_ACC_VISAREACHANGED));
/*N*/ }

//STRIP001 void ScTabView::StartDataSelect()
//STRIP001 {
//STRIP001 	ScGridWindow* pWin = pGridWin[aViewData.GetActivePart()];
//STRIP001 	USHORT nCol = aViewData.GetCurX();
//STRIP001 	USHORT nRow = aViewData.GetCurY();
//STRIP001 	if (pWin)
//STRIP001 		pWin->DoAutoFilterMenue( nCol, nRow, TRUE );
//STRIP001 }

//STRIP001 void ScTabView::EnableRefInput(BOOL bFlag)
//STRIP001 {
//STRIP001 	aHScrollLeft.EnableInput(bFlag);
//STRIP001 	aHScrollRight.EnableInput(bFlag);
//STRIP001 	aVScrollBottom.EnableInput(bFlag);
//STRIP001 	aVScrollTop.EnableInput(bFlag);
//STRIP001 	aScrollBarBox.EnableInput(bFlag);
//STRIP001 
//STRIP001 	// ab hier dynamisch angelegte
//STRIP001 
//STRIP001 	if(pTabControl!=NULL) pTabControl->EnableInput(bFlag,TRUE);
//STRIP001 
//STRIP001 	if(pGridWin[SC_SPLIT_BOTTOMLEFT]!=NULL)
//STRIP001 		pGridWin[SC_SPLIT_BOTTOMLEFT]->EnableInput(bFlag,FALSE);
//STRIP001 	if(pGridWin[SC_SPLIT_BOTTOMRIGHT]!=NULL)
//STRIP001 		pGridWin[SC_SPLIT_BOTTOMRIGHT]->EnableInput(bFlag,FALSE);
//STRIP001 	if(pGridWin[SC_SPLIT_TOPLEFT]!=NULL)
//STRIP001 		pGridWin[SC_SPLIT_TOPLEFT]->EnableInput(bFlag,FALSE);
//STRIP001 	if(pGridWin[SC_SPLIT_TOPRIGHT]!=NULL)
//STRIP001 		pGridWin[SC_SPLIT_TOPRIGHT]->EnableInput(bFlag,FALSE);
//STRIP001 	if(pColBar[SC_SPLIT_RIGHT]!=NULL)
//STRIP001 		pColBar[SC_SPLIT_RIGHT]->EnableInput(bFlag,FALSE);
//STRIP001 	if(pRowBar[SC_SPLIT_TOP]!=NULL)
//STRIP001 		pRowBar[SC_SPLIT_TOP]->EnableInput(bFlag,FALSE);
//STRIP001 }



}
