/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_docsh8.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 19:09:25 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

#include <tools/urlobj.hxx>
#include <svtools/converter.hxx>
#include <svtools/zforlist.hxx>
#include <comphelper/types.hxx>
#include <ucbhelper/content.hxx>
#include <comphelper/processfactory.hxx>
#include <connectivity/dbcharset.hxx>

#include <com/sun/star/sdb/CommandType.hpp>
#include <com/sun/star/sdbc/DataType.hpp>
#include <com/sun/star/sdbc/XConnection.hpp>
#include <com/sun/star/sdbc/XDriver.hpp>
#include <com/sun/star/sdbc/XDriverManager.hpp>
#include <com/sun/star/sdbc/XResultSetUpdate.hpp>
#include <com/sun/star/sdbc/XRow.hpp>
#include <com/sun/star/sdbc/XRowSet.hpp>
#include <com/sun/star/sdbc/XRowUpdate.hpp>
#include <com/sun/star/sdbc/XResultSetMetaDataSupplier.hpp>
#include <com/sun/star/sdbcx/XAppend.hpp>
#include <com/sun/star/sdbcx/XColumnsSupplier.hpp>
#include <com/sun/star/sdbcx/XDataDefinitionSupplier.hpp>
#include <com/sun/star/sdbcx/XDataDescriptorFactory.hpp>
#include <com/sun/star/sdbcx/XTablesSupplier.hpp>
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#include <com/sun/star/beans/XPropertySet.hpp>
#include <com/sun/star/container/XEnumerationAccess.hpp>
#include <com/sun/star/lang/XComponent.hpp>
#include <com/sun/star/ucb/NameClash.hpp>
#include <com/sun/star/ucb/TransferInfo.hpp>
#include <com/sun/star/ucb/XCommandInfo.hpp>

#include "scerrors.hxx"
#include "docsh.hxx"
#include "filter.hxx"
#include "progress.hxx"
#include "collect.hxx"
#include "cell.hxx"
#include "editutil.hxx"
#include "cellform.hxx"
#include "dbdocutl.hxx"
#include "globstr.hrc"
#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif
namespace binfilter {
using namespace ::com::sun::star;

// -----------------------------------------------------------------------

#define SC_SERVICE_ROWSET			"com.sun.star.sdb.RowSet"
#define SC_SERVICE_DRVMAN			"com.sun.star.sdbc.DriverManager"

//!	move to a header file?
//#define SC_DBPROP_DATASOURCENAME	"DataSourceName"
#define SC_DBPROP_ACTIVECONNECTION	"ActiveConnection"
#define SC_DBPROP_COMMAND			"Command"
#define SC_DBPROP_COMMANDTYPE		"CommandType"

#define SC_DBPROP_NAME				"Name"
#define SC_DBPROP_TYPE				"Type"
#define SC_DBPROP_PRECISION			"Precision"
#define SC_DBPROP_SCALE				"Scale"

#define SC_DBPROP_EXTENSION			"Extension"
#define SC_DBPROP_CHARSET			"CharSet"

#define SC_ROWCOUNT_ERROR		(-1)

// -----------------------------------------------------------------------
// MoveFile/KillFile/IsDocument: similar to SfxContentHelper

// static
//STRIP001 BOOL ScDocShell::MoveFile( const INetURLObject& rSourceObj, const INetURLObject& rDestObj )
//STRIP001 {
//STRIP001 	sal_Bool bMoveData = sal_True;
//STRIP001 	sal_Bool bRet = sal_True, bKillSource = sal_False;
//STRIP001 	if ( rSourceObj.GetProtocol() != rDestObj.GetProtocol() )
//STRIP001 	{
//STRIP001 		bMoveData = sal_False;
//STRIP001 		bKillSource = sal_True;
//STRIP001 	}
//STRIP001 	String aName = rDestObj.getName();
//STRIP001 	INetURLObject aDestPathObj = rDestObj;
//STRIP001 	aDestPathObj.removeSegment();
//STRIP001 	aDestPathObj.setFinalSlash();
//STRIP001 
//STRIP001 	try
//STRIP001 	{
//STRIP001 		::ucb::Content aDestPath( aDestPathObj.GetMainURL(INetURLObject::NO_DECODE),
//STRIP001 							uno::Reference< ::com::sun::star::ucb::XCommandEnvironment > () );
//STRIP001 		uno::Reference< ::com::sun::star::ucb::XCommandInfo > xInfo = aDestPath.getCommands();
//STRIP001 		::rtl::OUString aTransferName = ::rtl::OUString::createFromAscii( "transfer" );
//STRIP001 		if ( xInfo->hasCommandByName( aTransferName ) )
//STRIP001 		{
//STRIP001 			aDestPath.executeCommand( aTransferName, uno::makeAny(
//STRIP001                 ::com::sun::star::ucb::TransferInfo( bMoveData, rSourceObj.GetMainURL(INetURLObject::NO_DECODE), aName,
//STRIP001                										::com::sun::star::ucb::NameClash::ERROR ) ) );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			DBG_ERRORFILE( "transfer command not available" );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	catch( uno::Exception& )
//STRIP001 	{
//STRIP001 		// ucb may throw different exceptions on failure now
//STRIP001 		bRet = sal_False;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bKillSource )
//STRIP001 		KillFile( rSourceObj );
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }


// static
//STRIP001 BOOL ScDocShell::KillFile( const INetURLObject& rURL )
//STRIP001 {
//STRIP001 	sal_Bool bRet = sal_True;
//STRIP001 	try
//STRIP001 	{
//STRIP001 		::ucb::Content aCnt( rURL.GetMainURL(INetURLObject::NO_DECODE),
//STRIP001 						uno::Reference< ::com::sun::star::ucb::XCommandEnvironment > () );
//STRIP001 		aCnt.executeCommand( ::rtl::OUString::createFromAscii( "delete" ),
//STRIP001 								::comphelper::makeBoolAny( sal_True ) );
//STRIP001 	}
//STRIP001 	catch( uno::Exception& )
//STRIP001 	{
//STRIP001 		// ucb may throw different exceptions on failure now
//STRIP001 		bRet = sal_False;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }

// static
//STRIP001 BOOL ScDocShell::IsDocument( const INetURLObject& rURL )
//STRIP001 {
//STRIP001 	sal_Bool bRet = sal_False;
//STRIP001 	try
//STRIP001 	{
//STRIP001 		::ucb::Content aCnt( rURL.GetMainURL(INetURLObject::NO_DECODE),
//STRIP001 						uno::Reference< ::com::sun::star::ucb::XCommandEnvironment > () );
//STRIP001 		bRet = aCnt.isDocument();
//STRIP001 	}
//STRIP001     catch( uno::Exception& )
//STRIP001 	{
//STRIP001 		// ucb may throw different exceptions on failure now - warning only
//STRIP001 		DBG_WARNING( "Any other exception" );
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 long lcl_GetRowCount( const uno::Reference<sdbc::XConnection>& xConnection,
//STRIP001 						const String& rTabName )
//STRIP001 {
//STRIP001 	try
//STRIP001 	{
//STRIP001 		uno::Reference<sdbc::XStatement> xStatement = xConnection->createStatement();
//STRIP001 		DBG_ASSERT( xStatement.is(), "can't get Statement" );
//STRIP001 		if (!xStatement.is()) return SC_ROWCOUNT_ERROR;
//STRIP001 
//STRIP001 		String aQuoteStr;
//STRIP001 		uno::Reference<sdbc::XDatabaseMetaData> xDBMeta = xConnection->getMetaData();
//STRIP001 		if (xDBMeta.is())
//STRIP001 			aQuoteStr = xDBMeta->getIdentifierQuoteString();
//STRIP001 
//STRIP001 		String aSql = String::CreateFromAscii("SELECT COUNT ( * ) FROM ");
//STRIP001 		aSql += aQuoteStr;
//STRIP001 		aSql += rTabName;
//STRIP001 		aSql += aQuoteStr;
//STRIP001 
//STRIP001 		uno::Reference<sdbc::XResultSet> xResSet = xStatement->executeQuery( aSql );
//STRIP001 		uno::Reference<sdbc::XRow> xRow( xResSet, uno::UNO_QUERY );
//STRIP001 		DBG_ASSERT( xRow.is(), "can't get Row" );
//STRIP001 		if (!xRow.is()) return SC_ROWCOUNT_ERROR;
//STRIP001 
//STRIP001 		if ( xResSet->next() )
//STRIP001 			return xRow->getInt( 1 );
//STRIP001 	}
//STRIP001 	catch ( sdbc::SQLException& )
//STRIP001 	{
//STRIP001 	}
//STRIP001 	catch ( uno::Exception& )
//STRIP001 	{
//STRIP001 		DBG_ERROR("Unexpected exception in database");
//STRIP001 	}
//STRIP001 
//STRIP001 	return SC_ROWCOUNT_ERROR;
//STRIP001 }

//STRIP001 ULONG ScDocShell::DBaseImport( const String& rFullFileName, CharSet eCharSet,
//STRIP001 								BOOL bSimpleColWidth[MAXCOL+1] )
//STRIP001 {
//STRIP001 	ULONG nErr = eERR_OK;
//STRIP001 	long i;
//STRIP001 
//STRIP001 	try
//STRIP001 	{
//STRIP001 		INetURLObject aURL;
//STRIP001 		aURL.SetSmartProtocol( INET_PROT_FILE );
//STRIP001 		aURL.SetSmartURL( rFullFileName );
//STRIP001 		String aTabName = aURL.getBase( INetURLObject::LAST_SEGMENT, true,
//STRIP001 										INetURLObject::DECODE_UNAMBIGUOUS );
//STRIP001 		String aExtension = aURL.getExtension();
//STRIP001 		aURL.removeSegment();
//STRIP001 		aURL.removeFinalSlash();
//STRIP001 		String aPath = aURL.GetMainURL(INetURLObject::NO_DECODE);
//STRIP001 
//STRIP001 		uno::Reference<lang::XMultiServiceFactory> xFactory = ::legacy_binfilters::getLegacyProcessServiceFactory();
//STRIP001 		if (!xFactory.is())
//STRIP001 			return ERRCODE_IO_GENERAL;
//STRIP001 
//STRIP001 		uno::Reference<sdbc::XDriverManager> xDrvMan( xFactory->createInstance(
//STRIP001 							::rtl::OUString::createFromAscii( SC_SERVICE_DRVMAN ) ),
//STRIP001 							uno::UNO_QUERY);
//STRIP001 		DBG_ASSERT( xDrvMan.is(), "can't get DriverManager" );
//STRIP001 		if (!xDrvMan.is()) return SCERR_IMPORT_CONNECT;
//STRIP001 
//STRIP001 		String aConnUrl = String::CreateFromAscii("sdbc:dbase:");
//STRIP001 		aConnUrl += aPath;
//STRIP001 
//STRIP001 		dbtools::OCharsetMap aMap;
//STRIP001 		dbtools::OCharsetMap::CharsetIterator aIter = aMap.find( (rtl_TextEncoding) eCharSet );
//STRIP001         if ( aIter == aMap.end() )
//STRIP001         {
//STRIP001             DBG_ERRORFILE( "DBaseImport: dbtools::OCharsetMap doesn't know text encoding" );
//STRIP001             return SCERR_IMPORT_CONNECT;
//STRIP001         }
//STRIP001 		::rtl::OUString aCharSetStr = (*aIter).getIanaName();
//STRIP001 
//STRIP001 		uno::Sequence<beans::PropertyValue> aProps(2);
//STRIP001 		aProps[0].Name = ::rtl::OUString::createFromAscii(SC_DBPROP_EXTENSION);
//STRIP001 		aProps[0].Value <<= ::rtl::OUString( aExtension );
//STRIP001 		aProps[1].Name = ::rtl::OUString::createFromAscii(SC_DBPROP_CHARSET);
//STRIP001 		aProps[1].Value <<= aCharSetStr;
//STRIP001 
//STRIP001 		uno::Reference<sdbc::XConnection> xConnection =
//STRIP001 								xDrvMan->getConnectionWithInfo( aConnUrl, aProps );
//STRIP001 		DBG_ASSERT( xConnection.is(), "can't get Connection" );
//STRIP001 		if (!xConnection.is()) return SCERR_IMPORT_CONNECT;
//STRIP001 
//STRIP001 //!		long nRowCount = lcl_GetRowCount( xConnection, aTabName );
//STRIP001 		long nRowCount = 0;
//STRIP001 		if ( nRowCount < 0 )
//STRIP001 		{
//STRIP001 			DBG_ERROR("can't get row count");
//STRIP001 			nRowCount = 0;
//STRIP001 		}
//STRIP001 
//STRIP001 		ScProgress aProgress( this, ScGlobal::GetRscString( STR_LOAD_DOC ), nRowCount );
//STRIP001 
//STRIP001 		uno::Reference<sdbc::XRowSet> xRowSet( xFactory->createInstance(
//STRIP001 							::rtl::OUString::createFromAscii( SC_SERVICE_ROWSET ) ),
//STRIP001 							uno::UNO_QUERY);
//STRIP001 		uno::Reference<beans::XPropertySet> xRowProp( xRowSet, uno::UNO_QUERY );
//STRIP001 		DBG_ASSERT( xRowProp.is(), "can't get RowSet" );
//STRIP001 		if (!xRowProp.is()) return SCERR_IMPORT_CONNECT;
//STRIP001 
//STRIP001 		sal_Int32 nType = sdb::CommandType::TABLE;
//STRIP001 		uno::Any aAny;
//STRIP001 
//STRIP001 		aAny <<= xConnection;
//STRIP001 		xRowProp->setPropertyValue(
//STRIP001 					::rtl::OUString::createFromAscii(SC_DBPROP_ACTIVECONNECTION), aAny );
//STRIP001 
//STRIP001 		aAny <<= nType;
//STRIP001 		xRowProp->setPropertyValue(
//STRIP001 					::rtl::OUString::createFromAscii(SC_DBPROP_COMMANDTYPE), aAny );
//STRIP001 
//STRIP001 		aAny <<= ::rtl::OUString( aTabName );
//STRIP001 		xRowProp->setPropertyValue(
//STRIP001 					::rtl::OUString::createFromAscii(SC_DBPROP_COMMAND), aAny );
//STRIP001 
//STRIP001 		xRowSet->execute();
//STRIP001 
//STRIP001 		long nColCount = 0;
//STRIP001 		uno::Reference<sdbc::XResultSetMetaData> xMeta;
//STRIP001 		uno::Reference<sdbc::XResultSetMetaDataSupplier> xMetaSupp( xRowSet, uno::UNO_QUERY );
//STRIP001 		if ( xMetaSupp.is() )
//STRIP001 			xMeta = xMetaSupp->getMetaData();
//STRIP001 		if ( xMeta.is() )
//STRIP001 			nColCount = xMeta->getColumnCount();	// this is the number of real columns
//STRIP001 
//STRIP001 		if ( nColCount > MAXCOL+1 )
//STRIP001 		{
//STRIP001 			nColCount = MAXCOL+1;
//STRIP001 			nErr = SCWARN_IMPORT_RANGE_OVERFLOW;	// warning
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( nColCount > 0 )
//STRIP001 			aDocument.DoColResize( 0, 0, nColCount - 1, nRowCount + 1 );
//STRIP001 
//STRIP001 		uno::Reference<sdbc::XRow> xRow( xRowSet, uno::UNO_QUERY );
//STRIP001 		DBG_ASSERT( xRow.is(), "can't get Row" );
//STRIP001 		if (!xRow.is()) return SCERR_IMPORT_CONNECT;
//STRIP001 
//STRIP001 		// currency flag is not needed for dBase
//STRIP001 		uno::Sequence<sal_Int32> aColTypes( nColCount );	// column types
//STRIP001 		sal_Int32* pTypeArr = aColTypes.getArray();
//STRIP001 		for (i=0; i<nColCount; i++)
//STRIP001 			pTypeArr[i] = xMeta->getColumnType( i+1 );
//STRIP001 
//STRIP001 		//	read column names
//STRIP001 		//!	add type descriptions
//STRIP001 
//STRIP001 		for (i=0; i<nColCount; i++)
//STRIP001 		{
//STRIP001 			String aHeader = xMeta->getColumnLabel( i+1 );
//STRIP001 
//STRIP001 			switch ( pTypeArr[i] )
//STRIP001 			{
//STRIP001 				case sdbc::DataType::BIT:
//STRIP001 					aHeader.AppendAscii(RTL_CONSTASCII_STRINGPARAM( ",L" ));
//STRIP001 					break;
//STRIP001 				case sdbc::DataType::DATE:
//STRIP001 					aHeader.AppendAscii(RTL_CONSTASCII_STRINGPARAM( ",D" ));
//STRIP001 					break;
//STRIP001 				case sdbc::DataType::LONGVARCHAR:
//STRIP001 					aHeader.AppendAscii(RTL_CONSTASCII_STRINGPARAM( ",M" ));
//STRIP001 					break;
//STRIP001 				case sdbc::DataType::VARCHAR:
//STRIP001 					aHeader.AppendAscii(RTL_CONSTASCII_STRINGPARAM( ",C," ));
//STRIP001 					aHeader += String::CreateFromInt32( xMeta->getColumnDisplaySize( i+1 ) );
//STRIP001 					break;
//STRIP001 				case sdbc::DataType::DECIMAL:
//STRIP001 					{
//STRIP001 						long nPrec = xMeta->getPrecision( i+1 );
//STRIP001 						long nScale = xMeta->getScale( i+1 );
//STRIP001 						aHeader.AppendAscii(RTL_CONSTASCII_STRINGPARAM( ",N," ));
//STRIP001 						aHeader += String::CreateFromInt32(
//STRIP001 									SvDbaseConverter::ConvertPrecisionToDbase(
//STRIP001 										nPrec, nScale ) );
//STRIP001 						aHeader += ',';
//STRIP001 						aHeader += String::CreateFromInt32( nScale );
//STRIP001 					}
//STRIP001 					break;
//STRIP001 			}
//STRIP001 
//STRIP001 			aDocument.SetString( i, 0, 0, aHeader );
//STRIP001 		}
//STRIP001 
//STRIP001 		USHORT nRow = 1;		// 0 is column titles
//STRIP001 		BOOL bEnd = FALSE;
//STRIP001 		while ( !bEnd && xRowSet->next() )
//STRIP001 		{
//STRIP001 			if ( nRow <= MAXROW )
//STRIP001 			{
//STRIP001 				USHORT nCol = 0;
//STRIP001 				for (i=0; i<nColCount; i++)
//STRIP001 				{
//STRIP001 					ScDatabaseDocUtil::PutData( &aDocument, nCol, nRow, 0,
//STRIP001 												xRow, i+1, pTypeArr[i], FALSE,
//STRIP001 												&bSimpleColWidth[nCol] );
//STRIP001 					++nCol;
//STRIP001 				}
//STRIP001 				++nRow;
//STRIP001 			}
//STRIP001 			else		// past the end of the spreadsheet
//STRIP001 			{
//STRIP001 				bEnd = TRUE;							// don't continue
//STRIP001 				nErr = SCWARN_IMPORT_RANGE_OVERFLOW;	// warning message
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( nRowCount )
//STRIP001 				aProgress.SetStateOnPercent( nRow );
//STRIP001 		}
//STRIP001 
//STRIP001 		::comphelper::disposeComponent( xRowSet );
//STRIP001 		::comphelper::disposeComponent( xConnection );
//STRIP001 	}
//STRIP001 	catch ( sdbc::SQLException& )
//STRIP001 	{
//STRIP001 		nErr = SCERR_IMPORT_CONNECT;
//STRIP001 	}
//STRIP001 	catch ( uno::Exception& )
//STRIP001 	{
//STRIP001 		DBG_ERROR("Unexpected exception in database");
//STRIP001 		nErr = ERRCODE_IO_GENERAL;
//STRIP001 	}
//STRIP001 
//STRIP001 	return nErr;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 inline IsAsciiDigit( sal_Unicode c )
//STRIP001 {
//STRIP001 	return 0x31 <= c && c <= 0x39;
//STRIP001 }

//STRIP001 inline IsAsciiAlpha( sal_Unicode c )
//STRIP001 {
//STRIP001 	return (0x41 <= c && c <= 0x5a) || (0x61 <= c && c <= 0x7a);
//STRIP001 }

//STRIP001 void lcl_GetColumnTypes( ScDocShell& rDocShell,
//STRIP001 							const ScRange& rDataRange, BOOL bHasFieldNames,
//STRIP001 							::rtl::OUString* pColNames, sal_Int32* pColTypes,
//STRIP001 							sal_Int32* pColLengths, sal_Int32* pColScales,
//STRIP001 							BOOL& bHasMemo )
//STRIP001 {
//STRIP001 	//	updating of column titles didn't work in 5.2 and isn't always wanted
//STRIP001 	//	(saving normally shouldn't modify the document)
//STRIP001 	//!	read flag from configuration
//STRIP001 	BOOL bUpdateTitles = FALSE;
//STRIP001 
//STRIP001 	ScDocument* pDoc = rDocShell.GetDocument();
//STRIP001 	SvNumberFormatter* pNumFmt = pDoc->GetFormatTable();
//STRIP001 
//STRIP001 	USHORT nTab = rDataRange.aStart.Tab();
//STRIP001 	USHORT nFirstCol = rDataRange.aStart.Col();
//STRIP001 	USHORT nFirstRow = rDataRange.aStart.Row();
//STRIP001 	USHORT nLastCol = rDataRange.aEnd.Col();
//STRIP001 	USHORT nLastRow = rDataRange.aEnd.Row();
//STRIP001 
//STRIP001 	StrCollection aFieldNamesCollection;
//STRIP001 
//STRIP001 	long nField = 0;
//STRIP001 	USHORT nFirstDataRow = ( bHasFieldNames ? nFirstRow + 1 : nFirstRow );
//STRIP001 	for ( USHORT nCol = nFirstCol; nCol <= nLastCol; nCol++ )
//STRIP001 	{
//STRIP001 		BOOL bTypeDefined = FALSE;
//STRIP001 		BOOL bPrecDefined = FALSE;
//STRIP001 		long nFieldLen = 0;
//STRIP001 		long nPrecision = 0;
//STRIP001 		long nDbType = sdbc::DataType::SQLNULL;
//STRIP001 		String aFieldName, aString;
//STRIP001 
//STRIP001 		// Feldname[,Type[,Width[,Prec]]]
//STRIP001 		// Typ etc.: L; D; C[,W]; N[,W[,P]]
//STRIP001 		if ( bHasFieldNames )
//STRIP001 		{
//STRIP001 			pDoc->GetString( nCol, nFirstRow, nTab, aString );
//STRIP001 			aString.ToUpperAscii();
//STRIP001 			xub_StrLen nToken = aString.GetTokenCount( ',' );
//STRIP001 			if ( nToken > 1 )
//STRIP001 			{
//STRIP001 				aFieldName = aString.GetToken( 0, ',' );
//STRIP001 				aString.EraseAllChars( ' ' );
//STRIP001 				switch ( aString.GetToken( 1, ',' ).GetChar(0) )
//STRIP001 				{
//STRIP001 					case 'L' :
//STRIP001 						nDbType = sdbc::DataType::BIT;
//STRIP001 						nFieldLen = 1;
//STRIP001 						bTypeDefined = TRUE;
//STRIP001 						bPrecDefined = TRUE;
//STRIP001 						break;
//STRIP001 					case 'D' :
//STRIP001 						nDbType = sdbc::DataType::DATE;
//STRIP001 						nFieldLen = 8;
//STRIP001 						bTypeDefined = TRUE;
//STRIP001 						bPrecDefined = TRUE;
//STRIP001 						break;
//STRIP001 					case 'M' :
//STRIP001 						nDbType = sdbc::DataType::LONGVARCHAR;
//STRIP001 						nFieldLen = 10;
//STRIP001 						bTypeDefined = TRUE;
//STRIP001 						bPrecDefined = TRUE;
//STRIP001 						bHasMemo = TRUE;
//STRIP001 						break;
//STRIP001 					case 'C' :
//STRIP001 						nDbType = sdbc::DataType::VARCHAR;
//STRIP001 						bTypeDefined = TRUE;
//STRIP001 						bPrecDefined = TRUE;
//STRIP001 						break;
//STRIP001 					case 'N' :
//STRIP001 						nDbType = sdbc::DataType::DECIMAL;
//STRIP001 						bTypeDefined = TRUE;
//STRIP001 						break;
//STRIP001 				}
//STRIP001 				if ( bTypeDefined && !nFieldLen && nToken > 2 )
//STRIP001 				{
//STRIP001 					nFieldLen = aString.GetToken( 2, ',' ).ToInt32();
//STRIP001 					if ( !bPrecDefined && nToken > 3 )
//STRIP001 					{
//STRIP001 						String aTmp( aString.GetToken( 3, ',' ) );
//STRIP001 						if ( CharClass::isAsciiNumeric(aTmp) )
//STRIP001 						{
//STRIP001 							nPrecision = aTmp.ToInt32();
//STRIP001 							bPrecDefined = TRUE;
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aFieldName = aString;
//STRIP001 
//STRIP001 			// Feldnamen pruefen und ggbf. gueltigen Feldnamen erzeugen.
//STRIP001 			// Erstes Zeichen muss Buchstabe sein,
//STRIP001 			// weitere nur alphanumerisch und Unterstrich erlaubt,
//STRIP001 			// "_DBASELOCK" ist reserviert (obsolet weil erstes Zeichen kein Buchstabe),
//STRIP001 			// keine doppelten Namen.
//STRIP001 			if ( !IsAsciiAlpha( aFieldName.GetChar(0) ) )
//STRIP001 				aFieldName.Insert( 'N', 0 );
//STRIP001 			String aTmpStr;
//STRIP001 			sal_Unicode c;
//STRIP001 			for ( const sal_Unicode* p = aFieldName.GetBuffer(); c = *p; p++ )
//STRIP001 			{
//STRIP001 				if ( IsAsciiAlpha( c ) || IsAsciiDigit( c ) || c == '_' )
//STRIP001 					aTmpStr += c;
//STRIP001 				else
//STRIP001 					aTmpStr += '_';
//STRIP001 			}
//STRIP001 			aFieldName = aTmpStr;
//STRIP001 			if ( aFieldName.Len() > 10 )
//STRIP001 				aFieldName.Erase( 10 );
//STRIP001 			StrData* pStrData = new StrData( aFieldName );
//STRIP001 			if ( !aFieldNamesCollection.Insert( pStrData ) )
//STRIP001 			{	// doppelter Feldname, numerisch erweitern
//STRIP001 				USHORT nSub = 1;
//STRIP001 				String aFixPart( aFieldName );
//STRIP001 				do
//STRIP001 				{
//STRIP001 					++nSub;
//STRIP001 					String aVarPart = String::CreateFromInt32( nSub );
//STRIP001 					if ( aFixPart.Len() + aVarPart.Len() > 10 )
//STRIP001 						aFixPart.Erase( 10 - aVarPart.Len() );
//STRIP001 					aFieldName = aFixPart;
//STRIP001 					aFieldName += aVarPart;
//STRIP001 					pStrData->SetString( aFieldName );
//STRIP001 				} while ( !aFieldNamesCollection.Insert( pStrData ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aFieldName = 'N';
//STRIP001 			aFieldName += String::CreateFromInt32(nCol+1);
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( !bTypeDefined )
//STRIP001 		{	// Feldtyp
//STRIP001 			ScBaseCell* pCell;
//STRIP001 			pDoc->GetCell( nCol, nFirstDataRow, nTab, pCell );
//STRIP001 			if ( !pCell || pCell->HasStringData() )
//STRIP001 				nDbType = sdbc::DataType::VARCHAR;
//STRIP001 			else
//STRIP001 			{
//STRIP001 				ULONG nFormat;
//STRIP001 				pDoc->GetNumberFormat( nCol, nFirstDataRow, nTab, nFormat );
//STRIP001 				if ( pCell && pCell->GetCellType() == CELLTYPE_FORMULA
//STRIP001 				  && ((nFormat % SV_COUNTRY_LANGUAGE_OFFSET) == 0) )
//STRIP001 				{
//STRIP001 					nFormat = ScGlobal::GetStandardFormat(
//STRIP001 						((ScFormulaCell*)pCell)->GetValue(), *pNumFmt, nFormat,
//STRIP001 						((ScFormulaCell*)pCell)->GetFormatType() );
//STRIP001 				}
//STRIP001 				switch ( pNumFmt->GetType( nFormat ) )
//STRIP001 				{
//STRIP001 					case NUMBERFORMAT_LOGICAL :
//STRIP001 						nDbType = sdbc::DataType::BIT;
//STRIP001 						nFieldLen = 1;
//STRIP001 						break;
//STRIP001 					case NUMBERFORMAT_DATE :
//STRIP001 						nDbType = sdbc::DataType::DATE;
//STRIP001 						nFieldLen = 8;
//STRIP001 						break;
//STRIP001 					case NUMBERFORMAT_TIME :
//STRIP001 					case NUMBERFORMAT_DATETIME :
//STRIP001 						nDbType = sdbc::DataType::VARCHAR;
//STRIP001 						break;
//STRIP001 					default:
//STRIP001 						nDbType = sdbc::DataType::DECIMAL;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		BOOL bSdbLenAdjusted = FALSE;
//STRIP001 		BOOL bSdbLenBad = FALSE;
//STRIP001 		// Feldlaenge
//STRIP001 		if ( nDbType == sdbc::DataType::VARCHAR && !nFieldLen )
//STRIP001 		{	// maximale Feldbreite bestimmen
//STRIP001 			nFieldLen = pDoc->GetMaxStringLen( nTab, nCol, nFirstDataRow,
//STRIP001 				nLastRow );
//STRIP001 			if ( nFieldLen == 0 )
//STRIP001 				nFieldLen = 1;
//STRIP001 		}
//STRIP001 		else if ( nDbType == sdbc::DataType::DECIMAL )
//STRIP001 		{	// maximale Feldbreite und Nachkommastellen bestimmen
//STRIP001 			xub_StrLen nLen;
//STRIP001 			USHORT nPrec;
//STRIP001 			nLen = pDoc->GetMaxNumberStringLen( nPrec, nTab, nCol,
//STRIP001 				nFirstDataRow, nLastRow );
//STRIP001 			// dBaseIII Limit Nachkommastellen: 15
//STRIP001 			if ( nPrecision > 15 )
//STRIP001 				nPrecision = 15;
//STRIP001 			if ( nPrec > 15 )
//STRIP001 				nPrec = 15;
//STRIP001 			if ( bPrecDefined && nPrecision != nPrec )
//STRIP001 			{	// Laenge auf vorgegebene Nachkommastellen anpassen
//STRIP001 				if ( nPrecision )
//STRIP001 					nLen += nPrecision - nPrec;
//STRIP001 				else
//STRIP001 					nLen -= nPrec+1;			// auch den . mit raus
//STRIP001 			}
//STRIP001 			if ( nLen > nFieldLen )
//STRIP001 				nFieldLen = nLen;
//STRIP001 			if ( !bPrecDefined )
//STRIP001 				nPrecision = nPrec;
//STRIP001 			if ( nFieldLen == 0 )
//STRIP001 				nFieldLen = 1;
//STRIP001 			else if ( nFieldLen > 19 )
//STRIP001 				nFieldLen = 19;		// dBaseIII Limit Feldlaenge numerisch: 19
//STRIP001 			if ( nPrecision && nFieldLen < nPrecision + 2 )
//STRIP001 				nFieldLen = nPrecision + 2;		// 0. muss mit reinpassen
//STRIP001 			// 538 MUST: Sdb internal representation adds 2 to the field length!
//STRIP001 			// To give the user what he wants we must substract it here.
//STRIP001  			//! CAVEAT! There is no way to define a numeric field with a length
//STRIP001  			//! of 1 and no decimals!
//STRIP001 			if ( nFieldLen == 1 && nPrecision == 0 )
//STRIP001 				bSdbLenBad = TRUE;
//STRIP001 			nFieldLen = SvDbaseConverter::ConvertPrecisionToOdbc( nFieldLen, nPrecision );
//STRIP001 			bSdbLenAdjusted = TRUE;
//STRIP001 		}
//STRIP001 		if ( nFieldLen > 254 )
//STRIP001 		{
//STRIP001 			if ( nDbType == sdbc::DataType::VARCHAR )
//STRIP001 			{	// zu lang fuer normales Textfeld => Memofeld
//STRIP001 				nDbType = sdbc::DataType::LONGVARCHAR;
//STRIP001 				nFieldLen = 10;
//STRIP001 				bHasMemo = TRUE;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				nFieldLen = 254;					// dumm gelaufen..
//STRIP001 		}
//STRIP001 
//STRIP001 		pColNames[nField] = aFieldName;
//STRIP001 		pColTypes[nField] = nDbType;
//STRIP001 		pColLengths[nField] = nFieldLen;
//STRIP001 		pColScales[nField] = nPrecision;
//STRIP001 
//STRIP001 		// undo change to field length, reflect reality
//STRIP001 		if ( bSdbLenAdjusted )
//STRIP001 		{
//STRIP001 			nFieldLen = SvDbaseConverter::ConvertPrecisionToDbase( nFieldLen, nPrecision );
//STRIP001 			if ( bSdbLenBad && nFieldLen == 1 )
//STRIP001 				nFieldLen = 2;		// THIS is reality
//STRIP001 		}
//STRIP001 		if ( bUpdateTitles )
//STRIP001 		{	// Angabe anpassen und ausgeben
//STRIP001 			String aOutString = aFieldName;
//STRIP001 			switch ( nDbType )
//STRIP001 			{
//STRIP001 				case sdbc::DataType::BIT :
//STRIP001 					aOutString.AppendAscii(RTL_CONSTASCII_STRINGPARAM( ",L" ));
//STRIP001 					break;
//STRIP001 				case sdbc::DataType::DATE :
//STRIP001 					aOutString.AppendAscii(RTL_CONSTASCII_STRINGPARAM( ",D" ));
//STRIP001 					break;
//STRIP001 				case sdbc::DataType::LONGVARCHAR :
//STRIP001 					aOutString.AppendAscii(RTL_CONSTASCII_STRINGPARAM( ",M" ));
//STRIP001 					break;
//STRIP001 				case sdbc::DataType::VARCHAR :
//STRIP001 					aOutString.AppendAscii(RTL_CONSTASCII_STRINGPARAM( ",C," ));
//STRIP001 					aOutString += String::CreateFromInt32( nFieldLen );
//STRIP001 					break;
//STRIP001 				case sdbc::DataType::DECIMAL :
//STRIP001 					aOutString.AppendAscii(RTL_CONSTASCII_STRINGPARAM( ",N," ));
//STRIP001 					aOutString += String::CreateFromInt32( nFieldLen );
//STRIP001 					aOutString += ',';
//STRIP001 					aOutString += String::CreateFromInt32( nPrecision );
//STRIP001 					break;
//STRIP001 			}
//STRIP001 			if ( !aOutString.EqualsIgnoreCaseAscii( aString ) )
//STRIP001 			{
//STRIP001 				pDoc->SetString( nCol, nFirstRow, nTab, aOutString );
//STRIP001 				rDocShell.PostPaint( nCol, nFirstRow, nTab, nCol, nFirstRow, nTab, PAINT_GRID );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		++nField;
//STRIP001 	}
//STRIP001 }

//STRIP001 ULONG ScDocShell::DBaseExport( const String& rFullFileName, CharSet eCharSet, BOOL& bHasMemo )
//STRIP001 {
//STRIP001 	// remove the file so the dBase driver doesn't find an invalid file
//STRIP001 	INetURLObject aDeleteObj( rFullFileName, INET_PROT_FILE );
//STRIP001 	KillFile( aDeleteObj );
//STRIP001 
//STRIP001 	ULONG nErr = eERR_OK;
//STRIP001 	uno::Any aAny;
//STRIP001 
//STRIP001 	USHORT nFirstCol, nFirstRow, nLastCol, nLastRow;
//STRIP001 	USHORT nTab = GetSaveTab();
//STRIP001 	aDocument.GetDataStart( nTab, nFirstCol, nFirstRow );
//STRIP001 	aDocument.GetCellArea( nTab, nLastCol, nLastRow );
//STRIP001     if ( nFirstCol > nLastCol )
//STRIP001         nFirstCol = nLastCol;
//STRIP001     if ( nFirstRow > nLastRow )
//STRIP001         nFirstRow = nLastRow;
//STRIP001 	ScProgress aProgress( this, ScGlobal::GetRscString( STR_SAVE_DOC ),
//STRIP001 													nLastRow - nFirstRow );
//STRIP001 	SvNumberFormatter* pNumFmt = aDocument.GetFormatTable();
//STRIP001 
//STRIP001 	BOOL bHasFieldNames = TRUE;
//STRIP001 	for ( USHORT nDocCol = nFirstCol; nDocCol <= nLastCol && bHasFieldNames; nDocCol++ )
//STRIP001 	{	// nur Strings in erster Zeile => sind Feldnamen
//STRIP001 		if ( !aDocument.HasStringData( nDocCol, nFirstRow, nTab ) )
//STRIP001 			bHasFieldNames = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	long nColCount = nLastCol - nFirstCol + 1;
//STRIP001 	uno::Sequence<rtl::OUString> aColNames( nColCount );
//STRIP001 	uno::Sequence<sal_Int32> aColTypes( nColCount );
//STRIP001 	uno::Sequence<sal_Int32> aColLengths( nColCount );
//STRIP001 	uno::Sequence<sal_Int32> aColScales( nColCount );
//STRIP001 
//STRIP001 	ScRange aDataRange( nFirstCol, nFirstRow, nTab, nLastCol, nLastRow, nTab );
//STRIP001 	lcl_GetColumnTypes( *this, aDataRange, bHasFieldNames,
//STRIP001 						aColNames.getArray(), aColTypes.getArray(),
//STRIP001 						aColLengths.getArray(), aColScales.getArray(),
//STRIP001 						bHasMemo );
//STRIP001 
//STRIP001 	INetURLObject aURL;
//STRIP001 	aURL.SetSmartProtocol( INET_PROT_FILE );
//STRIP001 	aURL.SetSmartURL( rFullFileName );
//STRIP001 	String aTabName = aURL.getBase();
//STRIP001 	String aExtension = aURL.getExtension();
//STRIP001 	aURL.removeSegment();
//STRIP001 	aURL.removeFinalSlash();
//STRIP001 	String aPath = aURL.GetMainURL(INetURLObject::NO_DECODE);
//STRIP001 
//STRIP001 	try
//STRIP001 	{
//STRIP001 		uno::Reference<lang::XMultiServiceFactory> xFactory = ::legacy_binfilters::getLegacyProcessServiceFactory();
//STRIP001 		if (!xFactory.is()) return SCERR_EXPORT_CONNECT;
//STRIP001 
//STRIP001 		uno::Reference<sdbc::XDriverManager> xDrvMan( xFactory->createInstance(
//STRIP001 							::rtl::OUString::createFromAscii( SC_SERVICE_DRVMAN ) ),
//STRIP001 							uno::UNO_QUERY);
//STRIP001 		DBG_ASSERT( xDrvMan.is(), "can't get DriverManager" );
//STRIP001 		if (!xDrvMan.is()) return SCERR_EXPORT_CONNECT;
//STRIP001 
//STRIP001 		// get connection
//STRIP001 
//STRIP001 		String aConnUrl = String::CreateFromAscii("sdbc:dbase:");
//STRIP001 		aConnUrl += aPath;
//STRIP001 
//STRIP001 		dbtools::OCharsetMap aMap;
//STRIP001 		dbtools::OCharsetMap::CharsetIterator aIter = aMap.find( (rtl_TextEncoding) eCharSet );
//STRIP001         if ( aIter == aMap.end() )
//STRIP001         {
//STRIP001             DBG_ERRORFILE( "DBaseExport: dbtools::OCharsetMap doesn't know text encoding" );
//STRIP001             return SCERR_EXPORT_CONNECT;
//STRIP001         }
//STRIP001 		::rtl::OUString aCharSetStr = (*aIter).getIanaName();
//STRIP001 
//STRIP001 		uno::Sequence<beans::PropertyValue> aProps(2);
//STRIP001 		aProps[0].Name = ::rtl::OUString::createFromAscii(SC_DBPROP_EXTENSION);
//STRIP001 		aProps[0].Value <<= ::rtl::OUString( aExtension );
//STRIP001 		aProps[1].Name = ::rtl::OUString::createFromAscii(SC_DBPROP_CHARSET);
//STRIP001 		aProps[1].Value <<= aCharSetStr;
//STRIP001 
//STRIP001 		uno::Reference<sdbc::XConnection> xConnection =
//STRIP001 								xDrvMan->getConnectionWithInfo( aConnUrl, aProps );
//STRIP001 		DBG_ASSERT( xConnection.is(), "can't get Connection" );
//STRIP001 		if (!xConnection.is()) return SCERR_EXPORT_CONNECT;
//STRIP001 
//STRIP001 		// get dBase driver
//STRIP001 
//STRIP001 		uno::Reference<sdbc::XDriver> xDriver;
//STRIP001 		BOOL bDriverFound = FALSE;
//STRIP001 
//STRIP001 		uno::Reference<container::XEnumerationAccess> xEnAcc( xDrvMan, uno::UNO_QUERY );
//STRIP001 		DBG_ASSERT( xEnAcc.is(), "can't get DriverManager EnumerationAccess" );
//STRIP001 		if (!xEnAcc.is()) return SCERR_EXPORT_CONNECT;
//STRIP001 
//STRIP001 		uno::Reference<container::XEnumeration> xEnum = xEnAcc->createEnumeration();
//STRIP001 		DBG_ASSERT( xEnum.is(), "can't get DriverManager Enumeration" );
//STRIP001 		if (!xEnum.is()) return SCERR_EXPORT_CONNECT;
//STRIP001 
//STRIP001 		while ( xEnum->hasMoreElements() && !bDriverFound )
//STRIP001 		{
//STRIP001 			uno::Any aElement = xEnum->nextElement();
//STRIP001 			if ( aElement >>= xDriver )
//STRIP001 				if ( xDriver.is() && xDriver->acceptsURL( aConnUrl ) )
//STRIP001 					bDriverFound = TRUE;
//STRIP001 		}
//STRIP001 
//STRIP001 		DBG_ASSERT( bDriverFound, "can't get dBase driver" );
//STRIP001 		if (!bDriverFound) return SCERR_EXPORT_CONNECT;
//STRIP001 
//STRIP001 		// create table
//STRIP001 
//STRIP001 		uno::Reference<sdbcx::XDataDefinitionSupplier> xDDSup( xDriver, uno::UNO_QUERY );
//STRIP001 		DBG_ASSERT( xDDSup.is(), "can't get XDataDefinitionSupplier" );
//STRIP001 		if (!xDDSup.is()) return SCERR_EXPORT_CONNECT;
//STRIP001 
//STRIP001 		uno::Reference<sdbcx::XTablesSupplier> xTablesSupp =
//STRIP001 							xDDSup->getDataDefinitionByConnection( xConnection );
//STRIP001 		DBG_ASSERT( xTablesSupp.is(), "can't get Data Definition" );
//STRIP001 		if (!xTablesSupp.is()) return SCERR_EXPORT_CONNECT;
//STRIP001 
//STRIP001 		uno::Reference<container::XNameAccess> xTables = xTablesSupp->getTables();
//STRIP001 		DBG_ASSERT( xTables.is(), "can't get Tables" );
//STRIP001 		if (!xTables.is()) return SCERR_EXPORT_CONNECT;
//STRIP001 
//STRIP001 		uno::Reference<sdbcx::XDataDescriptorFactory> xTablesFact( xTables, uno::UNO_QUERY );
//STRIP001 		DBG_ASSERT( xTablesFact.is(), "can't get tables factory" );
//STRIP001 		if (!xTablesFact.is()) return SCERR_EXPORT_CONNECT;
//STRIP001 
//STRIP001 		uno::Reference<sdbcx::XAppend> xTablesAppend( xTables, uno::UNO_QUERY );
//STRIP001 		DBG_ASSERT( xTablesAppend.is(), "can't get tables XAppend" );
//STRIP001 		if (!xTablesAppend.is()) return SCERR_EXPORT_CONNECT;
//STRIP001 
//STRIP001 		uno::Reference<beans::XPropertySet> xTableDesc = xTablesFact->createDataDescriptor();
//STRIP001 		DBG_ASSERT( xTableDesc.is(), "can't get table descriptor" );
//STRIP001 		if (!xTableDesc.is()) return SCERR_EXPORT_CONNECT;
//STRIP001 
//STRIP001 		aAny <<= ::rtl::OUString( aTabName );
//STRIP001 		xTableDesc->setPropertyValue( ::rtl::OUString::createFromAscii(SC_DBPROP_NAME), aAny );
//STRIP001 
//STRIP001 		// create columns
//STRIP001 
//STRIP001 		uno::Reference<sdbcx::XColumnsSupplier> xColumnsSupp( xTableDesc, uno::UNO_QUERY );
//STRIP001 		DBG_ASSERT( xColumnsSupp.is(), "can't get columns supplier" );
//STRIP001 		if (!xColumnsSupp.is()) return SCERR_EXPORT_CONNECT;
//STRIP001 
//STRIP001 		uno::Reference<container::XNameAccess> xColumns = xColumnsSupp->getColumns();
//STRIP001 		DBG_ASSERT( xColumns.is(), "can't get columns" );
//STRIP001 		if (!xColumns.is()) return SCERR_EXPORT_CONNECT;
//STRIP001 
//STRIP001 		uno::Reference<sdbcx::XDataDescriptorFactory> xColumnsFact( xColumns, uno::UNO_QUERY );
//STRIP001 		DBG_ASSERT( xColumnsFact.is(), "can't get columns factory" );
//STRIP001 		if (!xColumnsFact.is()) return SCERR_EXPORT_CONNECT;
//STRIP001 
//STRIP001 		uno::Reference<sdbcx::XAppend> xColumnsAppend( xColumns, uno::UNO_QUERY );
//STRIP001 		DBG_ASSERT( xColumnsAppend.is(), "can't get columns XAppend" );
//STRIP001 		if (!xColumnsAppend.is()) return SCERR_EXPORT_CONNECT;
//STRIP001 
//STRIP001 		const ::rtl::OUString* pColNames = aColNames.getConstArray();
//STRIP001 		const sal_Int32* pColTypes     = aColTypes.getConstArray();
//STRIP001 		const sal_Int32* pColLengths   = aColLengths.getConstArray();
//STRIP001 		const sal_Int32* pColScales    = aColScales.getConstArray();
//STRIP001 		long nCol;
//STRIP001 
//STRIP001 		for (nCol=0; nCol<nColCount; nCol++)
//STRIP001 		{
//STRIP001 			uno::Reference<beans::XPropertySet> xColumnDesc = xColumnsFact->createDataDescriptor();
//STRIP001 			DBG_ASSERT( xColumnDesc.is(), "can't get column descriptor" );
//STRIP001 			if (!xColumnDesc.is()) return SCERR_EXPORT_CONNECT;
//STRIP001 
//STRIP001 			aAny <<= pColNames[nCol];
//STRIP001 			xColumnDesc->setPropertyValue( ::rtl::OUString::createFromAscii(SC_DBPROP_NAME), aAny );
//STRIP001 
//STRIP001 			aAny <<= pColTypes[nCol];
//STRIP001 			xColumnDesc->setPropertyValue( ::rtl::OUString::createFromAscii(SC_DBPROP_TYPE), aAny );
//STRIP001 
//STRIP001 			aAny <<= pColLengths[nCol];
//STRIP001 			xColumnDesc->setPropertyValue( ::rtl::OUString::createFromAscii(SC_DBPROP_PRECISION), aAny );
//STRIP001 
//STRIP001 			aAny <<= pColScales[nCol];
//STRIP001 			xColumnDesc->setPropertyValue( ::rtl::OUString::createFromAscii(SC_DBPROP_SCALE), aAny );
//STRIP001 
//STRIP001 			xColumnsAppend->appendByDescriptor( xColumnDesc );
//STRIP001 		}
//STRIP001 
//STRIP001 		xTablesAppend->appendByDescriptor( xTableDesc );
//STRIP001 
//STRIP001 		// re-open connection
//STRIP001 //		xConnection = xDrvMan->getConnectionWithInfo( aConnUrl, aProps );
//STRIP001 //		DBG_ASSERT( xConnection.is(), "can't get Connection" );
//STRIP001 //		if (!xConnection.is()) return SCERR_EXPORT_CONNECT;
//STRIP001 
//STRIP001 		// get row set for writing
//STRIP001 
//STRIP001 		uno::Reference<sdbc::XRowSet> xRowSet( xFactory->createInstance(
//STRIP001 							::rtl::OUString::createFromAscii( SC_SERVICE_ROWSET ) ),
//STRIP001 							uno::UNO_QUERY);
//STRIP001 		uno::Reference<beans::XPropertySet> xRowProp( xRowSet, uno::UNO_QUERY );
//STRIP001 		DBG_ASSERT( xRowProp.is(), "can't get RowSet" );
//STRIP001 		if (!xRowProp.is()) return SCERR_EXPORT_CONNECT;
//STRIP001 
//STRIP001 		aAny <<= xConnection;
//STRIP001 		xRowProp->setPropertyValue(
//STRIP001 					::rtl::OUString::createFromAscii(SC_DBPROP_ACTIVECONNECTION), aAny );
//STRIP001 
//STRIP001 		aAny <<= (sal_Int32) sdb::CommandType::TABLE;
//STRIP001 		xRowProp->setPropertyValue(
//STRIP001 					::rtl::OUString::createFromAscii(SC_DBPROP_COMMANDTYPE), aAny );
//STRIP001 
//STRIP001 		aAny <<= ::rtl::OUString( aTabName );
//STRIP001 		xRowProp->setPropertyValue(
//STRIP001 					::rtl::OUString::createFromAscii(SC_DBPROP_COMMAND), aAny );
//STRIP001 
//STRIP001 		xRowSet->execute();
//STRIP001 
//STRIP001 		// write data rows
//STRIP001 
//STRIP001 		uno::Reference<sdbc::XResultSetUpdate> xResultUpdate( xRowSet, uno::UNO_QUERY );
//STRIP001 		DBG_ASSERT( xResultUpdate.is(), "can't get XResultSetUpdate" );
//STRIP001 		if (!xResultUpdate.is()) return SCERR_EXPORT_CONNECT;
//STRIP001 
//STRIP001 		uno::Reference<sdbc::XRowUpdate> xRowUpdate( xRowSet, uno::UNO_QUERY );
//STRIP001 		DBG_ASSERT( xRowUpdate.is(), "can't get XRowUpdate" );
//STRIP001 		if (!xRowUpdate.is()) return SCERR_EXPORT_CONNECT;
//STRIP001 
//STRIP001 		USHORT nFirstDataRow = ( bHasFieldNames ? nFirstRow + 1 : nFirstRow );
//STRIP001 		ScFieldEditEngine aEditEngine( aDocument.GetEditPool() );
//STRIP001 		String aString;
//STRIP001 		double fVal;
//STRIP001 
//STRIP001 		for ( USHORT nDocRow = nFirstDataRow; nDocRow <= nLastRow; nDocRow++ )
//STRIP001 		{
//STRIP001 			xResultUpdate->moveToInsertRow();
//STRIP001 
//STRIP001 			for (nCol=0; nCol<nColCount; nCol++)
//STRIP001 			{
//STRIP001 				USHORT nDocCol = nFirstCol + nCol;
//STRIP001 
//STRIP001 				switch (pColTypes[nCol])
//STRIP001 				{
//STRIP001 					case sdbc::DataType::LONGVARCHAR:
//STRIP001 						{
//STRIP001 							ScBaseCell* pCell;
//STRIP001 							aDocument.GetCell( nDocCol, nDocRow, nTab, pCell );
//STRIP001 							if ( pCell && pCell->GetCellType() != CELLTYPE_NOTE )
//STRIP001 							{
//STRIP001 								if ( pCell->GetCellType() == CELLTYPE_EDIT )
//STRIP001 								{	// #60761# Paragraphs erhalten
//STRIP001 									aEditEngine.SetText( *((ScEditCell*)pCell)->GetData() );
//STRIP001 									aString = aEditEngine.GetText( LINEEND_CRLF );
//STRIP001 								}
//STRIP001 								else
//STRIP001 								{
//STRIP001 									ULONG nFormat;
//STRIP001 									Color* pColor;
//STRIP001 									aDocument.GetNumberFormat( nDocCol, nDocRow, nTab, nFormat );
//STRIP001 									ScCellFormat::GetString( pCell, nFormat, aString, &pColor, *pNumFmt );
//STRIP001 								}
//STRIP001 								xRowUpdate->updateString( nCol+1, aString );
//STRIP001 							}
//STRIP001 							else
//STRIP001 								xRowUpdate->updateNull( nCol+1 );
//STRIP001 						}
//STRIP001 						break;
//STRIP001 
//STRIP001 					case sdbc::DataType::VARCHAR:
//STRIP001 						aDocument.GetString( nDocCol, nDocRow, nTab, aString );
//STRIP001 						xRowUpdate->updateString( nCol+1, aString );
//STRIP001 						if ( nErr == eERR_OK && pColLengths[nCol] < aString.Len() )
//STRIP001 							nErr = SCWARN_EXPORT_DATALOST;
//STRIP001 						break;
//STRIP001 
//STRIP001 						break;
//STRIP001 
//STRIP001 					case sdbc::DataType::DATE:
//STRIP001 						{
//STRIP001 							aDocument.GetValue( nDocCol, nDocRow, nTab, fVal );
//STRIP001 							// #39274# zwischen 0 Wert und 0 kein Wert unterscheiden
//STRIP001 							BOOL bIsNull = (fVal == 0.0);
//STRIP001 							if ( bIsNull )
//STRIP001 								bIsNull = !aDocument.HasValueData( nDocCol, nDocRow, nTab );
//STRIP001 							if ( bIsNull )
//STRIP001 							{
//STRIP001 								xRowUpdate->updateNull( nCol+1 );
//STRIP001 								if ( nErr == eERR_OK &&
//STRIP001 										aDocument.HasStringData( nDocCol, nDocRow, nTab ) )
//STRIP001 									nErr = SCWARN_EXPORT_DATALOST;
//STRIP001 							}
//STRIP001 							else
//STRIP001 							{
//STRIP001 								Date aDate = *(pNumFmt->GetNullDate());		// tools date
//STRIP001 								aDate += (long)fVal;						//! approxfloor?
//STRIP001 								util::Date aUnoDate( aDate.GetDay(), aDate.GetMonth(), aDate.GetYear() );
//STRIP001 								xRowUpdate->updateDate( nCol+1, aUnoDate );
//STRIP001 							}
//STRIP001 						}
//STRIP001 						break;
//STRIP001 
//STRIP001 					case sdbc::DataType::DECIMAL:
//STRIP001 					case sdbc::DataType::BIT:
//STRIP001 						aDocument.GetValue( nDocCol, nDocRow, nTab, fVal );
//STRIP001 						if ( fVal == 0.0 && nErr == eERR_OK &&
//STRIP001 											aDocument.HasStringData( nDocCol, nDocRow, nTab ) )
//STRIP001 							nErr = SCWARN_EXPORT_DATALOST;
//STRIP001 						if ( pColTypes[nCol] == sdbc::DataType::BIT )
//STRIP001 							xRowUpdate->updateBoolean( nCol+1, ( fVal != 0.0 ) );
//STRIP001 						else
//STRIP001 							xRowUpdate->updateDouble( nCol+1, fVal );
//STRIP001 						break;
//STRIP001 
//STRIP001 					default:
//STRIP001 						DBG_ERROR( "ScDocShell::DBaseExport: unknown FieldType" );
//STRIP001 						if ( nErr == eERR_OK )
//STRIP001 							nErr = SCWARN_EXPORT_DATALOST;
//STRIP001 						aDocument.GetValue( nDocCol, nDocRow, nTab, fVal );
//STRIP001 						xRowUpdate->updateDouble( nCol+1, fVal );
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			xResultUpdate->insertRow();
//STRIP001 
//STRIP001 			//!	error handling and recovery of old
//STRIP001 			//!	ScDocShell::SbaSdbExport is still missing!
//STRIP001 
//STRIP001 			if ( !aProgress.SetStateOnPercent( nDocRow - nFirstRow ) )
//STRIP001 			{	// UserBreak
//STRIP001 				nErr = SCERR_EXPORT_DATA;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		::comphelper::disposeComponent( xRowSet );
//STRIP001 		::comphelper::disposeComponent( xConnection );
//STRIP001 	}
//STRIP001 	catch ( sdbc::SQLException& )
//STRIP001 	{
//STRIP001 		nErr = SCERR_EXPORT_CONNECT;
//STRIP001 	}
//STRIP001 	catch ( uno::Exception& )
//STRIP001 	{
//STRIP001 		DBG_ERROR("Unexpected exception in database");
//STRIP001 		nErr = ERRCODE_IO_GENERAL;
//STRIP001 	}
//STRIP001 
//STRIP001 	return nErr;
//STRIP001 }


}
