/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_pvlaydlg.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 19:01:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

//----------------------------------------------------------------------------

// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #include <vcl/msgbox.hxx>

// auto strip #include <com/sun/star/sheet/DataPilotFieldOrientation.hpp>

#define _PVLAYDLG_CXX
// auto strip #include "pvlaydlg.hxx"
#undef  _PVLAYDLG_CXX

// auto strip #include "uiitems.hxx"
// auto strip #include "rangeutl.hxx"
// auto strip #include "document.hxx"
// auto strip #include "viewdata.hxx"
// auto strip #include "tabvwsh.hxx"
// auto strip #include "reffact.hxx"
// auto strip #include "scresid.hxx"
// auto strip #include "pivot.hxx"
#include "pvglob.hxx"
// auto strip #include "pvfundlg.hxx"
#include "globstr.hrc"
#include "pivot.hrc"
// auto strip #include "dpobject.hxx"
// auto strip #include "dpsave.hxx"
#include "scmod.hxx"
namespace binfilter {

using namespace ::com::sun::star;

//----------------------------------------------------------------------------

#define FSTR(index) *(aFuncNameArr[index-1])
#define STD_FORMAT   SCA_VALID | SCA_TAB_3D \
					| SCA_COL_ABSOLUTE | SCA_ROW_ABSOLUTE | SCA_TAB_ABSOLUTE

long PivotGlobal::nObjHeight = 0;    // initialized with resource data
long PivotGlobal::nObjWidth  = 0;
long PivotGlobal::nSelSpace  = 0;


//============================================================================
//	struct FuncData

//STRIP001 struct FuncData
//STRIP001 {
//STRIP001 	short  nCol;
//STRIP001 	USHORT nFuncMask;
//STRIP001 
//STRIP001 	FuncData( short col, USHORT funcs = PIVOT_FUNC_SUM )
//STRIP001 		: nCol(col), nFuncMask(funcs) {}
//STRIP001 	FuncData( const FuncData& rCpy )
//STRIP001 		: nCol(rCpy.nCol), nFuncMask(rCpy.nFuncMask) {}
//STRIP001 
//STRIP001 	FuncData& operator=( const FuncData& r )
//STRIP001 		{ nCol=r.nCol; nFuncMask=r.nFuncMask; return *this; }
//STRIP001 
//STRIP001 	BOOL operator==( const FuncData& r )
//STRIP001 		{ return ( (nCol==r.nCol)&&(nFuncMask==r.nFuncMask) ); }
//STRIP001 };


//============================================================================

//----------------------------------------------------------------------------

//STRIP001 ScDPLayoutDlg::ScDPLayoutDlg( SfxBindings* pB, SfxChildWindow* pCW, Window* pParent,
//STRIP001 									const ScDPObject* pDPObject )
//STRIP001 	:	ScAnyRefDlg	( pB, pCW, pParent, RID_SCDLG_PIVOT_LAYOUT ),
//STRIP001 		aBtnOk			( this, ScResId( BTN_OK ) ),
//STRIP001 		aBtnCancel		( this, ScResId( BTN_CANCEL ) ),
//STRIP001 		aBtnHelp		( this, ScResId( BTN_HELP ) ),
//STRIP001         aBtnRemove      ( this, ScResId( BTN_REMOVE ) ),
//STRIP001         aBtnOptions     ( this, ScResId( BTN_OPTIONS ) ),
//STRIP001 		aBtnMore		( this, ScResId( BTN_MORE ) ),
//STRIP001 
//STRIP001 		aFtInfo			( this, ScResId( FT_INFO ) ),
//STRIP001 		aBtnIgnEmptyRows( this, ScResId( BTN_IGNEMPTYROWS ) ),
//STRIP001 		aBtnDetectCat	( this, ScResId( BTN_DETECTCAT ) ),
//STRIP001 		aBtnTotalCol	( this, ScResId( BTN_TOTALCOL ) ),
//STRIP001 		aBtnTotalRow	( this, ScResId( BTN_TOTALROW ) ),
//STRIP001 
//STRIP001 		aLbOutPos		( this, ScResId( LB_OUTAREA ) ),
//STRIP001 		aFtOutArea		( this, ScResId( FT_OUTAREA ) ),
//STRIP001 		aEdOutPos		( this, ScResId( ED_OUTAREA ) ),
//STRIP001 		aRbOutPos		( this, ScResId( RB_OUTAREA ), &aEdOutPos ),
//STRIP001         aFlAreas        ( this, ScResId( FL_OUTPUT ) ),
//STRIP001 
//STRIP001         aFtRow          ( this, ScResId( FT_ROW ) ),
//STRIP001         aWndRow         ( this, ScResId( WND_ROW ),    TYPE_ROW,    &aFtRow ),
//STRIP001         aFtCol          ( this, ScResId( FT_COL ) ),
//STRIP001         aWndCol         ( this, ScResId( WND_COL ),    TYPE_COL,    &aFtCol ),
//STRIP001         aFtData         ( this, ScResId( FT_DATA ) ),
//STRIP001         aWndData        ( this, ScResId( WND_DATA ),   TYPE_DATA,   &aFtData ),
//STRIP001         aWndSelect      ( this, ScResId( WND_SELECT ), TYPE_SELECT, String(ScResId(STR_SELECT)) ),
//STRIP001 
//STRIP001 		aSlider			( this, ScResId( WND_HSCROLL ) ),
//STRIP001         aFlLayout       ( this, ScResId( FL_LAYOUT ) ),
//STRIP001 		aStrUndefined	( ScResId( SCSTR_UNDEFINED ) ),
//STRIP001 		aStrNewTable	( ScResId( SCSTR_NEWTABLE ) ),
//STRIP001 
//STRIP001 		bIsDrag			( FALSE ),
//STRIP001 		aLabelDataArr	( NULL ),
//STRIP001         nLabelCount     ( 0 ),
//STRIP001 
//STRIP001         eLastActiveType ( TYPE_SELECT ),
//STRIP001 		nOffset			( 0 ),
//STRIP001 		//
//STRIP001 		pDlgDPObject	( NULL ),
//STRIP001 		pViewData		( ((ScTabViewShell*)SfxViewShell::Current())->
//STRIP001 								GetViewData() ),
//STRIP001 		pDoc			( ((ScTabViewShell*)SfxViewShell::Current())->
//STRIP001 								GetViewData()->GetDocument() ),
//STRIP001 		bRefInputMode	( FALSE )
//STRIP001 {
//STRIP001 	if ( pDPObject )
//STRIP001 	{
//STRIP001 		pDlgDPObject = new ScDPObject( *pDPObject );
//STRIP001 		pDlgDPObject->SetAlive( TRUE );		// needed to get structure information
//STRIP001 		pDlgDPObject->FillOldParam( thePivotData, FALSE );
//STRIP001 		pDlgDPObject->FillLabelData( thePivotData, bShowAll, MAX_LABELS );
//STRIP001 	}
//STRIP001 
//STRIP001 	Init();
//STRIP001 	FreeResource();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 __EXPORT ScDPLayoutDlg::~ScDPLayoutDlg()
//STRIP001 {
//STRIP001 	USHORT nEntries = aLbOutPos.GetEntryCount();
//STRIP001 	USHORT i;
//STRIP001 
//STRIP001 	for ( i=2; i<nEntries; i++ )
//STRIP001 		delete (String*)aLbOutPos.GetEntryData( i );
//STRIP001 
//STRIP001 	for ( i=0; i<nLabelCount; i++ )
//STRIP001 		delete aLabelDataArr[i];
//STRIP001 	delete [] aLabelDataArr;
//STRIP001 
//STRIP001 	for ( i=0; i<FUNC_COUNT; i++ )
//STRIP001 		delete aFuncNameArr[i];
//STRIP001 	for ( i=0; (i<MAX_LABELS); i++ )
//STRIP001 		delete aSelectArr[i];
//STRIP001 
//STRIP001 	for ( i=0; (i<MAX_FIELDS); i++ )
//STRIP001 	{
//STRIP001 		delete aColArr 	[i];
//STRIP001 		delete aRowArr 	[i];
//STRIP001 		delete aDataArr	[i];
//STRIP001 	}
//STRIP001 
//STRIP001 	delete pDlgDPObject;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 ScDPFieldWindow& ScDPLayoutDlg::GetFieldWindow( ScDPFieldType eType )
//STRIP001 {
//STRIP001     switch( eType )
//STRIP001     {
//STRIP001         case TYPE_ROW:  return aWndRow;
//STRIP001         case TYPE_COL:  return aWndCol;
//STRIP001         case TYPE_DATA: return aWndData;
//STRIP001     }
//STRIP001     return aWndSelect;
//STRIP001 }

//STRIP001 void __EXPORT ScDPLayoutDlg::Init()
//STRIP001 {
//STRIP001 	DBG_ASSERT( pViewData && pDoc,
//STRIP001 				"Ctor-Initialisierung fehlgeschlagen!" );
//STRIP001 
//STRIP001     aBtnRemove.SetClickHdl( LINK( this, ScDPLayoutDlg, ClickHdl ) );
//STRIP001     aBtnOptions.SetClickHdl( LINK( this, ScDPLayoutDlg, ClickHdl ) );
//STRIP001 
//STRIP001     USHORT i;
//STRIP001 	for ( i=0; i<FUNC_COUNT; i++ )
//STRIP001 		aFuncNameArr[i] = new String( ScResId( i+1 ) );
//STRIP001 
//STRIP001 	aBtnMore.AddWindow( &aFtOutArea );
//STRIP001 	aBtnMore.AddWindow( &aLbOutPos );
//STRIP001 	aBtnMore.AddWindow( &aEdOutPos );
//STRIP001     aBtnMore.AddWindow( &aRbOutPos );
//STRIP001 	aBtnMore.AddWindow( &aBtnIgnEmptyRows );
//STRIP001 	aBtnMore.AddWindow( &aBtnDetectCat );
//STRIP001 	aBtnMore.AddWindow( &aBtnTotalCol );
//STRIP001 	aBtnMore.AddWindow( &aBtnTotalRow );
//STRIP001     aBtnMore.AddWindow( &aFlAreas );
//STRIP001     aBtnMore.SetClickHdl( LINK( this, ScDPLayoutDlg, MoreClickHdl ) );
//STRIP001 
//STRIP001 	{
//STRIP001 		Size aSize( Window( this, ScResId( WND_FIELD ) ).GetSizePixel() );
//STRIP001         OHEIGHT = aSize.Height();
//STRIP001         OWIDTH  = aSize.Width();
//STRIP001 	}
//STRIP001     SSPACE = Window( this, ScResId( WND_FIELD_SPACE ) ).GetSizePixel().Width();
//STRIP001 
//STRIP001     CalcWndSizes();
//STRIP001 
//STRIP001 	for ( i=0; i<MAX_LABELS; i++ )
//STRIP001 		aSelectArr[i] = NULL;
//STRIP001 
//STRIP001 	for ( i=0; i<MAX_FIELDS; i++ )
//STRIP001 	{
//STRIP001 		aColArr[i]  = NULL;
//STRIP001 		aRowArr[i]  = NULL;
//STRIP001 		aDataArr[i] = NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	InitWndSelect( thePivotData.ppLabelArr, thePivotData.nLabels );
//STRIP001 	InitWnd( thePivotData.aColArr,  thePivotData.nColCount,  TYPE_COL );
//STRIP001 	InitWnd( thePivotData.aRowArr,  thePivotData.nRowCount,  TYPE_ROW );
//STRIP001 	InitWnd( thePivotData.aDataArr, thePivotData.nDataCount, TYPE_DATA );
//STRIP001 
//STRIP001     aSlider.SetPageSize( PAGE_SIZE );
//STRIP001     aSlider.SetVisibleSize( PAGE_SIZE );
//STRIP001     aSlider.SetLineSize( LINE_SIZE );
//STRIP001     aSlider.SetRange( Range( 0, ((thePivotData.nLabels+LINE_SIZE-1)/LINE_SIZE)*LINE_SIZE ) );
//STRIP001 
//STRIP001 	if ( thePivotData.nLabels > PAGE_SIZE )
//STRIP001 	{
//STRIP001         aSlider.SetEndScrollHdl( LINK( this, ScDPLayoutDlg, ScrollHdl ) );
//STRIP001 		aSlider.Show();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aSlider.Hide();
//STRIP001 
//STRIP001 	// Ein-/Ausgabebereiche: ----------------------------------------------
//STRIP001 
//STRIP001     aLbOutPos .SetSelectHdl( LINK( this, ScDPLayoutDlg, SelAreaHdl ) );
//STRIP001     aEdOutPos .SetModifyHdl( LINK( this, ScDPLayoutDlg, EdModifyHdl ) );
//STRIP001     aBtnOk    .SetClickHdl ( LINK( this, ScDPLayoutDlg, OkHdl ) );
//STRIP001     aBtnCancel.SetClickHdl ( LINK( this, ScDPLayoutDlg, CancelHdl ) );
//STRIP001 
//STRIP001 	if ( pViewData && pDoc )
//STRIP001 	{
//STRIP001 		/*
//STRIP001 		 * Aus den RangeNames des Dokumentes werden nun die
//STRIP001 		 * in einem Zeiger-Array gemerkt, bei denen es sich
//STRIP001 		 * um sinnvolle Bereiche handelt
//STRIP001 		 */
//STRIP001 
//STRIP001 		aLbOutPos.Clear();
//STRIP001 		aLbOutPos.InsertEntry( aStrUndefined, 0 );
//STRIP001 		aLbOutPos.InsertEntry( aStrNewTable,  1 );
//STRIP001 
//STRIP001 		ScAreaNameIterator aIter( pDoc );
//STRIP001 		String aName;
//STRIP001 		ScRange aRange;
//STRIP001 		String aRefStr;
//STRIP001 		while ( aIter.Next( aName, aRange ) )
//STRIP001 		{
//STRIP001 			if ( !aIter.WasDBName() )		// hier keine DB-Bereiche !
//STRIP001 			{
//STRIP001 				USHORT nInsert = aLbOutPos.InsertEntry( aName );
//STRIP001 
//STRIP001 				aRange.aStart.Format( aRefStr, SCA_ABS_3D, pDoc );
//STRIP001 				aLbOutPos.SetEntryData( nInsert, new String( aRefStr ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( thePivotData.nTab != MAXTAB+1 )
//STRIP001 	{
//STRIP001 		String aStr;
//STRIP001 		ScAddress( thePivotData.nCol,
//STRIP001 				   thePivotData.nRow,
//STRIP001 				   thePivotData.nTab ).Format( aStr, STD_FORMAT, pDoc );
//STRIP001 		aEdOutPos.SetText( aStr );
//STRIP001 		EdModifyHdl(0);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aLbOutPos.SelectEntryPos( aLbOutPos.GetEntryCount()-1 );
//STRIP001 		SelAreaHdl(NULL);
//STRIP001 	}
//STRIP001 
//STRIP001 	aBtnIgnEmptyRows.Check( thePivotData.bIgnoreEmptyRows );
//STRIP001 	aBtnDetectCat   .Check( thePivotData.bDetectCategories );
//STRIP001 	aBtnTotalCol	.Check( thePivotData.bMakeTotalCol );
//STRIP001 	aBtnTotalRow	.Check( thePivotData.bMakeTotalRow );
//STRIP001 
//STRIP001     aWndCol.SetHelpId( HID_SC_DPLAY_COLUMN );
//STRIP001     aWndRow.SetHelpId( HID_SC_DPLAY_ROW );
//STRIP001     aWndData.SetHelpId( HID_SC_DPLAY_DATA );
//STRIP001     aWndSelect.SetHelpId( HID_SC_DPLAY_SELECT );
//STRIP001 
//STRIP001     InitFocus();
//STRIP001 
//STRIP001 //	SetDispatcherLock( TRUE ); // Modal-Modus einschalten
//STRIP001 
//STRIP001 	//@BugID 54702 Enablen/Disablen nur noch in Basisklasse
//STRIP001 	//SFX_APPWINDOW->Disable(FALSE);		//! allgemeine Methode im ScAnyRefDlg
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 BOOL __EXPORT ScDPLayoutDlg::Close()
//STRIP001 {
//STRIP001 	return DoClose( ScPivotLayoutWrapper::GetChildWindowId() );
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScDPLayoutDlg::InitWndSelect( LabelData** ppLabelArr, long nLabels )
//STRIP001 {
//STRIP001 	if ( ppLabelArr )
//STRIP001 	{
//STRIP001         long nLast;
//STRIP001 		nLabelCount		= (nLabels > MAX_LABELS)    ? MAX_LABELS  : nLabels;
//STRIP001 		nLast			= (nLabelCount > PAGE_SIZE) ? PAGE_SIZE-1 : nLabelCount-1;
//STRIP001 		aLabelDataArr	= new LabelData*[nLabelCount];
//STRIP001 
//STRIP001         for ( long i=0; (i<nLabelCount); i++ )
//STRIP001 		{
//STRIP001 			aLabelDataArr[i] = new LabelData( *ppLabelArr[i] );
//STRIP001 
//STRIP001 			if ( i <= nLast )
//STRIP001 			{
//STRIP001 				aWndSelect.AddField( *(aLabelDataArr[i]->pStrColName), i );
//STRIP001 				aSelectArr[i] = new FuncData( aLabelDataArr[i]->nCol,
//STRIP001 											  aLabelDataArr[i]->nFuncMask );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScDPLayoutDlg::InitWnd( PivotField* pArr, long nCount, ScDPFieldType eType )
//STRIP001 {
//STRIP001 	if ( pArr && (eType != TYPE_SELECT) )
//STRIP001 	{
//STRIP001         FuncData**          pInitArr = NULL;
//STRIP001         ScDPFieldWindow*    pInitWnd = NULL;
//STRIP001         BOOL                bDataArr = FALSE;
//STRIP001 
//STRIP001 		switch ( eType )
//STRIP001 		{
//STRIP001 			case TYPE_COL:
//STRIP001 				pInitArr = aColArr;
//STRIP001 				pInitWnd = &aWndCol;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case TYPE_ROW:
//STRIP001 				pInitArr = aRowArr;
//STRIP001 				pInitWnd = &aWndRow;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case TYPE_DATA:
//STRIP001 				pInitArr = aDataArr;
//STRIP001 				pInitWnd = &aWndData;
//STRIP001 				bDataArr = TRUE;
//STRIP001 				break;
//STRIP001 			default:
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( pInitArr && pInitWnd )
//STRIP001 		{
//STRIP001             long j=0;
//STRIP001             for ( long i=0; (i<nCount); i++ )
//STRIP001 			{
//STRIP001                 USHORT nCol = pArr[i].nCol;
//STRIP001 				USHORT nMask = pArr[i].nFuncMask;
//STRIP001 
//STRIP001 				if ( nCol != PIVOT_DATA_FIELD )
//STRIP001 				{
//STRIP001 					pInitArr[j] = new FuncData( nCol, nMask );
//STRIP001 
//STRIP001 					if ( !bDataArr )
//STRIP001 					{
//STRIP001 						pInitWnd->AddField( GetLabelString( nCol ), j );
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						LabelData* pData = GetLabelData( nCol );
//STRIP001 						DBG_ASSERT( pData, "LabelData not found" );
//STRIP001 						if (pData)
//STRIP001 						{
//STRIP001 							String aStr( GetFuncString( pInitArr[j]->nFuncMask,
//STRIP001 														 pData->bIsValue ) );
//STRIP001 
//STRIP001 							aStr += GetLabelString( nCol );
//STRIP001 							pInitWnd->AddField( aStr, j );
//STRIP001 						}
//STRIP001 					}
//STRIP001 					j += 1;
//STRIP001 				}
//STRIP001 			}
//STRIP001 // Do not redraw here -> first the FixedText has to get its mnemonic char
//STRIP001 //            pInitWnd->Redraw();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScDPLayoutDlg::InitFocus()
//STRIP001 {
//STRIP001     if( aWndSelect.IsEmpty() )
//STRIP001     {
//STRIP001         aBtnOk.GrabFocus();
//STRIP001         NotifyFieldFocus( TYPE_SELECT, FALSE );
//STRIP001     }
//STRIP001     else
//STRIP001         aWndSelect.GrabFocus();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScDPLayoutDlg::AddField( long nFromIndex, ScDPFieldType eToType, const Point& rAtPos )
//STRIP001 {
//STRIP001     FuncData            fData( *(aSelectArr[nFromIndex]) );
//STRIP001     long                nAt   = 0;
//STRIP001     ScDPFieldWindow*    toWnd = NULL;
//STRIP001     ScDPFieldWindow*    rmWnd = NULL;
//STRIP001     FuncData**          toArr = NULL;
//STRIP001     FuncData**          rmArr = NULL;
//STRIP001     BOOL                bDataArr = FALSE;
//STRIP001 
//STRIP001 	switch ( eToType )
//STRIP001 	{
//STRIP001 		case TYPE_COL:
//STRIP001 			toWnd = &aWndCol;
//STRIP001 			rmWnd = &aWndRow;
//STRIP001 			toArr = aColArr;
//STRIP001 			rmArr = aRowArr;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case TYPE_ROW:
//STRIP001 			toWnd = &aWndRow;
//STRIP001 			rmWnd = &aWndCol;
//STRIP001 			toArr = aRowArr;
//STRIP001 			rmArr = aColArr;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case TYPE_DATA:
//STRIP001 			toWnd = &aWndData;
//STRIP001 			rmWnd = NULL;
//STRIP001 			toArr = aDataArr;
//STRIP001 			rmArr = NULL;
//STRIP001 			bDataArr = TRUE;
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (   (toArr[MAX_FIELDS-1] == NULL)
//STRIP001 		&& (!Contains( toArr, fData.nCol, nAt )) )
//STRIP001 	{
//STRIP001 		// ggF. in anderem Fenster entfernen
//STRIP001 		if ( rmArr )
//STRIP001 		{
//STRIP001 			if ( Contains( rmArr, fData.nCol, nAt ) )
//STRIP001 			{
//STRIP001 				rmWnd->DelField( nAt );
//STRIP001 				Remove( rmArr, nAt );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001         LabelData*  pData = aLabelDataArr[nFromIndex+nOffset];
//STRIP001         long        nAddedAt = 0;
//STRIP001 
//STRIP001 		if ( !bDataArr )
//STRIP001 		{
//STRIP001 			if ( toWnd->AddField( *(pData->pStrColName),
//STRIP001 								  DlgPos2WndPos( rAtPos, *toWnd ),
//STRIP001 								  nAddedAt ) )
//STRIP001 			{
//STRIP001 				Insert( toArr, fData, nAddedAt );
//STRIP001                 toWnd->GrabFocus();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			USHORT nMask = fData.nFuncMask;
//STRIP001 			String aStr( GetFuncString( nMask, pData->bIsValue ) );
//STRIP001 
//STRIP001 			aStr += *(pData->pStrColName);
//STRIP001 
//STRIP001 			if ( toWnd->AddField( aStr,
//STRIP001 								  DlgPos2WndPos( rAtPos, *toWnd ),
//STRIP001 								  nAddedAt ) )
//STRIP001 			{
//STRIP001 				fData.nFuncMask = nMask;
//STRIP001 				Insert( toArr, fData, nAddedAt );
//STRIP001                 toWnd->GrabFocus();
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 	}
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScDPLayoutDlg::MoveField( ScDPFieldType eFromType, long nFromIndex, ScDPFieldType eToType, const Point& rAtPos )
//STRIP001 {
//STRIP001     if ( eFromType == TYPE_SELECT )
//STRIP001         AddField( nFromIndex, eToType, rAtPos );
//STRIP001     else if ( eFromType != eToType )
//STRIP001 	{
//STRIP001         ScDPFieldWindow*    fromWnd  = NULL;
//STRIP001         ScDPFieldWindow*    toWnd    = NULL;
//STRIP001         ScDPFieldWindow*    rmWnd    = NULL;
//STRIP001         FuncData**          fromArr  = NULL;
//STRIP001         FuncData**          toArr    = NULL;
//STRIP001         FuncData**          rmArr    = NULL;
//STRIP001         long                nAt      = 0;
//STRIP001         BOOL                bDataArr = FALSE;
//STRIP001 
//STRIP001 		switch ( eFromType )
//STRIP001 		{
//STRIP001 			case TYPE_COL:
//STRIP001 				fromWnd = &aWndCol;
//STRIP001 				fromArr	= aColArr;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case TYPE_ROW:
//STRIP001 				fromWnd = &aWndRow;
//STRIP001 				fromArr	= aRowArr;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case TYPE_DATA:
//STRIP001 				fromWnd = &aWndData;
//STRIP001 				fromArr	= aDataArr;
//STRIP001 				break;
//STRIP001 		}
//STRIP001 
//STRIP001 		switch ( eToType )
//STRIP001 		{
//STRIP001 			case TYPE_COL:
//STRIP001 				toWnd = &aWndCol;
//STRIP001 				toArr = aColArr;
//STRIP001 				rmWnd = &aWndRow;
//STRIP001 				rmArr = aRowArr;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case TYPE_ROW:
//STRIP001 				toWnd = &aWndRow;
//STRIP001 				toArr = aRowArr;
//STRIP001 				rmWnd = &aWndCol;
//STRIP001 				rmArr = aColArr;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case TYPE_DATA:
//STRIP001 				toWnd = &aWndData;
//STRIP001 				toArr = aDataArr;
//STRIP001 				bDataArr = TRUE;
//STRIP001 				break;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( fromArr && toArr && fromWnd && toWnd )
//STRIP001 		{
//STRIP001             FuncData fData( *(fromArr[nFromIndex]) );
//STRIP001 
//STRIP001 			if ( Contains( fromArr, fData.nCol, nAt ) )
//STRIP001 			{
//STRIP001 				fromWnd->DelField( nAt );
//STRIP001 				Remove( fromArr, nAt );
//STRIP001 
//STRIP001 				if (   (toArr[MAX_FIELDS-1] == NULL)
//STRIP001 					&& (!Contains( toArr, fData.nCol, nAt )) )
//STRIP001 				{
//STRIP001                     long nAddedAt = 0;
//STRIP001 					if ( !bDataArr )
//STRIP001 					{
//STRIP001 						// ggF. in anderem Fenster entfernen
//STRIP001 						if ( rmArr )
//STRIP001 						{
//STRIP001 							if ( Contains( rmArr, fData.nCol, nAt ) )
//STRIP001 							{
//STRIP001 								rmWnd->DelField( nAt );
//STRIP001 								Remove( rmArr, nAt );
//STRIP001 							}
//STRIP001 						}
//STRIP001 
//STRIP001 						if ( toWnd->AddField( GetLabelString( fData.nCol ),
//STRIP001 											  DlgPos2WndPos( rAtPos, *toWnd ),
//STRIP001 											  nAddedAt ) )
//STRIP001 						{
//STRIP001 							Insert( toArr, fData, nAddedAt );
//STRIP001                             toWnd->GrabFocus();
//STRIP001 						}
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						String aStr;
//STRIP001 						USHORT nMask = fData.nFuncMask;
//STRIP001 						aStr  = GetFuncString( nMask );
//STRIP001 						aStr += GetLabelString( fData.nCol );
//STRIP001 
//STRIP001 						if ( toWnd->AddField( aStr,
//STRIP001 											  DlgPos2WndPos( rAtPos, *toWnd ),
//STRIP001 											  nAddedAt ) )
//STRIP001 						{
//STRIP001 							fData.nFuncMask = nMask;
//STRIP001 							Insert( toArr, fData, nAddedAt );
//STRIP001                             toWnd->GrabFocus();
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else // -> eFromType == eToType
//STRIP001 	{
//STRIP001         ScDPFieldWindow*    theWnd  = NULL;
//STRIP001         FuncData**          theArr   = NULL;
//STRIP001         long                nAt      = 0;
//STRIP001         long                nToIndex = 0;
//STRIP001         Point               aToPos;
//STRIP001         BOOL                bDataArr = FALSE;
//STRIP001 
//STRIP001 		switch ( eFromType )
//STRIP001 		{
//STRIP001 			case TYPE_COL:
//STRIP001 				theWnd = &aWndCol;
//STRIP001 				theArr = aColArr;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case TYPE_ROW:
//STRIP001 				theWnd = &aWndRow;
//STRIP001 				theArr = aRowArr;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case TYPE_DATA:
//STRIP001 				theWnd = &aWndData;
//STRIP001 				theArr = aDataArr;
//STRIP001 				bDataArr = TRUE;
//STRIP001 				break;
//STRIP001 		}
//STRIP001 
//STRIP001         FuncData fData( *(theArr[nFromIndex]) );
//STRIP001 
//STRIP001 		if ( Contains( theArr, fData.nCol, nAt ) )
//STRIP001 		{
//STRIP001 			aToPos = DlgPos2WndPos( rAtPos, *theWnd );
//STRIP001             theWnd->GetExistingIndex( aToPos, nToIndex );
//STRIP001 
//STRIP001 			if ( nToIndex != nAt )
//STRIP001 			{
//STRIP001                 long nAddedAt = 0;
//STRIP001 
//STRIP001 				theWnd->DelField( nAt );
//STRIP001 				Remove( theArr, nAt );
//STRIP001 
//STRIP001 				if ( !bDataArr )
//STRIP001 				{
//STRIP001 					if ( theWnd->AddField( GetLabelString( fData.nCol ),
//STRIP001 										   aToPos,
//STRIP001 										   nAddedAt ) )
//STRIP001 					{
//STRIP001 						Insert( theArr, fData, nAddedAt );
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					String aStr;
//STRIP001 					USHORT nMask = fData.nFuncMask;
//STRIP001 					aStr  = GetFuncString( nMask );
//STRIP001 					aStr += GetLabelString( fData.nCol );
//STRIP001 
//STRIP001 					if ( theWnd->AddField( aStr,
//STRIP001 										   DlgPos2WndPos( rAtPos, *theWnd ),
//STRIP001 										   nAddedAt ) )
//STRIP001 					{
//STRIP001 						fData.nFuncMask = nMask;
//STRIP001 						Insert( theArr, fData, nAddedAt );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//----------------------------------------------------------------------------

//STRIP001 void ScDPLayoutDlg::RemoveField( ScDPFieldType eFromType, long nIndex )
//STRIP001 {
//STRIP001     FuncData** pArr = NULL;
//STRIP001     switch( eFromType )
//STRIP001     {
//STRIP001         case TYPE_COL:  pArr = aColArr;     break;
//STRIP001         case TYPE_ROW:  pArr = aRowArr;     break;
//STRIP001         case TYPE_DATA: pArr = aDataArr;    break;
//STRIP001     }
//STRIP001 
//STRIP001     if( pArr )
//STRIP001     {
//STRIP001         ScDPFieldWindow& rWnd = GetFieldWindow( eFromType );
//STRIP001         rWnd.DelField( nIndex );
//STRIP001         Remove( pArr, nIndex );
//STRIP001         if( rWnd.IsEmpty() ) InitFocus();
//STRIP001     }
//STRIP001 }

//----------------------------------------------------------------------------

//STRIP001 void ScDPLayoutDlg::NotifyMouseButtonUp( const Point& rAt )
//STRIP001 {
//STRIP001 	if ( bIsDrag )
//STRIP001 	{
//STRIP001 		bIsDrag = FALSE;
//STRIP001 
//STRIP001         ScDPFieldType   eDnDToType;
//STRIP001         Point           aPos = ScreenToOutputPixel( rAt );
//STRIP001         BOOL            bDel = FALSE;
//STRIP001 
//STRIP001 		if ( aRectCol.IsInside( aPos ) )
//STRIP001 		{
//STRIP001 			eDnDToType = TYPE_COL;
//STRIP001 			bDel = FALSE;
//STRIP001 		}
//STRIP001 		else if ( aRectRow.IsInside( aPos ) )
//STRIP001 		{
//STRIP001 			eDnDToType = TYPE_ROW;
//STRIP001 			bDel = FALSE;
//STRIP001 		}
//STRIP001 		else if ( aRectData.IsInside( aPos ) )
//STRIP001 		{
//STRIP001 			eDnDToType = TYPE_DATA;
//STRIP001 			bDel = FALSE;
//STRIP001 		}
//STRIP001 		else if ( aRectSelect.IsInside( aPos ) )
//STRIP001 		{
//STRIP001 			eDnDToType = TYPE_SELECT;
//STRIP001 			bDel = TRUE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			bDel = TRUE;
//STRIP001 
//STRIP001         if ( bDel )
//STRIP001             RemoveField( eDnDFromType, nDnDFromIndex );
//STRIP001         else
//STRIP001             MoveField( eDnDFromType, nDnDFromIndex, eDnDToType, aPos );
//STRIP001 	}
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 PointerStyle ScDPLayoutDlg::NotifyMouseMove( const Point& rAt )
//STRIP001 {
//STRIP001     PointerStyle ePtr = POINTER_ARROW;
//STRIP001 
//STRIP001 	if ( bIsDrag )
//STRIP001 	{
//STRIP001 		Point aPos = ScreenToOutputPixel( rAt );
//STRIP001 
//STRIP001 		if ( aRectCol.IsInside( aPos ) )
//STRIP001             ePtr = POINTER_PIVOT_COL;
//STRIP001 		else if ( aRectRow.IsInside( aPos ) )
//STRIP001             ePtr = POINTER_PIVOT_ROW;
//STRIP001         else if ( aRectData.IsInside( aPos ) )
//STRIP001             ePtr = POINTER_PIVOT_FIELD;
//STRIP001         else if ( eDnDFromType != TYPE_SELECT )
//STRIP001             ePtr = POINTER_PIVOT_DELETE;
//STRIP001         else if ( aRectSelect.IsInside( aPos ) )
//STRIP001             ePtr = POINTER_PIVOT_FIELD;
//STRIP001         else
//STRIP001             ePtr = POINTER_NOTALLOWED;
//STRIP001 	}
//STRIP001 
//STRIP001     return ePtr;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 PointerStyle ScDPLayoutDlg::NotifyMouseButtonDown( ScDPFieldType eType, long nFieldIndex )
//STRIP001 {
//STRIP001     PointerStyle ePtr = POINTER_ARROW;
//STRIP001 
//STRIP001 	bIsDrag		  = TRUE;
//STRIP001 	eDnDFromType  = eType;
//STRIP001 	nDnDFromIndex = nFieldIndex;
//STRIP001 
//STRIP001 	if ( eType == TYPE_COL )
//STRIP001         ePtr = POINTER_PIVOT_COL;
//STRIP001 	else if ( eType == TYPE_ROW )
//STRIP001         ePtr = POINTER_PIVOT_ROW;
//STRIP001 
//STRIP001     return ePtr;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScDPLayoutDlg::NotifyDoubleClick( ScDPFieldType eType, long nFieldIndex )
//STRIP001 {
//STRIP001 	FuncData** pArr = NULL;
//STRIP001 	switch ( eType )
//STRIP001 	{
//STRIP001 		case TYPE_COL:		pArr = aColArr;		break;
//STRIP001 		case TYPE_ROW: 		pArr = aRowArr;		break;
//STRIP001 		case TYPE_DATA:		pArr = aDataArr;	break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pArr )
//STRIP001 	{
//STRIP001         long nArrPos = 0;
//STRIP001 		LabelData* pData = GetLabelData( pArr[nFieldIndex]->nCol, &nArrPos );
//STRIP001 		if ( pData )
//STRIP001 		{
//STRIP001 			String aFieldName = *(pData->pStrColName);
//STRIP001 			BOOL bOldShowAll = bShowAll[nArrPos];
//STRIP001 
//STRIP001             ScDPFunctionDlg* pDlg =
//STRIP001                 new ScDPFunctionDlg( this,
//STRIP001 										eType != TYPE_DATA,
//STRIP001 										aFieldName,
//STRIP001 										pArr[nFieldIndex]->nFuncMask,
//STRIP001 										bOldShowAll );
//STRIP001 
//STRIP001 			if ( pDlg->Execute() == RET_OK )
//STRIP001 			{
//STRIP001 				  pArr[nFieldIndex]->nFuncMask
//STRIP001 				= pData->nFuncMask
//STRIP001 				= pDlg->GetFuncMask();
//STRIP001 
//STRIP001 				if ( eType == TYPE_DATA )
//STRIP001 				{
//STRIP001 					String aStr;
//STRIP001 					aStr  = GetFuncString ( aDataArr[nFieldIndex]->nFuncMask );
//STRIP001 					aStr +=	GetLabelString( aDataArr[nFieldIndex]->nCol );
//STRIP001                     aWndData.SetFieldText( aStr, nFieldIndex );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					BOOL bNewShowAll = pDlg->GetShowAll();
//STRIP001 					if (bNewShowAll != bOldShowAll)
//STRIP001 					{
//STRIP001 						//!	remember which were changed?
//STRIP001 						bShowAll[nArrPos] = bNewShowAll;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			delete pDlg;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//----------------------------------------------------------------------------

//STRIP001 void ScDPLayoutDlg::NotifyFieldFocus( ScDPFieldType eType, BOOL bGotFocus )
//STRIP001 {
//STRIP001     /*  Enable Remove/Options buttons on GetFocus in field window.
//STRIP001         #107616# Enable them also, if dialog is deactivated (click into document).
//STRIP001         The !IsActive() condition handles the case that a LoseFocus event of a
//STRIP001         field window would follow the Deactivate event of this dialog. */
//STRIP001     BOOL bEnable = (bGotFocus || !IsActive()) && (eType != TYPE_SELECT);
//STRIP001     aBtnRemove.Enable( bEnable );
//STRIP001     aBtnOptions.Enable( bEnable );
//STRIP001     if( bGotFocus )
//STRIP001         eLastActiveType = eType;
//STRIP001 }

//----------------------------------------------------------------------------

//STRIP001 void ScDPLayoutDlg::NotifyMoveField( ScDPFieldType eToType )
//STRIP001 {
//STRIP001     ScDPFieldWindow& rWnd = GetFieldWindow( eLastActiveType );
//STRIP001     if( (eToType != TYPE_SELECT) && !rWnd.IsEmpty() )
//STRIP001     {
//STRIP001         MoveField( eLastActiveType, rWnd.GetSelectedField(), eToType, GetFieldWindow( eToType ).GetLastPosition() );
//STRIP001         if( rWnd.IsEmpty() )
//STRIP001             NotifyFieldFocus( eToType, TRUE );
//STRIP001         else
//STRIP001             rWnd.GrabFocus();
//STRIP001         if( eLastActiveType == TYPE_SELECT )
//STRIP001             aWndSelect.SelectNext();
//STRIP001     }
//STRIP001     else
//STRIP001         InitFocus();
//STRIP001 }

//----------------------------------------------------------------------------

//STRIP001 void ScDPLayoutDlg::NotifyRemoveField( ScDPFieldType eType, long nFieldIndex )
//STRIP001 {
//STRIP001     if( eType != TYPE_SELECT )
//STRIP001         RemoveField( eType, nFieldIndex );
//STRIP001 }

//----------------------------------------------------------------------------

//STRIP001 BOOL ScDPLayoutDlg::NotifyMoveSlider( USHORT nKeyCode )
//STRIP001 {
//STRIP001     long nOldPos = aSlider.GetThumbPos();
//STRIP001     switch( nKeyCode )
//STRIP001     {
//STRIP001         case KEY_HOME:  aSlider.DoScroll( 0 );                      break;
//STRIP001         case KEY_END:   aSlider.DoScroll( aSlider.GetRangeMax() );  break;
//STRIP001         case KEY_UP:
//STRIP001         case KEY_LEFT:  aSlider.DoScrollAction( SCROLL_LINEUP );    break;
//STRIP001         case KEY_DOWN:
//STRIP001         case KEY_RIGHT: aSlider.DoScrollAction( SCROLL_LINEDOWN );  break;
//STRIP001     }
//STRIP001     return nOldPos != aSlider.GetThumbPos();
//STRIP001 }

//----------------------------------------------------------------------------

//STRIP001 void ScDPLayoutDlg::Deactivate()
//STRIP001 {
//STRIP001     /*  #107616# If the dialog has been deactivated (click into document), the LoseFocus
//STRIP001         event from field window disables Remove/Options buttons. Re-enable them here by
//STRIP001         simulating a GetFocus event. Event order of LoseFocus and Deactivate is not important.
//STRIP001         The last event will enable the buttons in both cases (see NotifyFieldFocus). */
//STRIP001     NotifyFieldFocus( eLastActiveType, TRUE );
//STRIP001 }

//----------------------------------------------------------------------------

//STRIP001 BOOL ScDPLayoutDlg::Contains( FuncData** pArr, short nCol, long& nAt )
//STRIP001 {
//STRIP001 	if ( !pArr )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	BOOL	bFound	= FALSE;
//STRIP001     long    i       = 0;
//STRIP001 
//STRIP001 	while ( (i<MAX_FIELDS) && (pArr[i] != NULL) && !bFound )
//STRIP001 	{
//STRIP001 		bFound = (pArr[i]->nCol == nCol);
//STRIP001 		if ( bFound )
//STRIP001 			nAt = i;
//STRIP001 		i++;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bFound;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScDPLayoutDlg::Remove( FuncData** pArr, long nAt )
//STRIP001 {
//STRIP001 	if ( !pArr || (nAt>MAX_FIELDS-1) )
//STRIP001 		return;
//STRIP001 
//STRIP001 	DELETEZ( pArr[nAt] );
//STRIP001 
//STRIP001 	if ( (nAt != MAX_FIELDS-1) && (pArr[nAt+1] != NULL) )
//STRIP001 	{
//STRIP001         long i=nAt;
//STRIP001 		while ( i<MAX_FIELDS )
//STRIP001 		{
//STRIP001 			pArr[i] = pArr[i+1];
//STRIP001 			i++;
//STRIP001 		}
//STRIP001 		pArr[MAX_FIELDS-1] = NULL;
//STRIP001 	}
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScDPLayoutDlg::Insert( FuncData** pArr, const FuncData& rFData, long nAt )
//STRIP001 {
//STRIP001 	if ( !pArr || (nAt>MAX_FIELDS-1) )
//STRIP001 		return;
//STRIP001 
//STRIP001 	if ( pArr[nAt] == NULL )
//STRIP001 	{
//STRIP001 		pArr[nAt] = new FuncData( rFData );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( pArr[MAX_FIELDS-1] == NULL ) // mind. ein Slot frei?
//STRIP001 		{
//STRIP001             for ( long i=MAX_FIELDS-1; i>nAt; i-- )
//STRIP001 				pArr[i] = pArr[i-1];
//STRIP001 			pArr[nAt] = new FuncData( rFData );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 LabelData* ScDPLayoutDlg::GetLabelData( short nCol, long* pPos )
//STRIP001 {
//STRIP001 	LabelData*	pData	= NULL;
//STRIP001 	BOOL		bFound	= FALSE;
//STRIP001 
//STRIP001 	if ( aLabelDataArr )
//STRIP001 	{
//STRIP001         for ( long i=0; (i<nLabelCount) && !bFound; i++ )
//STRIP001 		{
//STRIP001 			bFound = (aLabelDataArr[i]->nCol == nCol);
//STRIP001 			if ( bFound )
//STRIP001 			{
//STRIP001 				pData = aLabelDataArr[i];
//STRIP001 				if (pPos)
//STRIP001 					*pPos = i;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return pData;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 String ScDPLayoutDlg::GetLabelString( short nCol )
//STRIP001 {
//STRIP001 	LabelData* pData = GetLabelData( nCol );
//STRIP001 	DBG_ASSERT( pData, "LabelData not found" );
//STRIP001 	if (pData && pData->pStrColName)
//STRIP001 		return *pData->pStrColName;
//STRIP001 
//STRIP001 	return String();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 String ScDPLayoutDlg::GetFuncString( USHORT& rFuncMask, BOOL bIsValue )
//STRIP001 {
//STRIP001 	String aStr;
//STRIP001 
//STRIP001 	if (   rFuncMask == PIVOT_FUNC_NONE
//STRIP001 		|| rFuncMask == PIVOT_FUNC_AUTO )
//STRIP001 	{
//STRIP001 		if ( bIsValue )
//STRIP001 		{
//STRIP001 			aStr = FSTR(PIVOTSTR_SUM);
//STRIP001 			rFuncMask = PIVOT_FUNC_SUM;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aStr = FSTR(PIVOTSTR_COUNT);
//STRIP001 			rFuncMask = PIVOT_FUNC_COUNT;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( rFuncMask == PIVOT_FUNC_SUM )		  aStr = FSTR(PIVOTSTR_SUM);
//STRIP001 	else if ( rFuncMask == PIVOT_FUNC_COUNT )	  aStr = FSTR(PIVOTSTR_COUNT);
//STRIP001 	else if ( rFuncMask == PIVOT_FUNC_AVERAGE )	  aStr = FSTR(PIVOTSTR_AVG);
//STRIP001 	else if ( rFuncMask == PIVOT_FUNC_MAX )		  aStr = FSTR(PIVOTSTR_MAX);
//STRIP001 	else if ( rFuncMask == PIVOT_FUNC_MIN )		  aStr = FSTR(PIVOTSTR_MIN);
//STRIP001 	else if ( rFuncMask == PIVOT_FUNC_PRODUCT )	  aStr = FSTR(PIVOTSTR_PROD);
//STRIP001 	else if ( rFuncMask == PIVOT_FUNC_COUNT_NUM ) aStr = FSTR(PIVOTSTR_COUNT2);
//STRIP001 	else if ( rFuncMask == PIVOT_FUNC_STD_DEV )	  aStr = FSTR(PIVOTSTR_DEV);
//STRIP001 	else if ( rFuncMask == PIVOT_FUNC_STD_DEVP )  aStr = FSTR(PIVOTSTR_DEV2);
//STRIP001 	else if ( rFuncMask == PIVOT_FUNC_STD_VAR )	  aStr = FSTR(PIVOTSTR_VAR);
//STRIP001 	else if ( rFuncMask == PIVOT_FUNC_STD_VARP )  aStr = FSTR(PIVOTSTR_VAR2);
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aStr  = ScGlobal::GetRscString( STR_TABLE_ERGEBNIS );
//STRIP001 		aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM( " - " ));
//STRIP001 	}
//STRIP001 
//STRIP001 	return aStr;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 Point ScDPLayoutDlg::DlgPos2WndPos( const Point& rPt, Window& rWnd )
//STRIP001 {
//STRIP001 	Point aWndPt( rPt );
//STRIP001 	aWndPt.X() = rPt.X()-rWnd.GetPosPixel().X();
//STRIP001 	aWndPt.Y() = rPt.Y()-rWnd.GetPosPixel().Y();
//STRIP001 
//STRIP001 	return aWndPt;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScDPLayoutDlg::CalcWndSizes()
//STRIP001 {
//STRIP001     // row/column/data area sizes
//STRIP001     aWndRow.SetSizePixel( Size( OWIDTH, MAX_FIELDS * OHEIGHT ) );
//STRIP001     aWndCol.SetSizePixel( Size( MAX_FIELDS * OWIDTH / 2, 2 * OHEIGHT ) );
//STRIP001     aWndData.SetSizePixel( Size( MAX_FIELDS * OWIDTH / 2, MAX_FIELDS * OHEIGHT ) );
//STRIP001 
//STRIP001     // selection area
//STRIP001     aWndSelect.SetSizePixel( Size(
//STRIP001         2 * OWIDTH + SSPACE, LINE_SIZE * OHEIGHT + (LINE_SIZE - 1) * SSPACE ) );
//STRIP001 
//STRIP001     // scroll bar
//STRIP001     Point aSliderPos( aWndSelect.GetPosPixel() );
//STRIP001     Size aSliderSize( aWndSelect.GetSizePixel() );
//STRIP001     aSliderPos.Y() += aSliderSize.Height() + SSPACE;
//STRIP001     aSliderSize.Height() = GetSettings().GetStyleSettings().GetScrollBarSize();
//STRIP001     aSlider.SetPosSizePixel( aSliderPos, aSliderSize );
//STRIP001 
//STRIP001 	aRectRow	= Rectangle( aWndRow.GetPosPixel(),		aWndRow.GetSizePixel() );
//STRIP001 	aRectCol	= Rectangle( aWndCol.GetPosPixel(),		aWndCol.GetSizePixel() );
//STRIP001 	aRectData	= Rectangle( aWndData.GetPosPixel(),	aWndData.GetSizePixel() );
//STRIP001 	aRectSelect = Rectangle( aWndSelect.GetPosPixel(),	aWndSelect.GetSizePixel() );
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 BOOL ScDPLayoutDlg::GetPivotArrays( PivotField*  pColArr,
//STRIP001 									   PivotField*	pRowArr,
//STRIP001 									   PivotField*	pDataArr,
//STRIP001                                        USHORT&      rColCount,
//STRIP001                                        USHORT&      rRowCount,
//STRIP001                                        USHORT&      rDataCount )
//STRIP001 {
//STRIP001 	BOOL bFit = TRUE;
//STRIP001     USHORT i=0;
//STRIP001 
//STRIP001 	for ( i=0; (i<MAX_FIELDS) && (aDataArr[i] != NULL ); i++ )
//STRIP001 	{
//STRIP001 		pDataArr[i].nCol		= aDataArr[i]->nCol;
//STRIP001 		pDataArr[i].nFuncMask	= aDataArr[i]->nFuncMask;
//STRIP001 	}
//STRIP001 	rDataCount = i;
//STRIP001 
//STRIP001 	for ( i=0; (i<MAX_FIELDS) && (aColArr[i] != NULL ); i++ )
//STRIP001 	{
//STRIP001 		pColArr[i].nCol			= aColArr[i]->nCol;
//STRIP001 		pColArr[i].nFuncMask	= aColArr[i]->nFuncMask;
//STRIP001 	}
//STRIP001 	rColCount = i;
//STRIP001 
//STRIP001 	for ( i=0; (i<MAX_FIELDS) && (aRowArr[i] != NULL ); i++ )
//STRIP001 	{
//STRIP001 		pRowArr[i].nCol			= aRowArr[i]->nCol;
//STRIP001 		pRowArr[i].nFuncMask	= aRowArr[i]->nFuncMask;
//STRIP001 	}
//STRIP001 	rRowCount = i;
//STRIP001 
//STRIP001 	if ( rRowCount < MAX_FIELDS )
//STRIP001 		pRowArr[rRowCount++].nCol = PIVOT_DATA_FIELD;
//STRIP001 	else if ( rColCount < MAX_FIELDS )
//STRIP001 		pColArr[rColCount++].nCol = PIVOT_DATA_FIELD;
//STRIP001 	else
//STRIP001 		bFit = FALSE;		// kein Platz fuer Datenfeld
//STRIP001 
//STRIP001 	return bFit;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScDPLayoutDlg::SetReference( const ScRange& rRef, ScDocument* pDoc )
//STRIP001 {
//STRIP001 	if ( bRefInputMode )
//STRIP001 	{
//STRIP001 		if ( rRef.aStart != rRef.aEnd )
//STRIP001 			RefInputStart( &aEdOutPos );
//STRIP001 /*
//STRIP001 		ScAddress	aAdr( nStartCol, nStartRow, nStartTab );
//STRIP001 		aAdr.PutInOrder( ScAddress( nEndCol, nEndRow, nEndTab ) );
//STRIP001 */
//STRIP001 		String aRefStr;
//STRIP001 		rRef.aStart.Format( aRefStr, STD_FORMAT, pDoc );
//STRIP001 		aEdOutPos.SetRefString( aRefStr );
//STRIP001 	}
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScDPLayoutDlg::SetActive()
//STRIP001 {
//STRIP001 	if ( bRefInputMode )
//STRIP001 	{
//STRIP001 		aEdOutPos.GrabFocus();
//STRIP001 		EdModifyHdl( NULL );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		GrabFocus();
//STRIP001 	}
//STRIP001 
//STRIP001 	RefInputDone();
//STRIP001 }

//----------------------------------------------------------------------------
// Handler:
//----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScDPLayoutDlg, ClickHdl, PushButton *, pBtn )
//STRIP001 {
//STRIP001     if( pBtn == &aBtnRemove )
//STRIP001     {
//STRIP001         ScDPFieldWindow& rWnd = GetFieldWindow( eLastActiveType );
//STRIP001         RemoveField( eLastActiveType, rWnd.GetSelectedField() );
//STRIP001         if( !rWnd.IsEmpty() ) rWnd.GrabFocus();
//STRIP001     }
//STRIP001     else if( pBtn == &aBtnOptions )
//STRIP001 	{
//STRIP001         ScDPFieldWindow& rWnd = GetFieldWindow( eLastActiveType );
//STRIP001         NotifyDoubleClick( eLastActiveType, rWnd.GetSelectedField() );
//STRIP001         rWnd.GrabFocus();
//STRIP001     }
//STRIP001     return 0;
//STRIP001 }

//----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScDPLayoutDlg, OkHdl, OKButton *, EMPTYARG )
//STRIP001 {
//STRIP001 	String		aOutPosStr( aEdOutPos.GetText() );
//STRIP001 	ScAddress	aAdrDest;
//STRIP001 	BOOL		bToNewTable = (aLbOutPos.GetSelectEntryPos() == 1);
//STRIP001 	USHORT		nResult		= !bToNewTable ? aAdrDest.Parse( aOutPosStr, pDoc ) : 0;
//STRIP001 
//STRIP001 	if (   bToNewTable
//STRIP001 		|| ( (aOutPosStr.Len() > 0) && (SCA_VALID == (nResult & SCA_VALID)) ) )
//STRIP001 	{
//STRIP001 		//@BugID 54702 Enablen/Disablen nur noch in Basisklasse
//STRIP001 		//SFX_APPWINDOW->Enable();
//STRIP001 
//STRIP001 		ScPivotParam	theOutParam;
//STRIP001 		PivotFieldArr	aColArr;
//STRIP001 		PivotFieldArr	aRowArr;
//STRIP001 		PivotFieldArr	aDataArr;
//STRIP001         USHORT          nColCount;
//STRIP001         USHORT          nRowCount;
//STRIP001         USHORT          nDataCount;
//STRIP001 
//STRIP001 		BOOL bFit = GetPivotArrays( aColArr,   aRowArr,   aDataArr,
//STRIP001 									nColCount, nRowCount, nDataCount );
//STRIP001 		if ( bFit && pDlgDPObject )
//STRIP001 		{
//STRIP001 			ScRange aOutRange( aAdrDest );		// bToNewTable is passed separately
//STRIP001 
//STRIP001 			ScDPSaveData aSaveData;
//STRIP001 			aSaveData.SetIgnoreEmptyRows( aBtnIgnEmptyRows.IsChecked() );
//STRIP001 			aSaveData.SetRepeatIfEmpty( aBtnDetectCat.IsChecked() );
//STRIP001 			aSaveData.SetColumnGrand( aBtnTotalCol.IsChecked() );
//STRIP001 			aSaveData.SetRowGrand( aBtnTotalRow.IsChecked() );
//STRIP001 
//STRIP001 			uno::Reference<sheet::XDimensionsSupplier> xSource = pDlgDPObject->GetSource();
//STRIP001 
//STRIP001 			ScDPObject::ConvertOrientation( aSaveData, aColArr,  nColCount,
//STRIP001 							sheet::DataPilotFieldOrientation_COLUMN, NULL, 0, 0, xSource, FALSE );
//STRIP001 			ScDPObject::ConvertOrientation( aSaveData, aRowArr,  nRowCount,
//STRIP001 							sheet::DataPilotFieldOrientation_ROW,    NULL, 0, 0, xSource, FALSE );
//STRIP001 			ScDPObject::ConvertOrientation( aSaveData, aDataArr, nDataCount,
//STRIP001 							sheet::DataPilotFieldOrientation_DATA,   NULL, 0, 0, xSource, FALSE,
//STRIP001 							aColArr, nColCount, aRowArr, nRowCount );
//STRIP001 
//STRIP001 			//	"show all" property
//STRIP001 			//!	init from pDlgDPObject, set only changed values
//STRIP001             for ( long i=0; i<nLabelCount; i++ )
//STRIP001 				if ( aLabelDataArr && aLabelDataArr[i]->pStrColName )
//STRIP001 				{
//STRIP001 					ScDPSaveDimension* pDim =
//STRIP001 						aSaveData.GetExistingDimensionByName( *aLabelDataArr[i]->pStrColName );
//STRIP001 					if (pDim)
//STRIP001 						pDim->SetShowEmpty( bShowAll[i] );
//STRIP001 				}
//STRIP001 
//STRIP001 			USHORT nWhichPivot = SC_MOD()->GetPool().GetWhich( SID_PIVOT_TABLE );
//STRIP001 			ScPivotItem aOutItem( nWhichPivot, &aSaveData, &aOutRange, bToNewTable );
//STRIP001 
//STRIP001 			bRefInputMode = FALSE;		// to allow deselecting when switching sheets
//STRIP001 
//STRIP001 			SetDispatcherLock( FALSE );
//STRIP001 			SwitchToDocument();
//STRIP001 
//STRIP001 			//	#95513# don't hide the dialog before executing the slot, instead it is used as
//STRIP001 			//	parent for message boxes in ScTabViewShell::GetDialogParent
//STRIP001 
//STRIP001 			GetBindings().GetDispatcher()->Execute( SID_PIVOT_TABLE,
//STRIP001 									  SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD,
//STRIP001 									  &aOutItem, 0L, 0L );
//STRIP001 			Close();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			ErrorBox( this, WinBits( WB_OK | WB_DEF_OK ),
//STRIP001 					 ScGlobal::GetRscString( STR_PIVOT_ERROR )
//STRIP001 					).Execute();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( !aBtnMore.GetState() )
//STRIP001 			aBtnMore.SetState( TRUE );
//STRIP001 
//STRIP001 		ErrorBox( this, WinBits( WB_OK | WB_DEF_OK ),
//STRIP001 				 ScGlobal::GetRscString( STR_INVALID_TABREF )
//STRIP001 				).Execute();
//STRIP001 		aEdOutPos.GrabFocus();
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 IMPL_LINK_INLINE_START( ScDPLayoutDlg, CancelHdl, CancelButton *, EMPTYARG )
//STRIP001 {
//STRIP001 	Close();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( ScDPLayoutDlg, CancelHdl, CancelButton *, EMPTYARG )


//----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScDPLayoutDlg, MoreClickHdl, MoreButton *, pBtn )
//STRIP001 {
//STRIP001 	if ( aBtnMore.GetState() )
//STRIP001 	{
//STRIP001 		bRefInputMode = TRUE;
//STRIP001 		//@BugID 54702 Enablen/Disablen nur noch in Basisklasse
//STRIP001 		//SFX_APPWINDOW->Enable();
//STRIP001 		aEdOutPos.Enable();
//STRIP001 		aEdOutPos.GrabFocus();
//STRIP001         aRbOutPos.Enable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		bRefInputMode = FALSE;
//STRIP001 		//@BugID 54702 Enablen/Disablen nur noch in Basisklasse
//STRIP001 		//SFX_APPWINDOW->Disable(FALSE);		//! allgemeine Methode im ScAnyRefDlg
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScDPLayoutDlg, EdModifyHdl, Edit *, EMPTYARG )
//STRIP001 {
//STRIP001 	String	theCurPosStr = aEdOutPos.GetText();
//STRIP001 	USHORT	nResult = ScAddress().Parse( theCurPosStr, pDoc );
//STRIP001 
//STRIP001 	if ( SCA_VALID == (nResult & SCA_VALID) )
//STRIP001 	{
//STRIP001 		String*	pStr	= NULL;
//STRIP001 		BOOL	bFound	= FALSE;
//STRIP001 		USHORT	i		= 0;
//STRIP001 		USHORT	nCount	= aLbOutPos.GetEntryCount();
//STRIP001 
//STRIP001 		for ( i=2; i<nCount && !bFound; i++ )
//STRIP001 		{
//STRIP001 			pStr = (String*)aLbOutPos.GetEntryData( i );
//STRIP001 			bFound = (theCurPosStr == *pStr);
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( bFound )
//STRIP001 			aLbOutPos.SelectEntryPos( --i );
//STRIP001 		else
//STRIP001 			aLbOutPos.SelectEntryPos( 0 );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScDPLayoutDlg, SelAreaHdl, ListBox *, EMPTYARG )
//STRIP001 {
//STRIP001 	String	aString;
//STRIP001 	USHORT	nSelPos = aLbOutPos.GetSelectEntryPos();
//STRIP001 
//STRIP001 	if ( nSelPos > 1 )
//STRIP001 	{
//STRIP001 		aString = *(String*)aLbOutPos.GetEntryData( nSelPos );
//STRIP001 	}
//STRIP001 	else if ( nSelPos == aLbOutPos.GetEntryCount()-1 ) // auf neue Tabelle?
//STRIP001 	{
//STRIP001 		aEdOutPos.Disable();
//STRIP001         aRbOutPos.Disable();
//STRIP001 	}
//STRIP001 	else
//STRIP001     {
//STRIP001 		aEdOutPos.Enable();
//STRIP001         aRbOutPos.Enable();
//STRIP001     }
//STRIP001 
//STRIP001 	aEdOutPos.SetText( aString );
//STRIP001 	return 0;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScDPLayoutDlg, ScrollHdl, ScrollBar *, EMPTYARG )
//STRIP001 {
//STRIP001     long nNewOffset = aSlider.GetThumbPos();
//STRIP001     long nOffsetDiff = nNewOffset - nOffset;
//STRIP001     nOffset = nNewOffset;
//STRIP001 
//STRIP001 	LabelData*	pData 	= NULL;
//STRIP001     long        nFields = Min( nLabelCount - nOffset, (long)PAGE_SIZE );
//STRIP001 
//STRIP001 	aWndSelect.ClearFields();
//STRIP001 
//STRIP001     long i=0;
//STRIP001 	for ( i=0; i<nFields; i++ )
//STRIP001 	{
//STRIP001 		pData = aLabelDataArr[nOffset+i];
//STRIP001 		aWndSelect.AddField( *(pData->pStrColName), i );
//STRIP001 		if ( aSelectArr[i] )
//STRIP001 			*(aSelectArr[i]) = FuncData( pData->nCol, pData->nFuncMask );
//STRIP001 		else
//STRIP001 			aSelectArr[i] = new FuncData( pData->nCol, pData->nFuncMask );
//STRIP001 	}
//STRIP001 	for ( ; i<MAX_LABELS; i++ )
//STRIP001 		DELETEZ( aSelectArr[i] );
//STRIP001 
//STRIP001     aWndSelect.ModifySelectionOffset( nOffsetDiff );    // adjusts selection & redraws
//STRIP001 	return 0;
//STRIP001 }


}
