/*
 * XSleep.java
 *
 * Created on 6. M?rz 2003, 15:07
 */
package com.sun.star.wizards.tutorial.executer.officeHelper;

import java.util.Hashtable;

/**
 * Mouse handling interface.
 *
 * @author $author$
 * @version $Revision: 1.2 $
 */
public interface XMouse {
	/**
	 * Sleeps for the specified time. To catch any InterruptedExceptions that occur,
	 * Thread.sleep() may be used instead.
	 *
	 * @param Time to sleep in milliseconds
	 */
	public void sleep(int millis);

	/**
	 * Click mouse.
	 */
	public void mouseClick();

	/**
	 * Click mouse.
	 *
	 * @param Click number
	 */
	public void mouseClick(int clickNumber);

	/**
	 * Click mouse.
	 *
	 * @param Params are 'LEFT', 'RIGHT' or 'CENTER'
	 */
	public void mouseClick(String mousClickTyp);

	/**
	 * Click mouse.
	 *
	 * @param
	 * @param Params are 'LEFT', 'RIGHT' or 'CENTER'
	 * @param Time to click in milliseconds
	 */
	public void mouseClick(String mousClickTyp, int mouseClickTime);

	/**
	 * mouse scroll.
	 *
	 * @param Scroll typs are 'UP' and 'DOWN'.
	 * @param Scroll number
	 */
	public void mouseScroll(String scrollTyp, int scrollNumber);

	/**
	 * This class returns the methods of this interface. This class is very important for
	 * the TutorialCreator class.
	 *
	 * @author $author$
	 * @version $Revision: 1.2 $
	 */
	public class XMouseMethods {
		private static final Hashtable m_xhash;

		static {
			m_xhash = getXMouse();
		}

		/**
		 * Get methods.
		 *
		 * @return hashtable
		 */
		public static Hashtable getMethods() {
			return m_xhash;
		}

		/**
		 * Creates the hashtable with all methods of this interface.
		 *
		 * @return hashtable
		 */
		private static Hashtable getXMouse() {
			String[][] sleep = new String[][] { { "typ", "" }, {
					"method", "sleep" }, {
					"millis", "" }
			};

			String[][] mouseClick1 = new String[][] { { "typ", "" }, {
					"method", "mouseClick" }
			};

			String[][] mouseClick2 = new String[][] { { "typ", "" }, {
					"method", "mouseClick" }, {
					"clickNumber", "" }
			};

			String[][] mouseClick3 = new String[][] { { "typ", "" }, {
					"method", "mouseClick" }, {
					"mousClickTyp", "" }
			};

			String[][] mouseClick4 = new String[][] { { "typ", "" }, {
					"method", "mouseClick" }, {
					"mousClickTyp", "" }, {
					"mouseClickTime", "" }
			};

			String[][] mouseScroll = new String[][] { { "typ", "" }, {
					"method", "mouseScroll" }, {
					"scrollTyp", "" }, {
					"scrollNumber", "" }
			};

			Hashtable xmouse = new Hashtable();
			xmouse.put("sleep", sleep);
			xmouse.put("mouseClick", mouseClick1);
			xmouse.put("mouseClick with NUMBER", mouseClick2);
			xmouse.put("mouseClick with TYP", mouseClick3);
			xmouse.put("mouseClick with TYP and TIME", mouseClick4);
			xmouse.put("mouseScroll", mouseScroll);

			return xmouse;
		}
	}
}
