/*
 * ActionTable.java
 *
 * Created on 6. M?rz 2003, 11:19
 */
package com.sun.star.wizards.tutorial.creator.frame.objectFinder;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;

import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;

/**
 * A helper class for the ActionFrame class. The action handling for the found objects is
 * the main purpose of this class.
 *
 * @author $author$
 * @version $Revision: 1.2 $
 */
public class ActionPanel extends JPanel {
	//implements XActionPanel {
	private ActionFrame m_actionFrame;
	private JTable m_table;
	protected JButton action;
	private JButton removeAction;
	private JButton upTable;
	private JButton downTable;

	/**
	 * Creates a new ActionPanel object.
	 *
	 * @param frame ActionFrame
	 */
	public ActionPanel(ActionFrame frame) {
		m_actionFrame = frame;
		init();
	}

	/**
	 * Initializes the panel.
	 */
	private void init() {
		DefaultTableColumnModel tCoumModel = new DefaultTableColumnModel() {
			public void moveColumn(int columnIndex, int newIndex) {
			}
		};

		DefaultTableModel tModel = new DefaultTableModel() {
			public boolean isCellEditable(int row, int col) {
				return false;
			}
		};

		tModel.setColumnIdentifiers(new Object[] { "Typ", "Method Name", "Params" });

		m_table = new JTable();
		m_table.setColumnModel(tCoumModel);
		m_table.setModel(tModel);
		m_table.setBackground(new Color(255, 250, 240));
		m_table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		m_table.getColumnModel().getColumn(2).setPreferredWidth(400);

		JScrollPane tableScrollPane = new JScrollPane();
		TitledBorder actionBorder = BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED), "Actions");
		tableScrollPane.setBorder(actionBorder);
		tableScrollPane.getViewport().add(m_table, null);

		JPanel bottomButtonPanel = new JPanel(new GridLayout(2, 1));
		bottomButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));

		action = new JButton("Add");
		removeAction = new JButton("Del");
		bottomButtonPanel.add(action);
		bottomButtonPanel.add(removeAction);

		JPanel bottomButtonPanel2 = new JPanel(new BorderLayout());
		bottomButtonPanel2.add(bottomButtonPanel, BorderLayout.CENTER);

		JPanel tableButtonPanel = new JPanel(new GridLayout(2, 1));
		tableButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));

		upTable = new JButton("Up");
		downTable = new JButton("Down");
		tableButtonPanel.add(upTable);
		tableButtonPanel.add(downTable);

		JPanel tableButtonPanel2 = new JPanel(new BorderLayout());
		tableButtonPanel2.add(tableButtonPanel, BorderLayout.CENTER);

		JPanel tableButtonPanels = new JPanel(new GridLayout(2, 1));
		tableButtonPanels.setPreferredSize(new Dimension(90, 110));
		tableButtonPanels.setBorder(BorderFactory.createEmptyBorder(20, 10, 0, 5));
		tableButtonPanels.add(bottomButtonPanel2);
		tableButtonPanels.add(tableButtonPanel2);

		JPanel tableButtonPanels2 = new JPanel(new BorderLayout());
		tableButtonPanels2.add(tableButtonPanels, BorderLayout.NORTH);

		setLayout(new BorderLayout());
		add(tableScrollPane, BorderLayout.CENTER);
		add(tableButtonPanels2, BorderLayout.EAST);
		action.setEnabled(false);
		setButtonsProperties();

		//********************************
		action.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (m_actionFrame.isAccessibleObjectFound()) {
					m_actionFrame.openMethodsDialog();
					setButtonsProperties();
				}
			}
		});

		removeAction.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				int[] rows = m_table.getSelectedRows();

				if (rows.length > 0) {
					DefaultTableModel tModel = (DefaultTableModel) m_table.getModel();

					for (int i = rows.length - 1; i > -1; i--) {
						tModel.removeRow(rows[i]);
					}

					setButtonsProperties();
				}
			}
		});

		upTable.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				int rows = m_table.getSelectedRow();

				if (rows > 0) {
					DefaultTableModel tModel = (DefaultTableModel) m_table.getModel();
					tModel.moveRow(rows, rows, rows - 1);
					m_table.setRowSelectionInterval(rows - 1, rows - 1);
				}
			}
		});

		downTable.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				int rows = m_table.getSelectedRow();
				DefaultTableModel tModel = (DefaultTableModel) m_table.getModel();

				if ((rows > -1) && ((rows + 1) < tModel.getRowCount())) {
					tModel.moveRow(rows, rows, rows + 1);
					m_table.setRowSelectionInterval(rows + 1, rows + 1);
				}
			}
		});
	}

	/**
	 * Add new actions.
	 *
	 * @param dataVector - actions in form of vector for adding
	 */
	public void addAction(Vector dataVector) {
		if ((dataVector != null) && !dataVector.isEmpty()) {
			String typ = "";
			String methodName = "";
			String params = "";

			for (int i = 0; i < dataVector.size(); i++) {
				Vector dataV = (Vector) dataVector.get(i);
				String temp = (String) dataV.get(0);

				if (temp.equals("typ")) {
					typ = (String) dataV.get(1);
				} else if (temp.equals("method")) {
					methodName = (String) dataV.get(1);
				} else {
					params = params + "<" + (String) dataV.get(1) + "/>";
				}
			}

			if ((params.length() > 0) && (params.lastIndexOf(";") == (params.length() - 1))) {
				params = params.substring(0, params.length() - 1);
			}

			String[] data = new String[] { typ, methodName, params };
			DefaultTableModel tModel = (DefaultTableModel) m_table.getModel();
			tModel.addRow(data);
		}
	}

	/**
	 * Initializes the table element of this panel.
	 */
	public void initTable() {
		DefaultTableModel tModel = (DefaultTableModel) m_table.getModel();

		for (int i = tModel.getRowCount() - 1; i > -1; i--) {
			tModel.removeRow(i);
		}

		setButtonsProperties();
	}

	/**
	 * Get the whole table data as vector.
	 *
	 * @return vector with table data
	 */
	public Vector getDataVector() {
		DefaultTableModel tModel = (DefaultTableModel) m_table.getModel();

		return (Vector) (tModel.getDataVector().clone());
	}

	/**
	 * Set the enabled property of various buttons.
	 */
	public void setButtonsProperties() {
		if (m_table.getModel().getRowCount() > 0) {
			removeAction.setEnabled(true);

			if (m_table.getModel().getRowCount() > 1) {
				upTable.setEnabled(true);
				downTable.setEnabled(true);
			} else {
				upTable.setEnabled(false);
				downTable.setEnabled(false);
			}
		} else {
			removeAction.setEnabled(false);
			upTable.setEnabled(false);
			downTable.setEnabled(false);
		}
	}
}
