/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dinst.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 12:35:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <salinst.hxx>
#include <dbmp.hxx>

class DummyInstance : public SalInstance
{
public:
    DummyInstance() {}
    virtual ~DummyInstance();

    virtual SalFrame*      	CreateChildFrame( SystemParentData* pParent, ULONG nStyle );
    virtual SalFrame*      	CreateFrame( SalFrame* pParent, ULONG nStyle );
    virtual void				DestroyFrame( SalFrame* pFrame );
    virtual SalObject*			CreateObject( SalFrame* pParent );
    virtual void				DestroyObject( SalObject* pObject );
    virtual SalVirtualDevice*	CreateVirtualDevice( SalGraphics* pGraphics,
                                                     long nDX, long nDY,
                                                     USHORT nBitCount, const SystemGraphicsData *pData = NULL );
    virtual void				DestroyVirtualDevice( SalVirtualDevice* pDevice );

    virtual SalInfoPrinter*	CreateInfoPrinter( SalPrinterQueueInfo* pQueueInfo,
                                               ImplJobSetup* pSetupData );
    virtual void				DestroyInfoPrinter( SalInfoPrinter* pPrinter );
    virtual SalPrinter*		CreatePrinter( SalInfoPrinter* pInfoPrinter );
    virtual void				DestroyPrinter( SalPrinter* pPrinter );

    virtual void				GetPrinterQueueInfo( ImplPrnQueueList* pList );
    virtual void				GetPrinterQueueState( SalPrinterQueueInfo* pInfo );
    virtual void				DeletePrinterQueueInfo( SalPrinterQueueInfo* pInfo );
    virtual String             GetDefaultPrinter();

    virtual SalSound*			CreateSalSound();
    virtual SalTimer*			CreateSalTimer();
    virtual SalOpenGL*			CreateSalOpenGL( SalGraphics* pGraphics );
    virtual SalI18NImeStatus*	CreateI18NImeStatus();
    virtual SalSystem*			CreateSalSystem();
    virtual SalBitmap*			CreateSalBitmap();
    virtual SalSession*			CreateSalSession();
    virtual vos::IMutex*		GetYieldMutex();
    virtual ULONG				ReleaseYieldMutex();
    virtual void				AcquireYieldMutex( ULONG nCount );
    virtual void				Yield( BOOL bWait );
    virtual bool				AnyInput( USHORT nType );

                            // Menues
    virtual SalMenu*        CreateMenu( BOOL bMenuBar );
    virtual void            DestroyMenu( SalMenu* pMenu);
    virtual SalMenuItem*    CreateMenuItem( const SalItemParams* pItemData );
    virtual void            DestroyMenuItem( SalMenuItem* pItem );
    virtual void*				GetConnectionIdentifier( ConnectionIdentifierType& rReturnedType, int& rReturnedBytes );
};

// plugin factory function
extern "C" 
{
    VCL_DLLPUBLIC SalInstance* create_SalInstance()
    {
        return new DummyInstance();
    }
}


DummyInstance::~DummyInstance()
{
}

SalFrame*			DummyInstance::CreateChildFrame( SystemParentData*, ULONG )
{
    return NULL;
}

SalFrame*			DummyInstance::CreateFrame( SalFrame*, ULONG )
{
    return NULL;
}

void				DummyInstance::DestroyFrame( SalFrame* )
{
}

SalObject*			DummyInstance::CreateObject( SalFrame* )
{
    return NULL;
}

void				DummyInstance::DestroyObject( SalObject* )
{
}

SalVirtualDevice*	DummyInstance::CreateVirtualDevice( SalGraphics*, long, long, USHORT, const SystemGraphicsData* )
{
    return NULL;
}

void				DummyInstance::DestroyVirtualDevice( SalVirtualDevice* )
{
}

SalInfoPrinter*		DummyInstance::CreateInfoPrinter( SalPrinterQueueInfo*, ImplJobSetup* )
{
    return NULL;
}

void				DummyInstance::DestroyInfoPrinter( SalInfoPrinter* )
{
}

SalPrinter*			DummyInstance::CreatePrinter( SalInfoPrinter* )
{
    return NULL;
}

void				DummyInstance::DestroyPrinter( SalPrinter* )
{
}

void				DummyInstance::GetPrinterQueueInfo( ImplPrnQueueList* )
{
}

void				DummyInstance::GetPrinterQueueState( SalPrinterQueueInfo* )
{
}

void				DummyInstance::DeletePrinterQueueInfo( SalPrinterQueueInfo* )
{
}

String				DummyInstance::GetDefaultPrinter()
{
    return String();
}

SalSound*			DummyInstance::CreateSalSound()
{
    return NULL;
}

SalTimer*			DummyInstance::CreateSalTimer()
{
    return NULL;
}

SalOpenGL*			DummyInstance::CreateSalOpenGL( SalGraphics* )
{
    return NULL;
}

SalI18NImeStatus*	DummyInstance::CreateI18NImeStatus()
{
    return NULL;
}

SalSystem*			DummyInstance::CreateSalSystem()
{
    return NULL;
}

SalBitmap*			DummyInstance::CreateSalBitmap()
{
    return new DummyBitmap();
}

vos::IMutex*		DummyInstance::GetYieldMutex()
{
    return NULL;
}

ULONG				DummyInstance::ReleaseYieldMutex()
{
    return 0;
}

void				DummyInstance::AcquireYieldMutex( ULONG nCount )
{
}

void				DummyInstance::Yield( BOOL )
{
}

bool				DummyInstance::AnyInput( USHORT )
{
    return false;
}

SalMenu*			DummyInstance::CreateMenu( BOOL )
{
    return NULL;
}

void				DummyInstance::DestroyMenu( SalMenu* )
{
}

SalMenuItem*		DummyInstance::CreateMenuItem( const SalItemParams* )
{
    return NULL;
}

void				DummyInstance::DestroyMenuItem( SalMenuItem* )
{
}

void*				DummyInstance::GetConnectionIdentifier( ConnectionIdentifierType& rReturnedType, int& rReturnedBytes )
{
    rReturnedType		= Blob;
    rReturnedBytes		= 0;
    return NULL;
}

SalSession*			DummyInstance::CreateSalSession()
{
    return NULL;
}
