/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: threadex.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 11:32:31 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <osl/conditn.h>
#include <osl/thread.h>
#include <tools/link.hxx>

#ifndef _VCL_DLLAPI_H
#include "dllapi.h"
#endif

namespace vcl
{
	class VCL_DLLPUBLIC ThreadExecutor
	{
		oslThread				m_aThread;
		oslCondition			m_aFinish;
		long					m_nReturn;

		SAL_DLLPRIVATE static void SAL_CALL worker( void* );
	public:
		ThreadExecutor();
		virtual ~ThreadExecutor();

		virtual long doIt() = 0;
		long execute();
	};

	class VCL_DLLPUBLIC SolarThreadExecutor
	{
		oslCondition			m_aFinish;
		long					m_nReturn;

		DECL_DLLPRIVATE_LINK( worker, void* );
	public:
		SolarThreadExecutor();
		virtual ~SolarThreadExecutor();

		virtual long doIt() = 0;
		long execute();
	};
	
}
