/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: salbmp.hxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 10:32:25 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SV_SALBMP_HXX
#define _SV_SALBMP_HXX

#ifndef _GEN_HXX
	#include <tools/gen.hxx>
#endif

#ifndef _SV_SV_H
	#include <sv.h>
#endif

#ifndef _SV_SALBTYPE_HXX
	#include <salbtype.hxx>
#endif

#ifndef _SV_SALDATA_HXX
	#include <saldata.hxx>
#endif

#ifndef _SV_SALINST_HXX
	#include <salinst.hxx>
#endif

#ifndef _SV_SALCONST_H
	#include <salconst.h>
#endif

#ifndef _SV_SALVD_HXX
	#include <salvd.hxx>
#endif

#ifndef _SV_SALCOLORUTILS_HXX
	#include <salcolorutils.hxx>
#endif

#ifndef _SV_SALPIXMAPUTILS_HXX
	#include <salpixmaputils.hxx>
#endif

#ifndef _SV_SALRECTANGLEUTILS_HXX
	#include <salrectangleutils.hxx>
#endif

// --------------
// - SalBitmap	-
// --------------

struct	BitmapBuffer;
class	BitmapColor;
class	BitmapPalette;
class	SalVirtualDevice;
class	SalGraphics;

class SalBitmap
{
	private:

		SalVirtualDevice  *mpVirDev;
		PixMapHandle       mhPixMap;
		Size               mnSize;
		USHORT             mnBitCount;

	public:

		 SalBitmap();
		~SalBitmap();

	public:

		BOOL            Create( const Size& rSize, USHORT nBitCount, const BitmapPalette& rPal );
		BOOL            Create( const SalBitmap& rSalBmp );
		BOOL            Create( const SalBitmap& rSalBmp, SalGraphics* pGraphics );
		BOOL            Create( const SalBitmap& rSalBmp, USHORT nNewBitCount );

		void            Destroy();

		Size            GetSize() const { return mnSize; }
		USHORT          GetBitCount() const { return mnBitCount; }

		BitmapBuffer   *AcquireBuffer( BOOL bReadOnly );
		void            ReleaseBuffer( BitmapBuffer* pBuffer, BOOL bReadOnly );

		SalGraphics    *GetGraphics();
		void            ReleaseGraphics( SalGraphics* pGraphics );
};

#endif // _SV_SALBMP_HXX
