/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: VCLGraphics.h,v $
 *
 *  $Revision: 1.20 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 10:30:57 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SV_VCLGRAPHICS_H
#define _SV_VCLGRAPHICS_H

typedef void *VCLGRAPHICS;

#ifndef _SV_SV_H
#include <sv.h>
#endif

#ifndef _SV_VCLVIEW_H
#include <VCLView.h>
#endif
#ifndef _SV_VCLWINDOW_H
#include <VCLWindow.h>
#endif

#include <premac.h>
#include <ApplicationServices/ApplicationServices.h>
#include <postmac.h>

#ifndef __cplusplus

#include <premac.h>
#import <AppKit/AppKit.h>
#include <postmac.h>

// ---------------
// - VCLGraphics -
// ---------------

@interface VCLGraphics : NSObject

// Get, and lock, a QuickDraw View

+ (CGrafPtr)LockFocusCGrafPort: (VCLView *)hView;

// Close, and unlock, a QuickDraw View

+ (void)UnLockFocusCGrafPort: (VCLView *)hView;
 
@end

#endif // ! __cplusplus

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

// -----------------------
// - C wrapper functions -
// -----------------------

// Get, and lock, a QuickDraw View

CGrafPtr VCLGraphics_LockFocusCGrafPort ( VCLVIEW hView );

// Close, and unlock, a QuickDraw View

void VCLGraphics_UnLockFocusCGrafPort ( VCLVIEW hView );

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // _SV_VCLGRAPHICS_H
