/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: step.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:29:58 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef UDM_STEP_HXX
#define UDM_STEP_HXX



// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
	// PARAMETERS
#include <udm/object.hxx>   // including all stuff here

namespace udm
{

/** @resp
    Is part of a ::udm::Path. It retrieves one ::udm::Object out another
    one in different ways, depending of the derivation used.

    There are a lot of standard derivations, whihc allow to stay strictly
    within the Udm-model. However, if needed, you can also leave the
    purist way ;-) - and implement different steps which do whatever
    strange things you want - as long as they still retrive an ::udm::Object
    out of another ::udm::Object.

    @how-to-derive
    Just overwrite the method Step::op_FCall() .
*/
class Step
{
  public:
    Object              operator()(
                            const Object &      i_rData ) const;
  private:
    virtual Object      op_FCall(
                            const Object &      i_rData) const = 0;
};

inline Object
Step::operator()( const Object & i_rData ) const
{ return op_FCall(i_rData); }






}   // namespace udm



#endif


