/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: stdstr.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:29:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef UDM_STDSTR_HXX
#define UDM_STDSTR_HXX



// USED SERVICES
	// BASE CLASSES
#include <udm/data.hxx>
	// COMPONENTS
	// PARAMETERS

namespace udm
{

/** This class is not named 'String' to make it possible to write

    using namespace csv;
    using namespace udm;

    at the same time, without producing ambiguities.
*/

class Stdstr : public Data
{
  public:
    typedef ::csv::String   value_type;

    virtual             ~Stdstr() {}

    // OPERATIONS

    // INQUIRY
    ::csv::String       value() const;

  private:
    // Interface Data:
    virtual accessor_type
                        inq_Type() const;
    virtual description inq_TypeDescription() const;
    virtual Stdstr &    access_Str();

    // Locals
    virtual ::csv::String
                        inq_Value() const = 0;
};



inline ::csv::String
Stdstr::value() const
    { return inq_Value(); }


}   //  namespace udm


#endif


