/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: i_boolean.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:24:15 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef UDM_I_BOOLEAN_HXX
#define UDM_I_BOOLEAN_HXX



// USED SERVICES
	// BASE CLASSES
#include <udm/boolean.hxx>
	// COMPONENTS
	// PARAMETERS
#include <udm/type_traits.hxx>


namespace udm
{

/**
*/
template <class SRC>
class TBoolean : public Boolean
{
  public:
    typedef SRC     source_type;

                        TBoolean();
    virtual             ~TBoolean();

    void                connect_to(
                            const source_type & i_rSrc );

  private:
    // Interface Data
    virtual void        do_Dispose();
    virtual void        do_BinWrite(
                            csv::bostream &     o_out ) const;

    // Interface StdStr
    virtual value_type  inq_Value() const;
    // DATA
    const SRC *         pSrc;
};


template <class SRC>
void
TBoolean<SRC>::connect_to( const source_type & i_rSrc )
{
 	pSrc = &i_rSrc;
}

void
TBoolean<SRC>::do_Dispose()
{
 	delete this;
}

template <class SRC>
void
TBoolean<SRC>::do_BinWrite( csv::bostream & o_out ) const
{
    UINT8 c = value() ? 1 : 0;
    o_out.write( &c, 1 );
}

template <class SRC>
Boolean::value_type
TBoolean<SRC>::inq_Value() const
{
    return convert_value_src_2_udm<SRC, Boolean::value_type>(*pSrc);
}


}   // namespace udm


#endif




