/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: creator.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:22:26 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef UDM_CREATOR_HXX
#define UDM_CREATOR_HXX


// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
	// PARAMETERS

namespace csv
{
 	class bistream;
}


namespace udm
{

class Data;

/** @resp
    DataCreator is used similar to an input iterator.

*/
class Creator
{
  public:
    virtual             ~Creator() {}

    DYN Data &          CreateFromBinary(
                            csv::bistream &     io_in );
  private:
    virtual DYN Data &  do_CreateFromBinary(
                            csv::bistream &     io_in ) = 0;
};

inline DYN Data &
Creator::CreateFromBinary( csv::bistream & io_in )
    { return do_CreateFromBinary(io_in); }



}   // namespace udm


#endif

