/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: DAVResourceAccessThread.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:08:02 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _DAVRESOURCEACCESSTHREAD_HXX_
#define _DAVRESOURCEACCESSTHREAD_HXX_

#include <vector>

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _RTL_REF_HXX_
#include <rtl/ref.hxx>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _DAVSESSION_HXX_
#include "DAVSession.hxx"
#endif
#ifndef _DAVEXCEPTION_HXX_
#include "DAVException.hxx"
#endif
#ifndef _NEONURI_HXX_
#include "NeonUri.hxx"
#endif
#ifndef _UCBHELPER_BACKGROUNDDOWNLOAD_HXX_
#include <ucbhelper/backgrounddownload.hxx>
#endif
#ifndef _COM_SUN_STAR_LANG_MULTISERVICEFACTOY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif


namespace webdav_ucp
{
    
    class DAVResourceAccessThread
        : public ::ucb::DownloadThread
    {
    public:
        
        DAVResourceAccessThread(
            const com::sun::star::uno::Reference<
            com::sun::star::lang::XMultiServiceFactory > & rSMgr,
            rtl::Reference<
            DAVSessionFactory > const & rSessionFactory,
            const rtl::OUString & rURL,
            const com::sun::star::uno::Reference<
            com::sun::star::ucb::XCommandEnvironment > & xEnv,
            bool bWithHeaders = true
        )
            throw(
                DAVException
            );
        
        DAVResourceAccessThread(
            const com::sun::star::uno::Reference<
            com::sun::star::lang::XMultiServiceFactory > & rSMgr,
            rtl::Reference<
            DAVSessionFactory > const & rSessionFactory,
            const rtl::OUString & rURL,            
            const std::vector< rtl::OUString > & rHeaderNames,// empty == 'all'
            DAVResource & rResource,
            const com::sun::star::uno::Reference<
            com::sun::star::ucb::XCommandEnvironment > & xEnv
        )
            throw(
                DAVException
            );
        
        void setURL( const rtl::OUString & rNewURL )
            throw( DAVException );
        
        
        DAVException GetException() const;
        
        std::vector< rtl::OUString >& getHeaderNames();

        DAVResource& getResource();
        
        
    protected:
        
        virtual void work();
        
        
    private:
        
        const rtl::OUString & getRequestURI() const;
        
        sal_Bool detectRedirectCycle( const rtl::OUString& rRedirectURL );
        
        sal_Bool handleException( DAVException & e );
        
        void initialize()
            throw ( 
                DAVException
            );
        
        
        mutable osl::Mutex    m_aMutex;
        DAVException          m_aException;
        rtl::OUString         m_aURL;
        rtl::OUString         m_aPath;
        rtl::Reference< DAVSession >        m_xSession;
        rtl::Reference< DAVSessionFactory > m_xSessionFactory;
        com::sun::star::uno::Reference<
            com::sun::star::lang::XMultiServiceFactory > m_xSMgr;
        std::vector< NeonUri > m_aRedirectURIs;
        
        // fill synchron!
        bool m_bWithHeaders;
        std::vector< rtl::OUString > m_aHeaderNames;// empty == 'all'
        DAVResource                  m_aResource;
    };

} // end namespace webdav_ucp



#endif
