/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: tutil.cxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 11:58:20 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "tutil.hxx"

// <namespace_tstutl>
namespace tstutl
{
    /**
     * some helper functions
     */
    // <function_cnvrtPth>
    ::rtl::OUString cnvrtPth( ::rtl::OString sysPth )
    {
        ::rtl::OUString sysPath( ::rtl::OUString::createFromAscii(
                                                        sysPth.getStr() ) );
        ::rtl::OUString fURL;
        if ( sysPth.indexOf("..") != -1 ) {

            ::rtl::OUString curDirPth;
            osl_getProcessWorkingDir( &curDirPth.pData );
            ::osl::FileBase::getAbsoluteFileURL( curDirPth, sysPath, fURL );
        }
        else  {
            ::osl::FileBase::getFileURLFromSystemPath( sysPath, fURL );
        }
        return fURL;
    } // </function_cnvrtPth>

    // <function_getEntriesFromFile>
    sal_uInt32 getEntriesFromFile( sal_Char* fName,
                                            vector< rtl_String* >& entries )
    {
        oslFileHandle inFile;

        rtl_uString* curDirPth = 0;
        rtl_uString* fURL = 0;
        osl_getProcessWorkingDir( &curDirPth );
        osl_getAbsoluteFileURL( curDirPth,
                            cnvrtPth(::rtl::OString(fName)).pData, &fURL );

        rtl_uString_release( curDirPth );

        if ( osl_openFile( fURL, &inFile, osl_File_OpenFlag_Read )
                                                       == osl_File_E_None )
        {
            while ( ! isEOF( inFile ) )
            {
                sal_Sequence* pSeq = 0;
                rtl_String* pStr = 0;
                osl_readLine( inFile, &pSeq );
                if ( ! pSeq->nElements || pSeq->elements[0] == '#' )
                {
                    rtl_byte_sequence_release( pSeq );
                    continue;
                }
                rtl_string_newFromStr_WithLength( &pStr, pSeq->elements,
                                                            pSeq->nElements );

                rtl_byte_sequence_release( pSeq );
                entries.push_back( pStr );
            }
        }
        rtl_uString_release( fURL );
        osl_closeFile( inFile );
        return ( entries.size() );

    } // </function_getEntriesFromFile>

    sal_Bool isEOF( oslFileHandle file )
    {
        sal_uInt64 curPos;
        sal_uInt64 fSize;

        // save current filepointer position
        osl_getFilePos( file, &curPos );

        // set filepointer to end of file
        osl_setFilePos( file, osl_Pos_End, 0 );

        // store filepointer position in fSize
        osl_getFilePos( file, &fSize );

        // set filepointer position to it's origin pos
        osl_setFilePos( file, osl_Pos_Absolut, curPos );

        return( curPos == fSize );
    }

    // <function_cpy>
    sal_Char* cpy( sal_Char* dest, const sal_Char* src )
    {
        sal_Char* pDest         = NULL;
        const sal_Char* pSrc    = NULL;

        /* set pointer */
        pDest = dest;
        pSrc  = src;

        /* copy string by char */
        while( *pDest++ = *pSrc++ );

        return ( dest );
    }

    sal_Char* ncpy( sal_Char* dest, const sal_Char* src, sal_uInt32 len )
    {
        if ( len >= ln(src) )
        {
            return( cpy( dest, src ) );
        }

        sal_uInt32 i;
        sal_Char* pDest         = dest;
        const sal_Char* pSrc    = src;

        // copy string by char
        for( i = 0; i < len; i++ )
            *pDest++ = *pSrc++;
        *pDest = '\0';

        return ( dest );
    }
    sal_uInt32 indexof( const sal_Char* str, sal_Char c )
    {
        sal_uInt32 i = 0;
        const sal_Char* ptr = str;
        while ( *ptr++ && (*ptr != c) )
            i++;
        return i;
    }

    sal_uInt32 rindexof( const sal_Char* str, sal_Char c )
    {
        sal_uInt32 i = 1;
        const sal_Char* ptr = str + (ln(str)-1);
        while ( *ptr && (*ptr != c) )
        {
            ++i;
            ptr--;
        }


        return ( ln(str) - i );
    }

    // <function_cat>
    sal_Char* cat( sal_Char* dest, const sal_Char* src )
    {
        // set pointers
        sal_Char* pDest = dest + ln(dest);
        const sal_Char* pSrc = src;

        while( *pDest++ = *pSrc++ );

        return ( dest );

    } // </function_cat>

    // <function_ln>
    sal_uInt32 ln( const sal_Char* str )
    {
        sal_uInt32 len = 0;
        const sal_Char* ptr = str;

        if( ptr )
            while( *ptr++ ) len++;

        return(len);
    } // <function_ln>

} // </namespace_tstutl>

