:
eval 'exec perl -wS $0 ${1+"$@"}'
    if 0;

#*************************************************************************
#
#   OpenOffice.org - a multi-platform office productivity suite
#
#   $RCSfile: brand.pl,v $
#
#   $Revision: 1.4 $
#
#   last change: $Author: rt $ $Date: 2005/09/09 11:45:36 $
#
#   The Contents of this file are made available subject to
#   the terms of GNU Lesser General Public License Version 2.1.
#
#
#     GNU Lesser General Public License Version 2.1
#     =============================================
#     Copyright 2005 by Sun Microsystems, Inc.
#     901 San Antonio Road, Palo Alto, CA 94303, USA
#
#     This library is free software; you can redistribute it and/or
#     modify it under the terms of the GNU Lesser General Public
#     License version 2.1, as published by the Free Software Foundation.
#
#     This library is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#     Lesser General Public License for more details.
#
#     You should have received a copy of the GNU Lesser General Public
#     License along with this library; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#     MA  02111-1307  USA
#
#*************************************************************************


#*********************************************************************
#
# main
#

$destdir = pop @ARGV;
mkdir $destdir,0777;

$productname = "OpenOffice.org";
$productfilename = "openoffice";

while ($_ = $ARGV[0], /^-/) {
    shift;
    last if /^--$/;
    if (/^-p/) {
        $productname = $ARGV[0];
        shift;
        
        # the productshortname must not contain blanks 
        # and should not contain extensions.
        $productshortname = $productname;
        $productshortname =~ s/\.org//g;
        $productshortname =~ s/ //g;
        $productshortname =~ s/\.[0..9]//;
    }
        
    if (/^-u/) {
        $productfilename = $ARGV[0];
        shift;
        
        # the product filename should be lower case.
        $productfilename =~ tr/A-Z/a-z/; 
    }
}

while (@ARGV) {
    $infile = shift @ARGV;
    
    unless (open INFILE, $infile) {
        print STDERR "Can't open input file $infile: $!\n";
        return;
    }
    
    unless (open OUTFILE,"> $destdir/$infile") {
        print STDOUT "Can't open output file $destdir/$infile: $!\n";
        return;
    }
    
    while (<INFILE>) {
        # remove possible Windows line-ends
        chomp;
        
        # patch all occurances of "OpenOffice" with a product string
        # that does not contain blanks.
        if (length($productshortname) > 0) {
            s/OpenOffice/$productshortname/g;
        }
        
        # patch all occurances of openoffice in ICON line with
        # $productfilename
        if ( /ICON/ ) {
            s/openoffice/$productfilename/;
        }

        # patch all occurances of openoffice in EXEC line with
        # $productfilename
        if ( /EXEC/ ) {
            s/openoffice/$productfilename/;
        }
        
        # replace %PRODUCTNAME placeholders
        s/%PRODUCTNAME/$productname/g;
        
        print OUTFILE "$_\n";
    }
    
    close(OUTFILE);
    close(INFILE);
}
