/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: gloslst.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 09:18:17 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _GLOSLST_HXX
#define _GLOSLST_HXX


#ifndef _DATETIME_HXX
#include <tools/datetime.hxx>
#endif
#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif
#ifndef _TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif
#ifndef _SVARRAY_HXX //autogen
#include <svtools/svarray.hxx>
#endif

class SwGlossaries;
class SvStringsISortDtor;

struct AutoTextGroup
{
	USHORT 		nCount;
	String 		sName;
	String  	sTitle;
	String		sLongNames;   // durch 0x0A getrennte Langnamen
	String 		sShortNames;  // durch 0x0A getrennte Kurznamen
	DateTime	aDateModified;
};


typedef AutoTextGroup* AutoTextGroupPtr;
SV_DECL_PTRARR(AutoTextGroups, AutoTextGroupPtr, 4, 4);

class SwGlossaryList : public AutoTimer
{
	AutoTextGroups	aGroupArr;
	String			sPath;
	BOOL 			bFilled;

	AutoTextGroup*	FindGroup(const String& rGroupName);
	void			FillGroup(AutoTextGroup* pGroup, SwGlossaries* pGloss);

public:
		SwGlossaryList();
		~SwGlossaryList();

	BOOL			HasLongName(const String& rBegin, SvStringsISortDtor* pLongNames );
	BOOL			GetShortName(const String& rLongName,
										String& rShortName, String& rGroupName );

	USHORT 			GetGroupCount();
	String			GetGroupName(USHORT nPos, BOOL bNoPath = TRUE, String* pTitle = 0);
	USHORT 			GetBlockCount(USHORT nGroup);
	String			GetBlockName(USHORT nGroup, USHORT nBlock, String& rShortName);

	void			Update();

	virtual void	Timeout();

	void			ClearGroups();
};

#endif






