/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: viewcontactpainthelper.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 20:01:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SDR_CONTACT_VIEWCONTACTPAINTHELPER_HXX
#define _SDR_CONTACT_VIEWCONTACTPAINTHELPER_HXX

#ifndef _SDR_CONTACT_DISPLAYINFO_HXX
#include <svx/sdr/contact/displayinfo.hxx>
#endif

//////////////////////////////////////////////////////////////////////////////
// predeclarations
class SdrObject;
class SfxItemSet;

namespace sdr
{
	namespace contact
	{
		class ViewContact;
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// ViewContact Paint helpers

namespace sdr
{
	namespace contact
	{
		// process the BackgroundObject painting
		sal_Bool PaintBackgroundObject(
			ViewContact& rPainter,
			SdrObject& rBackgroundObject,
			DisplayInfo& rDisplayInfo, 
			Rectangle& rPaintRectangle, 
			const ViewObjectContact& rAssociatedVOC);

		// Paint a PageBackgroundObject with the size of the page and the attributes
		// of the given FillProperties
		sal_Bool PaintBackgroundObjectWithItemSet(
			ViewContact& rPainter,
			DisplayInfo& rDisplayInfo, Rectangle& rPaintRectangle,
			const SfxItemSet& rFillProperties);
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

#endif //_SDR_CONTACT_VIEWCONTACTPAINTHELPER_HXX

// eof
