/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: accessibleiconchoicectrlentry.cxx,v $
 *
 *  $Revision: 1.15 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 14:25:23 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVTOOLS_ACCESSIBLEICONCHOICECTRLENTRY_HXX_
#include "accessibleiconchoicectrlentry.hxx"
#endif
#ifndef _ICNVW_HXX
#include "ivctrl.hxx"
#endif
#ifndef _SVTOOLS_HRC
#include "svtools.hrc"
#endif
#ifndef _SVTOOLS_SVTDATA_HXX
#include "svtdata.hxx"
#endif

#ifndef _COM_SUN_STAR_AWT_POINT_HPP_
#include <com/sun/star/awt/Point.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_RECTANGLE_HPP_
#include <com/sun/star/awt/Rectangle.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_SIZE_HPP_
#include <com/sun/star/awt/Size.hpp>
#endif

#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEEVENTID_HPP_
#include <com/sun/star/accessibility/AccessibleEventId.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEROLE_HPP_
#include <com/sun/star/accessibility/AccessibleRole.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLESTATETYPE_HPP_
#include <com/sun/star/accessibility/AccessibleStateType.hpp>
#endif

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _VCL_CONTROLLAYOUT_HXX
#include <vcl/controllayout.hxx>
#endif
#ifndef _TOOLKIT_AWT_VCLXWINDOW_HXX_
#include <toolkit/awt/vclxwindow.hxx>
#endif
#ifndef _TOOLKIT_HELPER_CONVERT_HXX_
#include <toolkit/helper/convert.hxx>
#endif
#ifndef _UTL_ACCESSIBLESTATESETHELPER_HXX_
#include <unotools/accessiblestatesethelper.hxx>
#endif
#ifndef _UTL_ACCESSIBLERELATIONSETHELPER_HXX_
#include <unotools/accessiblerelationsethelper.hxx>
#endif
#ifndef _CPPUHELPER_TYPEPROVIDER_HXX_
#include <cppuhelper/typeprovider.hxx>
#endif
#ifndef _COMPHELPER_SEQUENCE_HXX_
#include <comphelper/sequence.hxx>
#endif
#ifndef _SVTOOLS_STRINGTRANSFER_HXX_
#include <stringtransfer.hxx>
#endif
#ifndef COMPHELPER_ACCESSIBLE_EVENT_NOTIFIER
#include <comphelper/accessibleeventnotifier.hxx>
#endif

#define ACCESSIBLE_ACTION_COUNT		2
#define AID_EXPAND					0
#define AID_COLLAPSE				1

namespace
{
	void checkActionIndex_Impl( sal_Int32 _nIndex ) throw (::com::sun::star::lang::IndexOutOfBoundsException)
	{
		if ( _nIndex < 0 || _nIndex >= ACCESSIBLE_ACTION_COUNT )
			// only three actions
			throw ::com::sun::star::lang::IndexOutOfBoundsException();
	}
}

//........................................................................
namespace svt
{
	//........................................................................
	// class ALBSolarGuard ---------------------------------------------------------

	/** Aquire the solar mutex. */
	class ALBSolarGuard : public ::vos::OGuard
	{
	public:
    	inline ALBSolarGuard() : ::vos::OGuard( Application::GetSolarMutex() ) {}
	};

	// class AccessibleIconChoiceCtrlEntry -----------------------------------------------------

	using namespace ::com::sun::star::accessibility;
	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::lang;
	using namespace ::com::sun::star;

	DBG_NAME(AccessibleIconChoiceCtrlEntry)

	// -----------------------------------------------------------------------------
	// Ctor() and Dtor()
	// -----------------------------------------------------------------------------
	AccessibleIconChoiceCtrlEntry::AccessibleIconChoiceCtrlEntry( SvtIconChoiceCtrl& _rIconCtrl,
																  SvxIconChoiceCtrlEntry* _pEntry,
																  ULONG _nPos,
																  const Reference< XAccessible >& _xParent ) :

		AccessibleIconChoiceCtrlEntry_BASE	( m_aMutex ),

		m_pIconCtrl		( &_rIconCtrl ),
		m_nIndex		( _nPos ),
		m_xParent		( _xParent ),
        m_nClientId     ( 0 )

	{
		osl_incrementInterlockedCount( &m_refCount );
		{
			Reference< XComponent > xComp( m_xParent, UNO_QUERY );
			if ( xComp.is() )
				xComp->addEventListener( this );
		}
		osl_decrementInterlockedCount( &m_refCount );

		DBG_CTOR( AccessibleIconChoiceCtrlEntry, NULL );
	}
	// -----------------------------------------------------------------------------
	void AccessibleIconChoiceCtrlEntry::disposing( const EventObject& _rSource )
throw(RuntimeException)
	{
		if ( _rSource.Source == m_xParent )
		{
			dispose();
			DBG_ASSERT( !m_xParent.is() && ( NULL == m_pIconCtrl ), "" );
		}
	}
	// -----------------------------------------------------------------------------
	AccessibleIconChoiceCtrlEntry::~AccessibleIconChoiceCtrlEntry()
	{
		DBG_DTOR( AccessibleIconChoiceCtrlEntry, NULL );

		if ( IsAlive_Impl() )
		{
        	// increment ref count to prevent double call of Dtor
        	osl_incrementInterlockedCount( &m_refCount );
        	dispose();
		}
	}
	// -----------------------------------------------------------------------------
	void AccessibleIconChoiceCtrlEntry::NotifyAccessibleEvent( sal_Int16 _nEventId,
											   	const ::com::sun::star::uno::Any& _aOldValue,
											   	const ::com::sun::star::uno::Any& _aNewValue )
	{
        Reference< uno::XInterface > xSource( *this );
        AccessibleEventObject aEventObj( xSource, _nEventId, _aNewValue, _aOldValue );

	    if (m_nClientId)
		    comphelper::AccessibleEventNotifier::addEvent( m_nClientId, aEventObj );
	}
	// -----------------------------------------------------------------------------
	Rectangle AccessibleIconChoiceCtrlEntry::GetBoundingBox_Impl() const
	{
		Rectangle aRect;
		SvxIconChoiceCtrlEntry* pEntry = m_pIconCtrl->GetEntry( m_nIndex );
		if ( pEntry )
			aRect = m_pIconCtrl->GetBoundingBox( pEntry );

		return aRect;
	}
	// -----------------------------------------------------------------------------
	Rectangle AccessibleIconChoiceCtrlEntry::GetBoundingBoxOnScreen_Impl() const
	{
		Rectangle aRect;
		SvxIconChoiceCtrlEntry* pEntry = m_pIconCtrl->GetEntry( m_nIndex );
		if ( pEntry )
		{
			aRect = m_pIconCtrl->GetBoundingBox( pEntry );
			Point aTopLeft = aRect.TopLeft();
    		aTopLeft += m_pIconCtrl->GetWindowExtentsRelative( NULL ).TopLeft();
			aRect = Rectangle( aTopLeft, aRect.GetSize() );
		}

		return aRect;
	}
	// -----------------------------------------------------------------------------
	sal_Bool AccessibleIconChoiceCtrlEntry::IsAlive_Impl() const
	{
    	return ( !rBHelper.bDisposed && !rBHelper.bInDispose && m_pIconCtrl );
	}
	// -----------------------------------------------------------------------------
	sal_Bool AccessibleIconChoiceCtrlEntry::IsShowing_Impl() const
	{
    	sal_Bool bShowing = sal_False;
		Reference< XAccessibleContext > m_xParentContext =
			m_xParent.is() ? m_xParent->getAccessibleContext() : Reference< XAccessibleContext >();
    	if( m_xParentContext.is() )
    	{
        	Reference< XAccessibleComponent > xParentComp( m_xParentContext, uno::UNO_QUERY );
        	if( xParentComp.is() )
            	bShowing = GetBoundingBox_Impl().IsOver( VCLRectangle( xParentComp->getBounds() ) );
    	}

		return bShowing;
	}
	// -----------------------------------------------------------------------------
	Rectangle AccessibleIconChoiceCtrlEntry::GetBoundingBox() throw ( lang::DisposedException )
	{
    	ALBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( m_aMutex );

		EnsureIsAlive();
    	return GetBoundingBox_Impl();
	}
	// -----------------------------------------------------------------------------
	Rectangle AccessibleIconChoiceCtrlEntry::GetBoundingBoxOnScreen() throw ( lang::DisposedException )
	{
    	ALBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( m_aMutex );

		EnsureIsAlive();
    	return GetBoundingBoxOnScreen_Impl();
	}
	// -----------------------------------------------------------------------------
	void AccessibleIconChoiceCtrlEntry::EnsureIsAlive() const throw ( lang::DisposedException )
	{
    	if ( !IsAlive_Impl() )
        	throw lang::DisposedException();
	}
	// -----------------------------------------------------------------------------
	::rtl::OUString AccessibleIconChoiceCtrlEntry::implGetText()
	{
		::rtl::OUString sRet;
		SvxIconChoiceCtrlEntry* pEntry = m_pIconCtrl->GetEntry( m_nIndex );
		if ( pEntry )
			sRet = pEntry->GetDisplayText();
		return sRet;
	}
	// -----------------------------------------------------------------------------
	Locale AccessibleIconChoiceCtrlEntry::implGetLocale()
	{
    	Locale aLocale;
		aLocale = Application::GetSettings().GetUILocale();

    	return aLocale;
	}
	void AccessibleIconChoiceCtrlEntry::implGetSelection( sal_Int32& nStartIndex, sal_Int32& nEndIndex )
	{
		nStartIndex = 0;
		nEndIndex = 0;
	}
	// -----------------------------------------------------------------------------
	// XTypeProvider
	// -----------------------------------------------------------------------------
	// -----------------------------------------------------------------------------
	Sequence< sal_Int8 > AccessibleIconChoiceCtrlEntry::getImplementationId() throw (RuntimeException)
	{
		static ::cppu::OImplementationId* pId = NULL;

		if ( !pId )
		{
			::osl::Guard< ::osl::Mutex > aGuard( m_aMutex );

			if ( !pId )
			{
				static ::cppu::OImplementationId aId;
				pId = &aId;
			}
		}
		return pId->getImplementationId();
	}
	// -----------------------------------------------------------------------------
	// XComponent
	// -----------------------------------------------------------------------------
	void SAL_CALL AccessibleIconChoiceCtrlEntry::disposing()
	{
		::osl::MutexGuard aGuard( m_aMutex );

        // Send a disposing to all listeners.
	    if ( m_nClientId )
	    {
			sal_uInt32 nId = m_nClientId;
			m_nClientId =  0;
            comphelper::AccessibleEventNotifier::revokeClientNotifyDisposing( nId, *this );
	    }

		Reference< XComponent > xComp( m_xParent, UNO_QUERY );
		if ( xComp.is() )
			xComp->removeEventListener( this );

		m_pIconCtrl = NULL;
		m_xParent = NULL;
	}
	// -----------------------------------------------------------------------------
	// XServiceInfo
	// -----------------------------------------------------------------------------
	::rtl::OUString SAL_CALL AccessibleIconChoiceCtrlEntry::getImplementationName() throw(RuntimeException)
	{
		return getImplementationName_Static();
	}
	// -----------------------------------------------------------------------------
	Sequence< ::rtl::OUString > SAL_CALL AccessibleIconChoiceCtrlEntry::getSupportedServiceNames() throw(RuntimeException)
	{
		return getSupportedServiceNames_Static();
	}
	// -----------------------------------------------------------------------------
	sal_Bool SAL_CALL AccessibleIconChoiceCtrlEntry::supportsService( const ::rtl::OUString& _rServiceName ) throw (RuntimeException)
	{
		Sequence< ::rtl::OUString > aSupported( getSupportedServiceNames() );
		const ::rtl::OUString* pSupported = aSupported.getConstArray();
		const ::rtl::OUString* pEnd = pSupported + aSupported.getLength();
		for ( ; pSupported != pEnd && !pSupported->equals(_rServiceName); ++pSupported )
			;

		return pSupported != pEnd;
	}
	// -----------------------------------------------------------------------------
	// XServiceInfo - static methods
	// -----------------------------------------------------------------------------
	Sequence< ::rtl::OUString > AccessibleIconChoiceCtrlEntry::getSupportedServiceNames_Static(void) throw( RuntimeException )
	{
		Sequence< ::rtl::OUString > aSupported(3);
		aSupported[0] = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("com.sun.star.accessibility.AccessibleContext") );
		aSupported[1] = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("com.sun.star.accessibility.AccessibleComponent") );
		aSupported[2] = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("com.sun.star.awt.AccessibleIconChoiceControlEntry") );
		return aSupported;
	}
	// -----------------------------------------------------------------------------
	::rtl::OUString AccessibleIconChoiceCtrlEntry::getImplementationName_Static(void) throw( RuntimeException )
	{
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("com.sun.star.comp.svtools.AccessibleIconChoiceControlEntry") );
	}
	// -----------------------------------------------------------------------------
	// XAccessible
	// -----------------------------------------------------------------------------
	Reference< XAccessibleContext > SAL_CALL AccessibleIconChoiceCtrlEntry::getAccessibleContext(  ) throw (RuntimeException)
	{
		EnsureIsAlive();
		return this;
	}
	// -----------------------------------------------------------------------------
	// XAccessibleContext
	// -----------------------------------------------------------------------------
	sal_Int32 SAL_CALL AccessibleIconChoiceCtrlEntry::getAccessibleChildCount(  ) throw (RuntimeException)
	{
		return 0; // no children
	}
	// -----------------------------------------------------------------------------
	Reference< XAccessible > SAL_CALL AccessibleIconChoiceCtrlEntry::getAccessibleChild( sal_Int32 i ) throw (IndexOutOfBoundsException,RuntimeException)
	{
		throw IndexOutOfBoundsException();
		return Reference< XAccessible >(); // no children
	}
	// -----------------------------------------------------------------------------
	Reference< XAccessible > SAL_CALL AccessibleIconChoiceCtrlEntry::getAccessibleParent(  ) throw (RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex );

		EnsureIsAlive();
		return m_xParent;
	}
	// -----------------------------------------------------------------------------
	sal_Int32 SAL_CALL AccessibleIconChoiceCtrlEntry::getAccessibleIndexInParent(  ) throw (RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex );

    	return m_nIndex;
	}
	// -----------------------------------------------------------------------------
	sal_Int16 SAL_CALL AccessibleIconChoiceCtrlEntry::getAccessibleRole(  ) throw (RuntimeException)
	{
		return AccessibleRole::LABEL;
	}
	// -----------------------------------------------------------------------------
	::rtl::OUString SAL_CALL AccessibleIconChoiceCtrlEntry::getAccessibleDescription(  ) throw (RuntimeException)
	{
		// no description for every item
		return ::rtl::OUString();
	}
	// -----------------------------------------------------------------------------
	::rtl::OUString SAL_CALL AccessibleIconChoiceCtrlEntry::getAccessibleName(  ) throw (RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex );

		EnsureIsAlive();
		return implGetText();
	}
	// -----------------------------------------------------------------------------
	Reference< XAccessibleRelationSet > SAL_CALL AccessibleIconChoiceCtrlEntry::getAccessibleRelationSet(  ) throw (RuntimeException)
	{
    	return new utl::AccessibleRelationSetHelper;
	}
	// -----------------------------------------------------------------------------
	Reference< XAccessibleStateSet > SAL_CALL AccessibleIconChoiceCtrlEntry::getAccessibleStateSet(  ) throw (RuntimeException)
	{
    	ALBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( m_aMutex );

    	utl::AccessibleStateSetHelper* pStateSetHelper = new utl::AccessibleStateSetHelper;
		Reference< XAccessibleStateSet > xStateSet = pStateSetHelper;

		if ( IsAlive_Impl() )
		{
	       	pStateSetHelper->AddState( AccessibleStateType::TRANSIENT );
	       	pStateSetHelper->AddState( AccessibleStateType::SELECTABLE );
	       	pStateSetHelper->AddState( AccessibleStateType::ENABLED );
			if ( IsShowing_Impl() )
			{
	        	pStateSetHelper->AddState( AccessibleStateType::SHOWING );
				pStateSetHelper->AddState( AccessibleStateType::VISIBLE );
			}

			if ( m_pIconCtrl && m_pIconCtrl->GetCursor() == m_pIconCtrl->GetEntry( m_nIndex ) )
				pStateSetHelper->AddState( AccessibleStateType::SELECTED );
		}
		else
        	pStateSetHelper->AddState( AccessibleStateType::DEFUNC );

    	return xStateSet;
	}
	// -----------------------------------------------------------------------------
	Locale SAL_CALL AccessibleIconChoiceCtrlEntry::getLocale(  ) throw (IllegalAccessibleComponentStateException, RuntimeException)
	{
		ALBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( m_aMutex );

		return implGetLocale();
	}
	// -----------------------------------------------------------------------------
	// XAccessibleComponent
	// -----------------------------------------------------------------------------
	sal_Bool SAL_CALL AccessibleIconChoiceCtrlEntry::containsPoint( const awt::Point& rPoint ) throw (RuntimeException)
	{
    	return Rectangle( Point(), GetBoundingBox().GetSize() ).IsInside( VCLPoint( rPoint ) );
	}
	// -----------------------------------------------------------------------------
	Reference< XAccessible > SAL_CALL AccessibleIconChoiceCtrlEntry::getAccessibleAtPoint( const awt::Point& _aPoint ) throw (RuntimeException)
	{
		return Reference< XAccessible >();
	}
	// -----------------------------------------------------------------------------
	awt::Rectangle SAL_CALL AccessibleIconChoiceCtrlEntry::getBounds(  ) throw (RuntimeException)
	{
    	return AWTRectangle( GetBoundingBox() );
	}
	// -----------------------------------------------------------------------------
	awt::Point SAL_CALL AccessibleIconChoiceCtrlEntry::getLocation(  ) throw (RuntimeException)
	{
    	return AWTPoint( GetBoundingBox().TopLeft() );
	}
	// -----------------------------------------------------------------------------
	awt::Point SAL_CALL AccessibleIconChoiceCtrlEntry::getLocationOnScreen(  ) throw (RuntimeException)
	{
    	return AWTPoint( GetBoundingBoxOnScreen().TopLeft() );
	}
	// -----------------------------------------------------------------------------
	awt::Size SAL_CALL AccessibleIconChoiceCtrlEntry::getSize(  ) throw (RuntimeException)
	{
    	return AWTSize( GetBoundingBox().GetSize() );
	}
	// -----------------------------------------------------------------------------
	void SAL_CALL AccessibleIconChoiceCtrlEntry::grabFocus(  ) throw (RuntimeException)
	{
		// do nothing, because no focus for each item
	}
	// -----------------------------------------------------------------------------
	sal_Int32 AccessibleIconChoiceCtrlEntry::getForeground(	) throw (RuntimeException)
	{
    	ALBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( m_aMutex );

		sal_Int32 nColor = 0;
		Reference< XAccessible > xParent = getAccessibleParent();
		if ( xParent.is() )
		{
			Reference< XAccessibleComponent > xParentComp( xParent->getAccessibleContext(), UNO_QUERY );
			if ( xParentComp.is() )
				nColor = xParentComp->getForeground();
		}

		return nColor;
	}
	// -----------------------------------------------------------------------------
	sal_Int32 AccessibleIconChoiceCtrlEntry::getBackground(  ) throw (RuntimeException)
	{
    	ALBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( m_aMutex );

		sal_Int32 nColor = 0;
		Reference< XAccessible > xParent = getAccessibleParent();
		if ( xParent.is() )
		{
			Reference< XAccessibleComponent > xParentComp( xParent->getAccessibleContext(), UNO_QUERY );
			if ( xParentComp.is() )
				nColor = xParentComp->getBackground();
		}

		return nColor;
	}
	// -----------------------------------------------------------------------------
	// XAccessibleText
	// -----------------------------------------------------------------------------
	// -----------------------------------------------------------------------------
	awt::Rectangle SAL_CALL AccessibleIconChoiceCtrlEntry::getCharacterBounds( sal_Int32 _nIndex ) throw (IndexOutOfBoundsException, RuntimeException)
	{
		ALBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( m_aMutex );

		if ( ( 0 > _nIndex ) || ( getCharacterCount() <= _nIndex ) )
			throw IndexOutOfBoundsException();

		awt::Rectangle aBounds( 0, 0, 0, 0 );
		if ( m_pIconCtrl )
		{
			Rectangle aItemRect = GetBoundingBox_Impl();
			Rectangle aCharRect = m_pIconCtrl->GetEntryCharacterBounds( m_nIndex, _nIndex );
			aCharRect.Move( -aItemRect.Left(), -aItemRect.Top() );
			aBounds = AWTRectangle( aCharRect );
		}

		return aBounds;
	}
	// -----------------------------------------------------------------------------
	sal_Int32 SAL_CALL AccessibleIconChoiceCtrlEntry::getIndexAtPoint( const awt::Point& aPoint ) throw (RuntimeException)
	{
		ALBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( m_aMutex );

		sal_Int32 nIndex = -1;
		if ( m_pIconCtrl )
		{
			::vcl::ControlLayoutData aLayoutData;
			Rectangle aItemRect = GetBoundingBox_Impl();
			m_pIconCtrl->RecordLayoutData( &aLayoutData, aItemRect );
			Point aPnt( VCLPoint( aPoint ) );
			aPnt += aItemRect.TopLeft();
			nIndex = aLayoutData.GetIndexForPoint( aPnt );

			long nLen = aLayoutData.m_aUnicodeBoundRects.size();
			for ( long i = 0; i < nLen; ++i )
			{
			    Rectangle aRect = aLayoutData.GetCharacterBounds(i);
				BOOL bInside = aRect.IsInside( aPnt );

				if ( bInside )
					break;
			}
		}

	    return nIndex;
	}
	// -----------------------------------------------------------------------------
	sal_Bool SAL_CALL AccessibleIconChoiceCtrlEntry::copyText( sal_Int32 nStartIndex, sal_Int32 nEndIndex ) throw (IndexOutOfBoundsException, RuntimeException)
	{
		ALBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( m_aMutex );

		String sText = getText();
		if	( ( 0 > nStartIndex ) || ( sText.Len() <= nStartIndex )
			|| ( 0 > nEndIndex ) || ( sText.Len() <= nEndIndex ) )
			throw IndexOutOfBoundsException();

		sal_Int32 nLen = nEndIndex - nStartIndex + 1;
		OStringTransfer::CopyString( sText.Copy( (USHORT)nStartIndex, (USHORT)nLen ), m_pIconCtrl );

		return sal_True;
	}
	// -----------------------------------------------------------------------------
	// XAccessibleEventBroadcaster
	// -----------------------------------------------------------------------------
	void SAL_CALL AccessibleIconChoiceCtrlEntry::addEventListener( const Reference< XAccessibleEventListener >& xListener ) throw (RuntimeException)
	{
	    if (xListener.is())
        {
			::osl::MutexGuard aGuard( m_aMutex );
		    if (!m_nClientId)
                m_nClientId = comphelper::AccessibleEventNotifier::registerClient( );
		    comphelper::AccessibleEventNotifier::addEventListener( m_nClientId, xListener );
        }
	}
	// -----------------------------------------------------------------------------
	void SAL_CALL AccessibleIconChoiceCtrlEntry::removeEventListener( const Reference< XAccessibleEventListener >& xListener ) throw (RuntimeException)
	{
	    if (xListener.is())
	    {
			::osl::MutexGuard aGuard( m_aMutex );

            sal_Int32 nListenerCount = comphelper::AccessibleEventNotifier::removeEventListener( m_nClientId, xListener );
		    if ( !nListenerCount )
		    {
			    // no listeners anymore
			    // -> revoke ourself. This may lead to the notifier thread dying (if we were the last client),
			    // and at least to us not firing any events anymore, in case somebody calls
			    // NotifyAccessibleEvent, again
				sal_Int32 nId = m_nClientId;
				m_nClientId = 0;
			    comphelper::AccessibleEventNotifier::revokeClient( nId );
		    }
	    }
	}

	sal_Int32 SAL_CALL AccessibleIconChoiceCtrlEntry::getCaretPosition(  ) throw (::com::sun::star::uno::RuntimeException)
	{
		return -1;
	}
	sal_Bool SAL_CALL AccessibleIconChoiceCtrlEntry::setCaretPosition ( sal_Int32 nIndex ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException)
	{
		ALBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( m_aMutex );
		EnsureIsAlive();

		if ( !implIsValidRange( nIndex, nIndex, implGetText().getLength() ) )
			throw IndexOutOfBoundsException();

		return sal_False;
	}
	sal_Unicode SAL_CALL AccessibleIconChoiceCtrlEntry::getCharacter( sal_Int32 nIndex ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException)
	{
		ALBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( m_aMutex );
		EnsureIsAlive();
		return OCommonAccessibleText::getCharacter( nIndex );
	}
	::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue > SAL_CALL AccessibleIconChoiceCtrlEntry::getCharacterAttributes( sal_Int32 nIndex, const ::com::sun::star::uno::Sequence< ::rtl::OUString >& aRequestedAttributes ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException)
	{
		ALBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( m_aMutex );
		EnsureIsAlive();

		::rtl::OUString sText( implGetText() );

		if ( !implIsValidIndex( nIndex, sText.getLength() ) )
			throw IndexOutOfBoundsException();

		return ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >();
	}
	sal_Int32 SAL_CALL AccessibleIconChoiceCtrlEntry::getCharacterCount(  ) throw (::com::sun::star::uno::RuntimeException)
	{
		ALBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( m_aMutex );
		EnsureIsAlive();
		return OCommonAccessibleText::getCharacterCount(  );
	}

	::rtl::OUString SAL_CALL AccessibleIconChoiceCtrlEntry::getSelectedText(  ) throw (::com::sun::star::uno::RuntimeException)
	{
		ALBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( m_aMutex );
		EnsureIsAlive();
		return OCommonAccessibleText::getSelectedText(  );
	}
	sal_Int32 SAL_CALL AccessibleIconChoiceCtrlEntry::getSelectionStart(  ) throw (::com::sun::star::uno::RuntimeException)
	{
		ALBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( m_aMutex );
		EnsureIsAlive();
		return OCommonAccessibleText::getSelectionStart(  );
	}
	sal_Int32 SAL_CALL AccessibleIconChoiceCtrlEntry::getSelectionEnd(  ) throw (::com::sun::star::uno::RuntimeException)
	{
		ALBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( m_aMutex );
		EnsureIsAlive();
		return OCommonAccessibleText::getSelectionEnd(  );
	}
	sal_Bool SAL_CALL AccessibleIconChoiceCtrlEntry::setSelection( sal_Int32 nStartIndex, sal_Int32 nEndIndex ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException)
	{
		ALBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( m_aMutex );
		EnsureIsAlive();

		if ( !implIsValidRange( nStartIndex, nEndIndex, implGetText().getLength() ) )
			throw IndexOutOfBoundsException();

		return sal_False;
	}
	::rtl::OUString SAL_CALL AccessibleIconChoiceCtrlEntry::getText(  ) throw (::com::sun::star::uno::RuntimeException)
	{
		ALBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( m_aMutex );
		EnsureIsAlive();
		return OCommonAccessibleText::getText(  );
	}
	::rtl::OUString SAL_CALL AccessibleIconChoiceCtrlEntry::getTextRange( sal_Int32 nStartIndex, sal_Int32 nEndIndex ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException)
	{
		ALBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( m_aMutex );
		EnsureIsAlive();
		return OCommonAccessibleText::getTextRange( nStartIndex, nEndIndex );
	}
    ::com::sun::star::accessibility::TextSegment SAL_CALL AccessibleIconChoiceCtrlEntry::getTextAtIndex( sal_Int32 nIndex, sal_Int16 aTextType ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException)
	{
		ALBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( m_aMutex );
		EnsureIsAlive();
		return OCommonAccessibleText::getTextAtIndex( nIndex ,aTextType);
	}
    ::com::sun::star::accessibility::TextSegment SAL_CALL AccessibleIconChoiceCtrlEntry::getTextBeforeIndex( sal_Int32 nIndex, sal_Int16 aTextType ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException)
	{
		ALBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( m_aMutex );
		EnsureIsAlive();
		return OCommonAccessibleText::getTextBeforeIndex( nIndex ,aTextType);
	}
    ::com::sun::star::accessibility::TextSegment SAL_CALL AccessibleIconChoiceCtrlEntry::getTextBehindIndex( sal_Int32 nIndex, sal_Int16 aTextType ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException)
	{
		ALBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( m_aMutex );
		EnsureIsAlive();

		return OCommonAccessibleText::getTextBehindIndex( nIndex ,aTextType);
	}
//........................................................................
}// namespace svt
//........................................................................

