/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: eitem.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 09:24:15 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SFXENUMITEM_HXX
#define _SFXENUMITEM_HXX

#ifndef INCLUDED_SVTDLLAPI_H
#include "svtools/svtdllapi.h"
#endif

#ifndef _SVTOOLS_CENUMITM_HXX
#include <cenumitm.hxx>
#endif

//============================================================================
class SVT_DLLPUBLIC SfxEnumItem: public CntEnumItem
{
protected:
	SfxEnumItem(USHORT nWhich = 0, USHORT nValue = 0):
		CntEnumItem(nWhich, nValue) {}

	SfxEnumItem(USHORT nWhich, SvStream & rStream):
		CntEnumItem(nWhich, rStream) {}

public:
	TYPEINFO();

};

//============================================================================
class SVT_DLLPUBLIC SfxBoolItem: public CntBoolItem
{
public:
	TYPEINFO();

	SfxBoolItem(USHORT nWhich = 0, BOOL bValue = FALSE):
		CntBoolItem(nWhich, bValue) {}

	SfxBoolItem(USHORT nWhich, SvStream & rStream):
		CntBoolItem(nWhich, rStream) {}

	virtual SfxPoolItem * Create(SvStream & rStream, USHORT) const
	{ return new SfxBoolItem(Which(), rStream); }

	virtual SfxPoolItem * Clone(SfxItemPool * = 0) const
	{ return new SfxBoolItem(*this); }
};

#endif //  _SFXENUMITEM_HXX

