/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: activityanimationbasenode.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 20:38:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <canvas/debug.hxx>
#include <canvas/verbosetrace.hxx>

#include <activityanimationbasenode.hxx>


using namespace ::com::sun::star;

namespace presentation
{
    namespace internal
    {
        ActivityAnimationBaseNode::ActivityAnimationBaseNode( const uno::Reference< animations::XAnimationNode >&	xNode, 
                                                              const BaseContainerNodeSharedPtr&						rParent,
                                                              const NodeContext& 									rContext ) :
            AnimationBaseNode( xNode, rParent, rContext )
        {
        }

        void ActivityAnimationBaseNode::scheduleDeactivationEvent() const
        {
            // don't schedule explicit deactivation event here,
            // since the generated Activity in activate() will do 
            // that by itself.

            if( !getActivity().get() )
            {
                // Actually, DO generate the event for empty activity,
                // to keep the chain of animations running for this slide
                AnimationBaseNode::scheduleDeactivationEvent();
            }
        }
    }
}
