/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: extattr.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 19:01:17 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _EXTATTR_HXX
#define _EXTATTR_HXX

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

class ImpEaMgr;
class Icon;
class DirEntry;
class String;
class SvFileStream;
class ResId;

class SvEaMgr
{
	friend class ImpEaMgr;

	ImpEaMgr*		pImp;

	// Forbidden and not implemented.
	SvEaMgr();
	SvEaMgr (const SvEaMgr &);
	SvEaMgr & operator= (const SvEaMgr &);

public:
	explicit				SvEaMgr( const DirEntry& rEntry );
	explicit				SvEaMgr( const String& rFilename );
	explicit				SvEaMgr( SvFileStream& rStream );

					~SvEaMgr();

	BOOL  			GetIcon( Icon& ) const;
	BOOL			SetIcon( const ResId& );
	BOOL			SetIcon( const String& rIconFileName );

	BOOL  			GetLongName( String& ) const;
	BOOL			SetLongName( const String& );

	BOOL  			GetFileType( String& ) const;
	BOOL			SetFileType( const String& );

	BOOL    		GetComment( String& ) const;
	BOOL			SetComment( const String& );

	BOOL  			GetCreator( String& ) const;
	BOOL			SetCreator( const String& );

	BOOL  			GetVersionInfo( String& ) const;
	BOOL			SetVersionInfo( const String& );

	BOOL			Clone( const SvEaMgr& );

	static BOOL		GetAppCreator( String& );
};

#ifndef UNX

inline SvEaMgr::SvEaMgr( const DirEntry& ) {}
inline SvEaMgr::SvEaMgr( const String& ) {}
inline SvEaMgr::SvEaMgr( SvFileStream& ) {}
inline SvEaMgr::~SvEaMgr( ) {}
inline BOOL SvEaMgr::GetIcon( Icon& ) const { return FALSE; }
inline BOOL SvEaMgr::SetIcon( const ResId& ) { return FALSE; }
inline BOOL SvEaMgr::SetIcon( const String&  ) { return FALSE; }
inline BOOL SvEaMgr::GetLongName( String& ) const { return FALSE; }
inline BOOL SvEaMgr::SetLongName( const String& ) { return FALSE; }
inline BOOL SvEaMgr::GetFileType( String& ) const { return FALSE; }
inline BOOL SvEaMgr::SetFileType( const String& ) { return FALSE; }
inline BOOL SvEaMgr::GetComment( String& ) const { return FALSE; }
inline BOOL SvEaMgr::SetComment( const String& ) { return FALSE; }
inline BOOL SvEaMgr::GetCreator( String& ) const { return FALSE; }
inline BOOL SvEaMgr::SetCreator( const String& ) { return FALSE; }
inline BOOL SvEaMgr::GetVersionInfo( String& ) const { return FALSE; }
inline BOOL SvEaMgr::SetVersionInfo( const String& ) { return FALSE; }
inline BOOL SvEaMgr::Clone( const SvEaMgr& ) { return FALSE; }
inline BOOL SvEaMgr::GetAppCreator( String& ) { return FALSE; }

#endif /* UNX */

#endif /* _EXTATTR_HXX */
