/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: docscoll.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:39:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#include "sfxsids.hrc"
#include "shobj.hxx"
#include "sfxcoll.hxx"
#include "docscoll.hxx"
#include "objsh.hxx"
#include "app.hxx"
#include "objface.hxx"

#ifndef _SBXCLASS_HXX //autogen
#include <basic/sbx.hxx>
#endif
//=========================================================================

#define Documents
#include "sfxslots.hxx"

//=========================================================================

TYPEINIT1(SfxDocumentsCollection, SfxCollection);

//-------------------------------------------------------------------------

SfxDocumentsCollection::SfxDocumentsCollection()
:	SfxCollection( SFX_APP(), SFX_TYPELIB_INFO(Documents),
				   DEFINE_CONST_UNICODE( "Documents" ) )
{
/*
	Make( "Open", SbxCLASS_METHOD, SbxOBJECT )->SetUserData(SID_OPENDOC);
*/
};

//-------------------------------------------------------------------------

SfxObjectShell* SfxDocumentsCollection::FindDoc( const SbxVariable &rVar ) const
{
	// String oder Zahl
	USHORT nNo;
	if ( rVar.IsString() )
	{
		String aName( rVar.GetString() );
		nNo = (USHORT) aName.ToInt32();

		// "Ubers C-Api kommen immer Strings, auch wenn ein Index
		// gemeint ist; es wird davon ausgegangen, da\s nicht mehr als
		// 1000 Dokument gleichzeitig offen sind ...

		if ( ! nNo || aName.Len() >= 4 )
		{
			// aktuellen Parameter als Dokumentnamen interpretiert suchen
			for ( SfxObjectShell *pObjSh = SfxObjectShell::GetFirst();
				pObjSh;
				pObjSh = SfxObjectShell::GetNext( *pObjSh ) )
				if ( pObjSh->SfxShell::GetName() == aName )
					return pObjSh;
			// Namen nicht gefunden
			return 0;
		}
	}
	else
	{
		// aktuellen Parameter als Dokumentnummer interpretiert suchen
		nNo = rVar.GetUShort();
	}

	for ( SfxObjectShell *pObjSh = SfxObjectShell::GetFirst();
		pObjSh && nNo > 0;
		pObjSh = SfxObjectShell::GetNext( *pObjSh ) )
            if ( !--nNo )
				return pObjSh;

	// Index nicht gefunden
	return 0;
}

//-------------------------------------------------------------------------

USHORT SfxDocumentsCollection::CollCount() const
{
	// durchz"ahlen
	USHORT nCount = 0;
	for ( SfxObjectShell *pObjSh = SfxObjectShell::GetFirst();
			pObjSh;
			pObjSh = SfxObjectShell::GetNext( *pObjSh ) )
			++nCount;
	return nCount;
}

//-------------------------------------------------------------------------

void SfxDocumentsCollection::CollAdd( SbxVariable &rRet, SbxArray* pPar )
{
	// 'Add' mit Parametern auf SID_NEWDOC, ohne nach SID_NEWDOCDIRECT abbilden
	ExecuteSlot( pPar ? SID_NEWDOC : SID_NEWDOCDIRECT, rRet, pPar );
}

//-------------------------------------------------------------------------

void SfxDocumentsCollection::CollItem( SbxVariable &rRet, SbxArray* pPar )
{
	// genau ein aktueller Parameter vorhanden?
	if ( pPar && pPar->Count() == 2 )
	{
		// passendes Dokument vorhanden
		SfxObjectShell *pObjSh = FindDoc( *pPar->Get(1) );
		if ( pObjSh )
			// Returnwert setzen
			rRet.PutObject( pObjSh->GetSbxObject() );
		else
			// kein Dokument vorhanden
			SetError( SbxERR_NO_OBJECT );
	}
	else
		// falscher Parameter
		SetError( SbxERR_WRONG_ARGS );
}

//-------------------------------------------------------------------------

void SfxDocumentsCollection::CollRemove( SbxArray* pPar )
{
	// genau ein aktueller Parameter vorhanden?
	if ( pPar && pPar->Count() == 2 )
	{
		// passendes Dokument vorhanden
		SfxObjectShell *pObjSh = FindDoc( *pPar->Get(1) );
		if ( pObjSh )
			if ( pObjSh != SfxObjectShell::GetFirst() && // !Desktop
				 pObjSh->PrepareClose(FALSE) )
			{
				// gefundenes Dokument schlie\sen
				pObjSh->DoClose();
				return;
			}
			else
				SetError( ERRCODE_SBX_BAD_ACTION );
		else
			SetError( SbxERR_NO_OBJECT );
		return;
	}

	// falscher Parameter
	SetError( SbxERR_WRONG_ARGS );
}


