/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: maillistener.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:22:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// includes --------------------------------------------------------------

#include "maillistener.hxx"
#include "sfxuno.hxx"

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::lang;
using namespace ::cppu;

// class MailListener_Impl -----------------------------------------------

MailListener_Impl::MailListener_Impl()
{
	maPropertyName = UniString( DEFINE_CONST_UNICODE( SVT_INET_OPTION_SMTP_SERVER_NAME ) );
}

// -----------------------------------------------------------------------

void SAL_CALL MailListener_Impl::propertiesChange( const Sequence< PropertyChangeEvent >& evt ) throw( RuntimeException )
{
	String aNewServer = maInetOptions.GetSmtpServerName();
	if ( aNewServer != maOutboxServer )
	{
		maOutboxServer = aNewServer;
		maChangeLink.Call( this );
	}
}

// -----------------------------------------------------------------------

void SAL_CALL MailListener_Impl::disposing( const EventObject& obj ) throw( RuntimeException )
{
	Sequence< ::rtl::OUString > seqProperty(1);
	seqProperty[0] = maPropertyName;
	Reference< com::sun::star::beans::XPropertiesChangeListener > xTHIS(
			static_cast< OWeakObject* >( this ), UNO_QUERY );
	maInetOptions.removePropertiesChangeListener( seqProperty, xTHIS );
}

// -----------------------------------------------------------------------

void MailListener_Impl::Initialize()
{
	Sequence< ::rtl::OUString > seqProperty(1);
	seqProperty[0] = maPropertyName;

	maOutboxServer = maInetOptions.GetSmtpServerName();
	Reference< com::sun::star::beans::XPropertiesChangeListener > xTHIS(
			static_cast< OWeakObject* >( this ), UNO_QUERY );
	maInetOptions.addPropertiesChangeListener( seqProperty, xTHIS );
}

// -----------------------------------------------------------------------

void MailListener_Impl::Deinitialize()
{
	Sequence< ::rtl::OUString > seqProperty(1);
	seqProperty[0] = maPropertyName;
	Reference< com::sun::star::beans::XPropertiesChangeListener > xTHIS(
			static_cast< OWeakObject* >( this ), UNO_QUERY );
	maInetOptions.removePropertiesChangeListener( seqProperty, xTHIS );
}

