/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: itmfac.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:55:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef GCC
#pragma hdrstop
#endif


#ifndef _TOOLS_TIME_HXX //autogen
#include <tools/time.hxx>
#endif

#ifndef _GLOBNAME_HXX
#include <tools/globname.hxx>
#endif
#include "app.hxx"

class SfxItemFactory_Impl
{
	SvGlobalName      aGlobName;
	SfxItemCreateFunc pFunc;
	SfxPoolItem*      pFactItem;

public:
	SfxItemFactory_Impl(const SvGlobalName& rName, SfxItemCreateFunc pFuncP )
		: aGlobName( rName ), pFunc( pFuncP ), pFactItem( 0 ) {}
	const SvGlobalName& GetGlobalName() const { return aGlobName; }
	SfxPoolItem*  Create( USHORT nId, SvStream* pStrm ) const;
	TypeId GetType() const { return (TypeId) pFunc; }
};

SfxPoolItem* SfxItemFactory_Impl::Create( USHORT nId, SvStream* pStrm ) const
{
	if( !pStrm )
		return (*pFunc)();
	else
	{
		if( !pFactItem )
			((SfxItemFactory_Impl*)this)->pFactItem = (*pFunc )();
		SfxPoolItem* pRet = pFactItem->Create(
			*pStrm, pFactItem->GetVersion( SOFFICE_FILEFORMAT_40 ) );
		pRet->SetWhich( nId );
		return pRet;
	}
}

SfxItemFactoryList::~SfxItemFactoryList()
{
	for ( ULONG n = aList.Count(); n--; )
		delete aList.GetObject(n);
}

SfxItemFactory_Impl* SfxItemFactoryList::GetFactory_Impl(
  const SvGlobalName& rGlob) const
{
	USHORT nCount = ( USHORT ) aList.Count();
	for( USHORT n = 0; n <nCount; n++ )
	{
		SfxItemFactory_Impl* pFact =
			(SfxItemFactory_Impl *) aList.GetObject( n );
		if( pFact->GetGlobalName()	== rGlob )
			return pFact;
	}
	return 0;
}

SfxItemFactory_Impl* SfxItemFactoryList::GetFactory_Impl(
	TypeId aType) const
{
	USHORT nCount = ( USHORT ) aList.Count();
	for( USHORT n = 0; n <nCount; n++ )
	{
		SfxItemFactory_Impl* pFact =
			(SfxItemFactory_Impl *) aList.GetObject( n );
		if( pFact->GetType() == aType )
			return pFact;
	}
	return 0;
}

void SfxItemFactoryList::RegisterItemFactory(
	const SvGlobalName& rName, SfxItemCreateFunc pFunc)
{
	aList.Insert( new SfxItemFactory_Impl( rName, pFunc ), aList.Count() );
}


SfxPoolItem* SfxItemFactoryList::Create(
	const SvGlobalName& rGlob, USHORT nId, SvStream* pStrm ) const
{
	SfxItemFactory_Impl* pFact = GetFactory_Impl( rGlob );
	if( pFact )
		return pFact->Create( nId, pStrm );
	else
		return 0;
}

const SvGlobalName* SfxItemFactoryList::GetGlobalName(
	const SfxPoolItem* pItem ) const
{
	SfxItemFactory_Impl* pFact = GetFactory_Impl( pItem->Type() );
	return pFact ? &pFact->GetGlobalName() : 0;
}

