/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: objface.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:08:26 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFXOBJFACE_HXX
#define _SFXOBJFACE_HXX

#ifndef _SAL_CONFIG_H_
#include "sal/config.h"
#endif

#ifndef INCLUDED_SFX2_DLLAPI_H
#include "sfx2/dllapi.h"
#endif

#ifndef _SAL_TYPES_H_
#include "sal/types.h"
#endif
#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif
#ifndef _RESID_HXX //autogen
#include <tools/resid.hxx>
#endif

#include "msg.hxx"

struct SfxFormalArgument;
struct SfxTypeLibImpl;
struct SfxInterface_Impl;
class  SfxConfigManager;
class  SfxConfigItem;
class  SfxIFConfig_Impl;
class  SfxObjectUIArr_Impl ;
class  SfxModule;
class  SvStream;

class SFX2_DLLPUBLIC SfxInterface
{
friend class SfxIFConfig_Impl;
friend class SfxSlotPool;

	const char* 			pName;			// Sfx-internal name of interface
	const SfxInterface*     pGenoType;
	SfxSlot*                pSlots;
	USHORT                  nCount;
	const SfxTypeLibImpl*	pTypeLibInfo;
	SfxIFConfig_Impl*		pConfig;		// Interface configuration
	USHORT					nClassId;		// Id of interface
	ResId					aNameResId; 	// ResId of external interface name
	SfxInterface_Impl*		pImpData;

	SfxSlot*                operator[]( USHORT nPos ) const;

#ifdef _PROXYSHELL_VERWENDEN
protected:
#if _SOLAR__PRIVATE
	SAL_DLLPRIVATE void SetCount_Impl( USHORT n )
							{ nCount = n; }
#endif
#endif

public:
							SfxInterface( SfxModule *pMod,
										  const char *pClass,
										  const ResId& rResId,
										  USHORT nClassId,
										  const SfxInterface* pGeno,
										  const SfxTypeLibImpl * pLibInfo,
										  SfxSlot &rMessages, USHORT nMsgCount );
							SfxInterface( SfxModule *pMod,
										  const char *pClass,
										  const ResId& rResId,
										  USHORT nClassId,
										  const SfxInterface* pGeno,
										  const SfxTypeLibImpl * pLibInfo);
							~SfxInterface();

	void                    SetSlotMap( SfxSlot& rMessages, USHORT nMsgCount );
	void                    Init( );
	inline USHORT           Count() const;

	const SfxSlot*          GetRealSlot( const SfxSlot * ) const;
	const SfxSlot*          GetRealSlot( USHORT nSlotId ) const;
	virtual const SfxSlot*	GetSlot( USHORT nSlotId ) const;
	const SfxSlot*			GetSlot( const String& rCommand ) const;

	const char*             GetClassName() const { return pName; }
	int 					HasName() const { return 0 != aNameResId.GetId(); }
	String                  GetName() const
							{ return String(aNameResId); }
	ResMgr* 				GetResMgr() const
							{ return aNameResId.GetResMgr(); }

	const SfxTypeLibImpl*	GetTypeLibInfo() const
							{ return pTypeLibInfo; }
	const SfxInterface* 	GetGenoType() const { return pGenoType; }

	const SfxInterface*		GetRealInterfaceForSlot( const SfxSlot* ) const;

	void					RegisterObjectBar( USHORT, const ResId&, const String* pST=0 );
	void					RegisterObjectBar( USHORT, const ResId&, ULONG nFeature, const String* pST=0 );
	void					TransferObjectBar( USHORT, USHORT, SfxInterface*, const String* pST=0 );
	void					RegisterChildWindow( USHORT, BOOL bContext, const String* pST=0 );
	void					RegisterChildWindow( USHORT, BOOL bContext, ULONG nFeature, const String* pST=0 );
	void                    ReleaseChildWindow( USHORT nId);
	void					RegisterStatusBar( const ResId& );
	void                    ReleaseObjectBar( USHORT nId);
	void                    SetObjectBarName (const String& rName, USHORT nId);
	const ResId&			GetObjectBarResId( USHORT nNo ) const;
	USHORT                  GetObjectBarPos( USHORT nNo ) const;
	ULONG                   GetObjectBarFeature( USHORT nNo ) const;
	USHORT					GetObjectBarCount() const;
	void                    SetObjectBarPos( USHORT nPos, USHORT nId );
	const String*           GetObjectBarName( USHORT nNo ) const;
	BOOL					IsObjectBarVisible( USHORT nNo) const;
	void					SetObjectBarVisible( BOOL, USHORT);
	BOOL					StoreObjectBar (USHORT, SvStream&);
	int 					LoadObjectBar (USHORT, SvStream&);
	static USHORT			RegisterUserDefToolBox(USHORT, const String*,
										SfxConfigManager *pCfgMgr);
	static void				ReleaseUserDefToolBox(USHORT nId, SfxConfigManager*);
	BOOL					HasObjectBar(USHORT nId) const;

	ULONG					GetChildWindowFeature( USHORT nNo ) const;
	ULONG					GetChildWindowId( USHORT nNo ) const;
	USHORT					GetChildWindowCount() const;

	void					RegisterPopupMenu( const ResId& );
	const ResId&			GetPopupMenuResId() const;
	const ResId&			GetStatusBarResId() const;

	void					RegisterObjectMenu( USHORT nPos, const ResId& );
	const ResId&			GetObjectMenuResId( USHORT nNo ) const;
	USHORT					GetObjectMenuPos( USHORT nNo ) const;
	USHORT					GetObjectMenuCount() const;
	void                    ClearObjectMenus();
	void                    RemoveObjectMenu( USHORT nPos );

	USHORT					GetConfigId() const;
	SfxModule*				GetModule() const;
    void                    LoadConfig();

	USHORT					GetInterfaceId() const
							{ return nClassId; }

#if _SOLAR__PRIVATE
	SAL_DLLPRIVATE int ContainsSlot_Impl( const SfxSlot *pSlot ) const
							{ return pSlot >= pSlots && pSlot < pSlots + Count(); }
	SAL_DLLPRIVATE ResMgr* GetResManager_Impl() const
							{ return aNameResId.GetResMgr(); }
	SAL_DLLPRIVATE SfxObjectUIArr_Impl* GetObjectBarArr_Impl() const;
	SAL_DLLPRIVATE SfxConfigItem* GetConfig_Impl()
							{ return (SfxConfigItem*) pConfig; }
	SAL_DLLPRIVATE USHORT GetClassId_Impl() const
							{ return nClassId; }
#endif
};

//--------------------------------------------------------------------

// returns the number of functions in this cluster

inline USHORT SfxInterface::Count() const
{
	return nCount;
}

//--------------------------------------------------------------------

// returns a function by position in the array

inline SfxSlot* SfxInterface::operator[]( USHORT nPos ) const
{
	return nPos < nCount? pSlots+nPos: 0;
}

#if _SOLAR__PRIVATE
class SfxIFConfig_Impl
{
friend class SfxInterface;
	USHORT					nCount;
	SfxObjectUIArr_Impl*	pObjectBars;

public:
                    SfxIFConfig_Impl();
			        ~SfxIFConfig_Impl();
	BOOL    		Store(SvStream&);
    void            RegisterObjectBar( USHORT, const ResId&, ULONG nFeature, const String* pST=0 );
    USHORT          GetType();
};
#endif

#endif
