/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: viewshe1.cxx,v $
 *
 *  $Revision: 1.21 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 01:13:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SFX_TOPFRM_HXX //autogen wg. SfxTopViewFrame
#include <sfx2/topfrm.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif

#ifndef _SVX_F3DCHILD_HXX //autogen
#include <svx/f3dchild.hxx>
#endif
#ifndef	_SFX_WHITER_HXX
# include	<svtools/whiter.hxx>
#endif

#define _SI_NOSBXCONTROLS
#define _SI_NOOTHERFORMS
#define _SI_NOCONTROL
#define _SI_NOSBXCONTROLS
#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOVIEWMARKER
#define _SDR_NODRAGMETHODS
#define _SDR_NOUNDO
#define _SDR_NOXOUTDEV


#pragma hdrstop

#define ITEMID_LRSPACE			EE_PARA_LRSPACE
#define ITEMID_ULSPACE			EE_PARA_ULSPACE

#define ITEMID_SIZE 0

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif


#ifndef _SFX_HRC
#include <sfx2/sfx.hrc>
#endif
#include <svtools/style.hrc>
#include <svx/dialogs.hrc>

#ifndef _SVX_FLOAT3D_HXX
#include <svx/float3d.hxx>
#endif
#ifndef _SVX_F3DCHILD_HXX
#include <svx/f3dchild.hxx>
#endif

#ifndef _CLIPLISTENER_HXX
#include <svtools/cliplistener.hxx>
#endif

#include "schattr.hxx"
#define ITEMID_CHARTLEGENDPOS	SCHATTR_LEGEND_POS

#include "app.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"
#include "glob.hrc"
#include "schresid.hxx"

#include <svx/svdoutl.hxx>

#define ITEMID_COLOR 0
#ifndef _SVX_COLRITEM_HXX //autogen
#include <svx/colritem.hxx>
#endif

#ifndef _SVX_XFLCLIT_HXX //autogen
#include <svx/xflclit.hxx>
#endif
#include "viewshel.hxx"
#include "schview.hxx"
#include "docshell.hxx"
#include "fusel.hxx"
#include "futext.hxx"
#include "dgrdata.hxx"
#include "fu3d.hxx"
#include "chaxis.hxx"
#include "memchrt.hxx"
#include "SchTransferable.hxx"
#include "schmod.hxx"

#ifndef _SCH_DATAROW_HXX
# include	"datarow.hxx"
#endif
#ifndef _SCH_DATAPOIN_HXX
# include	"datapoin.hxx"
#endif
#ifndef	_SCH_PERSISTENT_OBJECT_POINTER
# include	"SchPersistentObjectPointer.hxx"
#endif

#include "chwindow.hxx"

#ifndef _CHTSCENE_HXX
#include "chtscene.hxx"
#endif

/*************************************************************************
|*
|* SfxRequests fuer Support-Funktionen
|*
\************************************************************************/

void SchViewShell::FuSupport(SfxRequest &rReq)
{
	ChartModel* pChtModel = &pChView->GetDoc();
	USHORT nSId = rReq.GetSlot();

	switch( nSId )
	{

#ifndef PRODUCT
		case SID_SHOW_ITEMBROWSER:
		{
			pChView->ShowItemBrowser( !pChView->IsItemBrowserVisible() );

			rReq.Done ();
		}
		break;
#endif
		case SID_CUT:
		{
			if(!pDocSh->IsReadOnly())
			{
				if (pFuActual && !pFuActual->DoCut() ||
					!pFuActual && pChView && !pChView->DoCut())
				{
					InfoBox aInfoBox(&GetViewFrame()->GetWindow(),
									 String(SchResId(STR_ACTION_NOTPOSSIBLE)));
					aInfoBox.Execute();
				}
			}
			rReq.Done();
		}
		break;

		case SID_COPY:
		{
			if (pFuActual)
				pFuActual->DoCopy();
			else if (pChView)
				pChView->DoCopy();
			rReq.Done();
		}
		break;

		case SID_PASTE:
		{

			if(!pDocSh->IsReadOnly())
			{
				if (pFuActual)
					pFuActual->DoPaste();
				else if (pChView)
					pChView->DoPaste();
			}
			rReq.Done();
		}
		break;

		case SID_NEW_ARRANGEMENT:
		{
			ChartModel& rChtModel = pDocSh->GetDoc();

			rChtModel.SetUseRelativePositions( FALSE );
			rChtModel.SetDiagramHasBeenMovedOrResized( TRUE );	// BM: is set to FALSE in SetUseRelativePositions. Needed to trigger the font scaling
			rChtModel.SetDiagramRectangle( rChtModel.GetChartRect() );
			rChtModel.BuildChart( TRUE );
			rChtModel.SetDiagramHasBeenMovedOrResized( FALSE ); // Has to be reset again (#91301#)
			rChtModel.SetUseRelativePositions( TRUE );
		}
		rReq.Done();
		break;

		case SID_DELETE:
		{
			if (pChView->IsTextEdit())
			{
				OutlinerView* pOLV = pChView->GetTextEditOutlinerView();

				if (pOLV)
				{
					KeyCode aKCode(KEY_DELETE);
					KeyEvent aKEvt( (sal_Unicode)0, aKCode );
					pOLV->PostKeyEvent(aKEvt);
				}
			}
			else
			{
				BOOL bDelete = TRUE;

				if (pFuActual)
				{
					KeyCode aKCode(KEY_DELETE);
					KeyEvent aKEvt( (sal_Unicode)0, aKCode );

					if (pFuActual->KeyInput(aKEvt))
						bDelete = FALSE;
				}

				if (bDelete &&
					!pChView->DeleteMarkedObjects
							(String(SchResId(STR_UNDO_DELETE))))
				{
					InfoBox aInfoBox(&GetViewFrame()->GetWindow(),
									 String(SchResId(STR_ACTION_NOTPOSSIBLE)));
					aInfoBox.Execute();
				}
			}
			rReq.Ignore ();
		}
		break;

		// slots for 3d flyer
		// ------------------
		case SID_3D_WIN:
		{
			if ( rReq.GetArgs() )
				GetViewFrame()->SetChildWindow( Svx3DChildWindow::GetChildWindowId(),
										((const SfxBoolItem&) (rReq.GetArgs()->
										Get( SID_3D_WIN ))).GetValue());
			else
				GetViewFrame()->ToggleChildWindow( Svx3DChildWindow::GetChildWindowId() );

			Invalidate();
			rReq.Ignore ();
		}
		break;

		case SID_3D_INIT:
		{
			SfxChildWindow* pWindow = GetViewFrame()->GetChildWindow( Svx3DChildWindow::GetChildWindowId() );
			if( pWindow )
			{
				Svx3DWin* p3DWin = (Svx3DWin*)( pWindow->GetWindow() );
				if( p3DWin )
				{
					p3DWin->InitColorLB( pChtModel );
				}
			}
		}
		break;

		case SID_3D_STATE:
		{
			SfxChildWindow* pWindow = GetViewFrame()->GetChildWindow( Svx3DChildWindow::GetChildWindowId() );
			if( pWindow )
			{
				Svx3DWin* p3DWin = (Svx3DWin*)( pWindow->GetWindow() );
				if (p3DWin && p3DWin->IsUpdateMode() && pChtModel->IsReal3D())
				{
                    bool bHasMarkedObj = pChView->AreObjectsMarked();
					SfxItemSet aSet( pChView->Get3DAttributes(
                                         bHasMarkedObj ? NULL : pChtModel->GetScene()));

					//	Create  an item set without items that are set to
					//	SFX_ITEM_DONTCARE.  This is acomplished by using TRUE as
					//	second argument (bInvalidAsDefault) to Put().
//					SfxItemSet aFilteredSet( *(aSet.GetPool()), aSet.GetRanges());
//					aFilteredSet.Put( aSet, TRUE );
                    delete mp3DFlyerReference;
					mp3DFlyerReference = new SfxItemSet (aSet/*aFilteredSet*/);

					p3DWin->Update( aSet/*aFilteredSet*/ );
				}
			}
		}
		break;
		
		case SID_3D_ASSIGN:
		{
			SfxChildWindow* pWindow = GetViewFrame()->GetChildWindow( Svx3DChildWindow::GetChildWindowId() );
			if( pWindow )
			{
				Svx3DWin* p3DWin = (Svx3DWin*)( pWindow->GetWindow() );
				if (p3DWin && pChtModel->IsReal3D())
				{
					long nId = -1;
					BOOL bBuildChart = FALSE;
                    bool bHasMarkedObj = pChView->AreObjectsMarked();

					const SdrMarkList &aMarkList = pChView->GetMarkedObjectList();
					if( aMarkList.GetMarkCount() )
					{
						const SdrMark *pMark = aMarkList.GetMark(0);
						if( pMark )
						{
                            // don't assign 3D attributes to legend
                            SchObjectId* pObjId = GetObjectId( *pMark->GetObj() );
                            if( pObjId )
                                nId = pObjId->GetObjId();

                            if( nId == CHOBJID_LEGEND ||
                                nId == CHOBJID_LEGEND_SYMBOL_COL ||
                                nId == CHOBJID_LEGEND_SYMBOL_ROW ||
                                nId == -1 )
                                break;
                        }
					}
				
					//	Get the possibly modified item set from the 3D flyer but
					//	reduce the item set's range the SDR attributes.
					SfxItemSet aSet( pChtModel->GetPool(),
									 SDRATTR_START,SDRATTR_END,
									 0);
					p3DWin->GetAttr( aSet );

					// create ItemSet without SFX_ITEM_DONTCARE. Put()
					// uses it's second parameter (bInvalidAsDefault) to
					// remove all such items to set them to default.
					SfxItemSet aFilteredSet( *(aSet.GetPool()), aSet.GetRanges());
					aFilteredSet.Put( aSet, TRUE );

					//	Determine the items that changed their values in the 3d flyer.
					//	Unset all those items in aFilteredSet that have the same
					//	value as in mp3DFlyerReference.
					SfxWhichIter aIterator (aFilteredSet);
					sal_uInt16 nWhich (aIterator.FirstWhich());
					const SfxPoolItem	*	pOldItem,
										*	pNewItem;
					while (nWhich != 0)
					{
                        DBG_ASSERT( mp3DFlyerReference, "SID_3D_ASSIGN without prior SID_3D_STATE" );
						pOldItem = mp3DFlyerReference->GetItem (nWhich, TRUE);
						pNewItem = aFilteredSet.GetItem (nWhich, TRUE);
						if (pOldItem!=NULL && pNewItem!=NULL)
							//	First use (faster) object identity for comparison
							//	of the old and new item and only if that fails use 
							//	the class specific compare operator.
							if (pOldItem == pNewItem || *pOldItem==*pNewItem)
								aFilteredSet.ClearItem (nWhich);
						nWhich = aIterator.NextWhich();
					}

					// BM: #67598# change data descr symbol color
					if ( nId == CHOBJID_DIAGRAM_ROWS ||
						 nId == CHOBJID_DIAGRAM_ROWGROUP ||
						 nId == CHOBJID_DIAGRAM_SPECIAL_GROUP )
					{
							// rebuild if DataDescription symbols are shown
						bBuildChart = pChtModel->ShowSym();
					}

					// #72612#	BM extra points are calculated using this attribute
					const SfxPoolItem *pPoolItem;
					if( SFX_ITEM_SET == aFilteredSet.GetItemState( SDRATTR_3DOBJ_PERCENT_DIAGONAL, TRUE, &pPoolItem ) &&
						( nId == CHOBJID_DIAGRAM_ROWS ||
						  nId == CHOBJID_DIAGRAM_ROWGROUP ||
						  nId == CHOBJID_DIAGRAM_SPECIAL_GROUP ||
						  nId == CHOBJID_DIAGRAM_DATA ) )
						bBuildChart = TRUE;


                    if( ! bHasMarkedObj )
                        pChView->Set3DAttributes( aFilteredSet, pChtModel->GetScene() );
                    else if ( ! bBuildChart )
						//	As we are rebuilding the chart in a short time
						//	we don't have to call this method.
						pChView->Set3DAttributes( aFilteredSet );

					//	Set the modified item set to all marked objects.  Update the
					//	flag that indicates wether a call to BuildChart() is necessary.
					if (aMarkList.GetMarkCount() != 0)
						for (ULONG i=0; i<aMarkList.GetMarkCount(); i++)
							bBuildChart |= SetItemSet (
								aMarkList.GetMark(i)->GetObj(),
								aFilteredSet);

					//	Call BuildChart() if necessary and remark the currently marked
					//	objects afterwards.
					if( bBuildChart )
					{
						//	Remember the currently marked objects ...
						SdrObject * pMarkedObject = NULL; 
						if (aMarkList.GetMarkCount() != 0)
							pMarkedObject = aMarkList.GetMark(0)->GetObj();
						SchPersistentObjectPointer pObject (pMarkedObject);
								
						pChtModel->BuildChart( FALSE );

						//	... and mark the equivalent object(s).
						const std::vector<SdrObject*> & pObjectList = 
							pObject.GetPointers (pChtModel);
						std::vector<SdrObject*>::const_iterator I;
						for (I=pObjectList.begin(); I!=pObjectList.end(); I++)
							pChView->MarkObj (*I, pChView->GetPageViewPvNum (0));
					}
				}
				break;
			}
		}
	}
}

/*************************************************************************
|*
|* SfxRequests fuer permanente Funktionen
|*
\************************************************************************/

void SchViewShell::FuPermanent(SfxRequest &rReq)
{
	ChartModel* pChDoc = &pChView->GetDoc();
	USHORT nSlotID = rReq.GetSlot();

	if (pFuActual)
	{
		if (pFuOld == pFuActual)
			pFuOld = NULL;

		if (nSlotID != SID_TEXTEDIT && pChView->IsTextEdit())
			pChView->EndTextEdit();

		pFuActual->Deactivate();
		delete pFuActual;
		pFuActual = NULL;
	}

	switch (nSlotID)
	{
		case SID_TOOL_SELECT:
			pFuActual = new SchFuSelection(this, GetWindow(), pChView,
										   pChDoc, rReq);
			rReq.Done();
			break;

		case SID_TEXTEDIT:
			pFuActual = new SchFuText(this, GetWindow(), pChView,
									  pChDoc, rReq);
			rReq.Done();
			break;
	}

	if (pFuOld)
	{
		pFuOld->Deactivate();
		delete pFuOld;
		pFuOld = NULL;
	}

	if (pFuActual)
	{
		pFuActual->Activate();
		pFuOld = pFuActual;
	}

	// Shell wird invalidiert, schneller als einzeln (laut MI)

	Invalidate();
}


/*************************************************************************
|*
|* Status (Enabled/Disabled) von Menue-SfxSlots setzen
|*
\************************************************************************/

void SchViewShell::GetMenuState(SfxItemSet &rSet)
{
	// abgefangenes LVD an Basisklasse weiterleiten,
	// wenn nicht IP-aktiv

	static ChartSelectionInfo aStaticInfo(CHART_SEL_QUERYSUPPORT|CHART_SEL_ROW);

	if (rSet.GetItemState(SID_RELOAD) != SFX_ITEM_UNKNOWN)
	{
		SfxViewFrame* pFrame = GetViewFrame();

		if (pFrame->IsA(TYPE(SfxTopViewFrame)))
			pFrame->GetSlotState(SID_RELOAD,
								 pFrame->GetInterface(), &rSet);
		else
			rSet.DisableItem(SID_RELOAD);
	}

	if(pDocSh->IsReadOnly())
	{

		//rset.DisableItem( SID_COPYFORMAT );
		rSet.DisableItem( SID_PASTEFORMAT);
		rSet.DisableItem( SID_DIAGRAM_DATA);
		rSet.DisableItem( SID_INSERT_TITLE );
		rSet.DisableItem( SID_INSERT_CHART_LEGEND );
		rSet.DisableItem( SID_INSERT_DESCRIPTION );
		rSet.DisableItem( SID_INSERT_AXIS );
		rSet.DisableItem( SID_INSERT_GRIDS );
		rSet.DisableItem( SID_CHARMAP );					// BM
		rSet.DisableItem( SID_DATA_ROW_POINT );
		rSet.DisableItem( SID_CHART_TITLE );
		rSet.DisableItem( SID_LEGEND );
		rSet.DisableItem( SID_DIAGRAM_AXIS );
		rSet.DisableItem( SID_DIAGRAM_GRID );
		rSet.DisableItem( SID_DIAGRAM_WALL );
		rSet.DisableItem( SID_DIAGRAM_FLOOR );
		rSet.DisableItem( SID_DIAGRAM_AREA );
		rSet.DisableItem( SID_DIAGRAM_TYPE );
		rSet.DisableItem( SID_TOGGLE_TITLE );
		rSet.DisableItem( SID_TOGGLE_LEGEND );
		rSet.DisableItem( SID_TOGGLE_AXIS_TITLE );
		rSet.DisableItem( SID_TOGGLE_AXIS_DESCR );
		rSet.DisableItem( SID_TOGGLE_GRID_HORZ );
		rSet.DisableItem( SID_TOGGLE_GRID_VERT );
		rSet.DisableItem( SID_DATA_IN_ROWS );
		rSet.DisableItem( SID_DATA_IN_COLUMNS );
		rSet.DisableItem( SID_TOOL_SELECT );
		rSet.DisableItem( SID_CONTEXT_TYPE );
		rSet.DisableItem( SID_NEW_ARRANGEMENT );
		rSet.DisableItem( SID_MAINTITLE );
		rSet.DisableItem( SID_SUBTITLE );
		rSet.DisableItem( SID_XAXIS_TITLE );
		rSet.DisableItem( SID_YAXIS_TITLE );
		rSet.DisableItem( SID_ZAXIS_TITLE );
		rSet.DisableItem( SID_DATA );
		rSet.DisableItem( SID_ADD_COLUMN );
		rSet.DisableItem( SID_ADD_ROW );
		rSet.DisableItem( SID_DIAGRAM_AXIS_X );
		rSet.DisableItem( SID_DIAGRAM_AXIS_Y );
		rSet.DisableItem( SID_DIAGRAM_AXIS_Z );
		rSet.DisableItem( SID_DIAGRAM_AXIS_A );
		rSet.DisableItem( SID_DIAGRAM_AXIS_B );
		rSet.DisableItem( SID_DIAGRAM_AXIS_C );
		rSet.DisableItem( SID_DIAGRAM_AXIS_ALL );
		rSet.DisableItem( SID_INSERT_STATISTICS );
		rSet.DisableItem( SID_DIAGRAM_TITLE_MAIN );
		rSet.DisableItem( SID_DIAGRAM_TITLE_SUB );
		rSet.DisableItem( SID_DIAGRAM_TITLE_X );
		rSet.DisableItem( SID_DIAGRAM_TITLE_Y );
		rSet.DisableItem( SID_DIAGRAM_TITLE_Z );
		rSet.DisableItem( SID_DIAGRAM_TITLE_ALL );
		rSet.DisableItem( SID_DIAGRAM_GRID_X_MAIN );
		rSet.DisableItem( SID_DIAGRAM_GRID_Y_MAIN );
		rSet.DisableItem( SID_DIAGRAM_GRID_Z_MAIN );
		rSet.DisableItem( SID_DIAGRAM_GRID_ALL );
		rSet.DisableItem( SID_HAS_X_DESCR );
		rSet.DisableItem( SID_HAS_Y_DESCR );
		rSet.DisableItem( SID_HAS_Z_DESCR );
		rSet.DisableItem( SID_DIAGRAM_OBJECTS );
		rSet.DisableItem( SID_HAS_X_TITLE );
		rSet.DisableItem( SID_HAS_Y_TITLE );
		rSet.DisableItem( SID_HAS_Z_TITLE );
		rSet.DisableItem( SID_HAS_MAIN_TITLE );
		rSet.DisableItem( SID_HAS_SUB_TITLE );
		rSet.DisableItem( SID_DIAGRAM_GRID_X_HELP );
		rSet.DisableItem( SID_DIAGRAM_GRID_Y_HELP );
		rSet.DisableItem( SID_DIAGRAM_GRID_Z_HELP );
		rSet.DisableItem( SID_DIAGRAM_DATA_WIN );
		rSet.DisableItem( SID_DIAGRAM_ERROR );
		rSet.DisableItem( SID_DIAGRAM_AVERAGEVALUE );
		rSet.DisableItem( SID_DIAGRAM_REGRESSION );
		rSet.DisableItem( SID_SCALE_TEXT );
		rSet.DisableItem( SID_TEXTBREAK );
		rSet.DisableItem( SID_ROW_POSITION );
		rSet.DisableItem( SID_ROW_MOREFRONT );
		rSet.DisableItem( SID_ROW_MOREBACK );
	}

	ChartModel& rDoc = pChView->GetDoc();
	BOOL bAxisChart     = rDoc.IsAxisChart();
	BOOL b3DChart	    = rDoc.IsReal3D();//3DChart();
	BOOL bTitleDisabled = TRUE;
	BOOL bAxisDisabled  = TRUE;

	if (pFuActual)
	{
		USHORT nSId = pFuActual->GetSlotID();
		rSet.Put(SfxBoolItem(nSId, TRUE));
	}

	rSet.Put(SfxBoolItem(SID_TEXTEDIT, pFuActual && pFuActual->GetSlotID() == SID_TEXTEDIT));
	rSet.Put(SfxBoolItem(SID_DIAGRAM_DATA, GetViewFrame()->HasChildWindow (SchDiagramDataWrapper::GetChildWindowId())));

	SchMemChart* pMemChart = rDoc.GetChartData();
	if( pMemChart && pMemChart->IsReadOnly() )
		rSet.DisableItem( SID_DIAGRAM_DATA );

	if (!bAxisChart)
	{
		rSet.DisableItem(SID_INSERT_AXIS);
		rSet.DisableItem(SID_INSERT_GRIDS);
		rSet.DisableItem(SID_DIAGRAM_WALL);
		rSet.DisableItem(SID_DIAGRAM_FLOOR);
	}

	if (rDoc.IsNetChart ())
	{
		rSet.DisableItem(SID_DIAGRAM_TITLE_X);
		rSet.DisableItem(SID_DIAGRAM_AXIS_X);
		rSet.DisableItem(SID_DIAGRAM_WALL);
		rSet.DisableItem(SID_DIAGRAM_FLOOR);
		//	There is no y-grid in net charts.  The x grid is attached to the y axis.
		rSet.DisableItem(SID_DIAGRAM_GRID_Y_MAIN);
		rSet.DisableItem(SID_DIAGRAM_GRID_Y_HELP);
	}

	if (!rDoc.IsStatisticChart ()) rSet.DisableItem(SID_INSERT_STATISTICS);

	if (!rDoc.HasTitle())
	{
		rSet.DisableItem(SID_DIAGRAM_TITLE_MAIN);
		rSet.DisableItem(SID_DIAGRAM_TITLE_SUB);
		rSet.DisableItem(SID_DIAGRAM_TITLE_X);
		rSet.DisableItem(SID_DIAGRAM_TITLE_Y);
		rSet.DisableItem(SID_DIAGRAM_TITLE_ALL);
	}

	if (!rDoc.ShowMainTitle())
	{
		rSet.DisableItem(SID_DIAGRAM_TITLE_MAIN);
	}
	else bTitleDisabled = FALSE;

	if (!rDoc.ShowSubTitle())
	{
		rSet.DisableItem(SID_DIAGRAM_TITLE_SUB);
	}
	else bTitleDisabled = FALSE;

	if (!rDoc.ShowXAxisTitle())
	{
		rSet.DisableItem(SID_DIAGRAM_TITLE_X);
	}
	else bTitleDisabled = FALSE;

	if (!rDoc.ShowYAxisTitle())
	{
		rSet.DisableItem(SID_DIAGRAM_TITLE_Y);
	}
	else bTitleDisabled = FALSE;

	if (!rDoc.ShowZAxisTitle())
	{
		rSet.DisableItem(SID_DIAGRAM_TITLE_Z);
	}
	else bTitleDisabled = FALSE;

	if (bTitleDisabled) rSet.DisableItem(SID_DIAGRAM_TITLE_ALL);

	if( !(rDoc.ShowXAxis() || rDoc.ShowXDescr()) )
	{
		rSet.DisableItem(SID_DIAGRAM_AXIS_X);
	}
	else bAxisDisabled = FALSE;

	if( !(rDoc.ShowYAxis() || rDoc.ShowYDescr()) )
	{
		rSet.DisableItem(SID_DIAGRAM_AXIS_Y);
	}
	else bAxisDisabled = FALSE;

	if( !(rDoc.ShowZAxis() || rDoc.ShowZDescr()) )
	{
		rSet.DisableItem(SID_DIAGRAM_AXIS_Z);
	}
	else bAxisDisabled = FALSE;

	// BM #68037#
	if( !(rDoc.GetAxisByUID(CHART_AXIS_SECONDARY_X)->IsVisible() ||
		  rDoc.GetAxisByUID(CHART_AXIS_SECONDARY_X)->HasDescription()) )
	{
		rSet.DisableItem(SID_DIAGRAM_AXIS_A);
	}
	else bAxisDisabled = FALSE;

	if( !(rDoc.GetAxisByUID(CHART_AXIS_SECONDARY_Y)->IsVisible() ||
		  rDoc.GetAxisByUID(CHART_AXIS_SECONDARY_Y)->HasDescription()) )
	{
		rSet.DisableItem(SID_DIAGRAM_AXIS_B);
	}
	else bAxisDisabled = FALSE;


	if( bAxisDisabled )
		rSet.DisableItem(SID_DIAGRAM_AXIS_ALL);

	if (!rDoc.GetShowLegend ()) rSet.DisableItem(SID_LEGEND);

	if (!rDoc.HasAxis())
	{
		rSet.DisableItem(SID_DIAGRAM_AXIS_X);
		rSet.DisableItem(SID_DIAGRAM_AXIS_Y);
		rSet.DisableItem(SID_DIAGRAM_AXIS_A);
		rSet.DisableItem(SID_DIAGRAM_AXIS_B);
		rSet.DisableItem(SID_DIAGRAM_AXIS_ALL);
	}

	if (!rDoc.HasGrid())
	{
		rSet.DisableItem(SID_DIAGRAM_GRID);
		rSet.DisableItem(SID_DIAGRAM_GRID_X_MAIN);
		rSet.DisableItem(SID_DIAGRAM_GRID_Y_MAIN);
		rSet.DisableItem(SID_DIAGRAM_GRID_Z_MAIN);
		rSet.DisableItem(SID_DIAGRAM_GRID_X_HELP);
		rSet.DisableItem(SID_DIAGRAM_GRID_Y_HELP);
		rSet.DisableItem(SID_DIAGRAM_GRID_Z_HELP);
		rSet.DisableItem(SID_DIAGRAM_GRID_ALL);
	}

	if (!b3DChart)
	{
		rSet.DisableItem(SID_DIAGRAM_FLOOR);
		rSet.DisableItem(SID_3D_VIEW);
		rSet.DisableItem(SID_DIAGRAM_AXIS_Z);
		rSet.DisableItem(SID_DIAGRAM_TITLE_Z);
		rSet.DisableItem(SID_DIAGRAM_GRID_Z_MAIN);
		rSet.DisableItem(SID_DIAGRAM_GRID_Z_HELP);

        rSet.DisableItem(SID_3D_WIN);
		rSet.DisableItem(SID_3D_INIT);
		rSet.DisableItem(SID_3D_STATE);
		rSet.DisableItem(SID_3D_ASSIGN);
	}
	if(!rDoc.CanAxis(CHART_AXIS_SECONDARY_X))	// BM #68037#
		rSet.DisableItem(SID_DIAGRAM_AXIS_A);
	
	if(!rDoc.CanAxis(CHART_AXIS_SECONDARY_Y))
		rSet.DisableItem(SID_DIAGRAM_AXIS_B);


	if (!pChView->AreObjectsMarked())
	{
		rSet.DisableItem(SID_CUT);
		rSet.DisableItem(SID_COPY);
		rSet.DisableItem(SID_DELETE);
		rSet.DisableItem(SID_DIAGRAM_OBJECTS);
		rSet.DisableItem(SID_ATTR_TRANSFORM);
	}
	else
    {
        // there are marked objects
        const SdrMarkList& rMarkList = pChView->GetMarkedObjectList();

        SdrMark* pMark = rMarkList.GetMark( 0 );
        SdrObject* pObj = pMark->GetObj();
        SchObjectId* pObjId = GetObjectId( *pObj );

        if( pObjId )
        {
            UINT16 nObjId = pObjId->GetObjId();

            if( ( ( rDoc.IsNetChart() || ! rDoc.IsAxisChart() )
                  && ( CHOBJID_DIAGRAM == nObjId ) )
                || CHOBJID_DIAGRAM_AREA == nObjId
                || CHOBJID_DIAGRAM_DATA == nObjId
                || CHOBJID_LEGEND_SYMBOL_ROW == nObjId )
            {
                rSet.DisableItem( SID_ATTR_TRANSFORM );
            }
            else
            {
                SdrObject* pParent = pObj->GetUpGroup();
                if( pParent )
                {
                    SchObjectId * pParentObjId = GetObjectId( *pParent );
                    if( pParentObjId &&
                        CHOBJID_DIAGRAM == pParentObjId->GetObjId())
                    {
                        // disable for subelements of diagram
                        rSet.DisableItem( SID_ATTR_TRANSFORM );
                    }
                }
            }

            // #102395# disable object properties for diagram object for charts
            // that do not have properties for it
            if( CHOBJID_DIAGRAM == nObjId &&
                ( rDoc.IsPieChart() || rDoc.IsNetChart()) )
            {
                rSet.DisableItem( SID_DIAGRAM_OBJECTS );
            }
        }
        else
        {
            // the selected object has no chart id
            rSet.DisableItem( SID_ATTR_TRANSFORM );
        }
    }

	BOOL bSwitchData = rDoc.IsSwitchData();

	if (!rDoc.ShowXGridMain())
	{
		rSet.DisableItem(SID_DIAGRAM_GRID_X_MAIN);
	}

	if (!rDoc.ShowYGridMain())
	{
		rSet.DisableItem(SID_DIAGRAM_GRID_Y_MAIN);
	}

	if (!rDoc.ShowZGridMain())
		rSet.DisableItem(SID_DIAGRAM_GRID_Z_MAIN);

	if (!rDoc.ShowXGridHelp())
	{
			rSet.DisableItem(SID_DIAGRAM_GRID_X_HELP);
	}

	if (!rDoc.ShowYGridHelp())
	{
		rSet.DisableItem(SID_DIAGRAM_GRID_Y_HELP);
	}

	if (!rDoc.ShowZGridHelp())
		rSet.DisableItem(SID_DIAGRAM_GRID_Z_HELP);

	rSet.Put(SfxBoolItem(SID_SCALE_TEXT, rDoc.TextScalability ()));
	rSet.Put(SfxBoolItem(SID_TOGGLE_TITLE, rDoc.ShowMainTitle() && rDoc.ShowSubTitle() ));
	rSet.Put(SfxBoolItem(SID_TOGGLE_LEGEND, rDoc.GetShowLegend()));
	rSet.Put(SfxBoolItem(SID_HAS_MAIN_TITLE, rDoc.ShowMainTitle() ) );
	rSet.Put(SfxBoolItem(SID_HAS_SUB_TITLE, rDoc.ShowSubTitle() ) );

	if (bAxisChart && !rDoc.IsNetChart ())
	{
		rSet.Put(SfxBoolItem(SID_HAS_X_TITLE, rDoc.ShowXAxisTitle() ) );
		rSet.Put(SfxBoolItem(SID_HAS_Y_TITLE, rDoc.ShowYAxisTitle() ) );
		rSet.Put(SfxBoolItem(SID_HAS_X_DESCR, rDoc.ShowXDescr() ) );
		rSet.Put(SfxBoolItem(SID_HAS_Y_DESCR, rDoc.ShowYDescr() ) );

		if (b3DChart)
		{
			rSet.Put(SfxBoolItem(SID_HAS_Z_TITLE, rDoc.ShowZAxisTitle() ) );
			rSet.Put(SfxBoolItem(SID_HAS_Z_DESCR, rDoc.ShowZDescr() ) );

			rSet.Put(SfxBoolItem(SID_TOGGLE_AXIS_TITLE,
								 rDoc.ShowXAxisTitle() ||
								 rDoc.ShowYAxisTitle() ||
								 rDoc.ShowZAxisTitle()));
			rSet.Put(SfxBoolItem(SID_TOGGLE_AXIS_DESCR,
								 rDoc.ShowXDescr() ||
								 rDoc.ShowYDescr() ||
								 rDoc.ShowZDescr()));
		}
		else
		{
			rSet.Put(SfxBoolItem(SID_TOGGLE_AXIS_TITLE,
								 rDoc.ShowXAxisTitle() ||
								 rDoc.ShowYAxisTitle()));
			rSet.Put(SfxBoolItem(SID_TOGGLE_AXIS_DESCR,
								 rDoc.ShowXDescr() ||
								 rDoc.ShowYDescr()));
		}

		rSet.Put(SfxBoolItem(SID_TOGGLE_GRID_HORZ, rDoc.ShowXGridMain()));
		rSet.Put(SfxBoolItem(SID_TOGGLE_GRID_VERT, rDoc.ShowYGridMain()));
	}
	else
	{
		rSet.DisableItem(SID_TOGGLE_AXIS_TITLE);
		rSet.DisableItem(SID_TOGGLE_AXIS_DESCR);
		rSet.DisableItem(SID_TOGGLE_GRID_VERT);
		if (!rDoc.IsNetChart ()) rSet.DisableItem(SID_TOGGLE_GRID_HORZ);
		else rSet.Put(SfxBoolItem(SID_TOGGLE_GRID_HORZ, rDoc.ShowXGridMain()));
	}

	long nSelRow=pChView->GetSelectedRow();
	if (nSelRow == -1)
	{
		rSet.DisableItem(SID_SET_DEFAULT);
		rSet.DisableItem(SID_ROW_MOREBACK);
		rSet.DisableItem(SID_ROW_MOREFRONT);
	}
	else
	{
		if(! (pMemChart->SubmitSelection(aStaticInfo) & CHART_SEL_ROW))
		{
			rSet.DisableItem(SID_SET_DEFAULT);
			rSet.DisableItem(SID_ROW_MOREBACK);
			rSet.DisableItem(SID_ROW_MOREFRONT);
		}
	}
	if(nSelRow==rDoc.GetRowCount()-1)
		rSet.DisableItem(SID_ROW_MOREBACK);
	if ((nSelRow==0) || ((nSelRow==1) && rDoc.IsXYChart()))
		rSet.DisableItem(SID_ROW_MOREFRONT);

    if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PASTE ) )
	{
		if ( ! mpClipEvtLstnr )
		{
			// create listener
			mpClipEvtLstnr = new TransferableClipboardListener( LINK( this, SchViewShell, ClipboardChanged ) );
			mpClipEvtLstnr->acquire();
			mpClipEvtLstnr->AddRemoveListener( GetWindow(), TRUE );

			// get initial state
			TransferableDataHelper aDataHelper(
                TransferableDataHelper::CreateFromSystemClipboard( GetWindow() ));
			mbTextPastePossible = ( aDataHelper.GetFormatCount() != 0 && aDataHelper.HasFormat( FORMAT_STRING ) );
            mbPastePossible = ( aDataHelper.GetFormatCount() != 0 &&
                                ( aDataHelper.HasFormat( FORMAT_GDIMETAFILE ) ||
                                  aDataHelper.HasFormat( FORMAT_BITMAP )));
		}

		if( pChView->IsTextEdit())
        {
            if( ! mbTextPastePossible )
                rSet.DisableItem( SID_PASTE );
        }
        else
        {
            if( ! mbPastePossible )
                rSet.DisableItem( SID_PASTE );
        }
	}

	if( !pChView->IsTextEdit() )	// enable special chars in text edit mode only
	{
		rSet.DisableItem(SID_CHARMAP);
	}

	rSet.Put(SfxBoolItem(SID_DATA_IN_ROWS,   !bSwitchData));
	rSet.Put(SfxBoolItem(SID_DATA_IN_COLUMNS, bSwitchData));

	if(bUserKnowsTranslation)
	{
		if(rDoc.GetChartData()->GetTranslation()==TRANS_NONE)
			bUserKnowsTranslation=FALSE;
		else
		{
			rSet.DisableItem(SID_DATA_IN_ROWS);
			rSet.DisableItem(SID_DATA_IN_COLUMNS);
		}
	}

	rSet.Put(SfxStringItem(SID_CONTEXT, pChView->GetContext()));
	rSet.Put(SfxStringItem(SID_CONTEXT_TYPE, pChView->GetContextType()));

	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_3D_WIN ))
	{
		USHORT nId = Svx3DChildWindow::GetChildWindowId();
		rSet.Put( SfxBoolItem( SID_3D_WIN, GetViewFrame()->HasChildWindow( nId )));
	}
}

/*************************************************************************
|*
|* SfxRequests fuer StatusBar bearbeiten
|*
\************************************************************************/

void SchViewShell::ExecStatusBar(SfxRequest& rReq)
{
}

/*************************************************************************
|*
|* Statuswerte der Statusbar zurueckgeben
|*
\************************************************************************/

void SchViewShell::GetStatusBarState(SfxItemSet& rSet)
{
}

/*************************************************************************
|*
|* Status der Attribut-Items
|*
\************************************************************************/

void SchViewShell::GetAttrState(SfxItemSet& rSet)
{
}



/**
	@short	Set the given item set at the given object.
*/
BOOL	SchViewShell::SetItemSet	(SdrObject * pObject, 
									const SfxItemSet & aSet)	const
{
	if (pObject == NULL)
		return false;
	
	ChartModel * pModel = &pChView->GetDoc();
	
	//	Handle the special cases for setting the item set.
	switch (GetObjectId(*pObject)->GetObjId())
	{
		case	CHOBJID_DIAGRAM_ROWS			:
		case	CHOBJID_DIAGRAM_ROWGROUP		:
		case	CHOBJID_DIAGRAM_SPECIAL_GROUP	:
			{
			//	The itemset of a row is set via a special method that
			//	clears the individual point itemsets.
			SchDataRow * pDataRow = GetDataRow (*pObject);
			DBG_ASSERT (pDataRow!=NULL, 
				"no data row information in SchViewShell::SetItemSet");
			pModel->PutDataRowAttr (
				pDataRow->GetRow(),
				aSet,
				TRUE,	//	Merge.
				TRUE);	//	Clear data point itemsets.
			}
			break;
			
		case	CHOBJID_DIAGRAM_DATA	:
			//	Set the item with a method that ensures that an own item set is
			//	created for the data point if it not already exists.
			{
			SchDataPoint * pDataPoint = GetDataPoint (*pObject);
			DBG_ASSERT (pDataPoint!=NULL, 
				"no data point information in SchViewShell::SetItemSet");
			pModel->PutDataPointAttr (
				pDataPoint->GetCol(), 
				pDataPoint->GetRow(), 
				aSet, 
				TRUE);	//	Merge
			}
			break;
			
		case	CHOBJID_DIAGRAM	:
			//	Setting the item set to the whole diagram is done in two steps.
			//	First set it to the rows and clear the individual point
			//	itemsets.  Then set it to the actual marked object.
			pModel->GetAttr(CHOBJID_DIAGRAM_FLOOR).Put (aSet);
			pModel->GetAttr(CHOBJID_DIAGRAM_WALL).Put (aSet);
			pModel->PutDataRowAttrAll (
				aSet,
				TRUE,	//	Merge.
				TRUE);	//	Clear data point itemsets.
			return true;
			
		default	:
			pModel->StoreObjectsAttributes (pObject, aSet, FALSE);	
	}
	
	return false;
}

IMPL_LINK( SchViewShell, ClipboardChanged, TransferableDataHelper*, pDataHelper )
{
	if ( pDataHelper )
	{
		mbTextPastePossible = ( pDataHelper->GetFormatCount() != 0 && pDataHelper->HasFormat( FORMAT_STRING ));
		mbPastePossible = ( pDataHelper->GetFormatCount() != 0 &&
                            ( pDataHelper->HasFormat( FORMAT_GDIMETAFILE ) ||
                              pDataHelper->HasFormat( FORMAT_BITMAP )));

		SfxBindings& rBindings = GetViewFrame()->GetBindings();
		rBindings.Invalidate( SID_PASTE );
	}
	return 0;
}
