/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dataedit.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:41:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SCH_DATAEDIT_HXX
#define _SCH_DATAEDIT_HXX

#ifndef _SV_WINDOW_HXX //autogen
#include <vcl/window.hxx>
#endif

#ifndef _SV_EDIT_HXX //autogen
#include <vcl/edit.hxx>
#endif


/*************************************************************************
|*
|* Editierfeld fuer Chart-Daten
|*
\************************************************************************/

class ChartDataEdit : public Edit
{
private:
	Link aCancelHdlLink;
	Link aAcceptHdlLink;

protected:
	virtual void KeyInput(const KeyEvent& rEvt);

public:
	ChartDataEdit(Window* pParent, const ResId& rId);
	virtual ~ChartDataEdit();

	void SetCancelHdl(const Link& rLink) { aCancelHdlLink = rLink; }
	const Link& GetCancelHdl() const { return aCancelHdlLink; }
	void SetAcceptHdl(const Link& rLink) { aAcceptHdlLink = rLink; }
	const Link& GetAcceptHdl() const { return aAcceptHdlLink; }
	void GoEOL ();
};

#endif	// _SCH_DATAEDIT_HXX


