/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fupoor.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:25:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


//svdraw.hxx
#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
#define _SI_NOSBXCONTROLS
#define _SI_NOOTHERFORMS
#define _SI_NOCONTROL
#define _SI_NOSBXCONTROLS

#include "datarow.hxx"
#ifndef _CTRLTOOL_HXX //autogen
#include <svtools/ctrltool.hxx>
#endif
#ifndef _SV_SELENG_HXX //autogen
#include <vcl/seleng.hxx>
#endif
#ifndef _SFXAPP_HXX //autogen
#include <sfx2/app.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif

#ifndef _AEITEM_HXX //autogen
#include <svtools/aeitem.hxx>
#endif

#include <svx/flstitem.hxx>

#pragma hdrstop

// Fuer SvxChooseControlEnum
//#define _BASIDESH_HXX
//#define _TBXCTL_HXX
//#include <basicsh.hxx>
//#include <svxids.hrc>

#include "schview.hxx"
#include "viewshel.hxx"
#include "chwindow.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "docshell.hxx"
#include "fupoor.hxx"

TYPEINIT0(SchFuPoor);


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchFuPoor::SchFuPoor(SchViewShell* pViewSh, SchWindow* pWin, SchView* pView,
					 ChartModel* pDoc, SfxRequest& rReq) :
	pViewShell(pViewSh),
	pWindow(pWin),
	pView(pView),
	pChDoc(pDoc),
	nSlotId(rReq.GetSlot()),
	pDialog(NULL),
	bIsInDragMode(FALSE),
	bFirstMouseMove(FALSE)
{
	nSlotValue   = 0;
	pMarkedObj   = 0;
	pMarkedObjId = 0;
	nMarkedID    = 0;

	const SfxItemSet* pSet = rReq.GetArgs();
	if (pSet)
	{
		if (pSet->GetItemState(nSlotId) == SFX_ITEM_SET)
		{
			const SfxPoolItem& rItem = pSet->Get(nSlotId);
			if( rItem.ISA(SfxAllEnumItem))
				nSlotValue = ((const SfxAllEnumItem&)rItem).GetValue();
		}
	}

	aDragTimer.SetTimeoutHdl(LINK(this, SchFuPoor, DragHdl));
	aDragTimer.SetTimeout(SELENG_DRAGDROP_TIMEOUT);

	if (pView->GetMarkedObjectList().GetMarkCount() >= 1)
	{
		pMarkedObj   = pView->GetMarkedObjectList().GetMark(0)->GetObj();
		pMarkedObjId = GetObjectId(*pMarkedObj);
		if (pMarkedObjId) nMarkedID = pMarkedObjId->GetObjId();

		if (nMarkedID == CHOBJID_DIAGRAM) nMarkedID = CHOBJID_DIAGRAM_WALL;
	}
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

SchFuPoor::~SchFuPoor()
{
	aDragTimer.Stop();

	delete pDialog;
}

/*************************************************************************
|*
|* Function aktivieren
|*
\************************************************************************/

void SchFuPoor::Activate()
{
	if (pDialog)
		pDialog->Show();
}

/*************************************************************************
|*
|* Function deaktivieren
|*
\************************************************************************/

void SchFuPoor::Deactivate()
{
	aDragTimer.Stop();

	if (pDialog)
		pDialog->Hide();

	if (pWindow)
		pWindow->ReleaseMouse();
}

//	SFX_APP()->SetHelpText(aStr);


/*************************************************************************
|*
|* Tastaturereignisse bearbeiten
|*
|* Wird ein KeyEvent bearbeitet, so ist der Return-Wert TRUE, andernfalls
|* FALSE.
|*
\************************************************************************/

BOOL SchFuPoor::KeyInput(const KeyEvent& rKEvt)
{
	BOOL bReturn = FALSE;

	switch (rKEvt.GetKeyCode().GetCode())
	{
		case KEY_ESCAPE:
		{
            // Terminate possible InPlace mode
            pViewShell->Escape();
		}
		break;
	}

	return bReturn;
}

/*************************************************************************
|*
|* Cut object to clipboard
|*
\************************************************************************/

BOOL SchFuPoor::DoCut()
{
	return pView && pView->DoCut(pWindow);
}

/*************************************************************************
|*
|* Copy object to clipboard
|*
\************************************************************************/

void SchFuPoor::DoCopy()
{
	if (pView)
		pView->DoCopy(pWindow);
}

/*************************************************************************
|*
|* Paste object from clipboard
|*
\************************************************************************/

void SchFuPoor::DoPaste()
{
	if (pView)
		pView->DoPaste(pWindow);
}

/*************************************************************************
|*
|* Timer-Handler fuer Drag&Drop
|*
\************************************************************************/

IMPL_LINK( SchFuPoor, DragHdl, Timer *, pTimer )
{
	USHORT nHitLog = (USHORT)pWindow->PixelToLogic(Size(HITPIX,0)).Width();
	SdrHdl* pHdl = pView->HitHandle(aMDPos, *pWindow);

	if (pHdl==NULL && pView->IsMarkedHit(aMDPos, nHitLog))
	{
		pWindow->ReleaseMouse();
		bIsInDragMode = TRUE;

		pView->BeginDrag(pWindow, aMDPos);
	}
	return 0;
}

/*************************************************************************
|*
|* Command-event
|*
\************************************************************************/

BOOL SchFuPoor::Command(const CommandEvent& rCEvt)
{
	return pView->Command(rCEvt, pWindow);
}

/*************************************************************************
|*
|* Handler fuer Mausbewegung
|*
\************************************************************************/

BOOL SchFuPoor::MouseMove(const MouseEvent& rMEvt)
{
	return FALSE;
}

/*************************************************************************
|*
|* Handler fuer Maustaste
|*
\************************************************************************/

BOOL SchFuPoor::MouseButtonDown(const MouseEvent& rMEvt)
{
	return FALSE;
}

/*************************************************************************
|*
|* Handler fuer Maustaste
|*
\************************************************************************/

BOOL SchFuPoor::MouseButtonUp(const MouseEvent& rMEvt)
{
	return FALSE;
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuPoor::Paint(const Rectangle& rRect, SchWindow* pWin)
{
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuPoor::SelectionHasChanged()
{
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuPoor::RemarkObject()
{
	if (nMarkedID)
	{
		SdrPage *pPage = pChDoc->GetPage(0);

		if (pPage)
		{
			SdrObject *pObj = GetObjWithId (nMarkedID, *pPage, 0, IM_DEEPWITHGROUPS);

			if (pObj)
			{
				SdrPageView* pPV = pView->GetPageViewPvNum (0);

				pView->UnmarkAll ();
				pView->LeaveAllGroup ();
				pView->SetMarkHdlHidden(TRUE);

                // #102217# enter group if required
                SdrObject* pUpGroup = pObj->GetUpGroup();
                if( pUpGroup != 0 )
                {
                    pView->MarkObj( pUpGroup, pPV );
                    pView->EnterMarkedGroup();
                }

                pView->MarkObj (pObj, pPV);
				pView->SetMarkHdlHidden(FALSE);
			}
		}
	}
}

/*************************************************************************
|*
|* Alle 3DCubes einzeln selektieren:
|*
\************************************************************************/

void SchFuPoor::Select3DGroupMembers( SdrObject *  pObj, SdrPageView *  pPV )
{
    // this currently does not work correctly, so it is disabled to be
    // consistent (it would otherwise work from time to time)
    return;

#if 0
 	pView->EnterMarkedGroup();
    pView->UnmarkAll();

    SdrObjListIter aIter( * pObj->GetSubList(), IM_FLAT );
    while( aIter.IsMore() )
    {
        SdrObject * pNextObj = aIter.Next();
        pView->MarkObj( pNextObj, pPV );
    }
#endif
}
