/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: tpscaley.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:17:35 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma optimize("",off)


#pragma hdrstop

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

// header for class Table
#ifndef _TOOLS_TABLE_HXX
#include <tools/table.hxx>
#endif
// header for class SvNumberformat
#ifndef _ZFORMAT_HXX
#ifndef _ZFORLIST_DECLARE_TABLE
#define _ZFORLIST_DECLARE_TABLE
#endif
#include <svtools/zformat.hxx>
#endif
// header for SvNumberFormatter
#ifndef _ZFORLIST_HXX
#include <svtools/zforlist.hxx>
#endif

#include "schattr.hxx"
#define ITEMID_DOUBLE	0
#ifndef _SVX_CHRTITEM_HXX //autogen
#include <svx/chrtitem.hxx>
#endif

#include "schresid.hxx"
#include "strings.hrc"
#include "chtmodel.hxx"
#include "attrib.hxx"
#include "tpscaley.hxx"
#include "tpscaley.hrc"

#include "chaxis.hxx"

#include <rtl/math.hxx>

/*************************************************************************
|*
|* Dialog zur Ausrichtung der Legende
|*
\************************************************************************/

SchScaleYAxisTabPage::SchScaleYAxisTabPage(Window* pWindow,const SfxItemSet& rInAttrs) :
	SfxTabPage(pWindow, SchResId(TP_SCALE_Y), rInAttrs),

	pMyModel (0),
	aFlScale(this, ResId(FL_SCALE_Y)),
	aTxtMin (this, ResId (TXT_MIN)),
	aFmtFldMin(this, ResId(EDT_MIN)),
	aCbxAutoMin(this, ResId(CBX_AUTO_MIN)),
	aTxtMax(this, ResId (TXT_MAX)),
	aFmtFldMax(this, ResId(EDT_MAX)),
	aCbxAutoMax(this, ResId(CBX_AUTO_MAX)),
	aTxtMain (this, ResId (TXT_STEP_MAIN)),
	aFmtFldStepMain(this, ResId(EDT_STEP_MAIN)),
	aCbxAutoStepMain(this, ResId(CBX_AUTO_STEP_MAIN)),
	aTxtHelp (this, ResId (TXT_STEP_HELP)),
	aFmtFldStepHelp(this, ResId(EDT_STEP_HELP)),
	aCbxAutoStepHelp(this, ResId(CBX_AUTO_STEP_HELP)),
	aTxtOrigin (this, ResId (TXT_ORIGIN)),
	aFmtFldOrigin(this, ResId(EDT_ORIGIN)),
	aCbxAutoOrigin(this, ResId(CBX_AUTO_ORIGIN)),
	aCbxLogarithm(this, ResId(CBX_LOGARITHM)),

	aFlTicks(this,ResId(FL_TICKS)),
	aCbxTicksInner(this, ResId(CBX_TICKS_INNER)),
	aCbxTicksOuter(this, ResId(CBX_TICKS_OUTER)),

	aFlHelpTicks(this,ResId(FL_HELPTICKS)),
	aCbxHelpTicksInner(this, ResId(CBX_HELPTICKS_INNER)),
	aCbxHelpTicksOuter(this, ResId(CBX_HELPTICKS_OUTER)),

	fMin(0.0),
	fMax(0.0),
	fStepMain(0.0),
	fStepHelp(0.0),
	fOrigin(0.0),
	nAxisType(0),
	aMtStepHelp (this, ResId (MT_STEPHELP)),
	rOutAttrs(rInAttrs),
	pNumFormatter(NULL),
	bLastStepMain(FALSE)
{
	FreeResource();
	SetExchangeSupport();

	aCbxAutoMin.SetClickHdl(LINK(this, SchScaleYAxisTabPage, EnableValueHdl));
	aCbxAutoMax.SetClickHdl(LINK(this, SchScaleYAxisTabPage, EnableValueHdl));
	aCbxAutoStepMain.SetClickHdl(LINK(this, SchScaleYAxisTabPage, EnableValueHdl));
	aCbxAutoStepHelp.SetClickHdl(LINK(this, SchScaleYAxisTabPage, EnableValueHdl));
	aCbxAutoOrigin.SetClickHdl(LINK(this, SchScaleYAxisTabPage, EnableValueHdl));
	aCbxLogarithm.SetClickHdl(LINK(this, SchScaleYAxisTabPage, HandleLogs));
	const SfxPoolItem *pPoolItem = NULL;
	if (rInAttrs.GetItemState(SCHATTR_AXISTYPE, TRUE, &pPoolItem) == SFX_ITEM_SET)
		nAxisType = (int) ((const SfxInt32Item*)pPoolItem)->GetValue();
}

/*************************************************************************
|*
|*	Werte-Editierfelder je nach Checkbox-Markierung enablen/disablen
|*
*************************************************************************/

IMPL_LINK( SchScaleYAxisTabPage, EnableValueHdl, CheckBox *, pCbx )
{
	if (pCbx == &aCbxAutoMin)
	{
		aFmtFldMin.Enable(!aCbxAutoMin.IsChecked());
	}
	else if (pCbx == &aCbxAutoMax)
	{
		aFmtFldMax.Enable(!aCbxAutoMax.IsChecked());
	}
	else if (pCbx == &aCbxAutoStepMain)
	{
		aFmtFldStepMain.Enable(!aCbxAutoStepMain.IsChecked());
		bLastStepMain = aCbxAutoStepMain.IsChecked();
	}
	else if (pCbx == &aCbxAutoStepHelp)
	{
		if (aCbxLogarithm.IsChecked ())
		{
			aFmtFldStepHelp.Hide ();
			aMtStepHelp.Show ();
			aMtStepHelp.Enable(!aCbxAutoStepHelp.IsChecked());
		}
		else
		{
			aFmtFldStepHelp.Show ();
			aMtStepHelp.Hide ();
			aFmtFldStepHelp.Enable(!aCbxAutoStepHelp.IsChecked());
		}
	}
	else if (pCbx == &aCbxAutoOrigin)
	{
		aFmtFldOrigin.Enable(!aCbxAutoOrigin.IsChecked());
	}
	return 0;
}

/*************************************************************************
|*
|* Erzeugung
|*
\*************************************************************************/

SfxTabPage* SchScaleYAxisTabPage::Create(Window* pWindow,const SfxItemSet& rOutAttrs)
{
	return new SchScaleYAxisTabPage(pWindow, rOutAttrs);
}

/*************************************************************************
|*
|* Fuellt uebergebenen Item-Set mit Dialogbox-Attributen
|*
\*************************************************************************/

BOOL SchScaleYAxisTabPage::FillItemSet(SfxItemSet& rOutAttrs)
{
	DBG_ASSERT( pNumFormatter, "No NumberFormatter available" );

	long nTicks=0;
	long nHelpTicks=0;

	if(aCbxHelpTicksInner.IsChecked())
		nHelpTicks|=CHAXIS_MARK_INNER;
	if(aCbxHelpTicksOuter.IsChecked())
		nHelpTicks|=CHAXIS_MARK_OUTER;
	if(aCbxTicksInner.IsChecked())
		nTicks|=CHAXIS_MARK_INNER;
	if(aCbxTicksOuter.IsChecked())
		nTicks|=CHAXIS_MARK_OUTER;

	rOutAttrs.Put(SfxInt32Item(SCHATTR_AXIS_TICKS,nTicks));
	rOutAttrs.Put(SfxInt32Item(SCHATTR_AXIS_HELPTICKS,nHelpTicks));

	rOutAttrs.Put(SfxBoolItem(SCHATTR_AXIS_AUTO_MIN		 ,aCbxAutoMin.IsChecked()));
	rOutAttrs.Put(SfxBoolItem(SCHATTR_AXIS_AUTO_MAX		 ,aCbxAutoMax.IsChecked()));
	rOutAttrs.Put(SfxBoolItem(SCHATTR_AXIS_AUTO_STEP_HELP,aCbxAutoStepHelp.IsChecked()));
	rOutAttrs.Put(SfxBoolItem(SCHATTR_AXIS_AUTO_ORIGIN   ,aCbxAutoOrigin.IsChecked()));
	rOutAttrs.Put(SfxBoolItem(SCHATTR_AXIS_LOGARITHM     ,aCbxLogarithm.IsChecked()));
	rOutAttrs.Put(SvxDoubleItem(fMax	 , SCHATTR_AXIS_MAX));
	rOutAttrs.Put(SvxDoubleItem(fMin	 , SCHATTR_AXIS_MIN));
	rOutAttrs.Put(SvxDoubleItem(fStepHelp, SCHATTR_AXIS_STEP_HELP));
	rOutAttrs.Put(SvxDoubleItem(fOrigin	 , SCHATTR_AXIS_ORIGIN));

	rOutAttrs.Put(SfxBoolItem(SCHATTR_AXIS_AUTO_STEP_MAIN,aCbxAutoStepMain.IsChecked()));
	rOutAttrs.Put(SvxDoubleItem(fStepMain,SCHATTR_AXIS_STEP_MAIN));

	return TRUE;
}

/*************************************************************************
|*
|* Initialisierung
|*
\*************************************************************************/

void SchScaleYAxisTabPage::Reset(const SfxItemSet& rInAttrs)
{
	DBG_ASSERT( pNumFormatter, "No NumberFormatter available" );

	const SfxPoolItem *pPoolItem = NULL;

	long nTicks=0,nHelpTicks=0;
	if(rInAttrs.GetItemState(SCHATTR_AXIS_TICKS,TRUE, &pPoolItem)== SFX_ITEM_SET)
		nTicks=((const SfxInt32Item*)pPoolItem)->GetValue();
	if(rInAttrs.GetItemState(SCHATTR_AXIS_HELPTICKS,TRUE, &pPoolItem)== SFX_ITEM_SET)
		nHelpTicks=((const SfxInt32Item*)pPoolItem)->GetValue();

	aCbxHelpTicksInner.Check(nHelpTicks&CHAXIS_MARK_INNER);
	aCbxHelpTicksOuter.Check(nHelpTicks&CHAXIS_MARK_OUTER);
	aCbxTicksInner.Check(nTicks&CHAXIS_MARK_INNER);
	aCbxTicksOuter.Check(nTicks&CHAXIS_MARK_OUTER);

	if (rInAttrs.GetItemState(SCHATTR_AXIS_AUTO_MIN,TRUE,&pPoolItem) == SFX_ITEM_SET)
		aCbxAutoMin.Check(((const SfxBoolItem*)pPoolItem)->GetValue());

	if (rInAttrs.GetItemState(SCHATTR_AXIS_MIN,TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		fMin = ((const SvxDoubleItem*)pPoolItem)->GetValue();
		aFmtFldMin.SetValue( fMin );
	}

	if (rInAttrs.GetItemState(SCHATTR_AXIS_AUTO_MAX,TRUE, &pPoolItem) == SFX_ITEM_SET)
		aCbxAutoMax.Check(((const SfxBoolItem*)pPoolItem)->GetValue());

	if (rInAttrs.GetItemState(SCHATTR_AXIS_MAX,TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		fMax = ((const SvxDoubleItem*)pPoolItem)->GetValue();
		aFmtFldMax.SetValue( fMax );
	}

	if (rInAttrs.GetItemState(SCHATTR_AXIS_AUTO_STEP_MAIN,TRUE, &pPoolItem) == SFX_ITEM_SET)
		aCbxAutoStepMain.Check(((const SfxBoolItem*)pPoolItem)->GetValue());

	if (rInAttrs.GetItemState(SCHATTR_AXIS_STEP_MAIN,TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		fStepMain = ((const SvxDoubleItem*)pPoolItem)->GetValue();
		aFmtFldStepMain.SetValue( fStepMain );
	}
	if (rInAttrs.GetItemState(SCHATTR_AXIS_AUTO_STEP_HELP,TRUE, &pPoolItem) == SFX_ITEM_SET)
		aCbxAutoStepHelp.Check(((const SfxBoolItem*)pPoolItem)->GetValue());
	if (rInAttrs.GetItemState(SCHATTR_AXIS_LOGARITHM,TRUE, &pPoolItem) == SFX_ITEM_SET)
		aCbxLogarithm.Check(((const SfxBoolItem*)pPoolItem)->GetValue());
	if (rInAttrs.GetItemState(SCHATTR_AXIS_STEP_HELP,TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		fStepHelp = ((const SvxDoubleItem*)pPoolItem)->GetValue();
		if (aCbxLogarithm.IsChecked ()) aMtStepHelp.SetValue ((long) fStepHelp);
		else
		{
			aFmtFldStepHelp.SetValue( fStepHelp );
		}
	}
	if (rInAttrs.GetItemState(SCHATTR_AXIS_AUTO_ORIGIN,TRUE, &pPoolItem) == SFX_ITEM_SET)
		aCbxAutoOrigin.Check(((const SfxBoolItem*)pPoolItem)->GetValue());
	if (rInAttrs.GetItemState(SCHATTR_AXIS_ORIGIN,TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		fOrigin = ((const SvxDoubleItem*)pPoolItem)->GetValue();
		aFmtFldOrigin.SetValue( fOrigin );
	}

	EnableValueHdl(&aCbxAutoMin);
	EnableValueHdl(&aCbxAutoMax);
	EnableValueHdl(&aCbxAutoStepMain);
	EnableValueHdl(&aCbxAutoStepHelp);
	EnableValueHdl(&aCbxAutoOrigin);
	CheckLogControls ();
}

/*************************************************************************
|*
|* Prueft die eingegebenen Werte
|*
\*************************************************************************/

int SchScaleYAxisTabPage::DeactivatePage(SfxItemSet* pItemSet)
{
	ULONG nIndex = pNumFormatter->GetStandardIndex(LANGUAGE_SYSTEM);
	Edit* pEdit = NULL;
	USHORT nErrStrId = 0;
	double fDummy;

	CheckLogs ();
	fMax = aFmtFldMax.GetValue();
	fMin = aFmtFldMin.GetValue();
	fOrigin = aFmtFldOrigin.GetValue();
	fStepMain = aFmtFldStepMain.GetValue();
	fStepHelp = aFmtFldStepHelp.GetValue();

	// check for entries that cannot be parsed for the current number format
	if ( aFmtFldMin.IsModified()
		&& !aCbxAutoMin.IsChecked()
		&& !pNumFormatter->IsNumberFormat(aFmtFldMin.GetText(), nIndex, fDummy))
	{
		pEdit = &aFmtFldMin;
		nErrStrId = STR_INVALID_NUMBER;
	}
	else if (aFmtFldMax.IsModified() && !aCbxAutoMax.IsChecked() &&
			 !pNumFormatter->IsNumberFormat(aFmtFldMax.GetText(),
											nIndex, fDummy))
	{
		pEdit = &aFmtFldMax;
		nErrStrId = STR_INVALID_NUMBER;
	}
	else if (aFmtFldStepMain.IsModified() && !aCbxAutoStepMain.IsChecked() &&
			 !pNumFormatter->IsNumberFormat(aFmtFldStepMain.GetText(),
											nIndex, fDummy))
	{
		pEdit = &aFmtFldStepMain;
		nErrStrId = STR_INVALID_NUMBER;
	}
	else if (!GetHelpValue ())
	{
		pEdit = &aFmtFldStepHelp;
		nErrStrId = STR_INVALID_NUMBER;
	}
	else if (aFmtFldOrigin.IsModified() && !aCbxAutoOrigin.IsChecked() &&
			 !pNumFormatter->IsNumberFormat(aFmtFldOrigin.GetText(),
											nIndex, fDummy))
	{
		pEdit = &aFmtFldOrigin;
		nErrStrId = STR_INVALID_NUMBER;
	}
	// check for entries in invalid ranges
	else if (!aCbxAutoMax.IsChecked() && !aCbxAutoMin.IsChecked() &&
			 fMin >= fMax)
	{
		pEdit = &aFmtFldMin;
		nErrStrId = STR_MINVALUE_LT_MAXVALUE;
	}
	else if (!aCbxAutoStepMain.IsChecked() && fStepMain <= 0.0)
	{
		pEdit = &aFmtFldStepMain;
		nErrStrId = STR_STEP_GT_ZERO;
	}
	else if (!aCbxAutoStepHelp.IsChecked() && fStepHelp <= 0.0)
	{
		pEdit = &aFmtFldStepMain;
		nErrStrId = STR_STEP_GT_ZERO;
	}
	else if (!aCbxAutoStepMain.IsChecked() && fStepMain > fabs( fMax - fMin ))
	{
		pEdit = &aFmtFldStepMain;
		nErrStrId = STR_STEPMAIN_LT_MAXVALUE;
	}
	else if (!aCbxLogarithm.IsChecked () && !aCbxAutoStepHelp.IsChecked() && fStepHelp > fStepMain)
	{
		pEdit = &aFmtFldStepHelp;
		nErrStrId = STR_STEPHELP_LT_STEPMAIN;
	}
	else
	{
		if(( ! aCbxAutoMin.IsChecked() &&
			 fOrigin < fMin ) ||
		   ( ! aCbxAutoMax.IsChecked() &&
			 fMax < fOrigin ))
		{
			nErrStrId = STR_WRONG_ORIGIN;

			if( ! aCbxAutoOrigin.IsChecked ())
				pEdit = &aFmtFldOrigin;
			else if( ! aCbxAutoMin.IsChecked())
				pEdit = &aFmtFldMin;
			else
				pEdit = &aFmtFldMax;
		}
	}

	if( nErrStrId )
	{
		WarningBox( this, WinBits( WB_OK ), String( SchResId( nErrStrId ))).Execute();
		if( pEdit )
		{
			pEdit->GrabFocus();
			pEdit->SetSelection( Selection( 0, SELECTION_MAX ));
		}
		return KEEP_PAGE;
	}

	if( pItemSet )
		FillItemSet( *pItemSet );
	return LEAVE_PAGE;
}

/*************************************************************************
|*
|*	pruefe die eingaben fuer logarithmische werte
|*
*************************************************************************/

IMPL_LINK( SchScaleYAxisTabPage, HandleLogs, CheckBox *, pCbx )
{
	CheckLogs ();

	return 0;
}

/*************************************************************************
|*
|*	pruefe die eingaben fuer logarithmische werte
|*
*************************************************************************/

void SchScaleYAxisTabPage::CheckLogs ()
{
	ULONG  nIndex    = pNumFormatter->GetStandardIndex(LANGUAGE_SYSTEM);
	Edit   *pEdit    = NULL;
	USHORT nErrStrId = 0;
	String aNumStr;
	Color* pDummy    = NULL;
	double fDummy;

	CheckLogControls ();

	if (!aCbxAutoMin.IsChecked ())
	{
		fMin = aFmtFldMin.GetValue();
		if (!pNumFormatter->IsNumberFormat(aFmtFldMin.GetText(), nIndex, fDummy))
		{
			pEdit = &aFmtFldMin;
			nErrStrId = STR_INVALID_NUMBER;
		}
		else if (aCbxLogarithm.IsChecked ())
			 {
				 if (fMin > 1.0)
				 {
					 double fVal = 1.0;

					 while (fVal < fMin)
						 fVal *= 10.0;

					 if (fVal > fMin) fVal /= 10.0;
					 fMin = fVal;
				 }
				 else if (fMin > 0.0)
					  {
						  double fVal = 1.0;

						  while (fVal > fMin)
						  {
							  fVal /= 10.0;
							  if(::rtl::math::approxEqual(fVal,fMin))
								  fMin=fVal; //Double-Ungenauigkeiten (last-bits) ausgleichen
						  }

						  fMin = fVal;
					  }
					  else fMin = 1.0;

				 aFmtFldMin.SetValue( fMin );
			 }
	}
	
	if (!aCbxAutoMin.IsChecked ())
	{
		fMax = aFmtFldMax.GetValue();
		if( !pNumFormatter->IsNumberFormat(aFmtFldMax.GetText(), nIndex, fDummy))
		{
			pEdit = &aFmtFldMax;
			nErrStrId = STR_INVALID_NUMBER;
		}
		else if (aCbxLogarithm.IsChecked ())
			 {
				 if (fMax > 1.0)
				 {
					 double fVal = 1.0;

					 while (fVal < fMax)
						 fVal *= 10.0;

					 fMax = fVal;
				 }
				 else if (fMax > 0.0)
					  {
						  double fVal = 1.0;

						  while (fVal > fMax)
							  fVal /= 10.0;

						  if (fVal < fMax) fVal *= 10.0;
						  fMax = fVal;
					  }
					  else fMax = 1.0;

				 aFmtFldMax.SetValue( fMax );
			 }
	}

	BOOL bNewOrigin = FALSE;

	if (aCbxAutoOrigin.IsChecked())
	{
		if (fMax < 0.0)
		{
			fOrigin = fMax;
			bNewOrigin = TRUE;
		}
		if (fMin > 0.0)
		{
			fOrigin = fMin;
			bNewOrigin = TRUE;
		}
		if ((fMax >= 0.0) && (fMin <= 0.0))
		{
			fOrigin = 0.0;
			bNewOrigin = TRUE;
		}
	}

	if (aCbxLogarithm.IsChecked ())
	{
		fOrigin = fMin;
		bNewOrigin = TRUE;
	}

	if( bNewOrigin )
	{
        aFmtFldOrigin.SetValue( fOrigin );
	}

	if (nErrStrId)
	{
		WarningBox(this, WinBits(WB_OK), String(SchResId(nErrStrId))).Execute();
		pEdit->GrabFocus();
		pEdit->SetSelection(Selection(0, SELECTION_MAX));
	}
}

/*************************************************************************
|*
|*	pruefe die eingaben fuer logarithmische werte
|*
*************************************************************************/

void SchScaleYAxisTabPage::CheckLogControls ()
{
	double fDummy;

	if (aCbxLogarithm.IsChecked ())
	{
		ULONG nIndex = pNumFormatter->GetStandardIndex(LANGUAGE_SYSTEM);

		aFmtFldOrigin.Enable (FALSE);
		aCbxAutoOrigin.Enable (FALSE);
		aFmtFldStepMain.Enable (FALSE);
		bLastStepMain = aCbxAutoStepMain.IsChecked();
		aCbxAutoStepMain.Check();
		aCbxAutoStepMain.Enable (FALSE);
		aFmtFldStepHelp.Enable (FALSE);
		aFmtFldStepHelp.Hide ();
		aMtStepHelp.Show ();

		fMin = aFmtFldMin.GetValue();
		if (pNumFormatter->IsNumberFormat(aFmtFldMin.GetText(), nIndex, fDummy ))
			if (fMin <= 0.0)
			{
				aFmtFldMin.SetValue( 1.0 );
			}

		aMtStepHelp.Enable (!aCbxAutoStepHelp.IsChecked ());
	}
	else
	{
		aCbxAutoStepMain.Check( bLastStepMain );

		aCbxAutoOrigin.Enable (TRUE);
		aFmtFldOrigin.Enable (!aCbxAutoOrigin.IsChecked ());

		aCbxAutoStepMain.Enable (TRUE);
		aFmtFldStepMain.Enable (!aCbxAutoStepMain.IsChecked ());

		aFmtFldStepHelp.Enable (!aCbxAutoStepHelp.IsChecked ());

		aFmtFldStepHelp.Show ();
		aMtStepHelp.Hide ();
	}
}

/*************************************************************************
|*
|*	pruefe die eingaben fuer logarithmische werte
|*
*************************************************************************/

BOOL SchScaleYAxisTabPage::GetHelpValue ()
{
	if (aCbxLogarithm.IsChecked ())
	{
		if (!aCbxAutoStepHelp.IsChecked()) fStepHelp = aMtStepHelp.GetValue ();

		return TRUE;
	}
	else
	{
		ULONG nIndex = pNumFormatter->GetStandardIndex(LANGUAGE_SYSTEM);
		double fDummy;

		fStepHelp = aFmtFldStepHelp.GetValue();
		return !(aFmtFldStepHelp.IsModified() && !aCbxAutoStepHelp.IsChecked() &&
				 !pNumFormatter->IsNumberFormat(aFmtFldStepHelp.GetText(),
												nIndex, fDummy));
	}
}

void SchScaleYAxisTabPage::SetNumFormatter( SvNumberFormatter* pFormatter )
{
	pNumFormatter = pFormatter;
	aFmtFldMax.SetFormatter( pNumFormatter );
	aFmtFldMin.SetFormatter( pNumFormatter );
	aFmtFldStepMain.SetFormatter( pNumFormatter );
	aFmtFldStepHelp.SetFormatter( pNumFormatter );
	aFmtFldOrigin.SetFormatter( pNumFormatter );
	SetNumFormat();
}

void SchScaleYAxisTabPage::SetNumFormat()
{
    DBG_ASSERT( pNumFormatter, "No Number Formatter" );
    if( ! pNumFormatter )
        return;
	const SfxPoolItem *pPoolItem = NULL;

	if( rOutAttrs.GetItemState( SCHATTR_AXIS_NUMFMT, TRUE, &pPoolItem ) == SFX_ITEM_SET )
	{
		ULONG nFmt = (ULONG)((const SfxInt32Item*)pPoolItem)->GetValue();
		short eType = pNumFormatter->GetType( nFmt );
        USHORT nDigits = pNumFormatter->GetFormatPrecision( nFmt );

		// change nFmt to an editable format (without loss of information)
		if( eType == NUMBERFORMAT_CURRENCY )	// for currencies just display decimals
		{
			nFmt = pNumFormatter->GetStandardIndex();
		}
		else
		{
			const SvNumberformat* pFormat = pNumFormatter->GetEntry( nFmt );
			if( pFormat )
			{
				LanguageType eLanguage = pFormat->GetLanguage();
				nFmt = pNumFormatter->GetStandardFormat( nFmt, eType, eLanguage );
			}
			// else: format is 'standard'
		}

        // #i16487# use precision of current numberformat for all fields
        aFmtFldMax.SetFormatKey( nFmt );
        aFmtFldMax.SetDecimalDigits( nDigits );
		aFmtFldMin.SetFormatKey( nFmt );
        aFmtFldMin.SetDecimalDigits( nDigits );
		aFmtFldOrigin.SetFormatKey( nFmt );
        aFmtFldOrigin.SetDecimalDigits( nDigits );

		// for steps use standard format if date or time format is chosen
		if( pNumFormatter &&
			( eType == NUMBERFORMAT_DATE ||
			  eType == NUMBERFORMAT_TIME ||
			  eType == NUMBERFORMAT_DATETIME ) )
		{
			nFmt = pNumFormatter->GetStandardIndex();
		}

        // take one digit more for the precision in step-fields
        if( nDigits < 15 )
            ++nDigits;

		aFmtFldStepMain.SetFormatKey( nFmt );
        aFmtFldStepMain.SetDecimalDigits( nDigits );
		aFmtFldStepHelp.SetFormatKey( nFmt );
        aFmtFldStepHelp.SetDecimalDigits( nDigits );
	}
}



