/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: _CharacterPropertiesAsian.java,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 01:01:04 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package ifc.style;

import lib.MultiPropertyTest;

import com.sun.star.awt.FontSlant;
import com.sun.star.awt.FontWeight;

/**
* Testing <code>com.sun.star.style.CharacterPropertiesAsian</code>
* service properties :
* <ul>
*  <li><code> CharHeightAsian</code></li>
*  <li><code> CharWeightAsian</code></li>
*  <li><code> CharFontNameAsian</code></li>
*  <li><code> CharFontStyleNameAsian</code></li>
*  <li><code> CharFontFamilyAsian</code></li>
*  <li><code> CharFontCharSetAsian</code></li>
*  <li><code> CharFontPitchAsian</code></li>
*  <li><code> CharPostureAsian</code></li>
*  <li><code> CharLocaleAsian</code></li>
*  <li><code> ParaIsCharacterDistance</code></li>
*  <li><code> ParaIsForbiddenRules</code></li>
*  <li><code> ParaIsHangingPunctuation</code></li>
* </ul> <p>
* Properties testing is automated by <code>lib.MultiPropertyTest</code>.
* @see com.sun.star.style.CharacterPropertiesAsian
*/
public class _CharacterPropertiesAsian extends MultiPropertyTest {

    public void _CharPostureAsian() {
        testProperty("CharPostureAsian", FontSlant.NONE, FontSlant.ITALIC);
    }

    public void _CharWeightAsian() {
        testProperty("CharWeightAsian", new Float(FontWeight.NORMAL),
            new Float(FontWeight.BOLD));
    }

    public void _ParaIsCharacterDistance() {
        testProperty("ParaIsCharacterDistance", Boolean.TRUE, Boolean.FALSE);
    }

    public void _ParaIsForbiddenRules() {
        testProperty("ParaIsForbiddenRules", Boolean.TRUE, Boolean.FALSE);
    }

    public void _ParaIsHangingPunctuation() {
        testProperty("ParaIsHangingPunctuation", Boolean.TRUE, Boolean.FALSE);
    }
} //finish class _CharacterPropertiesAsian
