
package org.netbeans.modules.openoffice.wizard.nodes;

import java.beans.FeatureDescriptor;
import org.netbeans.modules.openoffice.*;
import org.netbeans.modules.openoffice.wizard.panels.idl.BasePanel;
import org.netbeans.modules.openoffice.wizard.panels.idl.*;
import org.netbeans.modules.openoffice.wizard.keys.*;
import org.openide.nodes.*;
import java.util.Vector;
import java.util.StringTokenizer;


public class StructNode extends SENode
{

    public StructNode(NameKey namedkey)
    {
        super(namedkey);
        setName(namedkey.getName());
        setIconBase("org/netbeans/modules/openoffice/wizard/ui/struct");
    }

    public String generateSelf(int i)
    {
        String s = new String();
        String s1 = new String();
        for(int j = 0; j < i; j++)
            s1 = s1 + "    ";

        s = s1 + "struct " + getName() + " ";
                if(((StructKey)key).getbaseInterfaces().length() > 0)
            s = s + ": " + ((StructKey)key).getbaseInterfaces() + " ";
        s = s + "{\n";

        Node anode[] = getChildren().getNodes();
        for(int k = 0; k < anode.length; k++)
            s = s + ((BaseNode)anode[k]).generateSelf(i + 1);

        s = s + s1 + "};\n";
        return s;
    }

    public BasePanel getEditPanel()
    {
        ModuleCreatePanel modulepanel = new ModuleCreatePanel();
        modulepanel.setName(getName());
        return modulepanel;
    }

    public void reInit(BasePanel BasePanel)
    {
        if(BasePanel instanceof ModuleCreatePanel)
        {
            String s = ((ModuleCreatePanel)BasePanel).getName();
            if(!key.getName().equals(s))
            {
                key.setName(s);
                setName(s);
            }
        }
    }

    public void generateImports(Vector Imports1)
    {  StringTokenizer st = new StringTokenizer(((StructKey)key).getbaseInterfaces(),","); 
        while (st.hasMoreTokens())
        {    
                String Import = OOTools.replaceSubStrings(st.nextToken().trim(),"::", "/");
                if((Import.length() > 0) && (!Imports1.contains(Import)))
                 { 
                   Imports1.add(Import);
                 }  
        } 
                    
        Node anode[] = getChildren().getNodes();
        for(int l = 0; l < anode.length; l++)
        {
            ((BaseNode)anode[l]).generateImports(Imports1);
            
        }  
    }        
 
    
    private static final String ICON_BASE = "org/netbeans/modules/openoffice/wizard/ui/struct";
}
