

package org.netbeans.modules.openoffice.wizard.actions.idl;

import java.beans.FeatureDescriptor;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class DestroyAction extends NodeAction {
    
    public DestroyAction() {
    }
    
    public void performAction( Node anode[] ) {
        if ( enable( anode ) ) {
            TopManager topmanager = TopManager.getDefault();
            org.openide.NotifyDescriptor.Confirmation confirmation =
            new org.openide.NotifyDescriptor.Confirmation(
            MessageFormat.format(
            ResourceBundle.getBundle(
            "org/netbeans/modules/openoffice/wizard/actions/idl/Bundle").getString(
            "MSG_Destroy"), new Object[] {
                anode[0].getName()
            }), 2);
            topmanager.notify(confirmation);
            if(confirmation.getValue() == NotifyDescriptor.CANCEL_OPTION) {
                return;
            }
            if(anode[0].canDestroy())
                try {
                    anode[0].destroy();
                }
                catch(IOException ioexception) {}
        }
    }
    
    public boolean enable(Node anode[]) {
        return anode.length == 1;
    }
    
    public String getName() {
        return ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/actions/Bundle").getString("TXT_Destroy");
    }
    
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}
