/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ntprophelp.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 19:44:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <linguistic/misc.hxx>

#include "ntprophelp.hxx"
#include <linguistic/lngprops.hxx>

#ifndef _TOOLS_DEBUG_HXX //autogen wg. DBG_ASSERT
#include <tools/debug.hxx>
#endif

#include <com/sun/star/linguistic2/LinguServiceEvent.hpp>
#include <com/sun/star/linguistic2/LinguServiceEventFlags.hpp>
#include <com/sun/star/linguistic2/XLinguServiceEventListener.hpp>

#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

//using namespace utl;
using namespace osl;
using namespace rtl;
using namespace com::sun::star;
using namespace com::sun::star::beans;
using namespace com::sun::star::lang;
using namespace com::sun::star::uno;
using namespace com::sun::star::linguistic2;
using namespace linguistic;


#define A2OU(x)	::rtl::OUString::createFromAscii( x )

///////////////////////////////////////////////////////////////////////////

	
PropertyChgHelper::PropertyChgHelper(
		const Reference< XInterface > & rxSource,
		Reference< XPropertySet > &rxPropSet,
		const char *pPropNames[], USHORT nPropCount ) :
	xMyEvtObj			(rxSource),
	xPropSet			(rxPropSet),
	aPropNames			(nPropCount),
	aLngSvcEvtListeners	(GetLinguMutex())
{
	OUString *pName = aPropNames.getArray();
	for (INT32 i = 0;  i < nPropCount;  ++i)
	{
		pName[i] = A2OU( pPropNames[i] );
	}
}


PropertyChgHelper::PropertyChgHelper( const PropertyChgHelper &rHelper ) :
	aLngSvcEvtListeners	(GetLinguMutex())
{
	xPropSet	= rHelper.xPropSet;
	aPropNames	= rHelper.aPropNames;
	AddAsPropListener();
	
	xMyEvtObj	= rHelper.xMyEvtObj;
}


PropertyChgHelper::~PropertyChgHelper()
{	
}


void PropertyChgHelper::AddAsPropListener()
{
	if (xPropSet.is())
	{
		INT32 nLen = aPropNames.getLength();
		const OUString *pPropName = aPropNames.getConstArray();
		for (INT32 i = 0;  i < nLen;  ++i)
		{
			if (pPropName[i].getLength())
				xPropSet->addPropertyChangeListener( pPropName[i], this );
		}
	}
}

void PropertyChgHelper::RemoveAsPropListener()
{
	if (xPropSet.is())
	{
		INT32 nLen = aPropNames.getLength();
		const OUString *pPropName = aPropNames.getConstArray();
		for (INT32 i = 0;  i < nLen;  ++i)
		{
			if (pPropName[i].getLength())
				xPropSet->removePropertyChangeListener( pPropName[i], this );
		}
	}
}
		 

void PropertyChgHelper::LaunchEvent( const LinguServiceEvent &rEvt )
{
	cppu::OInterfaceIteratorHelper aIt( aLngSvcEvtListeners );
	while (aIt.hasMoreElements())
	{
		Reference< XLinguServiceEventListener > xRef( aIt.next(), UNO_QUERY );
		if (xRef.is())
			xRef->processLinguServiceEvent( rEvt );
	}
}


void SAL_CALL PropertyChgHelper::disposing( const EventObject& rSource ) 
		throw(RuntimeException)
{
	MutexGuard	aGuard( GetLinguMutex() );
	if (rSource.Source == xPropSet)
	{
		RemoveAsPropListener();
		xPropSet = NULL;
		aPropNames.realloc( 0 );
	}
}
    
	
sal_Bool SAL_CALL 
	PropertyChgHelper::addLinguServiceEventListener( 
			const Reference< XLinguServiceEventListener >& rxListener ) 
		throw(RuntimeException)
{
	MutexGuard	aGuard( GetLinguMutex() );
	
	BOOL bRes = FALSE;
	if (rxListener.is())
	{
		INT32	nCount = aLngSvcEvtListeners.getLength();
		bRes = aLngSvcEvtListeners.addInterface( rxListener ) != nCount;
	}
	return bRes;
}


sal_Bool SAL_CALL 
	PropertyChgHelper::removeLinguServiceEventListener( 
			const Reference< XLinguServiceEventListener >& rxListener ) 
		throw(RuntimeException)
{
	MutexGuard	aGuard( GetLinguMutex() );
	
	BOOL bRes = FALSE;
	if (rxListener.is())
	{
		INT32	nCount = aLngSvcEvtListeners.getLength();
		bRes = aLngSvcEvtListeners.removeInterface( rxListener ) != nCount;
	}
	return bRes;
}

///////////////////////////////////////////////////////////////////////////

static const char *aSP[] =
{
	UPN_IS_GERMAN_PRE_REFORM,
	UPN_IS_IGNORE_CONTROL_CHARACTERS,
	UPN_IS_USE_DICTIONARY_LIST,
};


PropertyHelper_Thes::PropertyHelper_Thes(
		const Reference< XInterface > & rxSource,
		Reference< XPropertySet > &rxPropSet ) :
	PropertyChgHelper	( rxSource, rxPropSet, aSP, sizeof(aSP) / sizeof(aSP[0]) )
{
	SetDefault();
	INT32 nLen = GetPropNames().getLength();
	if (rxPropSet.is() && nLen)
	{
		const OUString *pPropName = GetPropNames().getConstArray();
		for (INT32 i = 0;  i < nLen;  ++i)
		{
			BOOL *pbVal		= NULL,
				 *pbResVal	= NULL;

			if (A2OU( UPN_IS_GERMAN_PRE_REFORM ) == pPropName[i])
			{
				pbVal	 = &bIsGermanPreReform;
				pbResVal = &bResIsGermanPreReform;
			}
                        else if (A2OU( UPN_IS_IGNORE_CONTROL_CHARACTERS ) == pPropName[i])
                        {
                                pbVal    = &bIsIgnoreControlCharacters;
                                pbResVal = &bResIsIgnoreControlCharacters;
                        }
                        else if (A2OU( UPN_IS_USE_DICTIONARY_LIST ) == pPropName[i])
                        {
                                pbVal    = &bIsUseDictionaryList;
                                pbResVal = &bResIsUseDictionaryList;
                        }
			if (pbVal && pbResVal)
			{
				rxPropSet->getPropertyValue( pPropName[i] ) >>= *pbVal;
				*pbResVal = *pbVal;
			}
		}
	}
}


PropertyHelper_Thes::~PropertyHelper_Thes()
{
}


void PropertyHelper_Thes::SetDefault()
{
	bResIsGermanPreReform			= bIsGermanPreReform			= FALSE;
	bResIsIgnoreControlCharacters	= bIsIgnoreControlCharacters	= TRUE;
	bResIsUseDictionaryList			= bIsUseDictionaryList			= TRUE;
}


void SAL_CALL 
	PropertyHelper_Thes::propertyChange( const PropertyChangeEvent& rEvt ) 
		throw(RuntimeException)
{
	MutexGuard	aGuard( GetLinguMutex() );

	if (GetPropSet().is()  &&  rEvt.Source == GetPropSet())
	{
		INT16 nLngSvcFlags = 0;
		BOOL bSCWA = FALSE,	// SPELL_CORRECT_WORDS_AGAIN ?
			 bSWWA = FALSE;	// SPELL_WRONG_WORDS_AGAIN ?

		BOOL *pbVal = NULL;
		switch (rEvt.PropertyHandle)
		{
			case UPH_IS_IGNORE_CONTROL_CHARACTERS :
			{
				pbVal = &bIsIgnoreControlCharacters; 
				break;
			}
			case UPH_IS_GERMAN_PRE_REFORM		  :
			{
				pbVal = &bIsGermanPreReform; 
				bSCWA = bSWWA = TRUE;
				break;
			}
			case UPH_IS_USE_DICTIONARY_LIST		  :
			{
				pbVal = &bIsUseDictionaryList; 
				bSCWA = bSWWA = TRUE;
				break;
			}
			default:
				DBG_ERROR( "unknown property" );
		}
		if (pbVal)
			rEvt.NewValue >>= *pbVal;

		if (bSCWA)
			nLngSvcFlags |= LinguServiceEventFlags::SPELL_CORRECT_WORDS_AGAIN;
		if (bSWWA)
			nLngSvcFlags |= LinguServiceEventFlags::SPELL_WRONG_WORDS_AGAIN;
		if (nLngSvcFlags)
		{
			LinguServiceEvent aEvt( GetEvtObj(), nLngSvcFlags );
			LaunchEvent( aEvt );
		}
	}
}

		  
void PropertyHelper_Thes::SetTmpPropVals( const PropertyValues &rPropVals )
{
	// set return value to default value unless there is an 
	// explicitly supplied temporary value
	bResIsGermanPreReform			= bIsGermanPreReform;
	bResIsIgnoreControlCharacters	= bIsIgnoreControlCharacters;
	bResIsUseDictionaryList			= bIsUseDictionaryList;

	//
	INT32 nLen = rPropVals.getLength();
	if (nLen)
	{
		const PropertyValue *pVal = rPropVals.getConstArray();
		for (INT32 i = 0;  i < nLen;  ++i)
		{
			BOOL *pbResVal = NULL;
			switch (pVal[i].Handle)
			{
				case UPH_IS_GERMAN_PRE_REFORM		  : pbResVal = &bResIsGermanPreReform; break;
				case UPH_IS_IGNORE_CONTROL_CHARACTERS : pbResVal = &bResIsIgnoreControlCharacters; break;
				case UPH_IS_USE_DICTIONARY_LIST		  : pbResVal = &bResIsUseDictionaryList; break;
				default:
					DBG_ERROR( "unknown property" );
			}
			if (pbResVal)
				pVal[i].Value >>= *pbResVal;
		}
	}
}

///////////////////////////////////////////////////////////////////////////
