/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: eventsdocumenthandler.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:52:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef __FRAMEWORK_XML_EVENTSDOCUMENTHANDLER_HXX_
#define __FRAMEWORK_XML_EVENTSDOCUMENTHANDLER_HXX_

#ifndef __FRAMEWORK_XML_TOOLBOXCONFIGURATION_HXX_
#include <xml/eventsconfiguration.hxx>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef __COM_SUN_STAR_XML_SAX_XDOCUMENTHANDLER_HPP_
#include <com/sun/star/xml/sax/XDocumentHandler.hpp>
#endif

//_________________________________________________________________________________________________________________
//	other includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_THREADHELP_THREADHELPBASE_HXX_
#include <threadhelp/threadhelpbase.hxx>
#endif

#ifndef _RTL_USTRING_
#include <rtl/ustring.hxx>
#endif

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#include <hash_map>

#ifndef __FRAMEWORK_STDTYPES_H_
#include <stdtypes.h>
#endif

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

//*****************************************************************************************************************
// Hash code function for using in all hash maps of follow implementation.

class OReadEventsDocumentHandler :	public ::com::sun::star::xml::sax::XDocumentHandler,
									private ThreadHelpBase,	// Struct for right initalization of lock member! Must be first of baseclasses.
									public ::cppu::OWeakObject
{
	public:
		enum Events_XML_Entry
		{
			EV_ELEMENT_EVENTS,
			EV_ELEMENT_EVENT,
			EV_ATTRIBUTE_TYPE,
			EV_ATTRIBUTE_NAME,
			XL_ATTRIBUTE_HREF,
			XL_ATTRIBUTE_TYPE,
			EV_ATTRIBUTE_MACRONAME,
			EV_ATTRIBUTE_LIBRARY,
			EV_XML_ENTRY_COUNT
		};

		enum Event_XML_Namespace
		{
			EV_NS_EVENT,
			EV_NS_XLINK,
			EV_XML_NAMESPACES_COUNT
		};
		
		OReadEventsDocumentHandler( EventsConfig& aItems );
		virtual ~OReadEventsDocumentHandler();

		// XInterface
		virtual void SAL_CALL acquire() throw()
			{ OWeakObject::acquire(); }
		virtual void SAL_CALL release() throw()
			{ OWeakObject::release(); }
		virtual ::com::sun::star::uno::Any SAL_CALL queryInterface(
			const ::com::sun::star::uno::Type & rType ) throw( ::com::sun::star::uno::RuntimeException );

		// XDocumentHandler
		virtual void SAL_CALL startDocument(void)
		throw (	::com::sun::star::xml::sax::SAXException,
				::com::sun::star::uno::RuntimeException );

		virtual void SAL_CALL endDocument(void)
		throw(	::com::sun::star::xml::sax::SAXException,
				::com::sun::star::uno::RuntimeException );

		virtual void SAL_CALL startElement(
			const rtl::OUString& aName,
			const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XAttributeList > &xAttribs)
		throw(	::com::sun::star::xml::sax::SAXException,
				::com::sun::star::uno::RuntimeException );

		virtual void SAL_CALL endElement(const rtl::OUString& aName)
		throw(	::com::sun::star::xml::sax::SAXException,
				::com::sun::star::uno::RuntimeException );

		virtual void SAL_CALL characters(const rtl::OUString& aChars)
		throw(	::com::sun::star::xml::sax::SAXException,
				::com::sun::star::uno::RuntimeException );

		virtual void SAL_CALL ignorableWhitespace(const rtl::OUString& aWhitespaces)
		throw(	::com::sun::star::xml::sax::SAXException,
				::com::sun::star::uno::RuntimeException );

		virtual void SAL_CALL processingInstruction(const rtl::OUString& aTarget,
													const rtl::OUString& aData)
		throw(	::com::sun::star::xml::sax::SAXException,
				::com::sun::star::uno::RuntimeException );

		virtual void SAL_CALL setDocumentLocator(
			const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XLocator > &xLocator)
		throw(	::com::sun::star::xml::sax::SAXException,
				::com::sun::star::uno::RuntimeException );

	private:
		::rtl::OUString getErrorLineString();

		class EventsHashMap : public ::std::hash_map<	::rtl::OUString					,
														Events_XML_Entry				,
														OUStringHashCode				,
														::std::equal_to< ::rtl::OUString >	>
		{
			public:
				inline void free()
				{
					EventsHashMap().swap( *this );
				}
		};

		sal_Bool																	m_bEventsStartFound;
		sal_Bool																	m_bEventsEndFound;
		sal_Bool																	m_bEventStartFound;
		EventsHashMap																m_aEventsMap;
		EventsConfig&																m_aEventItems;
		::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XLocator >	m_xLocator;
};

class OWriteEventsDocumentHandler : private ThreadHelpBase // Struct for right initalization of lock member! Must be first of baseclasses.
{
	public:
		OWriteEventsDocumentHandler(
			const EventsConfig& aItems,
			::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XDocumentHandler > );
		virtual ~OWriteEventsDocumentHandler();

		void WriteEventsDocument() throw
			( ::com::sun::star::xml::sax::SAXException,
			  ::com::sun::star::uno::RuntimeException );
	
	protected:
		virtual void WriteEvent( 
				const ::rtl::OUString& aEventName, 
				const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& aPropertyValue ) throw
			( ::com::sun::star::xml::sax::SAXException,
			  ::com::sun::star::uno::RuntimeException );

		const EventsConfig&																	m_aItems;
		::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XDocumentHandler >	m_xWriteDocumentHandler;
		::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XAttributeList >		m_xEmptyList;
		::rtl::OUString																		m_aXMLEventNS;
		::rtl::OUString																		m_aXMLXlinkNS;
		::rtl::OUString																		m_aAttributeType;
		::rtl::OUString																		m_aAttributeURL;
		::rtl::OUString																		m_aAttributeLanguage;
		::rtl::OUString																		m_aAttributeLinkType;
		::rtl::OUString																		m_aAttributeMacroName;
		::rtl::OUString																		m_aAttributeLibrary;
		::rtl::OUString																		m_aAttributeName;
};

} // namespace framework

#endif
