/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: protdlg.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 19:37:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef PROTDLGS_HXX
#define PROTDLGS_HXX

#ifndef _LINK_HXX //autogen
#include <tools/link.hxx>
#endif

#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif

#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif

#ifndef _SV_DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif

#ifndef _SVX_CHECKLBX_HXX //autogen
#include <svx/checklbx.hxx>
#endif

#ifndef _SV_CTRL_HXX //autogen
#include <vcl/ctrl.hxx>
#endif

#ifndef _SV_WINDOW_HXX //autogen
#include <vcl/window.hxx>
#endif

#ifndef _TOOLS_RESMGR_HXX //autogen
#include <tools/resmgr.hxx>
#endif

#ifndef _SV_GROUP_HXX //autogen
#include <vcl/group.hxx>
#endif

#ifndef _SV_GEN_HXX //autogen
#include <tools/gen.hxx>
#endif

/*
#ifndef _SMART_COM_SUN_STAR_INSTALLATION_XPROTOCOLHANDLERCHECK_HXX_
#include <smart/com/sun/star/installation/XProtocolHandlerCheck.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_INSTALLATION_PROTOCOLS_HXX_
#include <smart/com/sun/star/installation/protocols.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_INSTALLATION_PROTDLGRES_HXX_
#include <smart/com/sun/star/installation/ProtDlgRes.hxx>
#endif
*/

#define protCount 5

class DetailsButton : public PushButton
{
private:
    BOOL mbExpanded;
public:
    DetailsButton(Window* pParent, const ResId& rResId);
    virtual void Click();
};

class ToggleButton : public RadioButton
{
public:
    ToggleButton(Window* pParent, const ResId& rResId);
    virtual void Click();
};

class ProtocolsSelectionDialog : public ModalDialog
{
private:
    GroupBox maRadioGroup;
    OKButton maOK;
    CancelButton maCancel;
//  HelpButton maHelp;     #65702#
    DetailsButton maDetails;
    String maNoDetails;
    String maDetailsStr;
    Size maExpanded;
public:
    GroupBox maListGroup;
    ToggleButton maStar, maOther;
    SvxCheckListBox maSelection;
    String maHttp;
    String maFtp;
    String maHttps;
    String maMail;
    String maNews;
    Size maNormal;
    CheckBox maPerform;
    int mnInitMask, mnMask;
    ProtocolsSelectionDialog(Window* pParent, ResMgr* pResMgr);
    ~ProtocolsSelectionDialog();
    void resize(BOOL expanded);
};

#endif
