/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dsntypes.hxx,v $
 *
 *  $Revision: 1.18 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 15:54:00 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _DBAUI_DSNTYPES_HXX_
#define _DBAUI_DSNTYPES_HXX_

#ifndef _SFXPOOLITEM_HXX
#include <svtools/poolitem.hxx>
#endif
#ifndef _COMPHELPER_STLTYPES_HXX_
#include <comphelper/stl_types.hxx>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

//.........................................................................
namespace dbaui
{
//.........................................................................

//=========================================================================
//= DATASOURCE_TYPE
//=========================================================================
/// known datasource types
enum DATASOURCE_TYPE
{
	DST_MYSQL_ODBC	=	1,	
	DST_MYSQL_JDBC	=	2,	
	DST_ADABAS		=	3,	
	DST_ORACLE_JDBC	=	4,	
	DST_JDBC		=	5,
	DST_ODBC		=	6,	
	DST_DBASE		=	7,	
	DST_MSACCESS	=	8,	
	DST_ADO			=	9,	
	DST_FLAT		=	10,
	DST_CALC		=	11,	
	DST_MOZILLA		=	12,	
	DST_LDAP		=	13,	
	DST_OUTLOOK		=	14,	
	DST_OUTLOOKEXP	=	15,	
	DST_EVOLUTION	=	16,
	DST_EMBEDDED	=	17,
 	DST_THUNDERBIRD	=	18,	

	DST_USERDEFINE1,	/// first user defined driver
	DST_USERDEFINE2,
	DST_USERDEFINE3,
	DST_USERDEFINE4,
	DST_USERDEFINE5,
	DST_USERDEFINE6,
	DST_USERDEFINE7,
	DST_USERDEFINE8,
	DST_USERDEFINE9,
	DST_USERDEFINE10,


	DST_UNKNOWN			/// unrecognized type 
};


//=========================================================================
//= ODsnTypeCollection
//=========================================================================
class ODsnTypeCollection
{
protected:
	DECLARE_STL_VECTOR(String, StringVector);
	DECLARE_STL_VECTOR(DATASOURCE_TYPE, TypeVector);
	typedef ::std::map<DATASOURCE_TYPE,DATASOURCE_TYPE> TRelatedTypes;

	StringVector	m_aDsnTypesDisplayNames;	/// user readable names for the datasource types
	StringVector	m_aDsnPrefixes;				/// DSN prefixes which determine the type of a datasource
	TypeVector		m_aDsnTypes;				/// types of datasources we know
	StringVector	m_aUserExtensions;			/// extensions of user defined types

#ifdef DBG_UTIL
	sal_Int32		m_nLivingIterators;			/// just for debugging reasons, counts the living iterators
#endif

public:
	class TypeIterator;
	friend class ODsnTypeCollection::TypeIterator;

	ODsnTypeCollection();
	~ODsnTypeCollection();

	/// get the datasource type from a DSN string
	DATASOURCE_TYPE	getType(const String& _rDsn) const;

	/// get the datasource type display name from a DSN string
	String getTypeDisplayName(const String& _rDsn) const;

	/// get the datasource type display name from a DSN string
	String getTypeDisplayName(DATASOURCE_TYPE _eType) const;

	/// the the DSN prefix associated with a given type
	String getDatasourcePrefix(DATASOURCE_TYPE _eType) const;

	/// returns the extension of the user defined type
	String getTypeExtension(DATASOURCE_TYPE _eType) const;

	/// on a given string, cut the type prefix and return the result
	String cutPrefix(const String& _rDsn) const;

	void extractHostNamePort(const String& _rDsn,String& _sDatabaseName,String& _rHostname,sal_Int32& _nPortNumber) const;

	/// check if the given data source type needs authentication
	sal_Bool hasAuthentication(DATASOURCE_TYPE _eType) const;

	/// check if the given data source allows creation of tables
    sal_Bool supportsTableCreation(DATASOURCE_TYPE _eType);
    
    // check if a Browse button may be shown to insert connection url
    sal_Bool supportsBrowsing(DATASOURCE_TYPE _eType);

	/// check if the given data source tyoe is based on the file system - i.e. the URL is a prefix plus a file URL
	sal_Bool isFileSystemBased(DATASOURCE_TYPE _eType) const;

	/// returns the data source type which should be used as embedded database.
	DATASOURCE_TYPE getEmbeddedDatabaseType(const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxORB) const;

	/// returns the URL which should be used as embedded database.
	::rtl::OUString getEmbeddedDatabaseURL(const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxORB) const;

	/// returns the UIName for the embedded database
	::rtl::OUString getEmbeddedDatabaseUIName(const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxORB) const;

	/// returns the settings for the embedded database.
	::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue> getEmbeddedDatabaseProperties(const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxORB) const;

	/// get access to the first element of the types collection
	TypeIterator	begin() const;
	/// get access to the (last + 1st) element of the types collection
	TypeIterator	end() const;

	/** read all user defined driver types.
		@param	_rxORB
			The service factory
	*/
	void initUserDriverTypes(const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxORB);

protected:
	/// return the connection type a DSN string represents
	DATASOURCE_TYPE implDetermineType(const String& _rDsn) const;

	/// return the index within the internal structures for the connection type a DSN string represents
	sal_Int32 implDetermineTypeIndex(const String& _rDsn) const;

	/// return the index within the internal structures for the connection type given
	sal_Int32 implDetermineTypeIndex(DATASOURCE_TYPE _eType) const;
};

//-------------------------------------------------------------------------
//- ODsnTypeCollection::TypeIterator
//-------------------------------------------------------------------------
class ODsnTypeCollection::TypeIterator
{
	friend class ODsnTypeCollection;

	friend bool operator==(const TypeIterator& lhs, const TypeIterator& rhs);
	friend bool operator!=(const TypeIterator& lhs, const TypeIterator& rhs) { return !(lhs == rhs); }

protected:
	const ODsnTypeCollection*	m_pContainer;
	sal_Int32					m_nPosition;

public:
	TypeIterator(const TypeIterator& _rSource);
	~TypeIterator();

	DATASOURCE_TYPE	getType() const;
	String			getPrefix() const;
	String			getDisplayName() const;

	/// prefix increment
	const TypeIterator&	operator++();
	/// postfix increment
	const TypeIterator	operator++(int) { TypeIterator hold(*this); ++*this; return hold; }

	/// prefix decrement
	const TypeIterator&	operator--();
	/// postfix decrement
	const TypeIterator	operator--(int) { TypeIterator hold(*this); --*this; return hold; }

protected:
	TypeIterator(const ODsnTypeCollection* _pContainer, sal_Int32 _nInitialPos = 0);
};

//=========================================================================
//= DbuTypeCollectionItem
//=========================================================================
/** allows an ODsnTypeCollection to be transported in an SfxItemSet
*/
class DbuTypeCollectionItem : public SfxPoolItem
{
	ODsnTypeCollection*	m_pCollection;

public:
	TYPEINFO();
	DbuTypeCollectionItem(sal_Int16 nWhich = 0, ODsnTypeCollection* _pCollection = NULL);
	DbuTypeCollectionItem(const DbuTypeCollectionItem& _rSource);

	virtual int 			 operator==(const SfxPoolItem& _rItem) const;
	virtual SfxPoolItem*	 Clone(SfxItemPool* _pPool = NULL) const;

	ODsnTypeCollection*	getCollection() const { return m_pCollection; }
};


//.........................................................................
}	// namespace dbaui
//.........................................................................

#endif // _DBAUI_DSNTYPES_HXX_

