/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: CKey.cxx,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 09:53:00 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#ifndef DBACCESS_CORE_API_KEY_HXX
#include "CKey.hxx"
#endif
#ifndef DBACCESS_CORE_API_KEYCOLUMNS_HXX
#include "CKeyColumns.hxx"
#endif
#ifndef _COM_SUN_STAR_SDBC_XROW_HPP_
#include <com/sun/star/sdbc/XRow.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XRESULTSET_HPP_
#include <com/sun/star/sdbc/XResultSet.hpp>
#endif
#ifndef DBACCESS_SHARED_DBASTRINGS_HRC
#include "dbastrings.hrc"
#endif

using namespace dbaccess;
using namespace connectivity;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
//	using namespace ::com::sun::star::sdbcx;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::lang;
// -------------------------------------------------------------------------
OTableKey::OTableKey(	OTableHelper* _pTable) : OTableKeyHelper(_pTable)
{
	construct();
}
// -------------------------------------------------------------------------
OTableKey::OTableKey(	OTableHelper* _pTable,
			const ::rtl::OUString& _Name,
			const ::rtl::OUString& _ReferencedTable,
			sal_Int32		_Type,
			sal_Int32		_UpdateRule,
			sal_Int32		_DeleteRule,
			const ::com::sun::star::uno::Reference< ::com::sun::star::sdbcx::XColumnsSupplier >& _rxKey
			) 
			: OTableKeyHelper(_pTable,
							_Name,
							_ReferencedTable,
							_Type,
							_UpdateRule,
							_DeleteRule)
				,m_xKey(_rxKey)
{
	construct();
	refreshColumns();
}
// -------------------------------------------------------------------------
void OTableKey::refreshColumns()
{
	Reference<XNameAccess> xNames;
	::std::vector< ::rtl::OUString> aVector;
	if ( m_xKey.is() ) 
	{
		xNames = m_xKey->getColumns();
		if ( xNames.is() )
		{
			Sequence< ::rtl::OUString> aNames = xNames->getElementNames();
			::rtl::OUString* pBegin	= aNames.getArray();
			::rtl::OUString* pEnd		= pBegin + aNames.getLength();
			for (; pEnd != pBegin; ++pBegin)
				aVector.push_back(*pBegin);
			
		}
		if ( m_pColumns )
			m_pColumns ->reFill(aVector);
		else
			m_pColumns	= new OKeyColumns(this,m_aMutex,aVector,xNames);
	}
	else 
		OTableKeyHelper::refreshColumns();

}
// -----------------------------------------------------------------------------
