/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: smtptr.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 08:00:41 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef COSV_SMTPTR_HXX
#define COSV_SMTPTR_HXX

// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
#include <template\s_pair.hxx>
	// PARAMETERS


template <class DYNOBJ>
class SmartPtr
{
	public:
		// LIFECYCLE
						SmartPtr(
							DYNOBJ *			let_dpObject = 0);
						SmartPtr(
							const SmartPtr &	in_rSmtptr);

						~SmartPtr()
							{ DecrRefCount(); }

		// OPERATORS
		SmartPtr &		operator=(
							const SmartPtr &	in_rSmtptr);

						operator bool() const
							{ return Ptr() != 0; }
		const DX *		operator->() const
							{ return Ptr(); }
		DX *			operator->()
							{ return Ptr(); }

		const DX &		operator*() const
							{ assert(Ptr() != 0); return *Ptr(); }
		DX &		    operator*()
							{ assert(Ptr() != 0); return *Ptr(); }

		// ACCESS
		/// So const objects can return mutable pointers to dynamic members!
		DX *			MutablePtr() const
							{ return Ptr(); }

	private:
		// Help functions
		void			IncrRefCount()
							{ dpPtr->mB++; }
		void			DecrRefCount();
		DYNOBJ *		Ptr() const
							{ return dpPtr->mA; }
		typedef S_Pair<DYNOBJ*,UINT16> RefCountPtr;

		/**	Forbidden function!
		**/
		SmartPtr<DYNOBJ> &
						operator=(
							DYNOBJ *			in_dpObject);



		DYN RefCountPtr *
						dpPtr;
};


template <class DYNOBJ>
SmartPtr<XX>::SmartPtr(DYNOBJ *	let_dpObject)
	:	dpPtr(new RefCountPtr(let_dpObject,1))
{
}

template <class DYNOBJ>
SmartPtr<XX>::SmartPtr(
const SmartPtr<DYNOBJ> & in_rSmtptr)
	:	dpPtr(in_rSmtptr.dpPtr)
{
	IncrRefCount();
}

template <class DYNOBJ>
SmartPtr<XX> &
SmartPtr<XX>::operator=(const SmartPtr<DYNOBJ> & in_rSmtptr)
{
	// Handelt auch selbst-Zuweisung korrekt:
	in_rSmtptr.IncrRefCount();
	DecrRefCount();
	dpPtr = in_rSmart.dpPtr;
}


#ifndef _USE_HTI_
#include <template\smtptr.hti>
#endif


#endif

