/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ACatalog.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:48:02 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _CONNECTIVITY_ADO_CATALOG_HXX_
#define _CONNECTIVITY_ADO_CATALOG_HXX_

#ifndef _CONNECTIVITY_SDBCX_CATALOG_HXX_
#include "connectivity/sdbcx/VCatalog.hxx"
#endif
#ifndef _CONNECTIVITY_ADO_AWRAPADOX_HXX_
#include "ado/Awrapadox.hxx"
#endif

namespace connectivity
{
	namespace ado
	{
		class OConnection;

		class OCatalog : public connectivity::sdbcx::OCatalog
		{
			WpADOCatalog	m_aCatalog;
			OConnection*	m_pConnection;

		public:
			virtual void refreshTables();
			virtual void refreshViews()	;
			virtual void refreshGroups();
			virtual void refreshUsers()	;

		public:
			OCatalog(_ADOCatalog* _pCatalog,OConnection* _pCon);
			~OCatalog();

			OConnection*		getConnection()		const { return m_pConnection;	}
			sdbcx::OCollection*	getPrivateTables()	const { return m_pTables;		}
			WpADOCatalog		getCatalog()		const { return m_aCatalog;		}
		};
	}
}
#endif // _CONNECTIVITY_ADO_CATALOG_HXX_

