/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: BIndex.cxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:21:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _CONNECTIVITY_ADABAS_INDEX_HXX_
#include "adabas/BIndex.hxx"
#endif
#ifndef _CONNECTIVITY_ADABAS_INDEXCOLUMNS_HXX_
#include "adabas/BIndexColumns.hxx"
#endif
#ifndef _COM_SUN_STAR_SDBC_XROW_HPP_
#include <com/sun/star/sdbc/XRow.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XRESULTSET_HPP_
#include <com/sun/star/sdbc/XResultSet.hpp>
#endif
#ifndef _CONNECTIVITY_ADABAS_TABLE_HXX_
#include "adabas/BTable.hxx"
#endif
#ifndef _COMPHELPER_TYPES_HXX_
#include <comphelper/types.hxx>
#endif

using namespace connectivity::adabas;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
//	using namespace ::com::sun::star::sdbcx;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::lang;
// -------------------------------------------------------------------------
OAdabasIndex::OAdabasIndex(	OAdabasTable* _pTable,
				const ::rtl::OUString& _Name,
				const ::rtl::OUString& _Catalog,
				sal_Bool _isUnique,
				sal_Bool _isPrimaryKeyIndex,
				sal_Bool _isClustered
				) : connectivity::sdbcx::OIndex(_Name,
								  _Catalog,
								  _isUnique,
								  _isPrimaryKeyIndex,
								  _isClustered,sal_True)
				,m_pTable(_pTable)
{
	construct();
	refreshColumns();
}
// -------------------------------------------------------------------------
OAdabasIndex::OAdabasIndex(OAdabasTable* _pTable) 
	: connectivity::sdbcx::OIndex(sal_True) 
	,m_pTable(_pTable)
{
	construct();
}
// -----------------------------------------------------------------------------

void OAdabasIndex::refreshColumns()
{
	if(!m_pTable)
		return;

	TStringVector aVector;
	if(!isNew())
	{
		Reference< XResultSet > xResult = m_pTable->getConnection()->getMetaData()->getIndexInfo(Any(),
		m_pTable->getSchema(),m_pTable->getTableName(),sal_False,sal_False);

		if(xResult.is())
		{
					Reference< XRow > xRow(xResult,UNO_QUERY);
			::rtl::OUString aColName;
			while(xResult->next())
			{
				if(xRow->getString(6) == m_Name)
				{
					aColName = xRow->getString(9);
					if(!xRow->wasNull())
						aVector.push_back(aColName);
				}
			}
			::comphelper::disposeComponent(xResult);
		}
	}
	if(m_pColumns)
		m_pColumns->reFill(aVector);
	else
		m_pColumns	= new OIndexColumns(this,m_aMutex,aVector);
}
// -----------------------------------------------------------------------------


