/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: heapmanager.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:48:49 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef CONFIGMGR_DATAHEAPMANAGER_HXX
#define CONFIGMGR_DATAHEAPMANAGER_HXX

#ifndef CONFIGMGR_DATALOCK_HXX
#include "datalock.hxx"
#endif

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _RTL_STRING_HXX_
#include <rtl/string.hxx>
#endif

namespace configmgr
{
// -----------------------------------------------------------------------------	
    namespace memory
    {
    // -------------------------------------------------------------------------
        class HeapManager
        {
        public:
            typedef struct Opaque_ * Handle;

            typedef sal_uInt32      Size;
            typedef sal_uInt32      Address;
            typedef rtl::OString    HeapId;
            typedef rtl::OString const & HeapIdParam;

        //    virtual HeapId newHeapId() = 0;
            virtual Handle createHeap(/*HeapIdParam _anId, */Size _sInitialSize) = 0;
            virtual Handle attachHeap(HeapIdParam _anId, Size & _rInitialSize) = 0;
            virtual Size   growHeap(Handle _aHeap, Size _sNewSize) = 0;
            virtual void   destroyHeap(Handle _aHeap) = 0;

            virtual void *  base(Handle _aHeap) = 0;
            virtual HeapId  id(Handle _aHeap) = 0;

            virtual Address allocate(Handle _aHeap, Size _sNewSize) = 0;
            virtual Address reallocate(Handle _aHeap, Address _aOldAddress, Size _sNewSize) = 0;
            virtual void    deallocate(Handle _aHeap, Address _aAddress) = 0;
            virtual bool    didAllocate(Handle _aHeap, Address _aAddress) = 0;

            typedef DataLock Lock;

            virtual Lock *  createHeapLock(Handle _aHeap) = 0;
            virtual void    destroyHeapLock(Handle _aHeap, Lock * _pLock) = 0;
        };
    // -------------------------------------------------------------------------
    }
// -----------------------------------------------------------------------------	
} // namespace configmgr

#endif // CONFIGMGR_DATAHEAPMANAGER_HXX

