/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dx_windowgraphicdevice.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 23:34:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_RENDERING_XLINEPOLYPOLYGON2D_HPP_
#include <com/sun/star/rendering/XLinePolyPolygon2D.hpp>
#endif

#ifndef _BGFX_TOOLS_CANVASTOOLS_HXX
#include <basegfx/tools/canvastools.hxx>
#endif

#include <canvas/canvastools.hxx>

#include <dx_impltools.hxx>
#include <dx_linepolypolygon.hxx>
#include <dx_canvasbitmap.hxx>
#include <dx_parametricpolypolygon.hxx>
#include <dx_windowgraphicdevice.hxx>


using namespace ::com::sun::star;

namespace dxcanvas
{
    WindowGraphicDevice::WindowGraphicDevice( HWND hOutputWnd ) :
        WindowGraphicDevice_Base( m_aMutex ),
        mhWnd( hOutputWnd ),
        maFullscreenSize(),
        mbIsFullscreen( false )
    {
    }

    WindowGraphicDevice::WindowGraphicDevice( HWND 						hOutputWnd,
                                              const ::basegfx::B2ISize& rFullscreenSize ) :
        WindowGraphicDevice_Base( m_aMutex ),
        mhWnd( hOutputWnd ),
        maFullscreenSize( rFullscreenSize ),
        mbIsFullscreen( true )
    {
    }

    WindowGraphicDevice::~WindowGraphicDevice()
    {
    }
    
    void SAL_CALL WindowGraphicDevice::disposing()
    {
        mhWnd = 0;
    }

    uno::Reference< rendering::XBufferController > SAL_CALL WindowGraphicDevice::getBufferController() throw (uno::RuntimeException)
    {
        return uno::Reference< rendering::XBufferController >();
    }

    uno::Reference< rendering::XColorSpace > SAL_CALL WindowGraphicDevice::getDeviceColorSpace() throw (uno::RuntimeException)
    {
        return uno::Reference< rendering::XColorSpace >();
    }

    geometry::RealSize2D SAL_CALL WindowGraphicDevice::getPhysicalResolution() throw (uno::RuntimeException)
    {
        if( mhWnd == 0 ) 
            return geometry::RealSize2D(1.0, 1.0);

        HDC hDC;
        if( !(hDC=GetDC( mhWnd )) )
            throw uno::RuntimeException();

        const int nHorzRes( GetDeviceCaps( hDC, 
                                           LOGPIXELSX ) );
        const int nVertRes( GetDeviceCaps( hDC, 
                                           LOGPIXELSY ) );

        ReleaseDC( mhWnd, hDC );

        return geometry::RealSize2D( nHorzRes*25.4,
                                     nVertRes*25.4 );
    }

    geometry::RealSize2D SAL_CALL WindowGraphicDevice::getSize() throw (uno::RuntimeException)
    {
        if( mhWnd == 0 ) 
            return geometry::RealSize2D(1.0, 1.0);

        HDC hDC;
        if( !(hDC=GetDC( mhWnd )) )
            throw uno::RuntimeException();

        const int nHorzSize( GetDeviceCaps( hDC, 
                                            HORZSIZE ) );
        const int nVertSize( GetDeviceCaps( hDC, 
                                            VERTSIZE ) );

        ReleaseDC( mhWnd, hDC );

        return geometry::RealSize2D( nHorzSize,
                                     nVertSize );
    }

    uno::Reference< rendering::XLinePolyPolygon2D > SAL_CALL WindowGraphicDevice::createCompatibleLinePolyPolygon( const uno::Sequence< uno::Sequence< geometry::RealPoint2D > >& points ) throw (uno::RuntimeException)
    {
        return uno::Reference< rendering::XLinePolyPolygon2D >( new LinePolyPolygon( points  ) );
    }

    uno::Reference< rendering::XBezierPolyPolygon2D > SAL_CALL WindowGraphicDevice::createCompatibleBezierPolyPolygon( const uno::Sequence< uno::Sequence< geometry::RealBezierSegment2D > >& points ) throw (uno::RuntimeException)
    {
        // TODO(F1): Bezier polygons NYI
        return uno::Reference< rendering::XBezierPolyPolygon2D >();
    }

    uno::Reference< rendering::XBitmap > SAL_CALL WindowGraphicDevice::createCompatibleBitmap( const geometry::IntegerSize2D& size ) throw (uno::RuntimeException)
    {
        return uno::Reference< rendering::XBitmap >( 
            new CanvasBitmap( BitmapSharedPtr( 
                                  new Gdiplus::Bitmap( 
                                      size.Width, 
                                      size.Height,
                                      PixelFormat24bppRGB ) ),
                              ImplRef( this ) ) );
    }

    uno::Reference< rendering::XVolatileBitmap > SAL_CALL WindowGraphicDevice::createVolatileBitmap( const geometry::IntegerSize2D& size ) throw (uno::RuntimeException)
    {
        // TODO(F2): Volatile bitmaps NYI
        return uno::Reference< rendering::XVolatileBitmap >();
    }

    uno::Reference< rendering::XBitmap > SAL_CALL WindowGraphicDevice::createCompatibleAlphaBitmap( const geometry::IntegerSize2D& size ) throw (lang::IllegalArgumentException, uno::RuntimeException)
    {
        return uno::Reference< rendering::XBitmap >( 
            new CanvasBitmap( BitmapSharedPtr( 
                                  new Gdiplus::Bitmap( 
                                      size.Width, 
                                      size.Height,
                                      PixelFormat32bppARGB ) ),
                              ImplRef( this ) ) );
    }

    uno::Reference< rendering::XVolatileBitmap > SAL_CALL WindowGraphicDevice::createVolatileAlphaBitmap( const geometry::IntegerSize2D& size ) throw (lang::IllegalArgumentException, uno::RuntimeException)
    {
        // TODO(F2): Volatile bitmaps NYI
        return uno::Reference< rendering::XVolatileBitmap >();
    }

    uno::Reference< rendering::XParametricPolyPolygon2DFactory > SAL_CALL WindowGraphicDevice::getParametricPolyPolygonFactory() throw (uno::RuntimeException)
    {
        return uno::Reference< rendering::XParametricPolyPolygon2DFactory >( this );
    }

    sal_Bool SAL_CALL WindowGraphicDevice::hasFullScreenMode() throw (uno::RuntimeException)
    {
        // TODO(F1): Fullscreen/window switching NYI. For now, this is XCanvas 
        // constructor-determined
        return false;
    }

    sal_Bool SAL_CALL WindowGraphicDevice::enterFullScreenMode( sal_Bool bEnter ) throw (uno::RuntimeException)
    {
        return false;
    }

    ::basegfx::B2ISize WindowGraphicDevice::getOutputOffset() const
    {
        if( isFullScreen() )
            return ::basegfx::B2ISize(); // fullscreen is always left, top aligned

        if( mhWnd == 0 ) 
            return ::basegfx::B2ISize(1, 1); // we're disposed

        POINT aPoint = { 0, 0 };
        
        if( !ClientToScreen( mhWnd, &aPoint ) )
            throw uno::RuntimeException();

        return ::basegfx::B2ISize( aPoint.x, 
                                   aPoint.y );
    }

    ::basegfx::B2ISize WindowGraphicDevice::getSizePixel() const
    {
        if( isFullScreen() )
            return maFullscreenSize;

        if( mhWnd == 0 )
            return ::basegfx::B2ISize(1, 1);

        // determine size from given window handle
        RECT aRect;
        
        if( !GetClientRect( mhWnd, &aRect ) )
            throw uno::RuntimeException();

        return ::basegfx::B2ISize( aRect.right - aRect.left,
                                   aRect.bottom - aRect.top );
    }

    bool WindowGraphicDevice::isFullScreen() const
    {
        return mbIsFullscreen;
    }

    uno::Reference< rendering::XParametricPolyPolygon2D > SAL_CALL WindowGraphicDevice::createLinearHorizontalGradient( const uno::Sequence< double >& leftColor, const uno::Sequence< double >& rightColor ) throw (lang::IllegalArgumentException, uno::RuntimeException)
    {
        // TODO(P1): Could as well use static objects here,
        // XParametricPolyPolygon2D has no (externally visible)
        // state. OTOH, might as well leave that as it is, to allow
        // each XParametricPolyPolygon2D to hold a static
        // XPolyPolygon2D internally, and hand out the same
        // XPolyPolygon2D each time
        // XParametricPolyPolygon2D::getOutline() is called.
        return uno::Reference< rendering::XParametricPolyPolygon2D >( 
            ParametricPolyPolygon::createLinearHorizontalGradient( leftColor, 
                                                                   rightColor,
                                                                   this ) );
    }

    uno::Reference< rendering::XParametricPolyPolygon2D > SAL_CALL WindowGraphicDevice::createAxialHorizontalGradient( const uno::Sequence< double >& middleColor, const uno::Sequence< double >& endColor ) throw (lang::IllegalArgumentException, uno::RuntimeException)
    {
        // TODO(P1): Could as well use static objects here,
        // XParametricPolyPolygon2D has no (externally visible)
        // state. OTOH, might as well leave that as it is, to allow
        // each XParametricPolyPolygon2D to hold a static
        // XPolyPolygon2D internally, and hand out the same
        // XPolyPolygon2D each time
        // XParametricPolyPolygon2D::getOutline() is called.
        return uno::Reference< rendering::XParametricPolyPolygon2D >( 
            ParametricPolyPolygon::createAxialHorizontalGradient( middleColor, 
                                                                  endColor,
                                                                  this ) );
    }

    uno::Reference< rendering::XParametricPolyPolygon2D > SAL_CALL WindowGraphicDevice::createCircularGradient( const uno::Sequence< double >& centerColor, const uno::Sequence< double >& endColor ) throw (lang::IllegalArgumentException, uno::RuntimeException)
    {
        // TODO(P1): Could as well use static objects here,
        // XParametricPolyPolygon2D has no (externally visible)
        // state. OTOH, might as well leave that as it is, to allow
        // each XParametricPolyPolygon2D to hold a static
        // XPolyPolygon2D internally, and hand out the same
        // XPolyPolygon2D each time
        // XParametricPolyPolygon2D::getOutline() is called.
        return uno::Reference< rendering::XParametricPolyPolygon2D >( 
            ParametricPolyPolygon::createCircularGradient( centerColor, 
                                                           endColor,
                                                           this ) );
    }

    uno::Reference< rendering::XParametricPolyPolygon2D > SAL_CALL WindowGraphicDevice::createRectangularGradient( const uno::Sequence< double >& centerColor, const uno::Sequence< double >& endColor, const geometry::RealRectangle2D& boundRect ) throw (lang::IllegalArgumentException, uno::RuntimeException)
    {
        // TODO(P1): Could as well use static objects here,
        // XParametricPolyPolygon2D has no (externally visible)
        // state. OTOH, might as well leave that as it is, to allow
        // each XParametricPolyPolygon2D to hold a static
        // XPolyPolygon2D internally, and hand out the same
        // XPolyPolygon2D each time
        // XParametricPolyPolygon2D::getOutline() is called.
        return uno::Reference< rendering::XParametricPolyPolygon2D >( 
            ParametricPolyPolygon::createRectangularGradient( centerColor, 
                                                              endColor, 
                                                              boundRect,
                                                              this ) );
    }

    uno::Reference< rendering::XParametricPolyPolygon2D > SAL_CALL WindowGraphicDevice::createVerticalLinesHatch( const uno::Sequence< double >& leftColor, const uno::Sequence< double >& rightColor ) throw (lang::IllegalArgumentException, uno::RuntimeException)
    {
        // TODO(F1): hatch factory NYI
        return uno::Reference< rendering::XParametricPolyPolygon2D >();
    }

    uno::Reference< rendering::XParametricPolyPolygon2D > SAL_CALL WindowGraphicDevice::createOrthogonalLinesHatch( const uno::Sequence< double >& leftTopColor, const uno::Sequence< double >& rightBottomColor ) throw (lang::IllegalArgumentException, uno::RuntimeException)
    {
        // TODO(F1): hatch factory NYI
        return uno::Reference< rendering::XParametricPolyPolygon2D >();
    }

    uno::Reference< rendering::XParametricPolyPolygon2D > SAL_CALL WindowGraphicDevice::createThreeCrossingLinesHatch( const uno::Sequence< double >& startColor, const uno::Sequence< double >& endColor ) throw (lang::IllegalArgumentException, uno::RuntimeException)
    {
        // TODO(F1): hatch factory NYI
        return uno::Reference< rendering::XParametricPolyPolygon2D >();
    }

    uno::Reference< rendering::XParametricPolyPolygon2D > SAL_CALL WindowGraphicDevice::createFourCrossingLinesHatch( const uno::Sequence< double >& startColor, const uno::Sequence< double >& endColor ) throw (lang::IllegalArgumentException, uno::RuntimeException)
    {
        // TODO(F1): hatch factory NYI
        return uno::Reference< rendering::XParametricPolyPolygon2D >();
    }
	
#define IMPLEMENTATION_NAME "DXCanvas::WindowGraphicDevice"
#define SERVICE_NAME "com.sun.star.rendering.WindowGraphicDevice"

    ::rtl::OUString SAL_CALL WindowGraphicDevice::getImplementationName(  ) throw (::com::sun::star::uno::RuntimeException)
    {
        return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( IMPLEMENTATION_NAME ) );
    }

    sal_Bool SAL_CALL WindowGraphicDevice::supportsService( const ::rtl::OUString& ServiceName ) throw (::com::sun::star::uno::RuntimeException)
    {
        return ServiceName.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM ( SERVICE_NAME ) );
    }

    ::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL WindowGraphicDevice::getSupportedServiceNames(  ) throw (::com::sun::star::uno::RuntimeException)
    {
        uno::Sequence< ::rtl::OUString > aRet(1);
        aRet[0] = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM ( SERVICE_NAME ) );

        return aRet;
    }
 
}
