/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dx_plainsurface.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 23:30:17 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _DXCANVAS_PLAINSURFACE_HXX
#define _DXCANVAS_PLAINSURFACE_HXX

#ifndef _BGFX_POINT_B2ISIZE_HXX
#include <basegfx/vector/b2isize.hxx>
#endif

#include <dx_winstuff.hxx>
#include <dx_surface.hxx>

#ifndef BOOST_SHARED_PTR_HPP_INCLUDED
#include <boost/shared_ptr.hpp>
#endif

namespace dxcanvas
{
	/* Definition of PlainSurface class */ 
    
    class PlainSurface : public Surface
    {
    public:
        PlainSurface( const COMReference<IDirectDrawSurface>& 	rDDSurface,
                      const ::basegfx::B2ISize&					rSize );
        virtual ~PlainSurface();

        /** Request a Gdiplus::Graphics for this surface

        	The Graphics is wrapped in a RAII class, which
        	transparently handles resource release when getting
        	destroyed.

        	@return a SurfaceGraphics for this surface, which might be
        	non-functional if something went wrong.

            @see getDC
         */
        virtual SurfaceGraphicsSharedPtr getGraphics();

        /** Query whether the content of this surface was lost

			Content of DirectX surfaces is somewhat volatile, in that
			other applications can in some circumstances claim video
			resources and thus destroy the content
         */
        virtual bool contentLost() const;

    private:
        friend class Device;

        // default: disabled copy/assignment
        PlainSurface(const PlainSurface&);
        PlainSurface& operator=( const PlainSurface& );

        COMReference<IDirectDrawSurface> 	mpSurface;
        ::basegfx::B2ISize					maSize;
    };

    typedef ::boost::shared_ptr< PlainSurface > PlainSurfaceSharedPtr;
}

#endif /* _DXCANVAS_PLAINSURFACE_HXX */
