/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: appedit.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:11:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _APPEDIT_HXX
#define _APPEDIT_HXX

#ifndef _SCRBAR_HXX //autogen
#include <vcl/scrbar.hxx>
#endif

#include "appwin.hxx"
#include "textedit.hxx"

class BasicFrame;

class AppEdit : public AppWin	 {	// Editor-Window:
public:
	ScrollBar *pVScroll;
	ScrollBar *pHScroll;
	void SetScrollBarRanges();
	ULONG nCurTextWidth;
private:
	void InitScrollBars();
protected:
	DECL_LINK( Scroll, ScrollBar* );
public:
	TYPEINFO();
	AppEdit( BasicFrame* );
	~AppEdit();
	USHORT GetLineNr();				// Aktuelle Zeilennummer
	FileType GetFileType();			// Liefert den Filetype
	virtual long InitMenu( Menu* );			// Initialisierung des Menues
	virtual long DeInitMenu( Menu* );	// rcksetzen, so da wieder alle Shortcuts enabled sind
	virtual void Command( const CommandEvent& rCEvt );	// Kommando-Handler
	void Resize();
	void PostLoad();				// Nachbearbeiten des geladenen (Source am Modul setzen)
	void PostSaveAs();				// Nachbearbeiten des Modils ...
	void Mark( short, short, short );// Text markieren
	void Highlight( USHORT nLine, USHORT nCol1, USHORT nCol2 );
	virtual BOOL ReloadAllowed(){ return !StarBASIC::IsRunning(); }
    virtual void LoadIniFile();		// (re)load ini file after change
};

#endif
